/*
 * WSFREE.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#include <wsub.h>
#include <alloc.h>

/* loop through array and free fileblock's.
 *  set fcb_count = 0.
 *  return count in memory.
 */
int wsfree(WSUB *p)
{
	int q;
	int result;

	p->count = 0;
	if (p->fcb == NULL)
		return 0;
	result = 0;
	for (q = 0; q < p->maxfb; q++) {
		if (p->fcb[q]) {
			free(p->fcb[q]);
			p->fcb[q] = NULL;
			result++;
		}
	}
	return result;
}