; OFREAD.ASM--
; Copyright (c) 2008 Hjort Nidudsson
;
; Change history:
; 21 Aug 2008	- Read bytes to STDI

INCLUDE 	clib.inc
INCLUDE 	io.inc
INCLUDE 	string.inc
INCLUDE 	iost.inc

_TEXT		SEGMENT

; IO_USECRC:	Update CRC value (->bb) after read
; IO_UPDTOTAL:	Update read size (->total) after read
; IO_USEUPD:	Call function oupdate(int) after read (progress)
; IO_CRYPT:	Decrypt buffer (->bp) after read

ofread		PROC	DIST
		push	si
		push	di
		mov	si,OSTDI
		test	[si.ios_flag],IO_MEMREAD
		jnz	SHORT @@memread
		mov	di,[si.ios_c]
		sub	di,[si.ios_i]   ; DI bytes left in buffer
		jnz	SHORT @@docopy
@@nocopy:	xor	ax,ax
		mov     [si.ios_i],ax   ; set index to zero
		mov	[si.ios_c],di   ; count to bytes left
		mov	cx,[si.ios_memz]
		sub	cx,di		; buffer size - rest
		push	DS
		mov	bx,[si.ios_file]; read from STDI
		lds	dx,[si.ios_bp]
		add	dx,di		; bp + count
		mov	ax,3F00h
		int	21h
		pop	DS
		jc	SHORT @@error
		or	ax,ax
		jz	SHORT @@toend
		add     [si.ios_c],ax
		mov	dx,[si.ios_flag]
		and	dx,(IO_UPDTOTAL or IO_USECRC or IO_USEUPD)
		jnz	SHORT @@test
@@toend:        or	ax,ax
		pop	di
		pop	si
		ret
@@test:		test	dx,IO_UPDTOTAL
		jz	SHORT @@testcrc
		movzx	eax,ax
		add     [si.ios_total],EAX
@@testcrc:	test	dx,IO_USECRC
		jz	SHORT @@update
		mov	dx,di
		call	oupdcrc
@@update:	test	[si.ios_flag],IO_USEUPD
		jz	SHORT @@crypt
		push	0		; 0 = STDI
		call	oupdate		; print out progress
@@crypt:        jmp	SHORT @@toend
@@memread:	call	iomemread
		jmp	SHORT @@toend

; The ogets function leaves byte left in buffer if count < getsize
; Bytes left is copyed to start of buffer, and read starts from
; size-left.

@@docopy:       cmp	di,[si.ios_c]
		je	SHORT @@null
		mov	eax,[si.ios_bp]
		push	eax
		add	ax,[si.ios_i]
		push	eax
		push	di
		call	memcpy
		jmp	SHORT @@nocopy

@@error:	push	ax
		call	dosmaperr
		or      [si.ios_flag],IO_ERROR
@@null:		xor	ax,ax
		jmp	SHORT @@toend

ofread		ENDP

; IO_MEMREAD:	offset	start of buffer

MAXOFFSET	=	0FFFFFh

iomemread:	mov	eax,[si.ios_offs]
		cmp	eax,MAXOFFSET
		jae	SHORT @@memeof
		push	[si.ios_bp]
		mov     dx,ax
		and	dx,15
		and	al,0F0h
		shl	eax,12
		mov	ax,dx
		push	eax

		mov	ecx,[si.ios_offs]
		xor	eax,eax
		mov	[si.ios_i],ax		; index to zero
		cmp	ax,[si.ios_c]		; prev read size?
		mov	ax,[si.ios_memz]        ; size of buffer
		mov	[si.ios_c],ax		; assume max size
		jz	SHORT @@
		add	ecx,eax
		cmp	ecx,MAXOFFSET
		jbe	SHORT @@
		sub	ecx,eax
		mov	eax,MAXOFFSET
		sub	eax,ecx
		mov	[si.ios_c],ax
		add	ecx,eax
@@:		mov	[si.ios_offs],ecx
		push	[si.ios_c]
		call	memcpy
@@memok:	xor	ax,ax
		inc	ax
		ret
@@memeof:	mov	[si.ios_offs],MAXOFFSET
		xor	ax,ax
		mov	[si.ios_i],ax
		mov	[si.ios_c],ax
@@toend:	ret

_TEXT		ENDS

		END
