/*
 * MENUS.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <errno.h>
#include <string.h>
#include <dzmain.h>

#define MENUSCMD	(-2)
#define MENUSLINE_COL	57

typedef struct {
	const char *info;
	int (*proc) (void);
      } MINFO;

static 	MINFO menus[] = {
	{ cp_long,   	cmalong		},
	{ cp_detail, 	cmadetail	},
	{ cp_hidden, 	cmahidden	},
	{ cp_mini,   	cmamini		},
	{ cp_sort,   	cmaname		},
	{ cp_sort,   	cmatype		},
	{ cp_sort,   	cmadate		},
	{ cp_sort,   	cmasize		},
	{ cp_toggle, 	cmatoggle	},
	{ cp_pfilter,	cmafilter   	},
	{ cp_subinfo,	cmasubinfo  	},
	{ cp_update, 	cmaupdate	},
	{ cp_chdrv,  	cmachdrv	},

	{ cp_rename, 	cmrename 	},
	{ cp_view,   	cmview 		},
	{ cp_edit,   	cmedit 		},
	{ cp_copy,   	cmcopy 		},
	{ cp_move,   	cmmove 		},
	{ cp_mkdir,  	cmmkdir		},
	{ cp_delete, 	cmdelete 	},
	{ cp_blkprop,	cmblkprop 	},
	{ cp_compress, 	cmcompress 	},
	{ cp_decompress, cmdecompress 	},
	{ cp_search, 	cmsearch 	},
	{ cp_history, 	cmhistory	},
	{ cp_exit,   	cmexit 		},

	{ cp_select, 	cmselect 	},
	{ cp_deselect, 	cmdeselect 	},
	{ cp_invert, 	cminvert 	},
	{ cp_compare, 	cmcompare 	},

	{ cp_toggleon, 	cmtoggleon 	},
	{ cp_togglehz, 	cmtogglehz 	},
	{ cp_togglesz, 	cmtogglesz 	},
	{ cp_egaline, 	cmegaline 	},
	{ cp_swappanels, cmswap 	},
	{ cp_confirm, 	cmconfirm 	},
	{ cp_screen, 	cmscreen 	},
	{ cp_panel, 	cmpanel 	},
	{ cp_config, 	cmoptions 	},

	{ cp_help, 	cmhelp		},
	{ cp_about, 	cmabout		},

	{ cp_long,   	cmblong		},
	{ cp_detail, 	cmbdetail	},
	{ cp_hidden, 	cmbhidden	},
	{ cp_mini,   	cmbmini		},
	{ cp_sort,   	cmbname		},
	{ cp_sort,   	cmbtype		},
	{ cp_sort,   	cmbdate		},
	{ cp_sort,   	cmbsize		},
	{ cp_toggle, 	cmbtoggle	},
	{ cp_pfilter,	cmbfilter   	},
	{ cp_subinfo,	cmbsubinfo  	},
	{ cp_update, 	cmbupdate	},
	{ cp_chdrv,  	cmbchdrv	},
};

int aputsl(const char *p)
{
	WCHR *wc;

	wc = (WCHR *)getxyp(0, *__egaline);
	__mshide();
	wcputw(wc, 80, MKW(at_Menus, ' '));
	wcputs(wc + 1, 79, 0, p);
	__msshow();
	return 0;
}

enum {	OP_LONGNAME,
	OP_DETAIL,
	OP_HIDDEN,
	OP_MINISTATUS,
	OP_NAME,
	OP_TYPE,
	OP_DATE,
	OP_SIZE,
	OP_TOGGLE,
	OP_FILTER,
	OP_SUBINFO,
	OP_UPDATE,
	OP_CHDRV,
	OP_COUNT	};

int menus_oid[] = {
	ID_ALONGNAME,
	ID_RENAME,
	ID_SELECT,
	ID_TOGGLEON,
	ID_HELP,
	ID_HELP,
	ID_BLONGNAME,
};

void panel_initmenus(WORD flag, TOBJ *o)
{
	if (_ifsmgr == 0)
		o[OP_LONGNAME].flag |= _O_STATE;
	if (flag & _W_LONGNAME)
		o[OP_LONGNAME].flag |= _O_FLAGB;
	if (flag & _W_DETAIL)
		o[OP_DETAIL].flag |= _O_FLAGB;
	if (flag & _W_HIDDEN)
		o[OP_HIDDEN].flag |= _O_FLAGB;
	if (flag & _W_MINISTATUS)
		o[OP_MINISTATUS].flag |= _O_FLAGB;
	switch (flag & _W_SORTFLAG) {
	case _W_SORTNAME: o[OP_NAME].flag |= _O_RADIO; break;
	case _W_SORTTYPE: o[OP_TYPE].flag |= _O_RADIO; break;
	case _W_SORTDATE: o[OP_DATE].flag |= _O_RADIO; break;
	case _W_SORTSIZE: o[OP_SIZE].flag |= _O_RADIO; break;
	}
}

int menus_modalidd(int idd)
{
	DOBJ 	*d,mu;
	WCHR 	mb[30];
	WCHR 	stl[80];
	int 	q,state;
	int	result;

	if (idd == ID_MTOOLS)
		return tools_modalidd(128, NULL, "Tools");
	mu.wp   = mb;
	mu.rc   = tobj_menusline[idd].rc;
	mu.flag = _D_COLOR|_D_MYBUF;
	wcpushst(stl, tobj_menusline[idd].data);
	if (twopen(&mu, at_MenusKey & 0x0F, NULL))
		twshow(&mu);
	if ((d = rsopen(ResourceMenus[idd])) == NULL)
		return 0;
	for (q = 0; q < d->count; q++)
		d->object[q].data = menus[menus_oid[idd] + q].info;
	if (idd == ID_MPANELA)
		panel_initmenus(config.ide[0].flag, d->object);
	else if (idd == ID_MPANELB)
		panel_initmenus(config.ide[1].flag, d->object);
	tdinit(d);
	result = tdmodal(d);
	state  = (d->object[result - 1].flag & _O_STATE);
	twclose(&mu);
	wcpopst(stl);
	if (result > 0 && result <= d->count) {
		if (state == 0)
			menus[menus_oid[idd] + result - 1].proc();
	} else if (mousep()) {
		return MOUSECMD;
	}
	return result;
}

/**/

int menus_idle(void)
{
	int q;
	int event = 0;

	do {
		tupdate();
		if (mousep())
			break;
		if (shift->AltLeft) {
			event = MENUSCMD;
			while (shift->Alt) {
				if ((q = getkey()) != 0) {
					event = q;
					break;
				}
			}
			break;
		} else if (shift->Ctrl) {
			return CTRL;
		}
	} while ((event = getkey()) == 0);
	return event;
}

int menus_getevent(void)
{
	int mx;
	int q,idd;
	int activ;
	int event;

	idd = 0;
	activ = 0;
	do {
		if (activ == 0) {
			if ((event = menus_idle()) == CTRL)
				return CTRL;
		}
		if (event == 0 && mousey() == 0) {
			mx = mousex();
			idd = ID_MPANELB;
			if (mx < MENUSLINE_COL) {
				while (mx < tobj_menusline[idd].rc.x)
					idd--;
				event = tobj_menusline[idd].ascii << 8;
			} else {
				return MOUSECMD;
			}
		} else if (event == 0) {
			return MOUSECMD;
		}
		switch (event) {
		case MOUSECMD:
			activ = 0;
			event = 0;
			break;
		case MENUSCMD:
			event = menus_modalidd(idd);
			activ = 1;
			break;
		case RIGHT:
			if (activ) {
				if (idd + 1 <= ID_MPANELB)
					idd++;
				else
					idd = ID_MPANELA;
				event = menus_modalidd(idd);
				break;
			}
			return event;
		case LEFT:
			if (activ) {
				if (idd > ID_MPANELA)
					idd--;
				else
					idd = ID_MPANELB;
				event = menus_modalidd(idd);
				break;
			}
			return event;
		case ESC:
			if (activ)
				return 0;
			return event;
		default:
			if (activ) {
				while(mousep());
				return 0;
			} else if (event) {
				q = -1;
				switch (event) {
				case 0x1E00/*'A'*/: q = 0; break;
				case 0x2100/*'F'*/: q = 1; break;
				case 0x1200/*'E'*/: q = 2; break;
				case 0x1F00/*'S'*/: q = 3; break;
				case 0x1400/*'T'*/: q = 4; break;
				case 0x2300/*'H'*/: q = 5; break;
				case 0x3000/*'B'*/: q = 6; break;
				}
				if (q != -1) {
					idd = q;
					event = menus_modalidd(idd);
					activ = 1;
					break;
				}
				if (activ == 0)
					return event;
			}
			break;
		}
	} while ( 1 );
}