/*
 * CMSUBSIZ.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <string.h>
#include <dir.h>
#include <progress.h>
#include <stdlib.h>
#include <dzmain.h>

static DWORD
	subd_count,
	file_count,
	size_low,
	size_high;

static void clear(void)
{
	subd_count =
	file_count =
	size_low   =
	size_high  = 0L;
}

static void add(DWORD h, DWORD l)
{
	if ((size_low + l) < size_low)
		size_high++;
	size_low += l;
	size_high += h;
}

static int dofile(const char *p, wfblk *wf)
{
	file_count++;
	if (progress_set(NULL, wf->name, 1) || p == NULL)
		return -1;
	add(wf->size_high, wf->size_low);
	return 0;
}

static int dosubdir(const char *p)
{
	progress_set(NULL, p, 0);
	subd_count++;
	return scan_files(p);

}

static int __getsize(char *p)
{
	fp_maskp = cp_stdmask;
	fp_fileblock = dofile;
	fp_directory = dosubdir;
	return scan_directory(1, p);
}

static int _lc_scansub(char *path)
{
	int x;

	progress_open(cp_subsize, NULL);
	x = __getsize(path);
	progress_close();
	return (x == 0);
}

static int _lc_iddsubinfo(char *info, const char *title)
{
	int x,y;
	long q;
	DOBJ *d;

	d = rsopen(IDD_SUBINFO);
	x = d->rc.x;
	y = d->rc.y;
	wctitle(d->wp, d->rc.col, title);
	twshow(d);
	scputs(x + 5, y + 2, 0, 0, cp_location);
	scpath(x + 15, y + 2, 20, info);
	scputf(x + 4, y + 3, 0, 0,
		cp_10lu_Files, file_count, subd_count - 1);
	q = mkbstring(info, size_high, size_low);
	scputf(x + 6, y + 6, 0, 0, cp_totalsbyte, info);
	if (q & 0xFFFF0000 && q & 0x0000FFFF)
		scputf(x + 12, y + 7, 0, 0, " %lu%c",
			(q & 0xFFFF), cp_bytesize[(q >> 16)]);
	tdmodal(d);
	return 0;
}

static int doselected(char *path)
{
	int x,result;
	fblk **fcb;

	subd_count++;
	result = 1;
	fcb = cpanel->ide->fcb;
	for (x = 0; x < cpanel->fcb_count; x++) {
		if (ISSELECTED(fcb[x]->flag)) {
			if (ISSUBDIR(fcb[x]->flag)) {
				if (!(result = _lc_scansub(strfcat(path, cpanel->ide->path, fcb[x]->name))))
					break;
			} else {
				add(0L, fcb[x]->size);
				file_count++;
			}
		}
	}
	if (result)
		return _lc_iddsubinfo(strcpy(path, cpanel->ide->path), cp_selected);
	return 0;
}

int cmsubsize(void)
{
	FBLK *b;
	char path[WMAXPATH];

	if ((b = cpanel_findfirst()) == NULL)
		return 0;
	if (ISARCHIVE(b->flag))
		return 0;
	clear();
	if (ISSELECTED(b->flag))
		return doselected(path);
	if (_lc_scansub(strfcat(path, cpanel->ide->path, b->name)))
		return _lc_iddsubinfo(path, cp_subsize);
	return 0;
}

int cmasubinfo(void)
{
	char path[WMAXPATH];

	if (panel_state(&panela) == 0 || ISARCHIVE(*panela.flag))
		return 0;
	clear();
	if (_lc_scansub(strcpy(path, panela.ide->path)))
		return _lc_iddsubinfo(path, cp_subsize);
	return 0;
}

int cmbsubinfo(void)
{
	char path[WMAXPATH];

	if (panel_state(&panelb) == 0 || ISARCHIVE(*panelb.flag))
		return 0;
	clear();
	if (_lc_scansub(strcpy(path, panelb.ide->path)))
		return _lc_iddsubinfo(path, cp_subsize);
	return 0;
}