;
; TDEDIT.ASM
;
; This file is part of DOSZIP
; Copyright (c) 1996 Hjort Nidudsson.
;

include		clib.inc
include		dos.inc
include		string.inc
include		dialog.inc
include		kbd.inc

		.386p
		locals

_TCONTINUE	=	0
_TEXITCMD	=	1

_DATA		SEGMENT

GLOBAL		tclrascii: BYTE
GLOBAL		tminascii: BYTE
GLOBAL		tmaxascii: BYTE

ti_proctab	DW	ti_case_mouse
		DW      ti_case_up
		DW      ti_case_esc
		DW      ti_case_down
		DW      ti_case_left
		DW      ti_case_continue
		DW      ti_case_right
		DW      ti_case_home
		DW      tinextword
		DW      tiprevword
		DW      titoend
		DW      tidelete
		DW      tibacksp
		DW      tienter

ti_keytable	DW	MOUSECMD
		DW      KEY_UP
		DW      KEY_ESC
		DW      KEY_DOWN
		DW      KEY_LEFT
		DW      _TCONTINUE
		DW      KEY_RIGHT
		DW      KEY_HOME
		DW      CTRLRIGHT
		DW      CTRLLEFT
		DW      KEY_END
		DW      KEY_DEL
		DW      KEY_BKSP
		DW      KEY_ENTER

key_count	=	(($ - ti_keytable) / 2)

_DATA		ENDS

_TEXT		SEGMENT

_tcurlp:	mov	ax,yoffs
		imul	bcol
		les	bx,base
		add	bx,ax
		mov	dx,ES
		mov	ax,bx
		ret

tiseto:		call	_tcurlp
		push	dx
		push	ax
		add	bx,bcol
		dec	bx
		xor	ax,ax
		mov	ES:[bx],al
		call	strlen
		mov	bcount,ax
		mov	dx,boffs
		add	dx,xoffs
		cmp	dx,ax
		jb	SHORT @@null
		call	titoend
		mov	ax,1
		ret
@@null:		xor	ax,ax
		ret

tiputl:		push	rcx
		push	ax
		push	0
		push	rccol
		push	ES
		push	bx
		call	scputs
		ret

tiputs:		push	si
		xor	si,si
		jmp	SHORT @@main
@@loop:		push	rcx
		mov	ax,rcy
		add	ax,si
		push	ax
		push	rccol
		xor	ax,ax
		mov	al,tclrascii
		push	ax
		call	scputw
		mov	ax,si
		imul	bcol
		les	bx,base
		add	bx,ax
		push	bx
		push	ES
		push	bx
		call	strlen
		pop	bx
		cmp	ax,boffs
		jbe	SHORT @@inc
		add	bx,boffs
		mov	ax,rcy
		add	ax,si
		call	tiputl
@@inc:		inc	si
@@main:		cmp	si,rcrow
		jl	SHORT @@loop
		mov	ax,rcx
		add	ax,xoffs
		push	ax
		mov	ax,rcy
		add	ax,yoffs
		push	ax
		call	gotoxy
		xor	ax,ax
		pop	si
		ret

titoend:	mov	ax,bcount
		mov	xoffs,ax
		mov	dx,rccol
		dec	dx
		cmp	ax,dx
		jb	SHORT @@1
		mov	xoffs,dx
@@1:		sub	ax,rccol
		inc	ax
		mov	boffs,ax
		cmp	ax,0
		jg	SHORT @@2
		mov	boffs,0
@@2:            mov	ax,bcol
		dec	ax
		cmp	ax,bcount
		jne	SHORT @@toend
		dec	boffs
@@toend:	mov	ax,_TCONTINUE
		ret

tiputc:		cmp	al,tminascii
		jb	SHORT @@exit
		cmp	al,tmaxascii
		ja	SHORT @@exit
		inc	bcount
		mov	dx,bcol
		cmp     dx,bcount
		jbe	SHORT @@beep

		push	ax
		call	_tcurlp
		push	dx
		add	ax,boffs
		add	ax,xoffs
		inc	ax
		push	ax
		push	dx
		dec	ax
		push	ax

		mov	ax,bcol
		sub	ax,boffs
		sub	ax,xoffs
		dec	ax
		push	ax
		call	memmove
		mov	ES,dx
		dec	ax
		mov	bx,ax
		pop	ax
		mov	ES:[bx],al

		inc	xoffs
		mov	ax,rccol
		cmp	ax,xoffs
		ja	SHORT @@toend
		dec	ax
		mov	xoffs,ax
		mov	ax,boffs
		add	ax,xoffs
		cmp	ax,bcount
		jae	SHORT @@toend
		inc	boffs
		jmp	SHORT @@toend
@@exit:		mov	ax,_TEXITCMD
		ret
@@beep:		push	23
		push	9
		call	beep
		mov	ax,bcol
		dec	ax
		mov	bcount,ax
@@toend:	mov	ax,_TCONTINUE
		ret

tinextword:	call	_tcurlp
		add	bx,boffs
		add	bx,xoffs
		xor	ax,ax
		cmp	al,ES:[bx]
		jz	SHORT @@toend
		mov	ax,boffs
		add	ax,xoffs
		cmp	ax,bcount
		jnb	SHORT @@toend
		cmp	BYTE PTR ES:[bx+1],0
		jz	SHORT @@toend
		push	bx
		inc	bx
		push	ES
		push	bx
		push	' '
		call	strchr
		pop	bx
		or	ax,ax
		jz	SHORT @@titoend
		mov	ES,dx
		xchg	ax,bx
@@1:		cmp     BYTE PTR ES:[bx],' '
		jne	SHORT @@2
		inc	bx
		jmp	SHORT @@1
@@2:		sub	bx,ax
		jmp	SHORT @@4
@@3:            dec	bx
		mov	ax,rccol
		dec	ax
		cmp	ax,xoffs
		jbe	SHORT @@5
		inc	xoffs
		jmp	SHORT @@4
@@5:		inc	boffs
@@4:		or	bx,bx
		jnz	SHORT @@3
		jmp	SHORT @@toend
@@titoend:	call	titoend
		ret
@@toend:	mov	ax,_TCONTINUE
		ret

dec_offset:	cmp	cx,xoffs
		je	SHORT @@b
		dec	xoffs
@@end:		ret
@@b:            cmp	cx,boffs
		je	short @@end
		dec	boffs
		ret

tiprevword:	mov	ax,boffs
		add	ax,xoffs
		or	ax,ax
		jz	SHORT ticontinue
		call	_tcurlp
		add	bx,boffs
		add	bx,xoffs
		dec	bx
		mov	dl,' '
		xor	cx,cx
@@2:		cmp	ES:[bx],dl
		ja	SHORT @@1
		call	dec_offset
		dec	bx
		jmp	SHORT @@2
@@1:		cmp	bx,ax
		jna	SHORT @@break
		call	dec_offset
		dec	bx
		cmp	ES:[bx],dl
		ja	SHORT @@1
@@break:	cmp	ax,bx
		jne	SHORT ticontinue
		xor	ax,ax
		mov     boffs,ax
		mov     xoffs,ax
ticontinue:	mov	ax,_TCONTINUE
		ret

tidelete:	call	_tcurlp
		add	bx,boffs
		add	bx,xoffs
		cmp	BYTE PTR ES:[bx],0
		jz	SHORT @@1
		dec	bcount
		push	dx
		push	bx
		push	dx
		inc	bx
		push	bx
		call	strcpy
		jmp	SHORT ticontinue
@@1:		mov	bx,rcrow
		dec	bx
		cmp	bx,yoffs
		jbe	SHORT ticontinue
		mov	bx,ax
		add	bx,bcol
		mov	cx,boffs
		add	cx,xoffs
		or	cx,cx
		jz	SHORT @@2
		push	ax
		push	dx
		push	bx
		call	strlen
		add	ax,bcount
		cmp	ax,bcol
		pop	ax
		jnb	SHORT @@3
		push	dx
		push	bx
		push	dx
		mov	cx,bx
		add	cx,bcol
		push	cx
		mov	cx,ax
		mov	ax,rcrow
		sub	ax,yoffs
		imul	bcol
		push	ax
		push	ES
		push	cx
		push	ES
		push	bx
		call	strcat
		call	memcpy
		jmp	SHORT @@3
@@2:		push	dx
		push	ax
		push	dx
		push	bx
		mov	ax,rcrow
		sub	ax,yoffs
		dec	ax
		imul	bcol
		push	ax
		call	memcpy
@@3:		mov	ax,rcrow
		dec	ax
		imul	bcol
		mov	edx,base
		add	dx,ax
		push	edx
		push	0
		push	bcol
		call	memset
		call	_tcurlp
		push	dx
		push	ax
		call	strlen
		mov	bcount,ax
		mov	ax,_TCONTINUE
		ret

tibacksp:       xor	cx,cx
		mov	ax,boffs
		add	ax,xoffs
		or	ax,ax
		jz	SHORT @@1
		call	dec_offset
		dec	bcount
		call	_tcurlp
		add	ax,xoffs
		add	ax,boffs
		push	dx
		push	ax
		push	dx
		inc	ax
		push	ax
		call	strcpy
		jmp	SHORT @@toend
@@1:            cmp	yoffs,cx
		jz	SHORT @@toend
		dec	yoffs
		call	tiseto
		call	titoend
		call	tidelete
@@toend:	mov	ax,_TCONTINUE
		ret

tienter:	mov	dx,rcrow
		dec	dx
		cmp	dx,yoffs
		jbe	SHORT ti_exit
		push	di
		mov	di,dx
@@loop:		cmp	di,yoffs
		jbe	SHORT @@break
		mov	ax,bcol
		imul	di
		mov	edx,base
		add	dx,ax
		push	edx
		sub	dx,bcol
		push	edx
		call	strcpy
		dec	di
		jmp	SHORT @@loop

@@break:	call	_tcurlp
		add	bx,boffs
		add	bx,xoffs
		push	bx
		push	dx
		add	ax,bcol
		push	ax
		push	dx
		push	bx
		call	strcpy
		pop	bx
		xor	ax,ax
		mov	ES:[bx],al
		inc	yoffs
		mov	boffs,ax
		mov	xoffs,ax
		pop	di
		mov	ax,_TCONTINUE
		ret

ti_exit:	mov	ax,_TEXITCMD
		ret

ti_case_mouse:	call	mousey
		mov	dx,rcy
		cmp	ax,dx
		jb	SHORT ti_exit
		add	dx,rcrow
		cmp	ax,dx
		jae	SHORT ti_exit
		push	ax
		call	mousex
		pop	cx
		mov	dx,rcx
		cmp	ax,dx
		jb	SHORT ti_exit
		add	dx,rccol
		cmp	ax,dx
		jae	SHORT ti_exit
		sub	cx,rcy
		mov	yoffs,cx
		sub	ax,rcx
		mov	xoffs,ax
		call	_tcurlp
		add	ax,boffs
		push	dx
		push	ax
		call	strlen
		cmp	ax,xoffs
		jae	SHORT @@a
		mov	xoffs,ax
@@a:		mov	ax,rcx
		add	ax,xoffs
		push	ax
		mov	ax,rcy
		add	ax,yoffs
		push	ax
		call	gotoxy
@@mouse:	call	mousep
		or	ax,ax
		jnz	SHORT @@mouse
		jmp	SHORT ti_case_continue

ti_case_up:	cmp	yoffs,0
		jz	SHORT ti_case_esc
		dec	yoffs
		jmp	SHORT ti_case_continue

ti_case_esc:	mov	ax,_TEXITCMD
		ret

ti_case_down:	mov	ax,rcrow
		dec	ax
		cmp	ax,yoffs
		jbe	SHORT ti_case_esc
		inc	yoffs
		jmp	SHORT ti_case_continue

ti_case_left:	xor	cx,cx
		call	dec_offset
ti_case_continue:
		mov	ax,_TCONTINUE
		ret

ti_case_right:	call	_tcurlp
		add	bx,boffs
		add	bx,xoffs
		mov	al,ES:[bx]
		sub	bx,xoffs
		or	al,al
		jz	SHORT @@elif

		mov	ax,rccol
		dec	ax
		cmp	ax,xoffs
		jbe	SHORT @@elif
		inc	xoffs
		jmp	SHORT ti_case_continue
@@elif:         push	ES
		push	bx
		call	strlen
		cmp	ax,rccol
		jb 	SHORT @@else
		inc	boffs
		jmp	SHORT ti_case_continue
@@else:		push	10
		push	1
		call	beep
		jmp	SHORT ti_case_continue

ti_case_home:	xor	ax,ax
		mov	xoffs,ax
		mov	boffs,ax
		jmp	SHORT ti_case_continue

tihandle_event:	mov	cx,key_count
		xor	bx,bx
@@keyloop:	cmp	ax,[bx.ti_keytable]
		jz	SHORT @@exe
		add	bx,2
		loop	SHORT @@keyloop
		call	tiputc
		ret
@@exe:		jmp	[bx.ti_proctab]
		ret

tiedit:		push	si
		push	di
		mov	si,_TCONTINUE
@@loop:		call	tiseto
		call	tiputs
		cmp	si,_TCONTINUE
		jne	SHORT @@break
		call	tgetevent
		mov	di,ax
		call	tihandle_event
		mov	si,ax
		jmp	SHORT @@loop
@@break:        call	_tcurlp
		push	dx
		push	ax
		call	strlen
		mov	bcount,ax
		mov	ax,di
		pop	di
		pop	si
		ret

timodal:	push	SS
		lea	ax,cursor
		push	ax
		call	getcursor
		push	rcx
		push	rcy
		call	gotoxy
		call	cursoron
		xor	ax,ax
		mov	xoffs,ax
		mov	yoffs,ax
		mov	boffs,ax
		call	tiseto
		call	tiedit
		push	ax
		call	tiputs
		push	cursor
		call	setcursor
		pop	ax
		ret

_TEXT		ENDS

PPROC		tdedit
ARG		base:	DWORD,\
		rect:	DWORD,\
		bcol:	WORD,\
		brow:	WORD
LOCAL		rcx:	WORD,\
		rcy:	WORD,\
		rcrow:	WORD,\
		rccol:	WORD,\
		yoffs:	WORD,\
		xoffs:	WORD,\
		boffs:	WORD,\
		bcount:	WORD,\
		cursor:	DWORD
		xor	ax,ax
		mov	al,rect.rc_x
		mov	rcx,ax
		mov	al,rect.rc_y
		mov	rcy,ax
		mov	al,rect.rc_row
		mov	rcrow,ax
		mov	al,rect.rc_col
		mov	rccol,ax
		call	timodal
@@toend:	ret
PEND		tdedit

		END
