/*
 * FILTER.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <time.h>
#include <string.h>
#include <stdlib.h>
#include <dzmain.h>

FILT *filtp;
static DOBJ *dialog;

const char cp_filter	[] = "Filter";
const char cp_directory [] = "Directory";

/* Panel Filters */

enum RCPanelFilter {
	OD_FCOUNT,
	OD_MASK,
	OD_PATH,
	OD_SET,
	OD_LOAD,
	OD_CANCEL
};

static int event_loadpath(void)
{
	char b[WMAXPATH];
	int result;

	result = tools_modalidd(WMAXPATH, b, cp_directory);
	while (mousep());
	if (result == 0 || result == MOUSECMD)
		return _C_NORMAL;
	strcpy(dialog->object[OD_PATH].data, ex_convert(b));
	return _C_REOPEN;
}

int panel_filter(panel *p, int x)
{
	WSUB *	w;
	DOBJ *	d;
	TOBJ *	o;
	char *	cp;
	int 	result;
	int 	max;

	cp = (char *)IDD_PanelFilter;
	cp[6] = x;
	if ((d = rsopen(IDD_PanelFilter)) == NULL)
		return 0;
	dialog = d;
	w = p->ide;
	o = d->object;
	o[OD_LOAD].proc = event_loadpath;
	strcpy(o[OD_MASK].data, w->mask);
	strcpy(o[OD_PATH].data, w->path);
	sprintf(o[OD_FCOUNT].data, "%d", w->maxfb);
	tdinit(d);
	result = tdevent(d);
	if (result == 0) {
		twclose(d);
		return 0;
	}
	max = atoi(o[OD_FCOUNT].data);
	strcpy(w->path, o[OD_PATH].data);
	strcpy(w->mask, o[OD_MASK].data);
	twclose(d);
	result = w->maxfb;
	if (max != result && max > 10 && max < WMAXFBLOCK) {
		if (w->fcb) {
			wsclose(w);
			w->maxfb = max;
			if (wsopen(w) == 0) {
				w->maxfb = result;
				wsopen(w);
				return 0;
			}
		}
	}
	panel_update_fcb(p);
	if (p == cpanel)
		com_setdevice(w);
	return 1;
}

int cmafilter(void)
{
	return panel_filter(&panela, 3);
}

int cmbfilter(void)
{
	return panel_filter(&panelb, 42);
}

/* Operation Filters */

enum RCOperationFilters {
	ID_INCLUDE,
	ID_EXCLUDE,
	ID_AFTER,
	ID_BEFORE,
	ID_GREATER,
	ID_LESS,
	ID_RDONLY,
	ID_HIDDEN,
	ID_SYSTEM,
	ID_VOLID,
	ID_SUBDIR,
	ID_ARCH,
	ID_OK,
	ID_CLEAR,
	ID_LOAD,
	ID_CANCEL
};

static int event_clearfilter(void)
{
	TOBJ *o;

	o = dialog->object;
	*(char *)o[ID_AFTER].data = 0;
	*(char *)o[ID_BEFORE].data = 0;
	*(char *)o[ID_GREATER].data = 0;
	*(char *)o[ID_LESS].data = 0;
	memset(&config.opfilt, 0, sizeof(FILT));
	strcpy(config.opfilt.include, cp_stdmask);
	config.opfilt.flag = 0xFFFF;
	tdsetbitflag(&o[ID_RDONLY], 6, _O_FLAGB, config.opfilt.flag);
	return _C_REOPEN;
}

static int event_loadfilter(void)
{
	char b[128];
	int result;

	result = tools_modalidd(128, b, cp_filter);
	while (mousep());
	if (result == 0 || result == MOUSECMD)
		return _C_NORMAL;
	if (dialog->index != 1)
		dialog->index = 0;
	strcpy(dialog->object[dialog->index].data, b);
	return _C_REOPEN;
}

static GCMD filter_keys[] = {
	{ F3, event_loadfilter },
	{ 0,  NULL },
};

int cmfilter(void)
{
	DOBJ *d;
	TOBJ *o;

	filtp = NULL;
	if ((d = rsopen(IDD_OperationFilters)) == NULL)
		return _C_ESCAPE;
	dialog = d;
	o = d->object;
	o[ID_INCLUDE].count = 8;
	o[ID_INCLUDE].data = config.opfilt.include;
	o[ID_EXCLUDE].count = 8;
	o[ID_EXCLUDE].data = config.opfilt.exclude;
	o[ID_CLEAR].proc = event_clearfilter;
	o[ID_LOAD].proc = event_loadfilter;
	o[ID_LOAD].data = filter_keys;
	if (config.opfilt.min_date)
		dwtolstr(o[ID_AFTER].data, config.opfilt.min_date);
	if (config.opfilt.max_date)
		dwtolstr(o[ID_BEFORE].data, config.opfilt.max_date);
	if (config.opfilt.min_size)
		sprintf(o[ID_GREATER].data, "%lu", config.opfilt.min_size);
	if (config.opfilt.max_size)
		sprintf(o[ID_LESS].data, "%lu", config.opfilt.max_size);
	tdsetbitflag(&o[ID_RDONLY], 6, _O_FLAGB, config.opfilt.flag);
	tdinit(d);
	if (tdevent(d) == 0) {
		tdclose(d);
		return _C_NORMAL;
	}
	config.opfilt.min_date = 0;
	config.opfilt.max_date = 0;
	if (*(char *)o[ID_AFTER].data)
		config.opfilt.min_date = strtodw(o[ID_AFTER].data);
	if (*(char *)o[ID_BEFORE].data)
		config.opfilt.max_date = strtodw(o[ID_BEFORE].data);
	config.opfilt.min_size = atol(o[ID_GREATER].data);
	config.opfilt.max_size = atol(o[ID_LESS].data);
	config.opfilt.flag = tdgetbitflag(&o[ID_RDONLY], 6, _O_FLAGB) | 0xFFC0;
	filtp = &config.opfilt;
	tdclose(d);
	return _C_NORMAL;
}

int test_filter(const char *name, DWORD size, WORD flag, WORD date)
{
	if (filtp == NULL)
		return 1;

	if (config.opfilt.min_size && size < config.opfilt.min_size)
		return 0;
	if (config.opfilt.max_size && size > config.opfilt.max_size)
		return 0;
	if (config.opfilt.min_date && date <= config.opfilt.min_date)
		return 0;
	if (config.opfilt.max_date && date >= config.opfilt.max_date)
		return 0;
	if ((config.opfilt.flag & flag) != flag)
		return 0;
	if (!config.opfilt.include[0] || cmpwargs(name, config.opfilt.include) == 0)
		return 0;
	if (config.opfilt.exclude[0] && cmpwargs(name, config.opfilt.exclude) == 1)
		return 0;
	return 1;
}