/*
 * CMSCREEN.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <io.h>
#include <string.h>
#include <dzmain.h>
#include <arch.h>
#include <errno.h>

static DOBJ *dialog;
const char cp_cmdreload[] = "ECHO.";

enum {  ID_DATE,
	ID_TIME,
	ID_COLOR1,
	ID_COLOR2,
	ID_COLOR3,
	ID_COLOR4,
	ID_COLOR5,
	ID_COLOR6,
	ID_USECOLOR,
	ID_EDITATTRIB,
	ID_EDITPAL,
	ID_STANDARD,
	ID_LOAD,
	ID_SAVE,
	ID_OK,
	ID_CANCEL,
	IDCOUNT		};

static COLOR color_Red;
static COLOR color_Black;
static COLOR color_Blue;
static COLOR color_Navy;
static COLOR color_Green;
static COLOR color_Yellow;

static int screen_editattrib(void);
static int screen_editpal(void);
static int screen_standard(void);
static int screen_usecolor(void);
static int screen_loadcolor(void);
static int screen_savecolor(void);
static int screen_reload(const char *);

int screen_reload(const char *p)
{
	memcpy(&config.dzcolor, p, 40);
	ex_command(cp_cmdreload);
	return _C_ESCAPE;
}

int screen_editattrib(void)
{
	if (editattrib())
		return screen_reload(at_background);
	return _C_NORMAL;
}

int screen_editpal(void)
{
	if (editpal())
		memcpy(&config.dzcolor, at_background, 40);
	return _C_NORMAL;
}

int screen_standard(void)
{
	void *p = NULL;

	switch (tdgetbitflag(&dialog->object[ID_COLOR1], 6, _O_RADIO)) {
	case 0x0001: p = &color_Navy; 	console |= CON_COLOR; break;
	case 0x0002: p = &color_Green; 	console |= CON_COLOR; break;
	case 0x0004: p = &color_Yellow;	console |= CON_COLOR; break;
	case 0x0008: p = &color_Red; 	resetpal(); break;
	case 0x0010: p = &color_Black;	resetpal(); break;
	case 0x0020: p = &color_Blue;	resetpal(); break;
	default:
		return _C_NORMAL;
	}
	return screen_reload(p);
}

int _lc_swsetflag(int, int, int);

int screen_usecolor(void)
{
	COBJ cr;
	RECT sc;
	int x,y;
	int end;
	int result;
	TOBJ *o;

	if (getcursor(&cr) == 0)
		cursoron();
	o   = &dialog->object[ID_USECOLOR];
	sc  = rcaddrc(dialog->rc, o->rc);
	x   = sc.x + 1;
	y   = sc.y;
	end = 0;
	gotoxy(x, y);

	while ( !end ) {
		result = tgetevent();
		switch (result) {
		case MOUSECMD:
			if (mousey() != y || mousex() < x - 1 || mousex() > x + 1) {
				end++;
				break;
			}
		case SPACE:
			o->flag = _lc_swsetflag(x, y, o->flag);
			if (o->flag & _O_FLAGB) {
				loadpal(at_palett);
			} else {
				resetpal();
			}
			break;
		default:
			end++;
			break;
		}
	}
	setcursor(cr);
	return result;
}

int screen_loadcolor(void)
{
	int z,h;
	char path[MAXPATH];
	char pal[MAXPATH];

	strfcat(path, programpath, "pal");
	strcpy(pal, "default");
	h = tgetline(cp_loadcolor, pal, 20, MAXPATH);
	if (h == 0 || pal[0] == 0)
		return 0;
	strfcat(path, NULL, pal);
	if (strchr(path, '.') == NULL)
		strcat(path, ".pal");
	if ((h = osopen(path, 0, M_RDONLY, A_OPEN)) == -1)
		return stderror(path, EMEROPEN, 0);
	z = osread(h, at_background, sizeof(COLOR));
	close(h);
	if (z != sizeof(COLOR))
		return _C_NORMAL;
	return screen_reload(at_background);
}

int screen_savecolor(void)
{
	int h;
	char path[MAXPATH];
	char pal[MAXPATH];

	strfcat(path, programpath, "pal");
	strcpy(pal, "default");
	h = tgetline(cp_savecolor, pal, 20, MAXPATH);
	if (h == 0 || pal[0] == 0)
		return 0;
	if (filexist(path) == 0 && wsmkdirlocal(path) == 0)
		return stderror(path, EMEROPEN, 0);
	strfcat(path, NULL, pal);
	if (strchr(path, '.') == NULL)
		strcat(path, ".pal");
	if ((h = getouthandle(path)) == -1)
		return stderror(path, EMEROPEN, 0);
	oswrite(h, at_background, sizeof(COLOR));
	close(h);
	return _C_NORMAL;
}

int cmscreen(void)
{
	DOBJ *d;
	TOBJ *o;

	if ((d = rsopen(IDD_Screen)) == 0)
		return 0;
	dialog = d;
	o = d->object;
	if (console & CON_COLOR)
		o[ID_USECOLOR].flag |= _O_FLAGB;
	o[ID_EDITATTRIB].proc = screen_editattrib;
	o[ID_EDITPAL].proc    = screen_editpal;
	o[ID_STANDARD].proc   = screen_standard;
	o[ID_USECOLOR].proc   = screen_usecolor;
	o[ID_LOAD].proc       = screen_loadcolor;
	o[ID_SAVE].proc       = screen_savecolor;
	if (console & CON_UDATE)
		o[ID_DATE].flag |= _O_FLAGB;
	if (console & CON_UTIME)
		o[ID_TIME].flag |= _O_FLAGB;
	tdinit(d);
	if (rsevent(IDD_Screen, d)) {
		if (o[ID_TIME].flag & _O_FLAGB) {
			console |= CON_UTIME;
		} else {
			console &= ~CON_UTIME;
			scputc(72, 0, 0, 8, ' ');
		}
		if (o[ID_DATE].flag & _O_FLAGB) {
			console |= CON_UDATE;
		} else {
			console &= ~CON_UDATE;
			scputc(63, 0, 0, 8, ' ');
		}
	}
	twclose(d);
	return (_end == 1) ? _C_ESCAPE : _C_NORMAL;
}

COLOR color_Red = {
	{ 0x00,0x40,0x40,0x70,0x10,0x70,0x30,0x70 },
	{ 0x00,0x0A,0x0F,0x0B,0x0F,0x07,0x08,0x07,
	  0x08,0x09,0x07,0x00,0x04,0x0A,0x0F,0x04 },
	{ 0,1,2,3,4,5,20,7,56,57,58,59,60,61,62,63 }
};

COLOR color_Black = {
	{ 0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x00 },
	{ 0x07,0x0A,0x0F,0x0B,0x0F,0x07,0x08,0x07,
	  0x08,0x0B,0x07,0x07,0x0F,0x0A,0x0B,0x0B },
	{ 0,1,2,3,4,5,20,7,56,57,58,59,60,61,62,63 }
};

COLOR color_Blue = {
	{ 0x00,0x10,0x70,0x70,0x40,0x30,0x30,0x70 },
	{ 0x00,0x0A,0x0F,0x0B,0x0F,0x07,0x08,0x07,
	  0x08,0x0B,0x00,0x00,0x0F,0x0A,0x0F,0x0F },
	{ 0,1,2,3,4,5,20,7,56,57,58,59,60,61,62,63 }
};

COLOR color_Navy = {
	{ 0x00,0x10,0x20,0x30,0x40,0x50,0x60,0x70 },
	{ 0x00,0x0D,0x0F,0x09,0x0F,0x07,0x08,0x07,
	  0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F },
	{ 0,136,7,7,4,63,3,7,56,59,0,0,4,3,63,63 }
};

COLOR color_Green = {
	{ 0x00,0x10,0x20,0x30,0x40,0x50,0x60,0x70 },
	{ 0x00,0x09,0x0F,0x09,0x0F,0x07,0x08,0x07,
	  0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F },
	{ 0,152,3,2,4,10,10,10,56,58,0,0,4,7,58,63 }
};

COLOR color_Yellow = {
	{ 0x00,0x10,0x20,0x30,0x40,0x50,0x60,0x70 },
	{ 0x00,0x0A,0x0F,0x0B,0x0F,0x07,0x08,0x07,
	  0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F },
	{ 0,54,6,6,4,62,3,6,56,48,0,0,4,2,63,0 }
};
