/* WGZREAD.C
 *
 */
#include <io.h>
#include <alloc.h>
#include <string.h>
#include <arch.h>

extern WORD zip_attrib;

int wgzreadentry(GZIP *z, int h, char *arcname)
{
	int len;
	char *p;

	zip_attrib = _A_GZ | _A_ARCH;
	if (osread(h, z, sizeof(GZIP) - 8) != sizeof(GZIP) - 8)
		return 0;
	if (z->magic != GZ_HEADERID)
		return 0;
	if ((z->flag & GZ_CONTINUATION) != 0)
		lseek(h, 0L + 2, SEEK_CUR);
	if ((z->flag & GZ_EXTRA_FIELD) != 0) {
		if (osread(h, &len, 2) != 2)
			return 0;
		lseek(h, 0L + len, SEEK_CUR);
	}
	osread(h, entryname, ARCMAXFNAME);
	lseek(h, 0L - 8, SEEK_END);
	osread(h, &z->crc, 8);
	if ((z->flag & GZ_ORIG_NAME) == 0) {
		strcpy(entryname, arcname);
		if ((p = strrchr(entryname, '.')) != NULL)
			*p = 0;
	}
	return 1;
}

int wgzread(WSUB *q)
{
	int x,h,size;
	GZIP z;
	FBLK *b;

	wsfree(q);
	if ((h = wsopenarch(q)) == -1)
		return 0;
	x = wgzreadentry(&z, h, q->file);
	close(h);
	if (x == 0)
		return 0;
	q->count  = 1;
	q->fcb[0] = fbupdir(_A_GZ);
	size = strlen(entryname) + sizeof(FBLK);
	if ((b = (FBLK *)malloc(size)) != NULL) {
		strcpy(b->name, entryname);
		b->flag = zip_attrib;
		b->size = z.size;
		b->time = 0;
		b->date = 0;
		q->fcb[1] = b;
		q->count++;
	}
	return q->count;
}
