/*
 * DTWEEKD.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <time.h>

int weekdayjan(int year)
{
	long d = DT_WEEKDAY;
	long y = DT_BASEYEAR;

	for(; y < year; y++, ++d)
		if (dt_isleap(y))
			++d;
	return (int)(d % 7);
}

int weekdaymnd(int m, int y)
{
	int d,q;

	d = weekdayjan(y);
	for (q = 1; q < m; q++)
		d += daysinmnd(q, y);
	return (d % 7);
}