/*
 * TMSGBOX.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <string.h>
#include <stdarg.h>
#include <stdio.h>
#include <dialog.h>

extern const char cp_error[];
static int _lk_msgbox(const char *, int);

int stdmsg(const char *title, const char *_frm, ...)
{
	va_list args;

	va_start(args, _frm);
	vsprintf(_bufin, _frm, args);
	va_end(args);

	return _lk_msgbox(title, _D_STDDLG);
}

int ermsg(const char *title, const char *_frm, ...)
{
	va_list args;
	const char *p;

	va_start(args, _frm);
	vsprintf(_bufin, _frm, args);
	va_end(args);

	if (title != NULL)
		p = title;
	else
		p = cp_error;
	return _lk_msgbox(p, _D_STDDLG | _D_STERR);
}

int _lk_msgbox(const char *title, int flag)
{
	DOBJ 	dl;
	TOBJ 	di[1];
	char *	p;
	char *	q;
	int  	lcount;
	int	col;
	int  	at;

	lcount = 0;
	for (p = _bufin; *p && (p = strchr(p, '\n')) != NULL; lcount++, p++)
		;

	dl.flag   = flag;
	dl.rc.x   = 10;
	dl.rc.y   = 5;
	dl.rc.row = lcount + 6;
	dl.rc.col = 60;
	dl.object = &di[0];
	dl.count  = 1;
	dl.index  = 0;

	di[0].flag   = _O_PBUTT | _O_CURID;
	di[0].rc.x   = 26;
	di[0].rc.y   = lcount + 4;
	di[0].rc.col = 6;
	di[0].rc.row = 1;
	di[0].ascii  = 'O';

	at = at_Dialog;
	if (dl.flag & _D_STERR) {
		at = at_Error;
		di[0].flag |= _O_DEXIT;
	}
	if (twopen(&dl, at, title) == 0)
		return 0;

	q = p  = _bufin;
	col    = dl.rc.col;
	lcount = 2;
	for (; *p && (p = strchr(q, '\n')) != NULL; lcount++) {
		*p++ = 0;
		if (*q)
			wcenter(dl.wp + ((lcount * col)) + 2, col - 4, q);
		q = p;
	}
	wcpbutt(rcbprc(dl.wp, di[0].rc, col), col, di[0].rc.col, "&Ok");
	if (*q)
		wcenter(dl.wp + (lcount * col) + 2, col - 4, q);

	return tdmodal(&dl);
}