;
; MAPERROR.ASM
;
; This file is part of DOSZIP
; Copyright (c) 1996 Hjort Nidudsson.
;
; Maps OS errors to errno values
;

INCLUDE		clib.inc
INCLUDE		errno.inc

ER_INVALID_FUNCTION		= 1
ER_FILE_NOT_FOUND		= 2
ER_PATH_NOT_FOUND		= 3
ER_TOO_MANY_OPEN_FILES		= 4
ER_ACCESS_DENIED		= 5
ER_INVALID_HANDLE		= 6
ER_ARENA_TRASHED		= 7
ER_NOT_ENOUGH_MEMORY		= 8
ER_INVALID_BLOCK		= 9
ER_BAD_ENVIRONMENT		= 10
ER_BAD_FORMAT			= 11
ER_INVALID_ACCESS		= 12
ER_INVALID_DATA			= 13
ER_INVALID_DRIVE		= 15
ER_CURRENT_DIRECTORY		= 16
ER_NOT_SAME_DEVICE		= 17
ER_NO_MORE_FILES		= 18
ER_WRITE_PROTECT		= 19
ER_NOT_ENOUGH_QUOTA		= 24
ER_LOCK_VIOLATION		= 33
ER_SHARINGBUF_EXCEEDED  	= 36
ER_BAD_NETPATH			= 53
ER_NETWORK_ACCESS_DENIED	= 65
ER_BAD_NET_NAME			= 67
ER_FILE_EXISTS			= 80
ER_CANNOT_MAKE			= 82
ER_FAIL_I24			= 83
ER_INVALID_PARAMETER		= 87
ER_NO_PROC_SLOTS	  	= 89
ER_DRIVE_LOCKED		 	= 108
ER_BROKEN_PIPE		 	= 109
ER_DISK_FULL		 	= 112
ER_INVALID_TARGET_HANDLE 	= 114
ER_INVALID_LEVEL		= 124
ER_WAIT_NO_CHILDREN	 	= 128
ER_CHILD_NOT_COMPLETE		= 129
ER_DIRECT_ACCESS_HANDLE		= 130
ER_NEGATIVE_SEEK		= 131
ER_SEEK_ON_DEVICE		= 132
ER_DIR_NOT_EMPTY		= 145
ER_NOT_LOCKED			= 158
ER_BAD_PATHNAME			= 161
ER_MAX_THRDS_REACHED		= 164
ER_LOCK_FAILED			= 167
ER_ALREADY_EXISTS		= 183
ER_INVALID_CODESEG		= 188
ER_LOOP_IN_RELOC_CHAIN		= 202
ER_FILENAME_EXCED_RANGE		= 206
ER_NESTING_NOT_ALLOWED		= 215

_DATA		SEGMENT

errnotable	DB	EINVAL
		DB	ENOENT
		DB	ENOENT
		DB	EMFILE
		DB	EACCES
		DB	EBADF
		DB	ENOMEM
		DB	ENOMEM
		DB	ENOMEM
		DB	E2BIG
		DB	ENOEXEC
		DB	EINVAL
		DB	EINVAL
		DB	ENOENT
		DB	EACCES
		DB	EXDEV
		DB	ENOENT
		DB	EACCES
		DB	ENOENT
		DB	EACCES
		DB	ENOENT
		DB	EEXIST
		DB	EACCES
		DB	EACCES
		DB	EINVAL
		DB	EAGAIN
		DB	EACCES
		DB	EPIPE
		DB	ENOSPC
		DB	EBADF
		DB	EINVAL
		DB	ECHILD
		DB	ECHILD
		DB	EBADF
		DB	EINVAL
		DB	EACCES
		DB	ENOTEMPTY
		DB	EACCES
		DB	ENOENT
		DB	EAGAIN
		DB	EACCES
		DB	EEXIST
		DB	ENOENT
		DB	EAGAIN
		DB	ENOMEM

doserrtable	DB	ER_INVALID_FUNCTION
		DB	ER_FILE_NOT_FOUND
		DB	ER_PATH_NOT_FOUND
		DB	ER_TOO_MANY_OPEN_FILES
		DB	ER_ACCESS_DENIED
		DB	ER_INVALID_HANDLE
		DB	ER_ARENA_TRASHED
		DB	ER_NOT_ENOUGH_MEMORY
		DB	ER_INVALID_BLOCK
		DB	ER_BAD_ENVIRONMENT
		DB	ER_BAD_FORMAT
		DB	ER_INVALID_ACCESS
		DB	ER_INVALID_DATA
		DB	ER_INVALID_DRIVE
		DB	ER_CURRENT_DIRECTORY
		DB	ER_NOT_SAME_DEVICE
		DB	ER_NO_MORE_FILES
		DB	ER_LOCK_VIOLATION
		DB	ER_BAD_NETPATH
		DB	ER_NETWORK_ACCESS_DENIED
		DB	ER_BAD_NET_NAME
		DB	ER_FILE_EXISTS
		DB	ER_CANNOT_MAKE
		DB	ER_FAIL_I24
		DB	ER_INVALID_PARAMETER
		DB	ER_NO_PROC_SLOTS
		DB	ER_DRIVE_LOCKED
		DB	ER_BROKEN_PIPE
		DB	ER_DISK_FULL
		DB	ER_INVALID_TARGET_HANDLE
		DB	ER_INVALID_HANDLE
		DB	ER_WAIT_NO_CHILDREN
		DB	ER_CHILD_NOT_COMPLETE
		DB	ER_DIRECT_ACCESS_HANDLE
		DB	ER_NEGATIVE_SEEK
		DB	ER_SEEK_ON_DEVICE
		DB	ER_DIR_NOT_EMPTY
		DB	ER_NOT_LOCKED
		DB	ER_BAD_PATHNAME
		DB	ER_MAX_THRDS_REACHED
		DB	ER_LOCK_FAILED
		DB	ER_ALREADY_EXISTS
		DB	ER_FILENAME_EXCED_RANGE
		DB	ER_NESTING_NOT_ALLOWED
		DB	ER_NOT_ENOUGH_QUOTA

_DATA		ENDS

PPROC		dosmaperr
ARG		doserr:	WORD
		push	ES
		push	dx
		push	cx
		mov	ES,CS:[DGROUP@]
		mov	dx,[doserr]
		mov	ES:[doserrno],dx
		xor	cx,cx
		jmp	SHORT @@loop
@@cmp:		mov	bx,cx
		cmp     dl,ES:[bx.doserrtable]
		jnz	SHORT @@next
		xor	ax,ax
		mov	al,ES:[bx.errnotable]
		mov	ES:[errno],ax
		jmp	SHORT @@toend
@@next:		inc	cx
@@loop:		cmp	cx,45
		jl	SHORT @@cmp
		cmp	dx,ER_WRITE_PROTECT
		jc	SHORT @@erload
		cmp	dx,ER_SHARINGBUF_EXCEEDED
		jnbe	SHORT @@erload
		mov	ES:[errno],EACCES
		jmp	SHORT @@toend
@@erload:	cmp	dx,ER_INVALID_CODESEG
		jc	SHORT @@einval
		cmp	dx,ER_LOOP_IN_RELOC_CHAIN
		jnbe	SHORT @@einval
		mov	ES:[errno],ENOEXEC
		jmp	SHORT @@toend
@@einval:	mov	ES:[errno],EINVAL
@@toend:	mov	ax,ES:[doserrno]
		pop	cx
		pop	dx
		pop	ES
		ret
PEND		dosmaperr

		END

