/*
 * TDIALOG.H
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#ifndef __INC_TDIALOG
#define __INC_TDIALOG
#if !defined(__INC_TWINDOW)
 #include <twindow.h>
#endif

#ifdef __cplusplus
 extern "C" {
#endif

#define tdhide 	twhide
#define tdshow 	twshow
#define tdclose	twclose

extern BYTE _CType tmaxascii;
extern BYTE _CType tminascii;
extern BYTE _CType tclrascii;

extern int (* _CType thelp)(void);
extern int (* _CType tupdate)(void);
extern int (* _CType tgetevent)(void);

DOBJ *_CType rsopen(ROBJ *);
int _CType rsmodal(ROBJ *);
int _CType rsevent(ROBJ *, DOBJ *);
int _CType rsreload(ROBJ *, DOBJ *);

int _CType tdopen(DOBJ *);
int _CType tdinit(DOBJ *);
int _CType tdevent(DOBJ *);
int _CType tdinitobj(DOBJ *, TOBJ *);
int _CType tdmodal(DOBJ *);
int _CType tdmemsize(DOBJ *);

int _CType getevent(void);
int _CType tupdtime(void);
int _CType tupddate(void);

int _CType tdxcellevent(DOBJ *, TOBJ *);

int _cdecl ermsg(const char *, const char *, ...);
int _cdecl stdmsg(const char *, const char *, ...);

int _CType tdedit(char *__bp, RECT __sc, int __lsize, int __lcount);
int _CType tgetline(const char *__title, char *__buf, int __lsize, int __bsize);
int _CType getxys(int, int, char *, int __lsize, int __bsize);

void _CType pbuttms(int __x, int __y, int __len);
void _CType pbuttset(int __x, int __y, int __len);
void _CType pbuttclr(int __x, int __y, int __len);

void _CType tdsetbitflag(TOBJ *, int __count, WORD __flag, DWORD __bitflag);
DWORD _CType tdgetbitflag(TOBJ *, int __count, WORD __flag);

void _CType scroll_delay(void);

#ifdef __cplusplus
 }
#endif
#endif /* __INC_TDIALOG */