; 18.07.2003 - METABOOT.BIN - a boot sector that patches others in RAM
; 28.08.2003 changed to "new style" with MetaKern in metakern.sys
;
; This boot sector is meant to be used with FreeDOS and MetaKern:
; Use it as one of the boot sectors for the MetaKern menu - read the
; MetaKern documentation for details - and it will be displayed like
; a normal FreeDOS menu item. However, this boot sector uses the copy
; of the current boot sector in RAM. Most of the work is delegated,
; and in particular, METABOOT contains no drive / partition specific
; information. That way, METABOOT makes MetaKern more flexible and
; easier to install. WARNING: This only works with FreeDOS boot sectors
; which leave a working copy of themselves at 1fe0:7c00 in RAM!
;
; Disclaimer:
;    This is an alpha version. Use it at your own risk. You may end up
;    being unable to boot (then SYS again). License: GPL 2. Copyright 2003
;    Eric Auer, eric@coli.uni-sb.de - please send feedback or patches. For
;    space reasons, please fetch the GPL text at www.gnu.org/licenses/ ...
;    Basically it means: Freeware and open source, but may only included
;    in projects which are open source, too. I allow you to boot non-free
;    operating systems using MetaKern (but not to distribute it with / as
;    part of a non-free / non-open operating system or software package).
;
; Compile:
;    nasm -o metaboot.bin metaboot.asm

        org 0x6c00	; flat binary file, gets loaded to 0:7c00 by
	; MetaKern, which passes on the current drive number in DL.
	; The org 0x6c00 is because METABOOT relocates itself by 4k
	; to make space for the FreeDOS boot sector.

; *************************************************************

start:	push dx		; SAVE DRIVE
	push cs
	pop ds		; init ds
	push cs
	pop es		; init es
	cld
	mov cx,0x100
	mov si,0x7c00	; assume being at 0:7c00
	mov di,0x6c00
	rep movsw	; relocate METABOOT to 0:6c00
	mov ax,part2
	jmp ax

;---------------

part2:	mov ax,0x1fe0	; FreeDOS boot sector should still be there
	mov ds,ax
	mov si,0x7c00	; 1fe0:7c00, not 1fe0:0...!
	mov di,0x7c00
	mov cx,0x100
	rep movsw	; copy FreeDOS boot sector back to 0:7c00
	push cs
	pop ds		; reset ds

	cmp [0x7dfe], word 0xaa55	; boot sector magic?
	jnz badluck	; give up otherwise

%ifdef OLDSTYLE
	mov ax,'KE'
%else
	mov ax,'ME'
%endif

	mov di, kernelname
	mov [di], ax	; uncloak pattern

	mov bp, 0x7c00	; search in boot sector
	call stringfind	; search in BP..BP+0x1f8, string DI, len 11
	jnz badluck	; Z = hit, at offset SI, DI unchanged

namefound:
	mov di, si		; overwrite the found string
	mov si, targetname	; by the kernel name which MetaKern
				; told us (e.g. "FDKERNELSYS").
	mov cx, 11
	rep movsb

goodluck:
	mov si,readytogomsg
	call print	; last message
	pop dx		; RESTORE DRIVE
	; mov dh,0x20	; "drive is supported by int 0x13"
	jmp word 0:0x7c00	; go for it! (and pass on DH and DL)

;---------------

badluck:
	mov si, abortmsg
	call print
	xor ax,ax
	int 0x16	; wait for a key
	int 0x19	; reboot warm
	mov al,0xfe
	out 0x64,al	; reboot cold

;---------------

stringfind:	; search for string at DI, len 11, in area BP..BP+0x1ff
		; return Z for hit at offset SI, DI unchanged
	push ax
	push cx
	xor ax,ax	; start search at buffer start
restringfind:
	mov si,bp	; buffer start
	add si,ax	; current search start
	mov cx,11
	push di
	push si		; needed for "return hit offset"
	repe cmpsb	; compare strings here
	pop si		; needed for "return hit offset"
	pop di
	jz foundstring	; ZF set - found
	inc ax		; next search start
	cmp ax,0x200-11	; still in range?
	jb restringfind
	or ax,ax	; clear ZF - not found
foundstring:
	pop cx
	pop ax
	ret

; *************************************************************

print:		; print zero-terminated string at CS:SI
	push ax	; updates SI to point to the end of the string
	push ds
	mov ax,cs
	mov ds,ax
print2:	lodsb
	or al,al
	jz eprint
	call printchar
	jmp short print2	; loop
eprint:	pop ds
	pop ax
	ret

;---------------

printchar:	; print char from AL
	push ax
	push bx
	mov ah,0x0e	; TTY
	xor bx,bx
	int 0x10	; BIOS screen stuff
	pop bx
	pop ax
	ret

; *************************************************************

%ifdef OLDSTYLE
kernelname	db "??RNEL  SYS"	; uncloaked to "KERNEL  SYS"
%else
kernelname	db "??TAKERNSYS"	; uncloaked to "METAKERNSYS"
%endif
					; at runtime

readytogomsg	db 13,10,"Now chaining to <"

targetname	db "KERNEL  SYS" 	; will be patched by MetaKern
					; before it calls METABOOT

readytogo2	db "> FreeDOS kernel loader...",13,10,0

abortmsg	db 13,10
		db "No FreeDOS boot sector in RAM at 0x1fe0:0x7c00"
		db 13,10
		db "-> giving up. Press a key to reboot.",13,10,0

; *************************************************************

		; make us exactly 3 sectors in size, for coolness:
                times   0x1fc-$+$$ db 0
sign		db 0, 0, 0x55, 0xaa	; boot sector magic value

