;    LSPPP - DOS PPP Packet Driver
;    Copyright (C) 1997-2003  David Lindauer
;
;    This program is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with this program; if not, write to the Free Software
;    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;    (for GNU General public license see file COPYING)
;
;    you may contact the author at:  mailto::camille@bluegrass.net
; 
;    or by snail mail at:
;
;    David Lindauer
;    850 Washburn Ave.  Apt #99
;    Louisville, KY 40222
;
include ppp.asi           
;
; dialer errors
;
DIAL_UNKNOWN_MODEM_RESPONSE = 1
DIAL_NO_MODEM = 2
DIAL_BAD_PHONE_NUMBER = 3
DIAL_NO_RETRIES = 4
DIAL_TIMEOUT_ERR = 5
DIAL_NO_CARRIER = 6

CGROUP group TSR,CONFIG
	assume cs:cgroup,ds:cgroup

	extrn	starttime : PROC, elapsedtime : PROC, IsXmitDone :PROC
	extrn	sendfirstbyte : PROC, condtext : PROC
	extrn   keypressed : PROC, chkkey : PROC, clflags : word
        extrn   act : byte, passwd : byte, cantext:byte
	public	dial_xmit_isr,dial_rcv_isr
	public	dial_timeout,dial_number,dial_retries, dial_flags
	public	dialer, dial_init, dialstr, dial_finish, hangup
	
TSR segment word public 'CODE'
	extrn   commport : word
dial_flags	db	0		; dialing flags
xmittop	dw	0			; top of xmit
xmitbot	dw	0			; bottom of xmit
rcvbot	dw	eorb			; bottom of receive
curtime		dw	0		; current time maintained by int
plplpl	db	3,"+++"			; go into command mode
ath0	db	5,"ATH0",13		;
waitforevent	PROC
	mov	[curtime],ax		; save time
	call	starttime		; save start time
wl:
	test	[dial_flags],DIAL_RECEIVED; wait for something
	jnz	wx		; got it, exit with carry clear
	call	chkkey    	; see if a key was pressed
	jc	wfekey		; get out if so
	call	elapsedtime	; check elapsed time
	sub	[curtime],ax
	jg	wl		; continue till done
	stc
wx:
	ret
wfekey:
	jmp	keypressed	; branch to error routine
waitforevent	ENDP
;
; send a string
;
blit	PROC
	lodsb			; get count byte
	mov	cl,al		; cx = count
	sub	ch,ch
	rep	movsb		; move it
	ret
blit	ENDP
send	PROC
	mov	di,offset cgroup:xmitbuf
send	ENDP
send2	PROC
	push	cs
	pop	es
	call	blit
	mov	[xmittop],di	; save xmit params
	mov	[xmitbot],offset cgroup:xmitbuf
	mov	di,offset cgroup:rcvbuf; init receive buffer
	mov	[rcvbot],di

	sub	al,al		; clear receive buffer
	mov	cx,20
	rep	stosb
	and	[dial_flags],NOT DIAL_RECEIVED ; nothing recived
	or	[dial_flags],DIAL_XOFF
	jmp	sendfirstbyte
send2	ENDP
;
; hang up the modem
;
hangup PROC
	mov	[dial_flags],DIALING
	mov	ax,18
	call	waitforevent
	mov	si,offset cgroup:plplpl
	call	send
	mov	ax,18
	call	waitforevent
	mov	si,offset cgroup:ath0
	call	send
	mov	ax,18
	jmp	waitforevent
hangup ENDP
;
; simple fetch_byte for xmitter
; note that the xmit and receive buffers go non-resident so we
; HAVE to dummy-proof
;
dial_xmit_isr	PROC
	mov	si,[xmitbot]
	cmp	si,[xmittop]
	jz	dxi_nomore
	lodsb
	mov	[xmitbot],si
	clc
	ret
dxi_nomore:
	stc
	ret
dial_xmit_isr	ENDP
;
; store byte during receive ISR
;
dial_rcv_isr	PROC
	cmp	al,0ah     		; ignore line feeds
	jz	drix2
	test	[dial_flags],DIAL_XOFF	; ignoring?
	jz	drixon			; no, try more
	cmp	al,0dh			; else quit ignoring if is CR
	jnz	drix2
	and	[dial_flags],NOT DIAL_XOFF
	ret
drixon:
	mov	di,[rcvbot]		; get buf pos	
	cmp	di,offset cgroup:rcvbuf ; now if the first char is a CR, ignore it
	jnz	cont
     	cmp	al,13
	jz	drix2
cont:
	cmp	di,offset cgroup:eorb		; make sure in bounds
	jnc	drix                    ; no get out
	stosb
	inc	[rcvbot]
drix:
	cmp	al,13			; see if CR
	jnz	drix2			; nope, get out
	or	[dial_flags],DIAL_RECEIVED ; mark it
drix2:
	ret
dial_rcv_isr	ENDP
TSR	ENDS
CONFIG	segment word public 'CODE'
rcvbuf		dw	80 DUP (0)	; receive buffer
eorb	label	word
xmitbuf		dw	80 dup (0)	; xmit buffer
eotb	label word
dial_timeout		dw	45*18	; configured timeout
dial_number		db	STRINGLEN DUP (0) ; configured number
dial_retries		db	5	; configured retries
timeleft		dw	0		; time for the waiting
dial_finish		dw	18	; count to delay after dialing
modemretry	db	0		; number of ATZ retries
sdialing	db	"Dialing...$"
snoconn		db	"Dialer: No Carrier...",13,10,'$' ; no carrier, can't connect
dl_unk	db	13,10,"Dialer: unknown response from modem",13,10,'$'
dl_nomodem db	13,10,"Dialer: need a hayes modem",13,10,'$'
dl_badphone db	13,10,"Dialer: no carrier",13,10,'$'
dl_noretries db	13,10,"Dialer: no retries left",13,10,'$'
dl_timeout db	13,10,"Dialer: connection timeout limit exceeded",13,10,'$'
dl_nocarrier db	13,10,"Dialer: no carrier",13,10,'$'
dl_busy	db	13,10,"Line is busy, trying again...$"
errtab	dw	cgroup:dl_unk,cgroup:dl_nomodem,cgroup:dl_badphone,cgroup:dl_noretries, cgroup:dl_timeout
	dw	cgroup:dl_nocarrier
;
; responses from a modem
;
sconnect	db	7,"CONNECT"
snodial		db	11,"NO DIALTONE"
sbusy		db	4,"BUSY"
sok		db	2,"OK"
snocarrier	db	10,"NO CARRIER"
slogin		db	5,"ogin:"
slogin2		db	8,"sername:"
slogin3		db	8,"assword:"
CR		db	1,13
;
; strings we send
;
ATZ	db	4,"ATZ",13
ATM	db	5,"ATM0",13
scrlf		db	1,13
T		db	1,"T"
dialstr db      5,"AT&F",13,256 DUP (0)
;
; if no T or P in number, a T will be added
;
ATD	db	3,"ATD"
ATX3D	db	5,"ATX3D"
;
; sent something, wait a while
;
;
; compare against known responses
;
isresponse2 PROC
	mov	di,offset cgroup:rcvbuf+1
	jmp	ir2
isresponse2 ENDP
isresponse PROC
	mov	di,offset cgroup:rcvbuf; do a string compare
ir2:
	lodsb			; get the count byte
	mov	cl,al		; to CX
	sub	ch,ch
	repe	cmpsb
	ret
isresponse ENDP
dial_init	PROC
	ret
dial_init	ENDP
;
; main dialer program
;
chkdial:
	test	al,080h		; see if connected
	jnz	nodial		; ok if so
	mov	dx,offset cgroup:snoconn	; otherwise not cnonnected
	call	condtext
	stc
	ret
nomodem:
	mov	al,DIAL_NO_MODEM
	jmp	x
nodial:	
;	and	[dial_flags],NOT DL_OPTION
	jmp	okx
dialer	PROC
	test	[clflags],L_OPTION	; get out if local mode
	jz	dialcont
	clc
	ret
dialcont:
	call	starttime	; small delay to let modem lines settle
	mov	dx,3
cddl:
	push	dx
	call	elapsedtime
	pop	dx
	sub	dx,ax
	jg	cddl

	mov	dx,[commport]
	add	dl,6		; point at MSR
	in	al,dx		; get the value
	test	[dial_flags],SHOULD_DIAL
	jz	chkdial
	test	[clflags],DF_OPTION
	jnz	godial
	test	al,080h 	; get out if already connected
	jnz	nodial
godial:
	mov	dx,offset cgroup:sdialing
	call	condtext
	mov	ax,[dial_timeout]	; set the timeout
	mov	[timeleft],ax		;
	mov	[dial_flags],DIALING	; put us in dialing mode
	mov	[modemretry],10
atzlp:
	mov	si,offset cgroup:ATZ	; before we do anything, put the prospective modem into echo mode
	call	send			; send it
	mov	ax,36			; wait 2 seconds
	call	waitforevent		; 
	jc	atzretry		; err if no response
	mov	si,offset cgroup:sok			; or if modem says not OK
	call	isresponse
	jz	hasmodem
atzretry:
        cmp     [cantext],1
        jz      nomodem
	dec	[modemretry]
	jnz	atzlp
    	jmp	nomodem
hasmodem:
	and	[dial_flags],NOT DIAL_RECEIVED ; wait 6/10ths of a second
	mov	ax,11
	call	waitforevent
	test	[dialstr],0ffh
	jz	nodialstr
	mov	si,offset cgroup:dialstr; configure modem
	call	send
	mov	ax,36			; wait a sec
	call	waitforevent			; ignore result
	and	[dial_flags],NOT DIAL_RECEIVED ; wait 6/10ths of a second
	mov	ax,11
	call	waitforevent
nodialstr:
	test	[clflags],DM_OPTION	; see if they want it mute
	jz	lp
	mov	si,offset cgroup:ATM	; yes, turn off the modem speaker
	call	send
	mov	ax,18
	call	waitforevent
lp:
	mov	di,offset cgroup:xmitbuf ; di = buffer
	mov	si,offset cgroup:ATD		; send dial string
	test	[clflags],DE_OPTION
	jz	noteurope
	mov	si,offset cgroup:ATX3D
noteurope:
	call	blit			;
	cmp	[dial_number+1],'P'	; any pulse dialing
	jz	onlynumber		; yes, no default
	cmp	[dial_number+1],'T'	; any touch dialing?
	jz	onlynumber		; yes, no default
	mov	si,offset cgroup:T			; else default to pulse
	call	blit
onlynumber:
	mov	si,offset cgroup:dial_number	; now put out their number
	call	blit
	mov	si,offset cgroup:scrlf		; and send the whole thing with CRLF
	call	send2
xlp:
	mov	di,offset cgroup:rcvbuf; init receive buffer
	mov	[rcvbot],di
	and	[dial_flags],NOT DIAL_RECEIVED ; nothing recived
	or	[dial_flags],DIAL_XOFF
	mov	ax,[timeleft]		; get timeleft
	call	waitforevent     	; wait
	jc	timeout			; get out if no time left
	mov	si,offset cgroup:sconnect	; is connect?
	call	isresponse
	jz	okx			; yes, exit carry clear
	mov	si,offset cgroup:snodial 	; no dial tone?
	call	isresponse		
	jz	badnumber               ; if not, don't bother to retry
	mov	si,offset cgroup:snocarrier	; no carrier
	call	isresponse
	jz	nocarrier			; branch to retry routine
	mov	si,offset cgroup:sbusy		;busy?
	call	isresponse
	jnz	xlp			; we don't know it so retry
retry:
	mov	ax,[curtime] 		; update total time left
	mov	[timeleft],ax
	dec	[dial_retries]		; see if more retries
	jz	noneleft			; yes, loop
	call	hangup			; hang up for retry
	mov	dx,offset cgroup:dl_busy
	call	condtext
	jmp	lp
noneleft:
	mov	al,DIAL_NO_RETRIES	; else quit
	jmp	x
nocarrier:
	mov	al,DIAL_NO_CARRIER
	jmp	x
unspecresp:
	mov	al,DIAL_UNKNOWN_MODEM_RESPONSE
	jmp	x
timeout:
	mov	al,DIAL_TIMEOUT_ERR
	jmp	x
badnumber:
	mov	al,DIAL_BAD_PHONE_NUMBER
x:
	stc
okx:

	mov	[curtime],0
	mov	[rcvbot],offset cgroup:eorb
;	mov	[xmitbot],offset cgroup:eotb
	jc	dialerr
	test	[clflags],DL_OPTION	; text mode login?
	jz	notextmode
	call	textmodelogin		; yes, do it
	jnc	dialer_x
notextmode:
	mov	ax,[dial_finish]	; wait for 1 second
	mov	[curtime],ax
	call	starttime		; save start time
wln:
	call	elapsedtime	; check elapsed time
	sub	[curtime],ax
	jg	wln		; continue till done
dialer_x:
	mov	[dial_flags],0
	clc
	ret	
dialerr:
	sub	ah,ah
	mov	bx,ax
	dec	bx
	shl	bx,1
	mov	dx,[errtab + bx]
	call	condtext
	mov	[dial_flags],0
	stc
	ret
dialer	ENDP
;
; attempt to log in in text mode
;
textmodelogin PROC
	and	[dial_flags],NOT DIAL_RECEIVED ; wait 6/10ths of a second
	or	[dial_flags],DIAL_XOFF
	mov	di,offset cgroup:rcvbuf; init receive buffer
	mov	[rcvbot],di
	call	StartTime
	mov	[curtime],18*3
tml1:
	mov	si,offset cgroup:slogin
	call	IsResponse2
	jz	enteruser
	mov	si,offset cgroup:slogin2
	call	IsResponse2
	jz	enteruser
	call	ElapsedTime
	sub	[curtime],ax
	jg	tml1
	stc
	ret
enteruser:
	and	[dial_flags],NOT DIAL_RECEIVED ; wait 6/10ths of a second
	or	[dial_flags],DIAL_XOFF
	mov	di,offset cgroup:rcvbuf; init receive buffer
	mov	[rcvbot],di
	mov	si,offset cgroup:act
	call	send
	mov	si,offset cgroup:CR
	call	send
	call	StartTime
	mov	[curtime],18*3
tml2:
	mov	si,offset cgroup:slogin3
	call	IsResponse2
	jz	enterpasswd
	call	ElapsedTime
	sub	[curtime],ax
	jg	tml2
	stc
	ret
enterpasswd:
	mov	si,offset cgroup:passwd
	call	send
	mov	si,offset cgroup:CR
	call	send
	sub	ah,ah
	ret
textmodelogin ENDP
CONFIG	ENDS
	end
