{ --------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.               }
{ (c) 1991-1999 Peter Mandrella                                   }
{ (c) 2000-2001 OpenXP-Team                                       }
{ (c) 2002-2005 FreeXP, http://www.freexp.de                      }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.     }
{                                                                 }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der }
{ Datei SLIZENZ.TXT oder auf www.crosspoint.de/oldlicense.html.   }
{ --------------------------------------------------------------- }
{ $Id: xpmime.pas,v 1.18 2005/01/01 11:16:30 mw Exp $ }

{ CrossPoint - Multipart-Nachrichten decodieren / lesen / extrahieren }

{$I XPDEFINE.INC}
{$O+,F+}

unit xpmime;

interface

uses  dos,typeform,montage,fileio,keys,lister,database,resource,
      xp0,xp1,xpglobal,xpkeys,mimedec;


type
  mpcode = (mcodeNone, mcodeQP, mcodeBase64, mcode8Bit);

      multi_part = record                   { Teil einer Multipart-Nachricht }
                     startline  : longint;  { 0 = kein Multipart }
                     lines      : longint;
                     code       : mpcode;
                     typ,subtyp : string[20];   { fr ext. Viewer }
                     level      : integer;      { Verschachtelungsebene 1..n }
                     fname      : string[40];   { fr Extrakt + ext. Viewer }
                     ddatum     : string[14];   { Dateidatum fr extrakt }
                     part,parts : integer;
                     alternative: boolean;
                     Charset    : string[30];
                   end;
      pmpdata    = ^multi_part;


procedure SelectMultiPart(select:boolean; index:integer; forceselect:boolean;
                          var mpdata:multi_part; var brk:boolean);
procedure ExtractMultiPart(var mpdata:multi_part; fn:string; append:boolean);


procedure mimedecode;    { Nachricht/Extrakt/MIME-Decode }

procedure SSP_Keys(var t:taste);
function typname(typ,subtyp:string):string;

implementation  { --------------------------------------------------- }

uses xp1o,xp3,xp3o,xp3ex,xpovl;


{ lokale Variablen von SelectMultiPart() und SMP_Keys }

const maxparts = 100;    { max. Teile in einer Nachricht }

type  mfra     = array[1..maxparts] of multi_part;
      mfrap    = ^mfra;

var   mf       : mfrap;


function typname(typ,subtyp:string):string;
var s : string[30];
begin
  if typ='text' then s:=getres2(2440,3)         { 'Text'   }
  else if typ='image' then s:=getres2(2440,4)   { 'Grafik' }
  else if typ='video' then s:=getres2(2440,5)   { 'Video'  }
  else if typ='audio' then s:=getres2(2440,6)   { 'Audio'  }
  else if typ='application' then s:=getres2(2440,7)  { 'Datei' }
  else if typ=#0'vorspann'  then s:=getres2(2440,1)  { 'Datei' }
  else if typ=#0'nachspann' then s:=getres2(2440,2)  { 'Datei' }
  else if typ=#0'gesamt'    then s:=getres2(2440,10)  { 'Datei' }
  else s:=typ;
  if subtyp='octet-stream' then subtyp:='';
  if (subtyp<>'') and (subtyp<>'plain') and (subtyp<>'octet-stream') then
    typname:=s+' ('+subtyp+')'
  else
    typname:=s;
end;


function codecode(encoding:string):mpcode;
begin
  encoding:=lstr(encoding);
  if encoding='base64' then codecode:=mcodeBase64
  else if encoding='quoted-printable' then codecode:=mcodeQP
  else if encoding='8bit' then codecode := mcode8Bit
  else codecode:=mcodeNone;
end;


procedure m_extrakt(var mpdata:multi_part);
var fn      : pathstr;
    useclip : boolean;
    brk,o   : boolean;
begin
  fn:=mpdata.fname;
  useclip:=true;                          { 'Nachrichtenteil extrahieren' }
  if ReadFilename(getres(2441),fn,true,useclip) then
  begin
    if not multipos(':\',fn) then fn:=ExtractPath+fn;
    if not UseClip and exist(fn) then
    begin
      o:=mpdata.typ<>'text';          { Falls vorhanden... Text: "anhngen" }
      o:=overwrite(fn,o,brk);         { Rest: "berschreiben"               }
    end
    else o:=true;                       { fr Clipboard immer berschreiben }
    if not exist(fn) or not brk or UseClip then
      ExtractMultiPart(mpdata,fn,not o);
    if UseClip then
      WriteClipfile(fn);
  end;
end;


procedure SMP_Keys(var t:taste); far;
begin
  Xmakro(t,16);                           { Macros des Archivviewer fuer das Popup benutzen }
  if ustr(t)='X' then
    m_extrakt(mf^[ival(mid(get_selection,57))]);
  if t=keyctcr then t:=keycr;
  if t=' ' then begin
    t:=keycr;
    mem[Seg0040:$17]:=mem[Seg0040:$17] or 4; 
    end;
end;


procedure SSP_Keys(var t:taste);          { Select-Tasten fuer SINGLE-PART MIME }
var OldET : byte;
begin
  Xmakro(t,16);                           { Macros des Archivviewer fuer das Popup benutzen }
  if ustr(t)='X' then
  begin
    OldET:=ExtraktTyp;
    ExtraktTyp:=0;                        { Als Text ohne Kopf extrahieren... }
    extrakt(1,aktdispmode,0);
    ExtraktTyp:=OldET;
    end;
  if t=keyctcr then t:=keycr;
  if t=' ' then begin
    t:=keycr;
    mem[Seg0040:$17]:=mem[Seg0040:$17] or 4; 
    end;
end;


{ Datumsformate:         11 Jan 92 01:02 +nnnn
                    Mon, 11 Jan 1992 01:02:03 +nnnn
                    Mon Jan 11, 1992 01:02:03 +nnnn  }

function RFC2Zdate(var s0:string):string;
var p,p2  : byte;
    t,m,j : word;
    h,min,s : integer;
    ti    : datetimest;
    zone  : string[10];

  function getstr:string;
  var p : byte;
  begin
    p:=cpos(' ',s0); if p=0 then p:=cpos(#9,s0);
    if p=0 then begin
      getstr:=s0; s0:='';
      end
    else begin
      getstr:=left(s0,p-1);
      s0:=trim(mid(s0,p+1));
      end;
  end;

  procedure CorrTime;           { Zonenoffset zu Zeit addieren }
  var res     : integer;
      off,moff: integer;
      p       : byte;
  begin
    val(copy(ti,1,2),h,res);
    val(copy(ti,4,2),min,res);
    val(copy(ti,7,2),s,res);
    p:=cpos(':',zone);
    if p=0 then begin
      off:=minmax(ival(mid(zone,2)),-13,13);
      moff:=0;
      end
    else begin
      off:=minmax(ival(copy(zone,2,p-2)),-13,13);
      moff:=minmax(ival(mid(zone,p+1)),0,59);
      end;
    zone:=left(zone,2)+formi(abs(off),2)+iifs(moff<>0,':'+formi(moff,2),'');
    dec(min,sgn(off)*moff);
    dec(h,off);
    while min<0  do begin  inc(min,60); dec(h); end;
    while min>59 do begin  dec(min,60); inc(h); end;
    while h<0    do begin  inc(h,24);   dec(t); end;
    while h>23   do begin  dec(h,24);   inc(t); end;
    if t<1 then begin
      dec(m);
      if m=0 then begin m:=12; dec(j); end;
      schalt(j);
      t:=monat[m].zahl;
      end
    else begin
      schalt(j);
      if t>monat[m].zahl then begin
        t:=1; inc(m);
        if m>12 then begin m:=1; inc(j); end;
        end;
      end;
  end;

begin
  p:=cpos(',',s0);
  p2:=cpos(' ',s0);
  if p>0 then
    if (p2=0) or (p2>p) then
      s0:=trim(mid(s0,p+1))   { Mon, 11 Jan ...   Wochentag killen }
    else begin                { [Mon ]Jan 11, ... }
      p2:=p-1;
      while s0[p2]<>' ' do dec(p2);
      s0:=copy(s0,p2+1,p-p2-1)+' '+copy(s0,max(1,p2-3),3)+' '+trim(mid(s0,p+1));
      end;
  t:=minmax(ival(getstr),1,31);
  p:=pos(lstr(getstr),'janfebmaraprmayjunjulaugsepoctnovdec');
  if p>0 then m:=(p+2)div 3 else m:=1;
  j:=minmax(ival(getstr),0,2099);
  if j<100 then
    if j<70 then inc(j,2000)   { 2stellige Jahreszahl ergnzen }
    else inc(j,1900);
  ti:=getstr;
  if cpos(':',ti)=0 then
    if length(ti)=4 then ti:=left(ti,2)+':'+right(ti,2)+':00'  { RFC 822 }
    else ti:='00:00:00';
  zone:=getstr;
  if zone='' then zone:='W+0'
  else if (zone[1]='+') or (zone[1]='-') then begin
    zone:='W'+left(zone,3)+':'+copy(zone,4,2);
    if lastchar(zone)=':' then zone:=zone+'00';
    end
  else zone:='W+0';
  CorrTime;
  RFC2Zdate:=formi(j,4)+formi(m,2)+formi(t,2)+formi(h,2)+formi(min,2)+
             formi(s,2)+zone;
end;



{ Liste der Teile einer Multipart-Nachricht erzeugen; }
{ Teil aus Liste auswhlen                            }

{ select:      true = Auswahlliste, falls mehr als ein Teil }
{ forceselect: true = Auswahl auch bei multipart/alternative }

procedure SelectMultiPart(select:boolean; index:integer; forceselect:boolean;
                          var mpdata:multi_part; var brk:boolean);
var   hdp      : headerp;
      hds      : longint;
      anzahl   : integer;     { Anzahl der Nachrichtenteile }
      anzahl0  : integer;     { Anzahl Nachrichtenteile ohne Gesamtnachricht }
      alter    : boolean;

  procedure MakePartlist;
  const maxlevel = 25;    { max. verschachtelte Multiparts }
        bufsize  = 2048;
  var   t      : text;
        tmp    : pathstr;
        buf    : pointer;
        bstack : array[1..maxlevel] of ^string;    { Boundaries }
        bptr   : integer;
        s,bufline : string;
        s2        : string;
        folded    : boolean;
        firstline : string[80];
        _encoding   : string[20];
        filename    : string;
        filedate    : string[14];
        subboundary : string[72];
        hdline      : string[30];
        ctype,subtype: string[15];    { content type }
        aCharset: String[30];
        vorspann : boolean;
        n,_start : longint;
        bound    : string[72];
        isbound  : boolean;
        endbound : boolean;
        last     : integer;
        endhd    : boolean;
        parname  : string[30];
        parvalue : string[100];
        stackwarn: boolean;

    label ende;

    procedure push(boundary:string);
    begin
      if bptr=maxlevel then begin
        if not stackwarn then
          rfehler(2405);   { 'zu viele verschachtelte Nachrichtenteile' }
        stackwarn:=true;
        end
      else begin
        inc(bptr);
        getmem(bstack[bptr],length(boundary)+1);
        bstack[bptr]^:=boundary;
        end;
    end;

    procedure pop;
    begin
      if bptr>0 then begin
        freemem(bstack[bptr],length(bstack[bptr]^)+1);
        dec(bptr);
        end;
    end;

    procedure reset_var;
    begin
      filename:='';
      filedate:='';
      _encoding:='';
      ctype:='';
      subtype:='';
      subboundary:='';
      aCharset:='';
    end;

    procedure GetParam;   { Content-Type-Parameter parsen }
    var p : byte;
    begin
      parname:=lstr(GetToken(s,'='));
      parvalue:='';
      if firstchar(s)='"' then delfirst(s);
      p:=1;
      while (p<=length(s)) and (s[p]<>';') do begin
        if s[p]='\' then
          delete(s,p,1);     { Quote auflsen }
        inc(p);
        end;
      parvalue:=trim(left(s,p-1));
      if lastchar(parvalue)='"' then dellast(parvalue);
      s:=trim(mid(s,p+1));
    end;

    function MimeVorspann:boolean;
    begin
      MimeVorspann:=(firstline='This is a multi-part message in MIME format.') or           { diverse }
                    (firstline='This is a multipart message in MIME format') or             { InterScan NT }
                    (firstline='Dies ist eine mehrteilige Nachricht im MIME-Format.') or    { Netscape dt. }
                    (firstline='This is a MIME-encapsulated message') or                    { Unix..? }
                    (firstline='This is a MIME encoded message.') or                        { ? }
                    (firstline='This message is in MIME format. Since your mail reader does not understand') or { MS Exchange }
                    (firstline='  This message is in MIME format.  The first part should be readable text,');   { elm }
    end;

  begin
    tmp:=TempS(dbReadInt(mbase,'msgsize'));
    extract_msg(0,'',tmp,false,0);
    assign(t,tmp);
    getmem(buf,bufsize);
    settextbuf(t,buf^,bufsize);
    reset(t);
    anzahl:=0;
    stackwarn:=false;
    firstline := '';

    if hdp^.boundary='' then begin     { Boundary erraten ... }
      n:=0; s:=''; bound:='';
      while not eof(t) and (n<100) and
         ((lstr(left(s,13))<>'content-type:') or (left(bound,2)<>'--')) do
      begin
        bound:=s;
        readln(t,s);
        inc(n);
      end;
      if bound='' then goto ende;
      hdp^.boundary:=mid(bound,3);
      close(t);
      reset(t);
    end;

    bptr:=0;
    push('--' + hdp^.boundary);
    n:=0;     { Zeilennummer }
    vorspann:=true;
    reset_var;
    last:=0;
    bufline:='';

    while not eof(t) and (anzahl<maxparts) do begin
      _start:=n+1;
      if bptr=0 then bound:=#0     { Nachspann }
      else bound:=bstack[bptr]^;
      repeat
        if bufline<>'' then begin
          s:=bufline; bufline:='';
          dec(_start);
          end
        else begin
          readln(t,s);
          inc(n);
          if (n>=1) and (FirstLine = '') then firstline:=s;
          end;
        endbound:=(s=bound+'--');
        isbound:=endbound or (s=bound);
        if (ctype='') and (s<>'') and not isbound then
          if vorspann then ctype:=#0'vorspann' {getres2(2440,1)} { 'Vorspann' }
          else ctype:=#0'nachspann' {getres2(2440,2)} ;          { 'Nachspann' }
      until isbound or eof(t);
      { Letzte Zeile im letzten Part wird sonst unterschlagen }
      if not isbound then inc(n);
      vorspann:=false;

      if not eof(t) and (ctype=#0'nachspann'{getres2(2440,2)}) then begin  { 'Nachspann' }
        { das war kein Nachspann, sondern ein text/plain ohne Subheader ... }
        ctype:='text'; subtype:='plain';
        end;

      if (ctype=#0'vorspann' {getres2(2440,1)}) and MimeVorspann then
        ctype:='';

      if ctype<>'' then begin
        inc(anzahl);
        with mf^[anzahl] do begin
          level:=bptr+last;
          typ:=LStr(ctype);
          subtyp:=LStr(subtype);
          code:=codecode(_encoding);
          mimeisodecode(filename,length(filename));
          fname:=filename;
          ddatum:=filedate;
          startline:=_start;
          lines:=n-startline;
          part:=anzahl;
          charset := LStr(aCharset);
        end;
      end;
      last:=0;

      if endbound then begin
        pop;
        s:='';
        last:=1;
        end;

      reset_var;
      if not eof(t) and not endbound then begin
        s2:='';
        repeat                       { Subheader auswerten }
          if s2<>'' then
            s:=iifs(s2=#0,'',s2)
          else begin
            readln(t,s); inc(n);
            end;
          if not eof(t) and (cpos(':',s)>0) then
            repeat                { Test auf Folding }
              readln(t,s2);
              inc(n);
              folded:=(firstchar(s2) in [' ',#9]);
              if folded then s:=s+' '+trim(s2)
              else if s2='' then s2:=#0;
            until not folded or eof(t);
          endhd:=cpos(':',s)=0;
          if endhd and (s<>'') then bufline:=s;
          hdline:=lstr(GetToken(s,':'));
          if hdline='content-transfer-encoding' then
            _encoding:=lstr(s)
          else
          if hdline='content-type' then
          begin
            ctype:=lstr(GetToken(s,'/'));
            subtype:=lstr(GetToken(s,';'));
            while s<>'' do
            begin
              GetParam;
              if (ctype='multipart') and (parname='boundary') then
                subboundary:=parvalue
              else if (parname='name') or (parname='filename') then
                filename:=parvalue
              else if (parname='x-date') then
                filedate:=RFC2Zdate(parvalue)
              else if (parname='charset') then
                aCharset := parvalue;
            end;
          end else
            { Manchmal ist der Dateiname nur im disposition-Teil enthalten }
            if (hdline='content-disposition') and (filename = '') then
            begin
              parname:=lstr(GetToken(s,'='));
              if firstchar(s)='"' then delfirst(s);
              if lastchar(s)='"' then dellast(s);
              if (pos('name', parname) >0) then filename:=left(s,cposx(';',s)-1);
            end;
        until endhd or eof(t);

        if subboundary<>'' then begin
          push('--'+subboundary);
          reset_var;
          vorspann:=true;
          end;

        end;
      end;

    pop;

    anzahl0:=anzahl;
    if anzahl>1 then begin
      inc(anzahl);
      with mf^[anzahl] do begin
        level:=1;
        typ:=#0'gesamt' {getres2(2440,10)};  { 'gesamte Nachricht' }
        subtyp:='';
        charset:='us-ascii';
        code:=mcodeNone;
        fname:='';
        startline:=1;
        lines:=n;
        part:=0;
        end;
      end;

  ende:
    close(t);
    _era(tmp);
    freemem(buf,bufsize);
  end;

  function fnform(fname:string; len:integer):string;
  begin
    if length(fname)<len then
      fnform:=rforms(fname,len)
    else if length(fname)>len then
      fnform:=left(fname,len-3)+'...'
    else
      fnform:=fname;
  end;


var i : integer;

begin                         { SelectMultiPart }
  brk:=false;
  fillchar(mpdata,sizeof(mpdata),0);
  new(hdp);
  ReadHeader(hdp^,hds,true);
  new(mf);
  MakePartlist;
  if not forceselect and (anzahl=3) and (mf^[2].typ='text')
     and (mf^[1].typ='text') and (mf^[1].subtyp='plain')
     and (((hdp^.mimetyp='multipart/alternative')      { Text+HTML Messis }
            and (mf^[2].subtyp='html'))
         or (mf^[2].subtyp='x-vcard'))                 { oder Text mit VCard }
  then begin
    index:=1;
    select:=false;                         { Standardmaessig Nur Text zeigen }
    alter:=true;
    end
  else
    alter:=false;

  if (index=0) and (anzahl>anzahl0) then
    index:=anzahl
  else
    index:=minmax(index,1,anzahl0);

  if anzahl>0 then
    if not select or (anzahl=1) then begin
      if (anzahl>1) or (mf^[index].typ <> #0'vorspann' {Lstr(getres2(2440,1))} ) then begin { 'Vorspann' }
        mpdata:=mf^[index];
        mpdata.parts:=max(1,anzahl0);
        mpdata.alternative:=alter;
        end
      end
    else begin
      listbox(56,min(screenlines-4,anzahl),getres2(2440,9) );   { 'mehrteilige Nachricht' }
      for i:=1 to anzahl do
        with mf^[i] do
          app_l(forms(sp((level-1)*2+1)+typname(typ,subtyp),25)+strsn(lines,6)+
                ' ' + fnform(fname,23) + ' ' + strs(i));
      listTp(SMP_Keys);
      ListSetStartpos(index);
      list(brk);
      if not brk then begin
        mpdata:=mf^[ival(mid(get_selection,57))];
        if FirstChar(mpdata.typ)=#0 then begin
          mpdata.typ:='text';
          mpdata.subtyp:='plain';
          end;
        mpdata.parts:=anzahl0;
        mpdata.alternative:=false;
        end;
      closelist;
      closebox;
      end;

  dispose(mf);
  dispose(hdp);
end;


{ Teil einer Multipart-Nachricht decodieren und extrahieren }

procedure ExtractMultiPart(var mpdata:multi_part; fn:string; append:boolean);
const bufsize = 2048;

var   input,t : text;
      tmp     : pathstr;
      f       : file;
      buf     : pointer;
      i       : longint;
      p,p1    : integer;
      s,s1    : string;
      rest1   : string[1];
      rest2   : string[2];
      softbreak,
      longline: boolean;
label again;

  function QP_decode(s0:string):string;              { String qp-decodieren }
  begin
    if s0<>'' then
    begin
      if softbreak then SetLength(s0,length(s0)-1);
      p:=1;
      while p<length(s0)-1 do
      begin
        while (p<length(s0)-1) and (s0[p]<>'=') do
          inc(p);
        if p<length(s0)-1 then
        begin
          s0[p]:=chr(hexval(copy(s0,p+1,2)));
          delete(s0,p+1,2);
        end;
        inc(p);
      end;
    end;
    QP_decode:=s0;
  end;

begin
  tmp:=TempS(dbReadInt(mbase,'msgsize'));
  extract_msg(0,'',tmp,false,0);
  assign(input,tmp);
  getmem(buf,bufsize);
  settextbuf(input,buf^,bufsize);
  reset(input);

  with mpdata do begin
    for i:=1 to startline-1 do
      readln(input);

    if code<>mcodeBase64 then     { plain / quoted-printable }
    begin
      assign(t,fn);
      if append then system.append(t)
      else rewrite(t);
      for i:=1 to lines do
      begin
        softbreak:=false;
        read(input,s);
        longline:=(s[0]=#255) and not eoln(input);
        if code=mcodeQP then
        begin
          if longline then
          begin
            rest2:='';
            if s[254]='=' then       { unvollstndiges qp-codiertes Zeichen }
            begin
              read(input,rest1);           { das nchste Zeichen => 'rest1' }
              rest2:=lastchar(s)+rest1;
              SetLength(s,253);
            end
            else if lastchar(s)='=' then   { unvollst. qp-codiertes Zeichen }
            begin
              read(input,rest2);        { die nchsten 2 Zeichen => 'rest2' }
              SetLength(s,254);
            end;
            if rest2<>''then                { qp-Zeichen einzeln decodieren }
            begin
              rest2:=QP_decode('='+rest2);
              s:=s+rest2;
              longline:=not eoln(input);
            end;
          end
          else softbreak:=(lastchar(s)='=');
          s:=QP_decode(s);
        end;

        if code in [mcodeNone, mcodeQP, mcode8Bit] then
          if (fname='') and (typ='text') and (subtyp<>'html') then
            CharsetToIBM(charset,s);

        write(t,s);
        if longline then dec (i)  { Rest der langen Zeile weiterbearbeiten }
        else begin                { Tricky aber erspart ein GOTO...}
          readln (input);
          if not softbreak then writeln (t);
        end;
        end;
      close(t);
      end

    else begin                          { base64 }
      assign(f,fn);
      if append then
      begin
        reset(f,1);
        seek(f,filesize(f));
      end
      else rewrite(f,1);
      s1:='';

      if lines>500 then { MK 01.02.2000 Auf 500 Zeilen angepasst }
        rmessage(2442);    { 'decodiere Binrdatei ...' }

      for i:=1 to lines do         { my: Bei Text zeilenweise konvertieren, }
      begin                        {     wegen mglicher Linebreaks mitten  }
        readln(input,s);           {     in UTF-Zeichen            10/2003  }
        DecodeBase64(s);
        if (fname='') and (typ='text') and (subtyp<>'html') then
        begin
      again:
          p:=cpos(#13,s);
          p1:=cpos(#10,s);
          if p+p1>0 then
          begin
            if (p=0) or (p1=0) then
              p:=max(p,p1)
            else
              p:=min(p,p1);
          end;
          if length(s1)<255 then
          begin
            if p=0 then          { kein CR/LF, Zeile bis max. 255 auffllen }
              p1:=255-length(s1)
            else                { CR/LF, Zeile bis CR/LF oder 255 auffllen }
              p1:=min(255-length(s1),p-1);
            s1:=s1+left(s,p1);
            delete(s,1,p1);
          end;
          if (p>0) or (length(s1)=255) then               { Daten schreiben }
          begin
            CharsetToIBM(charset,s1);
            if s1<>'' then
              blockwrite(f,s1[1],length(s1));
            if p>0 then                                             { CR/LF }
            begin
              if firstchar(s) in [#13,#10] then { Zeile bis CR/LF aufgefllt? }
              begin
                p:=1;
                while (s[p+1] in [#13,#10]) and (p<length(s)) do inc(p);
                s1:=left(s,p);
                delete(s,1,p);
                blockwrite(f,s1[1],length(s1));          { CR/LFs schreiben }
                s1:=s;                         { evtl. Rest von 's' => 's1' }
              end
              else begin                 { Zeile nicht bis CR/LF aufgefllt }
                s1:='';
                goto again;                     { Teil bis CR/LF bearbeiten }
              end;
            end
            else s1:=s;                  { kein CR/LF, Rest von 's' => 's1' }
          end;
        end
        else if s<>'' then blockwrite(f,s[1],length(s));
      end;

      if lines>500 then closebox;

      close(f);
      if ddatum<>'' then SetZCftime(fn,ddatum);
    end;
  end;
  close(input);
  _era(tmp);
  freemem(buf,bufsize);
end;

procedure mimedecode;    { Nachricht/Extract/MIME-Decode }
var mpdata : multi_part;
    brk    : boolean;
begin
  mpdata.startline:=0;
  SelectMultiPart(true,1,true,mpdata,brk);
  if not brk then
    if mpdata.startline>0 then
      m_extrakt(mpdata)
    else
      rfehler(2440);    { 'keine mehrteilige MIME-Nachricht' }
  FreeRes;
end;


end.
{
  $Log: xpmime.pas,v $
  Revision 1.18  2005/01/01 11:16:30  mw
  MW: - Willkommen im Jahr 2005

  Revision 1.17  2004/01/09 16:18:59  mw
  MW: - Wir haben jetzt 2004!!

  Revision 1.16  2003/10/18 14:30:57  my
  MY:- Fix fr letzten Commit: Wenn sich exakt an Pos. 255 ein Softbreak
       befand, wurde dies nicht als solches interpretiert, sondern statt-
       dessen ein CRLF geschrieben.

     - Code von 'm_extrakt()' vereinfacht (bei identischer Logik)

  Revision 1.15  2003/10/13 21:13:43  my
  MY:
  - Decodierung von quoted-printable-, base64-, und/oder UTF-7/8-codierten
    Textteilen in Multipart-Nachrichten korrigiert und deutlich robuster
    gestaltet, speziell im Zusammenhang mit langen Zeilen > 255 Zeichen:
    ----------------------------------------------------------------------
    1. Bei quoted-printable-codierten Zeilen mit mehr als 255 Zeichen
       wurde im Lister nur der Teil bis zu der Stelle angezeigt, die sich
       *vor* der qp-Decodierung an Pos. 255 der Zeile befand. Die bisheri-
       ge Behandlung langer Zeilen ging offenbar davon aus, da sich alle
       Mail- und Newsreader an das RFC-Limit von max. 76 Zeichen bei qp-
       codierten Zeilen halten, was in der Praxis ganz offenbar nicht der
       Fall ist.
       Die neue Routine decodiert jetzt beliebig lange qp-Zeilen korrekt
       und beachtet dabei auch alle theoretisch vorkommenden Sonderflle
       (Pos. 255 bzw. ein beliebiges Vielfaches davon oder ein "Softbreak"
       befinden sich mitten in einem codierten Zeichen, Zeichen "=" befin-
       det sich an Pos. 255, darf aber nicht als Softbreak fehlinterpre-
       tiert werden usw.).
    2. Die UTF-8-Decodierung besa grundstzlich bereits eine Vorkehrung
       gegen solche Sonderflle von "zerrissenen" codierten Zeichen (wie
       sie gerne bei zustzlich base64-codierten Texten entstehen), sie
       funktionierte im Falle langer Zeilen mit mehr als 255 Zeichen
       jedoch nur dann zuverlssig, wenn die Gesamtlnge der Zeile nicht
       mehr als 504 Zeichen betrug (ansonsten entstand Zeichenverlust).
       Auch hier werden jetzt beliebig lange Zeilen korrekt untersttzt.
    3. UTF-8-codierte Texte, die zustzlich qp-codiert waren und bei denen
       sich ein Softbreak "=" mitten in einem UTF-8-codierten Zeichen
       befand (was zulssig ist), wurden nicht korrekt decodiert, weil das
       Softbreak-Zeichen nach der qp-Decodierung und vor der bergabe des
       Strings an die UTF-8-Decodierroutine nicht entfernt wurde.
    4. Die Decodierung von base64-codierten Textteilen erfolgt jetzt immer
       "zeilenweise", d.h. anders als bisher knnen nie CRLFs (oder andere
       Zeilenabschlsse) mitten im zu decodierenden String enthalten sein.
       Dadurch werden jetzt auch UTF-8- und base64-codierte Texte, die
       durch CRLF zerrissene UTF-8-Zeichen enthalten, korrekt decodiert.
    5. Die UTF-7-Decodierung kann jetzt auch mit langen Zeilen > 255
       Zeichen sowie mit durch Softbreaks oder CRLFs zerrissenen codierten
       Zeichen umgehen; es gilt sinngem dasselbe wie bereits oben fr
       die UTF-8-Decodierung ausgefhrt.
    Anmerkung: Diese nderungen beheben noch nicht die gleichartigen
    Probleme, die zum Teil noch beim Beantworten und Weiterleiten von
    Nachrichten bestehen. Dort kann nach wie vor Zeichenverlust entstehen.

  MY:
  - Multipart-Variablen "Charset" und "aCharset" von 25 auf 30 Zeichen
    vergrert, um alle zulssigen Zeichensatzbezeichnungen untersttzen
    zu knnen.

  Revision 1.14  2003/07/30 23:09:51  my
  MY:- Source-Header auf "FreeXP" aktualisiert, einige Detailkorrekturen
       an CVS-Logs vorgenommen und hier und da CVS-Loginfos implementiert.

  Revision 1.13  2003/06/25 17:31:00  tw
  auto-de-branching

  Revision 1.12.2.30  2002/03/31 15:53:36  my
  JG:- Im MIME-Auswahlmen kann jetzt mit <Ctrl-Enter> oder <Space>
       (Leertaste) die Anzeige mit dem XP-Lister statt mit dem
       eingetragenen MIME-Viewer erzwungen werden.

  Revision 1.12.2.29  2002/03/29 15:01:54  my
  MY:- Text des letzten Commits przisiert.

  Revision 1.12.2.28  2002/03/27 19:45:18  my
  JG+MY:- Fix: Bei Dateianhngen in MIME-Multipart-Nachrichten, die nach
          der Deklaration des Dateinamens in einem "gefalteten" Header
          noch weitere Angaben wie "modification-date" enthielten, hielt
          XP diese Angaben fr einen Bestandteil des Dateinamens und
          konnte daher die Datei im Archiv-Viewer nicht korrekt
          extrahieren (bzw. gab die Fehlermeldung "Fehler beim
          Dateizugriff :-(" aus), wenn fr den MIME-Typ 'text/plain'
          der Viewer "(intern)" definiert war.

  Revision 1.12.2.27  2002/03/17 22:00:35  my
  JG:- Fix: Wenn beim Lesen von MIME-Multipart-Nachrichten die Auswahl
       "gesamte Nachricht" getroffen wurde, wurde je nach zuflligem
       Inhalt der Variable 'charset' die Nachricht mal in den IBM-
       Zeichensatz konvertiert und mal nicht.

  Revision 1.12.2.26  2002/03/14 17:34:46  my
  MY:- Das Decodieren von RFC-1522-codierten Dateinamen in Attachments
       klappte nicht (Anweisung eine Zeile zu tief einkopiert).

  Revision 1.12.2.25  2002/03/13 23:05:41  my
  RB[+MY]:- Gesamte Zeichensatzdecodierung und -konvertierung entrmpelt,
            von Redundanzen befreit, korrigiert und erweitert:
            - Alle Decodier- und Konvertierroutinen in neue Unit
              MIMEDEC.PAS verlagert.
            - Nach RFC 1522 codierte Dateinamen in Attachments werden
              jetzt decodiert (XPMIME.PAS).
            - 'MimeIsoDecode' kann jetzt auch andere Zeichenstze als
               ISO-8859-1 konvertieren. Daher erfolgt bei nach RFC 1522
               codierten Headerzeilen im Anschlu an die qp- oder base64-
               Decodierung keine starre ISO-8859-1-Konvertierung mehr,
               sondern es wird der deklarierte Zeichensatz korrekt
               bercksichtigt.
            - Untersttzung fr Zeichenstze ISO-8859-15 und Windows-1252
              implementiert.

  Revision 1.12.2.24  2002/03/08 23:14:50  my
  JG:- Fix: Textteile einer MIME-Multipart-Nachricht, die gleichzeitig
       base64- und UTF-codiert sind, werden jetzt in den IBM-Zeichensatz
       konvertiert (und daher korrekt angezeigt).

  JG+RB+MY:- Zeichensatzkonvertierung bei der Anzeige von MIME-Multipart-
             Nachrichten berarbeitet und korrigiert. Eine Konvertierung
             in den IBM-Zeichensatz findet jetzt nur noch dann statt, wenn
             es sich bei dem jeweiligen Nachrichtenteil
             - um einen Content-Type 'text/*', und
             - *nicht* um den Content-Type 'text/html', und
             - *nicht* um einen Dateianhang, und
             - um einen der ISO-8859-Zeichenstze oder einen anderen von
               XP untersttzten Zeichensatz handelt, oder wenn der
               Nachrichtenteil keine Zeichensatzdeklaration enthlt
               (letzteres ist notwendig wegen diverser kaputter Outlook-
               Versionen, die keinen Charset-Header erzeugen).
             Nicht mehr blind konvertiert werden daher u.a. Nachrichten-
             teile, deren Zeichensatz XP unbekannt ist, sowie HTML- und
             Datei-Anhnge. Bei der Auswahl "gesamte Nachricht" bzw. bei
             <Ctrl-Enter> findet ebenfalls keine Konvertierung (mehr)
             statt.

  JG:- Fix MIME-Multipart-Nachrichten: Bei Nachrichtenteilen vom Typ
       "text/plain" ohne Zeichensatzdeklaration war es vom Zufall
       abhngig, ob eine Zeichensatzkonvertierung stattfindet oder nicht
       (Charset-Variable war nicht initialisiert).

  Revision 1.12.2.23  2001/11/20 23:25:22  my
  MY:- Lizenz-Header aktualisiert

  Revision 1.12.2.22  2001/11/04 22:01:51  mk
  RB:- UTF-7 Support (dif from Andreas D. Bauer)

  Revision 1.12.2.21  2001/09/21 16:18:18  cl
  - typ is now #0'keyword' instead of GetRes2(2440,xxx),
  - the ressources are read in typname only,
  - so we can convert everything to LStr w/o damaging the case of
      strings from the ressource file

  Revision 1.12.2.20  2001/09/21 13:37:15  my
  MY:- Letzten Commit rckgngig gemacht. Fhrte zu demselben Bug, der
       mit dem vorletzten Commit gefixt wurde, obwohl die nderung an
       einer ganz anderen Stelle vorgenommen wurde. Bitte dafr sorgen,
       da die Strings im MIME-Dialog nicht in Kleinschreibung darge-
       stellt werden und dennoch alles funktioniert.

  Revision 1.12.2.19  2001/09/20 15:47:44  my
  MY:- 'LStr(ctype)' und 'LStr(subtype)' gendert in 'ctype' und 'subtype'

  Revision 1.12.2.18  2001/09/17 23:53:03  mk
  - fixed bug: sometimes singlepart mails where threated as binary mails

  Revision 1.12.2.17  2001/09/11 12:07:32  cl
  - small fixes/adaptions for MIME support (esp. 3.70 compatibility).

  Revision 1.12.2.16  2001/08/11 22:18:06  mk
  - changed Pos() to cPos() when possible, saves 1814 Bytes ;)

  Revision 1.12.2.15  2001/08/05 11:45:37  my
  - added new unit XPOVL.PAS ('uses')

  Revision 1.12.2.14  2001/07/01 23:04:17  mk
  - Fehler Base64-Dekodierung beseitigt
  - Routine DecodeBase64 von xpmime und uuz in typeform verlegt

  Revision 1.12.2.13  2001/05/30 20:19:26  my
  JG:- MIME multipart messages with lines longer than 255 chars are
       extracted correctly now (before they were truncated at pos 255)

  Revision 1.12.2.12  2000/12/25 23:57:44  mk
  - fehlerhafte Base64-Zeilen werden nicht mehr dekodiert

  Revision 1.12.2.11  2000/12/15 21:25:30  mk
  - fix fuer letzen Commit

  Revision 1.12.2.10  2000/12/15 00:25:15  mk
  - Extract von Multipartteilen mit X in Clipboard geht jetzt

  Revision 1.12.2.9  2000/11/18 23:30:57  mk
  - MIME-Erkennung wegen schrottiger Microsoft Outlook Software angepasst

  Revision 1.12.2.8  2000/10/26 13:17:36  mk
  - ISO859-1 Umwandlung immer durchfuerhen

  Revision 1.12.2.7  2000/10/24 10:17:25  mk
  - Sourceformatierungen verbessert

  Revision 1.12.2.6  2000/10/15 08:52:00  mk
  - misc fixes

  Revision 1.12.2.5  2000/08/05 14:36:57  jg
  - bei Single-Part Mime Mails kommt jetzt ebenfalls ein Auswahlmenue

  Revision 1.12.2.4  2000/08/03 14:48:26  mk
  - ein (nicht dringend noetiges) Freeres hinzugefuegt

  Revision 1.12.2.3  2000/07/27 16:16:09  mk
  - Bugfix fr den Bugfix fr einen Bugfix, der ausgeklammert wurde,
    um einen anderen Bug zu fixen, der entstand, weil man einen Bug der
    durch den ursprnglichen Bugfix entstand, an der falschen Stelle
    gefixt hatte.

  Revision 1.12.2.2  2000/07/27 14:56:52  jg
   - Mime-Extrakt - Makepartlist: INC(N) am EOF sorgt dafuer, dass die
     letzte Nachspann-Zeile angezeigt wird. Es darf nicht ausgefuehrt
     werden, wenn der Block mit EOF mit einem Boundary endet !

  Revision 1.12.2.1  2000/06/29 20:53:34  mk
  JG: - Mime-Auswahl erscheint nur noch, wenn wirklich noetig und sinnvoll

  Revision 1.12  2000/05/05 14:20:08  mk
  - erweiterte Filenamenerkennung bei MIME-Mails

  Revision 1.11  2000/04/22 23:29:55  mk
  - Endlosschleife beim QP-decodieren von Zeilen mit 255 Zeichen Laenge behoben
  - $H+ teils in xpmime implementiert um Zeilen laenger 255 Zeichen dekodieren zu koennen

  Revision 1.10  2000/03/24 17:37:05  jg
  - Mime-Extrakt: Bugfixes:
    Makepartlist: kein INC(N) mehr beim Block mit EOF
    Extraktmultipart: es wird wieder bis Lines extrahiert, nicht mehr Lines-1

  Revision 1.9  2000/03/09 22:29:56  rb
  text/html wird jetzt mit ISO-Zeichensatz exportiert

  Revision 1.8  2000/03/08 22:36:33  mk
  - Bugfixes fr die 32 Bit-Version und neue ASM-Routinen

  Revision 1.7  2000/03/01 23:41:48  mk
  - ExtractMultiPart decodiert jetzt eine Zeile weniger

  Revision 1.6  2000/02/22 15:51:20  jg
  Bugfix fr "O" im Lister/Archivviewer
  Fix fr Zusatz/Archivviewer - Achivviewer-Macros jetzt aktiv
  O, I,  ALT+M, ALT+U, ALT+V, ALT+B nur noch im Lister gltig.
  Archivviewer-Macros gltig im MIME-Popup

  Revision 1.5  2000/02/16 23:02:43  mk
  JB: * Nachricht/Extrakt/Mime Decode die Zieldatei schon vorhanden und waehlt
        entsprechend die Option Ueberschreiben/Anhaengen

}
