{ --------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.               }
{ (c) 2005      FreeXP, http://www.freexp.de                      }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.     }
{                                                                 }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der }
{ Datei SLIZENZ.TXT oder auf www.crosspoint.de/oldlicense.html.   }
{ --------------------------------------------------------------- }
{ $Id: xp9mime.pas,v 1.3 2005/09/27 11:47:06 mw Exp $ }

{ --- Bearbeitungs-Routinen fr MIME-Typen-Liste ---------------- }
{$I XPDEFINE.INC}
{F+}

unit xp9mime;

interface

const maxgl   = 40;
var  d         : pointer;
     drec      : array[1..maxgl] of longint;
     p0,p,gl   : integer;
     aufbau    : boolean;

  procedure ReadMimetyp(edit:boolean; var typ,ext,prog:string;
                        var brk:boolean);
  procedure EditMimetyp(isNew: Boolean);
  procedure DelMimetyp;

implementation  {---------------------------------------------------}

uses xp3,typeform,xp1,resource,maske,xp0,xp9sel,dbase,datadef,database,
     xp2b,xp1input;

  { --- Bearbeitungs-Routinen fr MIME-Typen-Liste ------------------}

  procedure ReadMimetyp(edit:boolean; var typ,ext,prog:string;
                        var brk:boolean);
  var x,y,add : byte;
  begin
    typ:=extmimetyp(typ);
    add:=iif(typ='*/*',0,2);
    dialog(ival(getres2(935,0)),5+add,getres2(935,iif(edit,2,1)),x,y);  { 'Viewer ndern' / 'Viewer hinzufgen' }
    if typ='*/*' then begin
      maddtext(3,2,getres2(935,3),0);                  { 'MIME-Typ         ' }
      maddtext(3+length(getres2(935,3))+2,2,typ,col.coldiahigh);
      end
    else begin
      maddstring(3,2,getres2(935,3),typ,33,40,         { 'MIME-Typ         ' }
           '"!'+without(range('#','~'),'()<>@,;:\"[]?=')); { MK 12/99 Zeichen "/" zugelassen }
        mhnr(821); {JG: 1051->821}
      maddstring(3,4,getres2(935,4),ext,5,5,'<');              { 'Dateierweiterung ' }
      mhnr(822); {JG}
      end;
    maddstring(3,4+add,getres2(935,5),prog,33,ViewprogLen,''); mhnr(823); {JG} { 'Viewer-Programm  ' }
      msetvfunc(progtest);
    freeres;
    repeat
      readmask(brk);
      if not brk and (typ+ext='') then
        rfehler(932);    { 'Es mu ein MIME-Typ oder eine Dateierweiterung angegeben werden!' }
    until brk or (typ+ext<>'');
    enddialog;
    typ:=compmimetyp(typ);
  end;

  procedure EditMimetyp(isNew: Boolean);
  var typ  : string[30];
      ext  : string[5];
      prog : string[ViewprogLen];
      brk  : boolean;
      isValid: boolean;
  begin
    if isNew then begin
      typ:= ''; ext:= ''; prog:= '';
    end else
    begin
      dbGo(d,drec[p]);
      dbReadN(d,mimeb_typ,typ);
      dbReadN(d,mimeb_extension,ext);
      dbReadN(d,mimeb_programm,prog);
    end;
    if typ = '*/*' then
    begin
      RFehler(935); { 'Standardeintrag kann nicht editiert werden' }
      exit;
    end;
    readmimetyp(not IsNew,typ,ext,prog,brk);
    if not brk then
    begin
      {  check for duplicate entries }
      isValid := true;
      if typ <> '' then
      begin
        dbSeek(mimebase,mtiTyp,UStr(typ));
        { duplicate is valid if Edit Mode and found rec = edited rec }
        if IsNew or (dbRecNo(d) <> drec[p]) then
          isValid := not (not dbBOF(mimebase) and not dbEOF(mimebase) and
            stricmp(typ,dbReadStr(mimebase,'typ')));
      end;
      if Ext <> '' then
      begin
        dbSeek(mimebase,mtiExt,UStr(Ext));
        { duplicate is valid if Edit Mode and found rec = edited rec }
        if IsNew or (dbRecNo(d) <> drec[p]) then
          isValid := isValid and not (not dbBOF(mimebase) and not dbEOF(mimebase) and
            stricmp(ext,dbReadStr(mimebase,'extension')));
      end;
      if not IsNew and (typ = '*/*') then IsValid := true;

      if isValid then
      begin
        if isNew then
          dbAppend(d)
        else
          dbGo(d,drec[p]);
        dbWriteN(d,mimeb_typ,typ);
        dbWriteN(d,mimeb_extension,ext);
        dbWriteN(d,mimeb_programm,prog);
        ReadDefaultViewers;
      end else
        RFehler(934); { Doppelte MIME-Typen oder Dateierweiterungen sind nicht erlaubt! }
      dbFlushClose(d);
      dbGo(d,drec[1]);
      if isNew then
        dbSkip(d,-1);     {ein Feld zurueck, damit Neueintrag sichtbar ist}
      aufbau:=true;
    end;
  end;

  procedure DelMimetyp;
  var
    s     : string[40];
  begin
    dbGo(d,drec[p]);
    s:=dbReadStr(d,'typ');
    if s='*/*' then
      rfehler(931)          { 'Standardeintrag kann nicht gelscht werden' }
    else begin
      if s='' then s:=dbReadStr(d,'extension');
      if ReadJN(getreps(906,s),true) then begin   { '"%s" lschen' }
        dbDelete(d);
        dbFlushClose(d);
        if p=1 then dbGoTop(d)
        else dbGo(d,drec[1]);
        aufbau:=true;
        end;
      end;
    ReadDefaultViewers;
  end;

end.
{
  $Log: xp9mime.pas,v $
  Revision 1.3  2005/09/27 11:47:06  mw
  MW: - Noch eine Repartur von Edit/Viewer

  Revision 1.2  2005/08/21 10:47:01  mw
  MW: - Fix Edit/Viewer

  Revision 1.1  2005/03/04 14:20:59  mw
  MW: - Speicherproblem in xp9.pas beseitigt.
        (Unit xp9 wurde zu gro frs Overlay)

}