{ --------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.               }
{ (c) 1991-1999 Peter Mandrella                                   }
{ (c) 2000-2001 OpenXP-Team                                       }
{ (c) 2002-2005 FreeXP, http://www.freexp.de                      }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.     }
{                                                                 }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der }
{ Datei SLIZENZ.TXT oder auf www.crosspoint.de/oldlicense.html.   }
{ --------------------------------------------------------------- }
{ $Id: xpe.pas,v 1.20 2005/01/01 11:16:30 mw Exp $ }

{ CrossPoint - Editor }

{$I XPDEFINE.INC}
{$O+,F+}

unit xpe;

interface

uses
  crt,dos,dosx,typeform,fileio,inout,keys,winxp,maus2,resource,maske,
  eddef,editor,xpglobal,xp0,xp1o,xp1help,xp1input,xpkeys,xp5,xp10,lfn;


const EditXkeyfunc : EdTProc = nil;
Var   EditNachricht : boolean;  
      SendNachricht : boolean;
      Skip4parken   : boolean;

procedure TED(const fn:string; reedit:boolean; keeplines:byte;
              ukonv:boolean; const nachricht,senden:boolean);
procedure SigEdit(const datei:string);
procedure EditText;
procedure Notepad;
procedure EditSetbetreff(const betr:string; maxlen:byte);
function  EditGetBetreff:string;

function  EditKeyFunc(var t:taste):boolean;

function  EditQuitfunc(ed:ECB):taste;               { Speichern: J/N/Esc }
function  EditOverwrite(ed:ECB; fn:string):taste;   { berschr.: J/N/Esc }
procedure EditMessage(txt:string; error:boolean);
procedure EditAskFile(ed:ECB; var fn:string; save,uuenc:boolean);
function  EditFindfunc(ed:ECB; var txt:string; var igcase:boolean):boolean;
function  EditReplfunc(ed:ECB; var txt,repby:string; var igcase:boolean):boolean;
procedure EditCfgFunc(var cfg:EdConfig; var brk:boolean);
procedure Editor_options;


implementation  {--------------------------------------------------------}

uses  xp1,xp6o;

const edbetreff     : ^string = nil;
      doautosave    : boolean = false;
      inited        : boolean = false;
 
var
      edbmaxlen : byte;      { maximale Betrefflnge }
      EdCfg     : EdConfig;


procedure setcolors;
var ecol : EdColrec;
    i    : integer;
begin
  ecol.coltext:=col.coledittext;
  ecol.colstatus:=col.coleditstatus;
  ecol.colmarked:=col.coleditmarked;
  for i:=1 to 9 do
    if quotecolors then
      ecol.colquote[i]:=col.coleditquote[i]
    else
      ecol.colquote[i]:=col.coleditquote[1];
  ecol.colendmark:=col.coleditendmark;
  ecol.colmenu:=col.coleditmenu;
  ecol.colmenuhi:=col.coleditmenuhi;
  ecol.colmenuinv:=col.coleditmenuinv;
  ecol.colmenuhiinv:=col.coledithiinv;
  EdSetColors(ecol);
end;

{$IFDEF FPC }
  {$HINTS OFF }
{$ENDIF }


function EditQuitfunc(ed:ECB):taste;   { Speichern: J/N/(P/)Esc }
var brk : boolean;
begin
  if EditNachricht and SendNachricht then 
  begin 
     {skip4parken:=false; }
     case ReadIt(length(getres2(2500,4))+11,getres2(2500,3),getres2(2500,4),1,brk) of
       0,4 : EditQuitFunc:=keyesc;
       1   : EditQuitFunc:=_jn_[1];
       2   : EditQuitFunc:=_jn_[2];
       3   : begin
               skip4parken:=true;
               EditQuitFunc:=_jn_[1];
               end; 
       end;
     end
   else begin
     case ReadIt(length(getres2(2500,2))+9,iifs(EditNachricht,getres2(2500,3),getres2(2500,1)),getres2(2500,2),1,brk) of
       0,3 : EditQuitFunc:=keyesc;
       1   : EditQuitFunc:=_jn_[1];
       2   : EditQuitFunc:=_jn_[2];
       end;
     end; 
  freeres;
end;

function EditOverwrite(ed:ECB; fn:string):taste;   { berschr.: J/N/Esc }
var brk : boolean;
begin
  if Overwrite(fn,false,brk) then EditOverwrite:=_jn_[1]
  else EditOverwrite:=iifs(brk,keyesc,_jn_[2]);
end;

procedure EditMessage(txt:string; error:boolean);
begin
  if error then fehler(txt)
  else hinweis(txt);
end;

procedure EditAskFile(ed:ECB; var fn:string; save,uuenc:boolean);
var useclip : boolean;
begin
  if save then fn:='' else fn:=SendPath+'*.*';
  useclip:=false;          { 'Block speichern' / 'Block laden' }
  if readfilename(getres(iif(save,2504,2505))
                  +iifs(uuenc,' '+getres(2509),'')
                  ,fn,true,useclip) then begin
    if not multipos('\:',fn) then fn:=sendpath+fn;
    end
  else
    fn:='';
end;

function EditFindfunc(ed:ECB; var txt:string; var igcase:boolean):boolean;
var x,y : byte;
    brk : boolean;
begin
  dialog(ival(getres2(2506,0)),5,getres2(2506,1),x,y);    { 40 / 'Suchen' }
  maddstring(3,2,getres2(2506,2),txt,ival(getres2(2506,0))-   { 'Text  ' }
                   length(getres2(2506,2))-7,MaxFindLen,''); mnotrim;
  maddbool(3,4,getres2(2506,3),igcase);     { 'Schreibweise ignorieren' }
  readmask(brk);
  EditFindfunc:=not brk;
  enddialog;
  freeres;
end;

function EditReplfunc(ed:ECB; var txt,repby:string; var igcase:boolean):boolean;
var x,y : byte;
    brk : boolean;
begin
  dialog(ival(getres2(2506,10)),7,getres2(2506,11),x,y);    { 40 / 'Suchen/ersetzen' }
  maddstring(3,2,getres2(2506,12),txt,ival(getres2(2506,10))-   { 'Text  ' }
                 length(getres2(2506,12))-7,MaxFindLen,''); mnotrim;
  maddstring(3,4,getres2(2506,13),repby,ival(getres2(2506,10))-  { 'ersetzen durch ' }
                 length(getres2(2506,13))-7,MaxFindLen,''); mnotrim;
  maddbool(3,6,getres2(2506,3),igcase);     { 'Schreibweise ignorieren' }
  readmask(brk);
  EditReplfunc:=not brk;
  enddialog;
  freeres;
end;

procedure EditCfgFunc(var cfg:EdConfig; var brk:boolean);
var x,y : byte;
    ec  : string[1];
begin
  with cfg do begin
    dialog(ival(getres2(2508,0)),9,getres2(2508,1),x,y);  { 30 / 'Editor-Einstellungen' }
    maddint(3,2,getres2(2508,2),rechter_rand,5,2,60,77);  { 'rechter Rand  ' }
    mhnr(8063);
    ec:=absatzendezeichen;
    maddstring(3,4,getres2(2508,3),ec,1,1,range(#1,#254));  { 'Absatzendezeichen' }
    mappsel(false,''#20''#17' ');
    maddbool(3,6,getres2(2508,4),AutoIndent);             { 'autom. einrcken' }
    maddbool(3,7,getres2(2508,5),PersistentBlocks);       { 'persistente Blcke' }
    maddbool(3,8,getres2(2508,6),QuoteReflow);            { 'Quote-Reflow' }
    readmask(brk);
    enddialog;
    if not brk then begin
      if ec='' then absatzendezeichen:=' '
      else absatzendezeichen:=ec[1];
      end;
    end;
end;

procedure InitEditor;
var p : EdProcs;
begin
  EdInitDefaults(color);
  EdgetConfig(EdCfg);
  setcolors;
  EdGetProcs(p);
  with p do begin
    QuitFunc:=EditQuitfunc;
    Overwrite:=EditOverwrite;
    MsgProc:=EditMessage;
    FileProc:=EditAskFile;
    FindFunc:=EditFindFunc;
    ReplFunc:=EditReplFunc;
    CfgFunc:=EditCfgFunc;
    end;
  EdSetProcs(p);
  EdSelcursor:=auswahlcursor;
end;

procedure EditSetLangdata;
var ld : LangData;
    i  : integer;
begin
  fillchar(ld,sizeof(ld),0);
  with ld do begin
    ja:=_jn_[1];
    nein:=_jn_[2];
    zeile:=getres2(2503,1);
    spalte:=getres2(2503,2);
    for i:=1 to 7 do
      errors[i]:=getres2(2503,10+i);
    askreplace:=getres2(2503,20);
    replacechr:=getres2(2503,21);
    ersetzt:=getres2(2503,22);
    drucken:=getres2(2503,23);
    for i:=0 to editmenumps do
      menue[i]:=getres2(2503,30+i);
    freeres;
    EdSetLanguage(ld);
    end;
end;


procedure EditBetreff; forward;

function EditKeyFunc(var t:taste):boolean;
begin
  if (edbetreff<>nil) and (t=keyaltb) then EditBetreff;
  if (@EditXKeyFunc<>nil) and EditXKeyFunc(t) then;
  if t=keyf6 then Makroliste(6)
  else XMakro(t,32);
  EditKeyFunc:=false;
end;


procedure TED(const fn:string; reedit:boolean; keeplines:byte;
              ukonv:boolean; const nachricht,senden:boolean);
const EditFusszeile = false;
var   ed     : ECB;
      p      : scrptr;
      mb     : byte;
      mt     : boolean;
begin
  FlushClose;
  if not inited then begin
    InitEditor; inited:=true;
    end
  else begin
    SetColors;
    EdSetConfig(EdCfg);
    end;
  EditSetLangData;
  mt:=m2t;
  if keeplines>0 then begin
    mb:=dphback; if Nachricht then dphback:=col.coledithead;
    m2t:=true;
    Disp_DT;
    end
  else
    m2t:=false;
  ed:=EdInit(1,80,1+keeplines,screenlines-iif(EditFusszeile,1,0),{74}0,true,2,OtherQuoteChars);
  if EdLoadFile(ed,fn,reedit,{iif(reedit,}1{,0)}) then;
  sichern(p);
  if EditFusszeile then DispFunctionkeys(true);
  EdSetTProc(ed,EditKeyFunc);
 (* EdPointswitch(deutsch); { Yuppie-Schalter } *)
  EdSetUkonv(ukonv);
  if doautosave then EdAutosave;
  doautosave:=false;
  maus_pushinside(1,screenwidth,1,screenlines);
  if EdEdit(ed,nachricht,senden)=0 then;
  EdGetConfig(EdCfg);
  maus_popinside;
  if keeplines>0 then dphback:=mb;
  m2t:=mt;
  holen(p);
  EdExit(ed);
  if Nachricht and Skip4parken then
    pushkey(copy(getres2(611,30),1,1));
end;


{ --- Nachrichteneditor ------------------------------------------- }

procedure EditSetbetreff(const betr:string; maxlen:byte);
begin
  getmem(edbetreff,maxlen+1);
  edbmaxlen:=maxlen;
  edbetreff^:=betr;
end;

function EditGetBetreff:string;
begin
  if edbetreff=nil then
    EditGetbetreff:=''
  else begin
    EditGetbetreff:=edbetreff^;
    freemem(edbetreff,edbmaxlen+1);
    edbetreff:=nil;
    end;
end;

procedure EditBetreff;
var x,y : byte;
    brk : boolean;
begin
  if edbetreff=nil then exit;
  dialog(min(edbmaxlen+7+length(getres(2507)),70),3,'',x,y);
  maddstring(3,2,getres(2507),edbetreff^,min(edbmaxlen,48),edbmaxlen,'');
  msetvfunc(xp6o.umlauttest); mhnr(88);
  readmask(brk);
  enddialog;
  if not brk then begin
    attrtxt(col.coledithead);
    mwrt(2,2,forms(getres2(611,42)+edbetreff^,79));
    freeres;
    end;
end;


{ --- Signatureditor ---------------------------------------------- }


procedure SigEdit(const datei:string);
var ok   : boolean;
    x,y  : byte;
    n,nn : shortint;
    a    : taste;
    i    : integer;
    s    : string;
    t    : text;
begin
  repeat
    editfile(datei,false,false,false,1,false);    { in XP1 }
    if _filesize(datei)<=MaxSigsize then
      ok:=true
    else begin
      assign(t,datei);
      reset(t);
      readln(t,s);
      close(t);
      if s='-*-' then
        ok:=true
      else begin
        nn:=ival(getres2(2501,1));
        msgbox(51,nn+6,getres2(2501,0),x,y);     { 'Hinweis' }
        for i:=1 to nn-1 do
          mwrt(x+3,y+1+i,getreps2(2501,i+1,strs(MaxSigsize)));
        mwrt(x+3,y+2+nn,getres2(2501,nn+1));      { 'Zurck zum Editor?' }
        errsound;
        a:='';
        n:=readbutton(x+3,y+8,2,getres2(2501,6),1,true,a);   { '  ^Ja  , ^Nein ' }
        freeres;
        closebox;
        ok:=(n<>1);
        end;
      end;
  until ok;
end;


procedure EditText;
var s       : string;
    useclip : boolean;
begin
  if keepedname then
    s:=editname
  else
    s:=sendpath+WildCard;
  useclip:=true;
  pushhp(11607);
  if readfilename(getres(2502),s,true,useclip) then begin   { 'Text bearbeiten' }
    if not multipos(DirSepa+':',s)
      then s:=sendpath+s;
    editname:=s;
    EditFile(s,false,false,false,0,false);
    if useclip then WriteClipfile(s);
    end;
  pophp;
end;


procedure Notepad;
var s  : string;
    ma : byte;
begin
  s:='NOTEPAD';
  doautosave:=true;
  ma:=lastattr;
  savecursor;
  pushhp(54);
  EditFile(s,false,false,false,0,false);
  pophp;
  restcursor;
  attrtxt(ma);
end;


procedure Editor_options;  { EditorOptionen Extern aendern }
var config : Edconfig;
    brk    : boolean;
    t      : text;
    s      : string;
    p      : byte;

begin
  assign(t,editor.EdConfigFile);
  brk:=true;

  if not existf(t) then            { neues Defaultconfig erstellen }
  begin
    config.rechter_rand:=74;
    config.absatzendezeichen:='';
    config.AutoIndent:=true;
    config.PersistentBlocks:=true;
    config.QuoteReflow:=true;
    end

  else begin
    reset(t);                      { oder existierendes Configfile laden }
    while not eof(t) do begin
      readln(t,s);
      LoString(s);
      p:=cpos('=',s);
      with config do       
        if p>0 then
          if left(s,p-1)='rechterrand' then
            config.rechter_rand:=ival(mid(s,p+1))
          else if left(s,p-1)='absatzende' then
            config.absatzendezeichen:=iifc(p<length(s),s[p+1],' ')
          else if left(s,p-1)='autoindent' then
            config.AutoIndent:=(mid(s,p+1)<>'n')
          else if left(s,p-1)='persistentblocks' then
            config.PersistentBlocks:=(mid(s,p+1)<>'n')
          else if left(s,p-1)='quotereflow' then
            config.QuoteReflow:=(mid(s,p+1)<>'n');
      end;
    close(t);
    end;

  EditCfgFunc(config,brk);         { Menue aufrufen }

  if not brk then begin            { und Aenderungen speichern }
    rewrite(t);
    with Config do begin
      writeln(t,'RechterRand=',rechter_rand);
      writeln(t,'AbsatzEnde=',absatzendezeichen);
      writeln(t,'AutoIndent=',iifc(AutoIndent,'J','N'));
      writeln(t,'PersistentBlocks=',iifc(PersistentBlocks,'J','N'));
      writeln(t,'QuoteReflow=',iifc(QuoteReflow,'J','N'));
      end;
    close(t);
    end;
  inited:=false;
  menurestart:=brk;
end;

end.

{
  $Log: xpe.pas,v $
  Revision 1.20  2005/01/01 11:16:30  mw
  MW: - Willkommen im Jahr 2005

  Revision 1.19  2004/01/09 16:18:59  mw
  MW: - Wir haben jetzt 2004!!

  Revision 1.18  2003/07/30 23:09:50  my
  MY:- Source-Header auf "FreeXP" aktualisiert, einige Detailkorrekturen
       an CVS-Logs vorgenommen und hier und da CVS-Loginfos implementiert.

  Revision 1.17  2003/06/25 17:30:17  tw
  auto-de-branching

  Revision 1.16.2.9  2002/04/21 20:10:13  my
  MY:- Einige Funktionen von xp6 nach xp6o verlagert, um etwas Platz
       im Codesegment fr die kommenden forcebox-Fixes zu schaffen.

  Revision 1.16.2.8  2002/04/19 16:38:06  my
  JG[+MY]: MIME-Multipart-Versand (RFC/ZConnect) implementiert :-):
           OpenXP/16 kann jetzt standardkonforme MIME-Multipart-Nachrich-
           ten erzeugen und versenden. Es knnen sowohl im Sendefenster
           als auch direkt im Editor (!) Dateien und Textteile beliebiger
           Anzahl und Gre an die aktuelle Nachricht angehngt werden.
           Die nderung der Reihenfolge bereits angehngter Nachrichten-
           teile ist mglich, das Weiterleiten von MIME-Multipart-
           Nachrichten mittels N/W/K, N/W/O, N/W/E und N/W/R wird jetzt
           ebenfalls untersttzt. Weitere Details siehe Hilfe (?/S/A).
           Kompletter Sourcecode fr XP entwickelt von JG, Anpassungen
           an und Einbau in OpenXP/16 durch MY.
           Spezieller Dank an HH fr die Vorarbeit im Rahmen der
           Entwicklung des XP-Tools XPBMIME, dessen Arbeitsweise teilweise
           als Ansto und Vorlage fr die aktuelle XP-Implementation
           diente, sowie an JM fr seine Mitarbeit daran, speziell im
           Bereich Zeichensatzbehandlung und ZConnect-Konformitt.

  Revision 1.16.2.7  2002/04/19 15:51:30  my
  MY:- Taste fr "Parken" im Editor wird jetzt aus Ressource ausgelesen

  Revision 1.16.2.6  2002/03/17 21:48:17  my
  MY:- Fix: Wenn whrend des Editierens einer Nachricht mit <Alt-E> eine
       externe Datei editiert wurde, dann wurde beim Verlassen der
       Nachricht diese ebenfalls als Datei behandelt (kein 'Parken'-
       Button, falscher Dialog "Datei wurde gendert").

  Revision 1.16.2.5  2001/10/22 23:05:35  my
  MY:- Option "Parken" beim Editieren von Nachrichten erscheint nur noch,
       wenn es sich auch um eine zu versendende Nachricht handelt (also
       nicht bei N//T)

  Revision 1.16.2.4  2001/09/16 20:35:22  my
  JG+MY:- Beim Editieren von Nachrichten gibt es im "nderungen
          speichern?"-Dialog die Option "Parken", die direkt ein "P" ans
          Sendefenster weiterleitet.

  MY:- Copyright-/Lizenz-Header aktualisiert

  Revision 1.16.2.3  2001/08/11 20:16:30  mk
  - added const parameters if possible, saves about 2.5kb exe

  Revision 1.16.2.2  2000/12/12 14:03:57  mk
  - weitere lfn-fixes

  Revision 1.16.2.1  2000/11/24 15:23:47  mk
  - Edit/Config uebernimmt Optionen jetzt immer

  Revision 1.16  2000/05/22 16:12:11  hd
  - Anpassung an UnixFS (Filesystem)
  - screenwidth statt 80 (Screen)

  Revision 1.15  2000/05/09 13:13:10  hd
  - UnixFS: EditText angepasst

  Revision 1.14  2000/05/07 10:42:04  hd
  - Linux: Variable Fensterbreite

  Revision 1.13  2000/05/02 19:14:02  hd
  xpcurses statt crt in den Units

  Revision 1.12  2000/04/15 14:08:06  jg
  - Bugfix: Erstaufruf der Editoroptionen ging nur aus dem Editor heraus.

  Revision 1.11  2000/04/14 14:55:35  jg
  - Bugfix: es gab zwei Routinen namens Editoptions...

}
