{ --------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.               }
{ (c) 1991-1999 Peter Mandrella                                   }
{ (c) 2000-2001 OpenXP-Team                                       }
{ (c) 2002-2005 FreeXP, http://www.freexp.de                      }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.     }
{                                                                 }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der }
{ Datei SLIZENZ.TXT oder auf www.crosspoint.de/oldlicense.html.   }
{ --------------------------------------------------------------- }
{ $Id: xp2.pas,v 1.68 2005/01/01 11:16:28 mw Exp $ }

{ CrossPoint - StartUp }

{$I XPDEFINE.INC}
{$O+,F+}

unit xp2;

interface

uses crt, xpcfg,
     dos,dosx,typeform,fileio,keys,inout,winxp,mouse,datadef,database,
     databaso,maske,video,help,printerx,lister,win2,maus2,crc,clip,
     resource,montage, xpglobal, xp0,xp1,xp10,xp1o2,xp1input,
     xp1help,xp5,xpdatum,lfn;

var
  { First start of XP2? }
  XPFirstStart: Boolean;

procedure zusatz_menue;
procedure setaltfkeys;

procedure defaultcolors;
procedure readcolors;
procedure setcolors;
procedure readpar;
procedure GetResdata;
procedure FreeResdata;
procedure loadresource;
procedure setmenus;
procedure freemenus;

procedure initvar;
procedure SetNtAllowed;
procedure readconfig;
procedure saveconfig;
procedure SaveConfig2;
procedure cfgsave;       { mit Fenster }
procedure GlobalModified;
function  AskSave:boolean;
procedure read_regkey;   { registriert? }
procedure test_pfade;
procedure test_defaultbox;
procedure test_defaultgruppen;
procedure test_systeme;
procedure testdiskspace;
procedure testfilehandles;
procedure TestAutostart;
procedure ReadDomainlist;
procedure setAutoTZ(const XPStart:boolean);
procedure checkTimeZone(const XPStart:boolean);

implementation  {-----------------------------------------------------}

uses
  xp2b,xp1o,xpe,xp3,xp9bp,xp9,xpnt,xpfido,xpkeys,xpreg,xpovl;

procedure setmenu(nr:byte; s:string);
begin
  getmem(menu[nr],length(s)+1);
  menu[nr]^:=s;
end;

procedure zusatz_menue;         { Zusatz-Men neu aufbauen }
var s       : string;
    i,ml    : byte;
    n       : byte;
    m1empty : boolean;
  begin
  freemem(menu[2],length(menu[2]^)+1);
  freemem(menu[menus],length(menu[menus]^)+1);
  s:=''; ml:=14;
  n:=0;

  for i:=1 to 10 do                                  { Zusatzmenue 1-10 }
    with fkeys[0]^[i] do
      if menue<>'' then begin
        s:=s+','+hex(i+$24,3)+menue;
        ml:=max(ml,length(menue)-iif(cpos('^',menue)>0,3,2));
        inc(n);
        end;
  m1empty:=false;
  if s<>'' then s:=',-'+s else m1empty:=true;
  s:='Zusatz,'+forms(getres2(10,100),ml+4)+'@K,'+getres2(10,101)+s;
  getmem(menu[2],length(s)+1);
  menu[2]^:=s;

  s:='';
  for i:=1 to iif(screenlines=25,9,10) do            { Zusatzmenue 11-20 }
    with fkeys[4]^[i] do
      if menue<>'' then begin
        s:=s+','+hex(i+$24,3)+menue;
        ml:=max(ml,length(menue)-iif(cpos('^',menue)>0,3,2));
        inc(n);
        end;
  if m1empty and (s<>'') then s:=',-'+s; 
  getmem(menu[menus],length(s)+1);
  menu[menus]^:=s;
end;

procedure setmenus;
var i : integer;
begin
  for i:=0 to menus do
    if (i<>11) then setmenu(i,getres2(10,i));
  zusatz_menue;
  case videotype of
    0,1 : setmenu(11,'Zeilen,0b125');
    2   : setmenu(11,'Zeilen,0b125,0b226,0b329,0b431,0b535,0b638,0b743,0b850');
    3   : setmenu(11,'Zeilen,0b125,0b226,0b328,0b430,0b533,0b636,0b740,0b844,0b950');
  end;
  FreeRes;
end;


procedure freemenus;
var i : integer;
begin
  for i:=0 to menus do
    freemem(menu[i],length(menu[i]^)+1);
end;


procedure readmenudat;   { Liste der unsichtbaren Menpunkte einlesen }
var f       : file;
    version : integer;
    i,j,w   : integer;
begin
  anzhidden:=0;
  if ParMenu then exit;
{$IFDEF Debug }
  dbLog('-- Mendatei einlesen');
{$ENDIF }
  assign(f,menufile);
  if existf(f) then begin
    reset(f,1);
    blockread(f,version,2);
    if version=1 then begin
      blockread(f,anzhidden,2);
      anzhidden:=minmax(anzhidden,0,min(maxhidden,filesize(f) div 2 - 2));
      if anzhidden>0 then begin
        getmem(hidden,2*anzhidden);
        blockread(f,hidden^,2*anzhidden);
        end;
      end;
    close(f);
    end;
  if anzhidden>0 then             { zur Sicherheit nochmal sortieren... }
    for i:=anzhidden downto 2 do
      for j:=1 to i-1 do
        if hidden^[j]>hidden^[j+1] then begin
          w:=hidden^[j];
          hidden^[j]:=hidden^[j+1];
          hidden^[j+1]:=w;
          end;
end;


procedure HelpScreen;
var n,i     : integer;
    t       : taste;
    sclines : byte;
begin
  DosOutput;
  iomaus:=false;
  n:=res2anz(202);
  writeln;
  sclines:=getscreenlines;
  for i:=1 to n do begin
    writeln(getres2(202,i));
    if (i+5) mod (sclines-1)=0 then
      if not outputredirected then begin
        write(getres(12));
        get(t,curon);
        write(#13,sp(30),#13);
        end;
    end;
  CloseResource;
  runerror:=false;
  halt;
end;


procedure readpar;
var i  : integer;
    s  : string[127];
    t  : text;
    sr : searchrec;

  function _is(ss:string):boolean;
  begin
    _is:=('/'+ss=lstr(s)) or ('-'+ss=lstr(s));
  end;

  function isl(ss:string):boolean;
  begin
    isl:=('/'+ss=lstr(left(s,length(ss)+1))) or
         ('-'+ss=lstr(left(s,length(ss)+1)));
  end;

  function ReplDP(s:string):string;   { Fido-Boxname: "_" -> ":" }
  var p1,p2 : byte;
  begin
    p1:=cpos(':',s);
    p2:=cpos('_',s);
    if (p2>0) and (((p1=0) or ((p2<p1) and (ival(left(s,p2-1))>0)))) then
      s[p2]:=':';
    ReplDP:=s;
  end;

  procedure NetPar(s:string);
  var p : byte;
  begin
    p:=cpos(':',s);
    s:=ReplDP(trim(s));
    if p=0 then
      ParNetcall:=s
    else begin
      ParNetcall:=left(s,min(p-1,BoxNameLen));
      ParNCtime:=formi(ival(copy(s,p+1,2)),2)+':'+formi(ival(copy(s,p+4,2)),2);
      end;
  end;

  procedure UserPar(s:string);
  var p : byte;
  begin
    p:=cpos(':',s);
    s:=ReplDP(s);
    if p=0 then
      writeln('fehlerhafte /user - Option')
    else begin
      s[p]:=' ';
      ParSetuser:=left(s,sizeof(ParSetuser)-1);
      end;
  end;

  procedure SetZeilen(z:byte);
  begin
    case videotype of
      2 : if z in [25,26,29,31,35,38,43,50] then ParZeilen:=z;
      3 : if z in [25,26,28,30,33,36,40,44,50] then ParZeilen:=z;
    end;
  end;

  procedure Par_mailto; { Mailto: Parameter auswerten }
  Var i,j,k :  Byte;
      s2    : string[8];
      s3    : string[128];
  begin                 { -mailto:user@name?subject=betreff;serverbox }
    if deutsch then
    begin
      keyboard('nd');
{     writeln('Deutsch'); }
    end else
    begin
      keyboard('md');
{     writeln('Englisch'); }
    end;
    i:=cposx('\',s);
    if i <= length(s) then keyboard(keyup+mid(s,i+1)+keydown);
    j:=cpos('?',s);       
    k:=cpos('&',s);
    if (k=0) or (j<k) then k:=j;
    if k=0 then k:=i;
    keyboard(copy(s,9,k-9)+keydown);    
    if j>0 then 
    begin 
      s3:=copy(s,j+1,i-j-1);  { Zwischen ? und ; }      
      if ustr(left(s3,4))='SUBJ' then 
      begin
        k:=cposX('&',s3);
        keyboard(copy(s3,9,k-9));
        end;
      end;
    ParNoBeta:=true;
    ParNoDLL:=true;
  end;

  procedure ParAuswerten;
  begin
    if _is('h') or _is('?') then ParHelp:=true else
    if _is('d')    then ParDebug:=true else
    if isl('df:') then ParDebFlags:=ParDebFlags or ival(mid(s,5)) else
    if _is('dd')   then ParDDebug:=true else
    if _is('trace')then ParTrace:=true else
    if _is('m')    then ParMono:=true else
    if _is('j')    then ParNojoke:=true else
    if isl('n:')   then NetPar(ustr(mid(s,4))) else
    if isl('nr:')  then begin
                          NetPar(ustr(mid(s,5)));
                          ParRelogin:=true;
                        end else
    if isl('nsp:') then begin
                          NetPar(ustr(mid(s,6)));
                          ParNSpecial:=true;
                        end else
    if _is('r')    then ParReorg:=true else
    if _is('rp')   then ParTestres:=false else
    if _is('pack') then ParPack:=true else
    if isl('xpack:') then begin
                         ParXpack:=true;
                         ParXPfile:=ustr(copy(s,8,8));
                       end else
    if _is('xpack')then ParXPack:=true else
    if _is('q')    then ParQuiet:=true else
    if _is('maus') then ParMaus:=true else
    if isl('ip:') then ParPuffer:=ustr(copy(s,5,70)) else
    if isl('ipe:')then begin
                         ParPuffer:=ustr(copy(s,6,70));
                         ParPufED:=true;
                       end else
    if _is('g')    then ParGelesen:=true else
    if isl('ips:')then ParSendbuf:=ustr(mid(s,6)) else
    if isl('t:')  then ParTiming:=ival(copy(s,4,2)) else
    if _is('x')    then ParExit:=true else
    if _is('xx')   then ParXX:=true else
    if isl('user:') then UserPar(mid(s,7)) else
    if isl('k:')  then begin
                         if length(s) = 4 then Parkey:=s[4]
                         else begin 
                           parkey:=' ';
                           if length(s)>4 then keyboard(_getmacro(mid(s,4)));
                           end;
                         end else
    if _is('eb')   then ParEmpfbest:=true else
    if _is('pa')   then ParPass:='*' else
    if isl('pa:') then ParPass:=mid(s,5) else
    if isl('pw:') then ParPasswd:=mid(paramstr(i),5) else
    if isl('z:')  then SetZeilen(ival(mid(s,4))) else

    { Achtung! Folgende Reihenfolge muss bleiben! }
    if _is('w0')   then ParWintime:=0 else
    if _is('os2a') then begin ParWintime:=1; ParOS2:=1; end else
    if _is('os2b') then begin ParWintime:=1; ParOS2:=2; end else
    if _is('os2c') then begin ParWintime:=1; ParOS2:=3; end else
    if _is('os2d') then begin ParWintime:=1; ParOs2:=4; end else
    if _is('w')    then ParWintime:=1 else
    if _is('w1')   then ParWintime:=1 else
    if _is('w2')   then ParWintime:=2 else
    { Reihenfolge bis hier }

    if _is('ss')   then ParSsaver:=true else
  { if isl('gd:') then SetGebdat(mid(s,5)) else }
    if isl('av:') then ParAV:=mid(s,5) else
    if isl('autostart:') then ParAutost:=mid(s,12) else
    if isl('l:')  then ParLanguage:=ustr(mid(s,4)) else
    if isl('f:') then ParFontfile:=ustr(mid(s,4)) else
    if _is('nomem')then ParNomem:=true else
    if _is('sd')   then ParNoSmart:=true else
    if _is('lcd')  then ParLCD:=true else
    if _is('menu') then ParMenu:=true else
    if _is('g1')   then ParG1:=true else
    if _is('g2')   then ParG2:=true else
{$IFDEF Beta } { Keine Beta-Meldung anzeigen }
    if _is('nb')   then ParNoBeta:=true else
{$ELSE } { nb bergehen, auch wenn nicht bentigt }
    if _is('nb')   then else
{$ENDIF }
    if _is('novdmchk') then ParNoDLL:=true else
    if isl('mailto:') then Par_mailto else
    {Dummy da schon in xpx.pas komplett ausgewertet}
    if _is('noovrbuf')   then else
    if isl('lfn') and (not LFNEnabled) then EnableLFN else
    if isl('312') then OldXPComp := true else
    if _is('nolock') then ParNolock:=true
    else               begin
                         writeln('unbekannte Option: ',paramstr(i),#7);
                         delay(500);
                       end
  end;


  procedure ReadParFile;
  begin
    reset(t);
    while not eof(t) do begin
      readln(t,s);
      s:=trim(s);
      if s<>'' then ParAuswerten;
      end;
    close(t);
  end;

begin
  { Unter Win/OS2/Linux: Default "/w", Rechenzeitfreigabe abschalten mit "/w0" }
  if (winversion>0) or (lo(dosversion)>=20) or (DOSEmuVersion <> '')
    then ParWintime:=1;
  extended:=exist('xtended.15');
  findfirst(AutoxDir+'*.OPT',0,sr);    { permanente Parameter-Datei }
  while doserror=0 do begin
    assign(t,AutoxDir+sr.name);
    ReadParfile;
    findnext(sr);
  end;
  FindClose(sr);
  for i:=1 to paramcount do begin      { Command-Line-Parameter }
    s:=paramstr(i);
    ParAuswerten;
    end;
  findfirst(AutoxDir+'*.PAR',0,sr);    { temporre Parameter-Datei }
  while doserror=0 do begin
    assign(t,AutoxDir+sr.name);
    ReadParfile;
    erase(t);
    if ioresult<>0 then
      writeln('Fehler: kann '+AutoxDir+sr.name+' nicht lschen!');
    findnext(sr);
  end;
  FindClose(sr);
  if VideoType<2 then ParFontfile:='';
  if (ParFontfile<>'') and (ParFontfile[1]<>'*') then
    ParFontfile:=FExpand(ParFontfile);
  if ParDebug then Multi3:=ShowStack;
  if ParDDebug then dbOpenLog('database.log');
  ListDebug:=ParDebug;
  if (left(ParAutost,4)<='0001') and (right(ParAutost,4)>='2359') then
    ParAutost:='';
end;



procedure GetResdata;
const intbrett = '$/';
var s : string;
    p : byte;
    i : integer;

  procedure getkey(var c:char);
  begin
    if p<=length(s) then begin
      if s[p]='^' then begin
        inc(p);
        c:=chr(ord(s[p])-64);
        end
      else
        c:=s[p];
      inc(p,2);
      end;
  end;

begin
  helpfile:=getres(1);
{$IFDEF UnixFS}
   lostring(helpfile);
{$ENDIF}
  keydeffile:=getres(2);
  _fehler_:=getres2(11,1);
  _hinweis_:=getres2(11,2);
  _daylen_:=ival(getres2(11,3));
  s:=getres2(11,4);
  getmem(_days_,length(s)+1);
  _days_^:=s;
  statbrett:=intbrett+getres2(11,5);
  unvbrett:=intbrett+getres2(11,6);
  netbrett:=intbrett+getres2(11,7);
  _jn_:=getres2(11,8);
  masklanguage(_jn_);
  _wotag_:=getres2(11,9);
  for i:=1 to 12 do
    monat[i].tag:=getres2(11,i+9);
  ListHelpStr:=getres2(11,22);
  freeres;
  if IsRes(22) then begin     { Tastendefinitionen }
    s:=getres2(22,1);         { Bretter }
    p:=1;
    getkey(k0_S);  getkey(k0_A);  getkey(k0_H);  getkey(k0_cH);
    getkey(k0_L);  getkey(k0_E);  getkey(k0_V);  getkey(k0_cT);
    getkey(k0_P);  getkey(k0_Le); getkey(k0_B);  getkey(k0_I);
    getkey(k0_TE); getkey(k0_cG); getkey(k0_cE); getkey(k0_cW);
    getkey(k0_cF); getkey(k0_Ac); getkey(k0_SB);
    s:=getres2(22,2);          { User }
    p:=1;
    getkey(k1_S);  getkey(k1_A);  getkey(k1_H);  getkey(k1_V);
    getkey(k1_L);  getkey(k1_E);  getkey(k1_cV); getkey(k1_B);
    getkey(k1_I);  getkey(k1_TE); getkey(k1_R);  getkey(k1_P);
    getkey(k1_cE); getkey(k1_cW); getkey(k1_U);  getkey(k1_SB);
    s:=getres2(22,3);          { Nachrichten }
    p:=1;
    getkey(k2_S);  getkey(k2_cR); getkey(k2_cH); getkey(k2_I);
    getkey(k2_O);  getkey(k2_H);  getkey(k2_L);  getkey(k2_K);
    getkey(k2_cU); getkey(k2_V);  getkey(k2_cE); getkey(k2_U);
    getkey(k2_cF); getkey(k2_cI); getkey(k2_G);  getkey(k2_cA);
    getkey(k2_KA); getkey(k2_EA); getkey(k2_cW); getkey(k2_cD);
    getkey(k2_R);  getkey(k2_cN); getkey(k2_BB); getkey(k2_A);
    getkey(k2_b);  getkey(k2_cB); getkey(k2_SB); getkey(k2_p);
    getkey(k2_cP); getkey(k2_SP); getkey(k2_cT); getkey(k2_cQ);
    s:=getres2(22,4);          { AutoVersand }
    p:=1;
    getkey(k3_H);  getkey(k3_E);  getkey(k3_L);  getkey(k3_A);
    getkey(k3_T);  getkey(k3_I);  getkey(k3_S);  getkey(k3_K);
    s:=getres2(22,5);          { Lister }
    p:=1;
    getkey(k4_D);  getkey(k4_W);  getkey(k4_L);  getkey(k4_cL);
    getkey(k4_H);  getkey(k4_F);
    freeres;
    end;
end;

procedure FreeResdata;
begin
  freemem(_days_,length(_days_^)+1);
end;


procedure loadresource;             { Sprachmodul laden }
var lf : string[12];
    lf2: string[12];
    sr : searchrec;
    t  : text;
    s  : string[40];
    ca : char;
    choice   : boolean;
    resFiles : string;                 { alle 'XP-?.RES' (je .RES ein char) }
    resOther : string[sizeof(ParLanguage)-1];    { erste gefundene XP-*.RES }

  procedure WrLf;
  begin
    rewrite(t);
    writeln(t,lf);
    close(t);
  end;

  procedure select_language;
  var i : byte;
  begin
    if (resFiles='') and (resOther<>'') then
      ParLanguage:=resOther
    else if length(resFiles)=1 then
      ParLanguage:=resFiles
    else begin                                       { ggf. Auswahl bringen }
      choice:=true;
      ParLanguage:=firstchar(resFiles);
      for i:=1 to length(resFiles) do
        write('<'+resFiles[i]+'>'+
              iifs(resFiles[i]='D','eutsch',iifs(resFiles[i]='E','nglish',''))+
              iifs(i<length(resFiles),' / ',' ?  '+ParLanguage));
      GotoXY(wherex-1,wherey);
      repeat
        ca:=upcase(readkey);
      until (cpos(ca,resFiles)>0) or (ca=keycr);
      if (ca<>keycr) then                               { <Enter> = Default }
      begin
        write(ca);
        parlanguage:=ca;
      end;
    end;
  end;

  procedure ResNotFound(const f:string);
  begin
    writeln(iifs(ParLanguage='D','Sprachmodul ','Language module ')+f+
            iifs(ParLanguage='D',' nicht gefunden',' not found'));
  end;

begin { loadresource }
  choice:=false;
  lf:=''; resFiles:=''; resOther:='';
  languageopt:=false;
  col.colmbox:=$70;
  col.colmboxrahmen:=$70;
  findfirst('XP-*.RES',ffAnyFile,sr); { Hier drfte es keine Probleme geben }
  if DosError<>0 then
    interr('Kein Sprachmodul installiert / No language module installed (XP-*.RES)')
  else while doserror=0 do
  begin
    if sr.name[5]='.' then                 { Ressourcen nach dem Muster     }
    begin                                  { 'XP-?.RES' in resFiles ablegen }
      if upcase(sr.name[4])='D' then       { ('D' und 'E' vorne!)           }
        insert(upcase(sr.name[4]),resFiles,1)
      else if upcase(sr.name[4])='E' then
        insert(upcase(sr.name[4]),resFiles,iif(firstchar(resFiles)='D',2,1))
      else
        resFiles:=resFiles+upcase(sr.name[4]);
    end
    else if resOther='' then
      resOther:=copy(sr.name,4,cpos('.',sr.name)-4); { 1. 'XP-*.RES' merken }
    findnext(sr);
    if not languageopt then          { Sprachenwechsel in Men deaktivieren }
      languageopt:=doserror=0;       { (siehe auch xp4o2.pas und xp4.inc)   }
  end;
  FindClose(sr);
  assign(t,'XP.RES');
  reset(t);
  { ----------------------------------------------------------------------- }
  if ioresult<>0 then                        { Wenn XP.RES nicht existiert  }
  begin
    if ParLanguage='' then                  { /L Parameter bercksichtigen, }
    begin
      select_language;                      { ansonsten Auswahl bringen     }
      lf:='XP-'+ParLanguage+'.RES';
      WrLf;                                          { und XP.RES erstellen }
      ParLanguage:='';
    end;
  end
  { ----------------------------------------------------------------------- }
  else begin                                             { XP.RES vorhanden }
    readln(t,lf);
    close(t);
    if (ParLanguage='') and not exist(lf) then
    begin
      ResNotFound(lf);              { 'Sprachmodul XP-*.RES nicht gefunden' }
      writeln;
      select_language;
      lf:='XP-'+ParLanguage+'.RES';
      WrLf;
      ParLanguage:='';
    end;
  end;
  { ----------------------------------------------------------------------- }
  if (ParLanguage<>'') then                                  { /L angegeben }
  begin
    lf2:='XP-'+ParLanguage+'.RES';
    if not exist(lf2) then
    begin
      ResNotFound(lf2);             { 'Sprachmodul XP-*.RES nicht gefunden' }
      writeln;
      if (lf<>'') and exist(lf) then          { wenn existierende Ressource }
        lf2:=lf                               { in XP.RES, diese verwenden  }
      else begin
        select_language;
        lf2:='XP-'+ParLanguage+'.RES';
      end;
    end;
    if (ustr(lf)<>lf2) then
    begin
      lf:=lf2;
      WrLf;
    end;
  end;
  { ----------------------------------------------------------------------- }

  { ab hier ist 'lf' immer mit einer existierenden Ressource belegt! }
  ParLanguage:=copy(lf,4,cpos('.',lf)-4);
  assign(t,lf);
  reset(t);
  readln(t); readln(t);
  readln(t,s);
  deutsch:=(lstr(s)='deutsch');
  close(t);
  if not OpenResource(lf,ResMinmem) or (getres(6)<>LangVersion) then
  begin
    if exist('XP.RES') then _era('XP.RES');
    if choice then
    begin
      writeln;  { damit Ausgabe nicht direkt }
      writeln;  { hinter Eingabe erfolgt     }
    end;
    interr(iifs(deutsch,'Falsche Version von ','Wrong version of ')+lf);
  end;
  GetResdata;
  if ParHelp then HelpScreen;
end;


{$I xp2cfg.inc}


procedure test_pfade;
var   res  : integer;

  procedure TestDir(d:string);
  begin
    if not IsPath(ownpath+d) then begin
      mkdir(ownpath+left(d,length(d)-1));
      if ioresult<>0 then
        interr(reps(getres(203),left(d,length(d)-1))+#7);   { 'Fehler: Kann %s-Verzeichnis nicht anlegen!' }
      end;
  end;

  procedure TestDir2(d:string);
  begin
    if not IsPath(d) and XPFirstStart then
    begin
      mkdir(left(d,length(d)-1));
      if ioresult<>0 then
        interr(reps(getres(203),left(d,length(d)-1))+#7);   { 'Fehler: Kann %s-Verzeichnis nicht anlegen!' }
      end;
  end;

  procedure SetPath(var pathp:pathptr; var oldpath:pathstr);
  begin
    getmem(pathp,length(oldpath)+1);
    pathp^:=oldpath;
    oldpath:=OwnPath;
  end;

begin
  TestDir2(logpath);
  TestDir2(temppath);
  TestDir2(extractpath);
  TestDir2(sendpath);
  if logpath='' then logpath:=ownpath
  else
    if not IsPath(logpath) then
    begin
      logpath:=ownpath;
      trfehler(204,60);  { 'ungltiges Logfileverzeichnis' }
    end;
  if temppath='' then temppath:=ownpath
  else
    if not IsPath(temppath) then
    begin
      temppath:=ownpath;
      trfehler(201,60);   { 'ungltiges Temporr-Verzeichnis eingestellt' }
      end;
  if extractpath='' then extractpath:=OwnPath
  else
    if not IsPath(extractpath) then
    begin
      extractpath:=OwnPath;
      trfehler(202,60);   { 'ungltiges Extrakt-Verzeichnis eingestellt' }
      end;
  if sendpath='' then sendpath:=ownpath
  else
    if not IsPath(sendpath) then
    begin
      sendpath:=ownpath;
      trfehler(203,60);   { 'ungltiges Sendeverzeichnis' }
      end;
  editname:=sendpath+WildCard;
  TestDir(XFerDir);
  TestDir(JanusDir);
  TestDir(FidoDir);
  TestDir(AutoxDir);
  TestDir(BadDir);
  if not IsPath(filepath) then begin
    MkLongdir(filepath,res);
    if res<>0 then begin
      filepath:=OwnPath+InfileDir;
      TestDir(InfileDir);
      end;
    end;
end;


{ Stammbox anlegen, falls noch nicht vorhanden }

procedure test_defaultbox;
var d    : DB;
    dname: string[8];
begin
{$IFDEF Debug }
  dbLog('-- Boxen berprfen');
{$ENDIF }
  dbOpen(d,BoxenFile,1);
  dbSeek(d,boiName,ustr(DefaultBox));
  if not dbFound then begin
    if dbRecCount(d)=0 then begin
      xp9.get_first_box(d);
      dbRead(d,'dateiname',dname);
      end
    else begin
      dbGoTop(d);
      dbRead(d,'boxname',DefaultBox);
      dbRead(d,'dateiname',dname);
      end;
    SaveConfig;
    end
  else
    dbRead(d,'Dateiname',dname);
  if not exist(OwnPath+dname+BfgExt) then begin
    DefaultBoxPar(nt_Netcall,boxpar);
    WriteBox(dname,boxpar);
    end;
  if deffidobox<>'' then begin
    dbSeek(d,boiName,deffidobox);
    if not dbFound then deffidobox:=''
    else HighlightName:=ustr(dbReadStr(d,'username'));
    if deffidobox<>'' then SetDefZoneNet;
    end;
  dbClose(d);  
end;


{ Testen, ob die 3 Default-Brettgruppen vorhanden sind }

procedure test_defaultgruppen;
var d     : DB;

  procedure AppGruppe(name:string; limit:longint; halten:integer16;
                      var grnr:longint);
  const b : byte = 1;
  var   s : string[8];
  begin
    dbAppend(d);
    dbWrite(d,'name',name);
    dbWrite(d,'haltezeit',halten);
    dbWrite(d,'msglimit',limit);
    dbWrite(d,'flags',b);
    s:='header';   dbWrite(d,'kopf',s);
    s:='signatur'; dbWrite(d,'signatur',s);
    dbRead(d,'INT_NR',grnr);
  end;

  procedure getGrNr(name:string; var grnr:longint);
  begin
    dbSeek(d,giName,ustr(name));
    if not dbFound then interr(getres(204));  { 'fehlerhafte Gruppendatei!' }
    dbRead(d,'INT_NR',grnr);
  end;

(*  procedure WriteFido;
  var b : byte;
      s : string[8];
  begin
    b:=4;  dbWrite(d,'flags',b);     { Re^n = N }
    b:=1;  dbWrite(d,'umlaute',b);   { ASCII    }
    s:=''; dbWrite(d,'signatur',s);  { keine Sig. }
  end; *)

begin
{$IFDEF Debug }
  dbLog('-- Gruppen berprfen');
{$ENDIF }
  dbOpen(d,GruppenFile,1);
  if dbEOF(d) then begin
    AppGruppe('Intern',0,0,IntGruppe);
    AppGruppe('Lokal',0,stdhaltezeit,LocGruppe);
    AppGruppe('Netz',maxnetmsgs,stdhaltezeit,NetzGruppe);
    { AppGruppe('Fido',8192,stdhaltezeit,dummy);
      WriteFido; }
    end
  else begin
    getGrNr('Intern',IntGruppe);
    getGrNr('Lokal',LocGruppe);
    getGrNr('Netz',NetzGruppe);
    end;
  dbCLose(d);
end;


procedure test_systeme;
var d : DB;
    s : string[30];
begin
{$IFDEF Debug }
  dbLog('-- Systeme berprfen');
{$ENDIF }
  dbOpen(d,SystemFile,1);
  if dbRecCount(d)=0 then begin
    dbAppend(d);
    s:='SYSTEM';
    dbWrite(d,'name',s);
    end;
  dbClose(d);
end;


procedure testdiskspace;
var free : longint;
    x,y  : byte;
begin
  if ParNomem then exit;
{$IFDEF Debug }
  dbLog('-- Plattenplatz testen');
{$ENDIF }
  free:=disk_free(0);
  if free<200000 then free:=0;
  if free=0 then
  begin
    exitscreen(0);
    writeln(getreps(205,left(OwnPath,2)));   { 'Fehler: zu wenig freier Speicher auf Laufwerk %s !' }
    writeln;
    errsound; delay(60); errsound; delay(60); errsound;
    runerror:=false;
    halt(1);
  end
  else if iifb(xp_ntvdm_ok,free<MinMB,free div $100000<MinMB) then
  begin
    msgbox(51,8,'',x,y);
    moff;
    if not xp_ntvdm_ok then free:=free div $100000;
    wrt(x+3,y+1,getres2(206,1));   { 'WARNUNG!' }
    wrt(x+3,y+3,reps(getres2(206,2),trim(strsrn(free,0,1))));  { 'Es sind nur noch %s MB freier Speicherplatz' }
    wrt(x+3,y+4,reps(getres2(206,3),left(ownpath,2)));         { 'auf Laufwerk %s vorhanden! '}
    wrt(x+3,y+6,getres(12));   { 'Taste drcken ...' }
    freeres;
    mon;
    errsound; delay(60); errsound; delay(60); errsound;
    inout.cursor(curon);
    DisableDOS:=true;
    wkey(30,false);
    DisableDOS:=false;
    inout.cursor(curoff);
    closebox;
  end;     
end;

procedure savehandles;
var i,a,b : byte;

begin
   a:=0;
   b:=0;
   for i:=1 to 255 do
   begin
     if handles[i]=$ff then a:=a+1;
     if ((a=needfiles) and (b=0)) then b:=i;
     if ((b>=needfiles) and (handles[i]<>$ff)) then b:=i;
   end;
   MemW[PrefixSeg:$32] := b;
end; 

procedure testfilehandles;
var f,nf,lcol,x,y,i : byte;
    s1,s2,s3,tesf   : string[80];
    w1,w2           : word;
const test='CABDEFGHIJKLMNOPQRSTUVWXYZ';

begin
 if NOT DOSBOX then begin
  s1:='';
  s2:='';
  s3:='';
  f:=FreeFILES((needfiles+needreserve));
  if f<(needfiles+needreserve) then begin
    nf:=((ConfigFILES+((needfiles+needreserve)-f)+4)div 5)*5;
    s1:=getres2(10000+100*(223 div 100),223 mod 100);
    truncstr(s1,screenwidth-4);
    if WinVersion=4 then
       {Windows NT/2000/XP}
       s2:=getenv('SYSTEMROOT')+'\SYSTEM32\CONFIG.NT'
    else if ((WinVersion=3) and (lo(dosversion)=8)) then
       begin
         {Sonderfall WinME}
         s1:=getres2(10000+100*(225 div 100),225 mod 100);
         truncstr(s1,screenwidth-4);
         s2:=getreps2(10000+100*(226 div 100),226 mod 100,strs(nf));
         truncstr(s2,screenwidth-4);
         s3:=getres2(10000+100*(227 div 100),227 mod 100);
         truncstr(s3,screenwidth-4);
       end
    else begin
      s2:=getenv('ComSpec');
      s2:=Copy(s2,1,3)+'CONFIG.SYS';
      if existrf(s2) then s2:=s2 else begin
        s2:='';
        tesf:=test;
        for i:=1 to 26 do begin
          if s2='' then begin           
            s2:=tesf[i]+':\CONFIG.SYS';
            if not existrf(s2) then s2:='';                    
          end;
        end;
        if s2='' then s2:='CONFIG.SYS';
      end;
    end;
    truncstr(s2,screenwidth-4);
    if s3='' then begin
      s3:=getreps2(10000+100*(224 div 100),224 mod 100,strs(nf));
      truncstr(s3,screenwidth-4);
    end;
    savecursor; lcol:=textattr;
    w1:=windmin; w2:=windmax;
    window(1,1,80,25);
    pushhp(20223);
    msgbox(max(length(s1),max(length(s2),length(s3)))+6,7,_fehler_,x,y);
    mwrt(x+3,y+2,left(s1,screenwidth-6));
    mwrt(x+3,y+3,left(s2,screenwidth-6));
    mwrt(x+3,y+4,left(s3,screenwidth-6));    
    errsound;
    wait(curoff);
    closebox;
    pophp;
    windmin:=w1; windmax:=w2;
    restcursor;
    attrtxt(lcol);
    runerror:=false;
    exitscreen(0);
    halt(1);
    end;
  savehandles;
 end
 else begin
  {Unter DOSBOX geht der Standardtest auf oeffnen von nul schief.}
  {Ein spezieller Test fuer DOSBOX eruebrigt sich, da DOSBOX}
  {immer genuegend FILES bereitstellt (FILES=100)}
 end;
end;

procedure read_regkey;
var t   : text;
    s   : string[20];
    p   : byte;
    l1,l2,l3 : integer32;
    l   : integer32;
    code: integer32;

  procedure freereg;
  begin
    with registriert do
    begin
      nr:=0;
      tc:='F';        { Freeware-"Key" }
      komreg:=false;
      orgreg:=false;
    end;
  end;

begin
  freereg;
  assign(t,regdat);
  if existf(t) then
  begin
    reset(t);
    readln(t,s);
    s:=trim(s);
    close(t);
    if firstchar(s)='!' then
    begin
      registriert.komreg:=true;
      registriert.orgreg:=true;
      delfirst(s);
    end;
    p:=cpos('-',s);
    if p>0 then
    begin
      if s[1] in ['A','B','C'] then
      begin
        registriert.tc:=s[1]; delete(s,1,1); dec(p);
      end
      else
        registriert.tc:='A';
      l:=ival(left(s,p-1));              { lfd. Nummer }
      if ((l>=4001) and (l<=4009)) or
         (l=800) or                      { Key in Cracker-Box aufgetaucht }
         (l=4088) or                     { Key auf CD-ROM aufgetaucht     }
         (l=4266) or (l=4333) or         { storniert                      }
         (l=8113) or                     { Key in CCC.GER verffentlicht  }
         (l=6323) or                     { Key in Cracker-Kreisen aufgetaucht }
         (l=101) or                      { Key im Usenet aufgetaucht }
         (l=0) or (l=11232) or (l=12345) or (l=23435) or (l=32164) or
         (l=33110) or (l=34521) or (l=54321) or (l=12034) then   { Hacks }
        l:=0;
      registriert.nr:=l;
      l1:=CRC16strXP(reverse(hex(l+11,4))); l1:=l1 xor (l1 shl 4);

      { Registrierungsbug plattformunabhngig emulieren }
      { 10923 * 3 ist grer als maxint (32767) }
      if l<10923 then
        l2:=CRC16strXP(reverse(hex(l*3,5)))
      else
        l2:=CRC16strXP(reverse(hex(l*3-65536,5)));

      l2:=l2 xor (l2*37);
      l3:=l1 xor l2 xor CRC16strXP(reverse(strs(l)));
      delete(s,1,p);
      p:=cpos('-',s); if p=0 then p:=length(s)+1;
      code:=ival(left(s,p-1));                { -Code }
      if registriert.nr=0 then code:=-1;
      delete(s,1,p);
      case registriert.tc of
        'A' : if code<>l1 then freereg;
        'C' : if code<>l3 then freereg;
        'B' : if code<>l2 then freereg;
      end;
      with registriert do
      begin
        komreg:=komreg and IsKomCode(nr);
        orgreg:=orgreg and IsOrgCode(nr);
      end;
    end;
  end;
end;

procedure TestAutostart;
var p   : byte;
    f,t : string[5];
    min : word;
begin
  p:=cpos('-',ParAutost);
  if p=0 then exit;
  min:=ival(left(ParAutost,p-1));
  f:=formi(min div 100,2)+':'+formi(min mod 100,2)+':00';
  min:=ival(mid(ParAutost,p+1));
  t:=formi(min div 100,2)+':'+formi(min mod 100,2)+':59';
  if f<t then
    quit:=quit or (time<f) or (time>t)
  else
    quit:=quit or ((f>time) and (t<time));
end;



procedure ReadDomainlist;
var d   : DB;
    p   : DomainNodeP;
    dom : string[120];

  function smaller(dl:DomainNodeP):boolean;
  begin
    smaller:=(dom<dl^.domain^);
  end;

  procedure InsertIntoList(var dl:DomainNodeP);
  begin
    if dl=nil then
      dl:=p
    else
      if smaller(dl) then
        InsertIntoList(dl^.left)
      else
        InsertIntoList(dl^.right);
  end;

  procedure freeDomainList(var DomainList:DomainNodeP);
  var lauf : DomainNodeP;
  begin
    if Assigned(Domainlist) then begin
      freeDomainList(DomainList^.left);
      lauf:=DomainList^.right;
      Dispose(DomainList);
      freeDomainList(lauf);
    end;
  end;

begin
  freeDomainList(DomainList);
  DomainList:=nil;
  dbOpen(d,BoxenFile,0);
  while not dbEOF(d) do
  begin
    inc(ntused[dbReadInt(d,'netztyp')]);
    if ntDomainReply(dbReadInt(d,'netztyp')) then
    begin
      new(p);
      if dbReadInt(d,'netztyp') in [nt_UUCP,nt_Client] then begin
        dom:=lstr(dbReadStr(d,'fqdn'));
        if dom='' then dom:=lstr(dbReadStr(d,'pointname')+dbReadStr(d,'domain'));
      end
      else begin
        dom:=lstr(dbReadStr(d,'fqdn'));
        if dom='' then dom:=lstr(dbReadStr(d,'pointname')+'.'+dbReadStr(d,'boxname')+
                                 dbReadStr(d,'domain'));
      end;
      getmem(p^.domain,length(dom)+1);
      p^.domain^:=dom;
      p^.left:=nil;
      p^.right:=nil;
      insertintolist(DomainList);
    end;
    dbNext(d);
  end;
  dbClose(d);
end;

end.
{
  $Log: xp2.pas,v $
  Revision 1.68  2005/01/01 11:16:28  mw
  MW: - Willkommen im Jahr 2005

  Revision 1.67  2004/05/03 08:29:25  mw
  MW: - Optimierungen der Routinen fr DOSBOX

  Revision 1.66  2004/05/03 06:09:47  mw
  MW: - Korrektur des letzten Commits

  Revision 1.65  2004/05/02 23:41:22  mw
  MW: - Anpassungen an DOSBOX

  Revision 1.64  2004/01/09 16:18:58  mw
  MW: - Wir haben jetzt 2004!!

  Revision 1.63  2003/09/03 17:02:41  mw
  MW: - Anpassung an Windows ME:
        Die Fehlermeldung ber zu wenig FILES weist unter
        Windows ME jetzt auf die SYSTEM.INI

  Revision 1.62  2003/08/30 06:07:54  mw
  MW: - Fehler unter non-WinNT:
        Bei zu wenig Speicherplatz wurde
        der noch verfgbare Speicherplatz in Bytes
        und nicht in MBytes ausgegeben.

  Revision 1.61  2003/08/28 21:51:15  my
  MY:- Beim XP-Start wird unter Windows NT/2000/XP jetzt auf Existenz und
       korrekte Revision der NT-Schnittstelle XP_NTVDM.DLL geprft und
       ggf. ein Warnhinweis ausgegeben sowie die Auswahl angeboten, XP zu
       beenden oder fortzufahren. Die Prfung lt sich mit dem Kommando-
       zeilen-Parameter "/novdmchk" abschalten.
       [Vorlufige Fassung, ausfhrlicherer Hinweis und Hilfetexte mit
       Erluterungen mssen noch implementiert werden.]

  Revision 1.60  2003/08/23 23:01:30  my
  MY:- Neue Funktion 'disk_free' implementiert, die abhngig vom jeweili-
       gen OS (WinNT/2K/XP oder andere) bei der Ermittlung des freien
       Plattenplatzes die entsprechenden Routinen 'diskfree' oder
       'NTDiskFree' verwendet, und in allen Units, die bisher selbst auf
       das OS getestet haben, diese neue Funktion verwendet.

  Revision 1.59  2003/08/23 17:28:08  my
  MY:- NTDiskFree-Routinen kompakter geschrieben und Redundanzen
       eliminiert, Typos gefixt, Source formatiert

  Revision 1.58  2003/08/21 21:12:09  my
  MY: - Source ein wenig formatiert
      - Aufflligeres Fehlersignal bei zuwenig Plattenplatz

  Revision 1.57  2003/08/18 13:06:52  mw
  MW: - Konsequenter Umbau auf fileio.diskfree (Vorbereitung auf Umstellung
        auf NTDiskFree/NTDiskSize.

  Revision 1.56  2003/08/18 12:38:55  mw
  MW: - Neue Warnung beim Programmstart:
        Ist die Gre eines MPUFFERs in MB+MinMB grer als 2 GB dann
        warnt XP.

      - XP luft nicht mehr ins 2 GB pro Ablage Problem.

  Revision 1.55  2003/08/11 22:52:12  my
  MY:- Ein paar kosmetische Korrekturen in 'loadresource' und im letzten
       Commit-Log.

  Revision 1.54  2003/08/11 07:22:45  mw
  MW: - Testfilehandles verfeinert:
        Anhand von COMSPEC wird versucht, die CONFIG.SYS zu suchen.
        Wenn dies schiefgeht, wird auf jedem Laufwerk danach gesucht.
        Die Ausgabe der Fehlermeldung zeigt also jetzt auch genau
        auf die CONFIG.SYS.

  Revision 1.53  2003/08/10 22:29:18  my
  MY:- Laden des Sprachmoduls (Ressource) beim XP-Start komplett
       berarbeitet und logischer gestaltet:
       -------------------------------------------------------------------
       1. Erzeugung der Fehlermeldung bei ungltigen "alten" Ressourcen
          mit 128 Bytes Blockgre von RESOURCE.PAS nach XP2.PAS verlagert
          und mit gleichlautender Fehlermeldung im Falle einer "echten"
          falschen Ressourcen-Version zusammengefat ('OpenResource' ist
          jetzt eine Funktion).
       2. Wenn gar keine Ressource vorhanden ist, dann bricht XP jetzt mit
          einer Fehlermeldung ab, statt wie bisher einen sinnfreien und
          zwangslufig zu einer Fehlermeldung fhrenden Auswahl-Dialog zu
          erzeugen, welche der (nicht vorhandenen) Ressourcen der User
          laden mchte.
       3. Wenn nur eine einzige Ressource vorhanden ist, dann ldt XP
          diese jetzt unter allen Umstnden und ohne Rckfrage. Sollte der
          Parameter /L: bergeben worden und/oder die Datei XP.RES vorhan-
          den sein, dann werden diese Angaben jetzt ignoriert, der Inhalt
          von XP.RES berschrieben und ggf. eine (allerdings meist nicht
          wahrnehmbare) Fehlermeldung erzeugt, da der mit /L: bergebene
          bzw. in XP.RES enthaltene Dateiname nicht existiert.
       4. In folgenden Fllen erzeugt XP jetzt einen Auswahl-Dialog,
          welches Sprachmodul geladen werden soll:
            Es existieren mehrere Dateien, deren Name dem Muster
            'XP-?.RES' ("?" = 1 Zeichen) entspricht, und
            - XP.RES ist nicht vorhanden (in diesem Fall wurde auch bisher
              schon ein Auswahl-Dialog erzeugt);
            - XP.RES ist vorhanden, enthlt aber einen nicht existierenden
              Dateinamen; in diesem Fall erscheint zustzlich zum Dialog
              eine Fehlermeldung (hier brach XP bisher mit einer Fehler-
              meldung ab);
            - Der Parameter /L: wurde bergeben, aber die angegebene
              Ressource existiert nicht *und* XP.RES existiert ebenfalls
              nicht oder enthlt keinen Dateinamen einer existierenden
              Ressource (anderenfalls wrde dieser verwendet werden); hier
              erscheint ebenfalls zustzlich zum Dialog eine Fehlermeldung
              (auch hier brach XP bisher mit einer Fehlermeldung ab,
              schrieb den Dateinamen der nicht vorhandenen Ressource dann
              aber dennoch in XP.RES, was prompt zu einer erneuten Fehler-
              meldung beim nchsten XP-Start fhrte).
          Wenn in den o.g. Fllen jedoch nur eine einzige Ressource mit
          einem Dateinamen nach dem Muster "XP-?.RES" existiert, aber
          zustzlich eine oder mehrere nach dem Muster "XP-*.RES"
          ("*" = mehrere Zeichen), dann wird *kein* Auswahl-Dialog
          erzeugt, weil diesen Ressourcen keine eindeutige Taste
          zugeordnet werden kann. Es wird dann ohne Rckfrage die einzige
          Ressource geladen, deren Dateiname dem Muster "XP-?.PAS"
          entspricht.
          Existiert hingegen gar keine Ressource mit einem Dateinamen nach
          dem Muster "XP-?.RES", jedoch mehrere mit einem Dateinamen nach
          dem Muster "XP-*.RES", dann wird die erste von 'findfirst'
          gefundene Ressource geladen.
       5. Detailnderungen beim Auswahl-Dialog:
          - Es werden jetzt *alle* Ressourcen zur Auswahl angeboten, deren
            Dateiname dem Muster "XP-?.RES" entspricht. Dabei wird bei den
            Dateien "XP-D.RES" bzw. "XP-E.RES" wie bisher der String
            "<D>eutsch" bzw. "<E>nglish" ausgegeben, in allen anderen
            Fllen lediglich das Zeichen hinter "XP-" in spitzen Klammern.
          - Durch alle oben beschriebenen nderungen ist jetzt gewhr-
            leistet, da die zur Auswahl angebotenen Ressourcen auch
            existieren, so da es nicht mehr zu einer Fehlermeldung
            "XP-?.RES not found" kommen kann.
          - Etwaige andere Fehlermeldungen *nach* Auswahl einer Ressource
            ("falsche Version von XP-?.RES") sind jetzt sprachabhngig
            (Deutsch bei XP-D.RES, Englisch in allen anderen Fllen) und
            erfolgen nicht mehr direkt hinter der Eingabeposition, sondern
            2 Zeilen darunter.
          - Vorgabe ist jetzt immer "D" (wenn XP-D.RES existiert) bzw. "E"
            (wenn XP-E.RES, jedoch nicht XP-D.RES existiert); bisher war
            das vom Zufall abhngig. Existieren beide Ressourcen nicht,
            ist Vorgabe das Zeichen hinter "XP-" der ersten von
            'findfirst' gefundenen Ressource.
          - Die vom User getroffene Auswahl wird jetzt angezeigt.
       Generell wird damit jetzt so weit wie mglich vermieden, da XP
       unntigerweise mit einer Fehlermeldung abbricht oder sinnlose
       Auswahl-Dialoge erzeugt, die ebenfalls zwingend zu einem Abbruch
       fhren.

  Revision 1.52  2003/08/07 22:11:03  my
  MY+JM+JG: Videoroutinen berarbeitet und korrigiert:
            --------------------------------------------------------------
            1. Fix: Beim Setzen des Videomodus und der Zeilenanzahl sowie
               dem Laden interner Fonts werden die entsprechenden Aktionen
               generell jetzt wirklich nur noch dann (aber dann auch
               immer) ausgefhrt, wenn sie tatschlich erforderlich sind
               (d.h. wenn sich die Werte der ursprnglichen bzw. vorheri-
               gen DOS-Instanz von den in XP zu verwendenden Werten unter-
               scheiden). Bisher wurden die Routinen teils berflssiger-
               weise, teils aber auch genau dort nicht ausgefhrt, wo dies
               htte geschehen mssen (z.B. bei der Verwendung interner
               Fonts).
            2. Fix: Es wird jetzt auch die Spaltenanzahl geprft und ggf.
               korrigiert. Bisher prsentierte XP einen zerschossenen
               Bildschirm, wenn die Spaltenanzahl in der ursprnglichen
               bzw. vorherigen DOS-Instanz z.B. auf 94 gesetzt war.
            3. Fix: Wenn die Zeilenanzahl der ursprnglichen bzw. vorheri-
               gen DOS-Instanz auf 43 gesetzt war, war die Bildschirmdar-
               stellung nicht korrekt: Bei Verwendung der Standard-Fonts
               war der Bildschirm "zu klein", so da die letzten 4 bis 5
               Zeilen zwar vorhanden, aber nicht sichtbar waren; bei Ver-
               wendung der internen Fonts (Parameter /f:*1 bis /f:*3) wa-
               ren zwar alle Zeilen sichtbar, aber XP lief im 21- (/f:*2)
               bzw. 25-Zeilen-Modus (/f:*1 und /f:*3). Jetzt wird der
               korrekte 25- bzw. 28-Zeilen-Modus verwendet und bei
               Standard-Fonts der Bildschirm vollstndig angezeigt.
               Ursache dieses Fehlverhaltens war, da der 43-Zeilen-Modus
               ein Sondermodus mit 350 vertikalen Bildpunkten ist, XP aber
               stur vom VGA-Standard mit 400 Bildpunkten ausging.
               Falls XP in einer DOS-Instanz im 43-Zeilen-Modus gestartet
               wurde, dann wird nach der Beendigung von XP die ursprng-
               liche Bildpunktanzahl wiederhergestellt (sonst kann es
               sonderbare "Verlngerungseffekte" speziell in einer DOS-Box
               von Windows geben).
               Die nderung wirkt sich auch auf DOS-Boxen unter Windows
               aus, bei denen der 43-Zeilen-Modus nicht ber den "mode"-
               Befehl o.., sondern ber die Bildschirm-Eigenschaften in
               der PIF-Datei gesetzt wurde.
            Alle bis hier beschriebenen nderungen wirken sich aus beim
            XP-Start, beim ndern der Zeilenanzahl in XP, und bei der
            Rckkehr aus einer DOS-Shell nach XP.
            4. VESA-Modus fr 60 Zeilen wieder ausgebaut. Die Funktion hat
               selten richtig funktioniert und war eher eine Quelle fr
               Bugreports als ein wirklich sinnvolles Feature. Bei
               bestehenden Konfigurationen mit 60 Zeilen wird in
               XPOINT.CFG automatisch "ScreenLines=50" eingetragen und
               intern gesetzt.
            5. Der interne Font "C2" (wird mit /f:*1 aktiviert) ist jetzt
               - auer bei den Kleinbuchstaben natrlich, die wie bisher
               als Kapitlchen ausgefhrt sind - identisch mit dem
               Standard-Font 8x14, der in den Zeilenmodi 28, 30, 33 und 36
               geladen wird.
            6. Es wird jetzt in *allen* Zeilenmodi ein XP-interner
               Standard-Font in die Grafikkarte geladen (Vorbereitung fr
               Euro-Support). Bisher war dies nur bei den Zeilenmodi 28,
               30, 33 und 36 der Fall.
            7. Einige optische Anpassungen beim Standard-Font 8x14 (0, ,
               M, m, n etc.).
            8. Der Standard-Font 8x14 ist jetzt *nicht* mehr ber den
               Parameter /f:*4 ansprechbar (wie die Standard-Fonts 8x16
               und 8x8 auch nicht ber Parameter ansprechbar sind).

  Revision 1.51  2003/08/04 18:03:34  my
  MY:- Konstante 'needreserve' fr von externen Programmen bentigte
       Filehandles eingefhrt und CVS-Log des Filehandle-Commits
       ergnzt/korrigiert.

  Revision 1.50  2003/08/03 23:08:33  my
  MW:- Windows-Versionserkennung verbessert:
       1. Windows 9x-Versionen werden jetzt unter X/S/S mit ihrer
          richtigen Version statt pauschal als "Windows 95/98/Me" erkannt.
       2. Wenn die XP_NTVDM.DLL fehlt und somit unter Windows NT/2000/XP
          keine korrekte Versionserkennung vorgenommen werden kann, dann
          wird unter X/S/S statt der Fehlermeldung "XP_NTVDM.DLL nicht
          gefunden" jetzt pauschal als Version "Windows NT/2000/XP"
          ausgegeben.

  Revision 1.49  2003/08/03 22:54:47  my
  MW [+MY+JM]:- Fix: Aufgrund whrend der Entwicklungsphase unter
                bestimmten Umstnden reproduzierbarer Pseudo-Datenbank-
                Crashes, deren Ursache eine zu geringe Anzahl verfgbarer
                Filehandles war, und weil XP bisher ohnehin permanent hart
                an der Grenze dessen gearbeitet hat, was aufgrund der
                Anzahl der von XP selbst geffneten Dateien an Filehandles
                bentigt wurde (was wiederum Ursache fr sporadische und
                nicht reproduzierbare Pseudo-Datenbank-Crashes an ganz
                anderen Stellen in der Vergangenheit gewesen sein kann),
                wurde die Verwaltung der Filehandles besser organisiert,
                abgesichert und komplett berarbeitet:
                1. XP testet beim Start jetzt auf mindestens 30 (bisher:
                   16) freie Filehandles fr sich selbst sowie auf eine
                   zustzliche Reserve von mindestens 10 Filehandles fr
                   extern gestartete Programme (die diesen dann auch
                   exklusiv zur Verfgung stehen). Steht diese Mindest-
                   anzahl von 40 freien Filehandles nicht zur Verfgung,
                   startet XP nicht und gibt wie bisher eine Hinweismel-
                   dung aus, da die Anzahl der Dateien, auf die gleich-
                   zeitig zugegriffen werden kann, erhht werden mu. Zu
                   empfehlen ist hier ohnehin der Maximalwert von 255
                   Dateien, da ein niedrigerer Wert keinen nennenswerten
                   Vorteil hinsicht-lich des verfgbaren unteren
                   Speichers ergibt.
                2. Steht die Mindestanzahl von 40 freien Filehandles zur
                   Verfgung, startet XP ohne Fehlermeldung und reserviert
                   fr sich selbst 30 Handles. Alle brigen Filehandles
                   stehen externen Programmen zur Verfgung und sind vor
                   der Verwendung durch XP geschtzt.
                3. Die Tabelle der max. zu verwaltenden Filehandles
                   wurde von 30 auf 255 Eintrge erhht, damit sicher-
                   gestellt ist, da unter allen Umstnden gengend
                   Eintrge vorhanden sind und die Reservierung von
                   Filehandles nicht an einer zu klein dimensionierten
                   Tabelle scheitern kann.
                4. Die Hinweismeldung verweist unter Windows NT/2000/XP
                   jetzt nicht mehr auf die (dort nicht vorhandene) Datei
                   CONFIG.SYS, sondern auf die Datei CONFIG.NT mit
                   vollstndigem Pfad (%SYSTEMROOT%\SYSTEM32).

  Revision 1.48  2003/08/03 15:23:02  my
  MY:- FreeXP ist jetzt Freeware. :-) Smtliche Shareware-Beschrnkungen
       und Registrierungsfunktionen deaktiviert bzw. eliminiert. Die
       Eingabe eines freiwilligen Keys ist weiterhin mglich, dieser bzw.
       ein bereits existierender Key wird wie bisher an den entsprechenden
       Stellen (Software-Header, Origin usw.) angezeigt; Freeware-Versio-
       nen ohne Key melden sich mit "R/Free". Men /XPoint/Registrierung
       umbenannt in /XPoint/Lizenz, dort verweist der Button statt auf die
       weggefallene LIZENZ.DOC nun auf die Quelltextlizenz SLIZENZ.TXT.

  Revision 1.47  2003/07/30 23:09:49  my
  MY:- Source-Header auf "FreeXP" aktualisiert, einige Detailkorrekturen
       an CVS-Logs vorgenommen und hier und da CVS-Loginfos implementiert.

  Revision 1.46  2003/06/25 17:28:15  tw
  auto-de-branching

  Revision 1.45.2.32  2003/04/12 08:23:57  mw
  MW: - Wegfall des Schalters /xmsovr und neuer Schalter /noovrbuf

  Revision 1.45.2.31  2003/01/14 21:47:09  mw
  MW: - XMS-Overlaycache nun per Kommandozeile einschaltbar
        (Wenn Compilerschalter gesetzt und kein EMS vorhanden)
      - Kommandozeilenauswertung in der xpx.pas jetzt
        positionsunabhngig realisiert.
      - Compilerschalter XMSOVR jetzt per Default eingeschaltet

  Revision 1.45.2.30  2002/03/27 19:52:12  my
  MY:- Interne nderung: Die LFN-Untersttzung wird bei Angabe des
       Kommandozeilenschalters "/lfn" nur noch dann aktiviert, wenn sie
       nicht bereits sowieso schon aktiviert war.

  Revision 1.45.2.29  2001/12/20 15:03:54  my
  MY:- Registrierroutine fr RFC/Client gem Vereinbarung mit Peter
       Mandrella (Mail vom 21.11.2001) angepat => kein UUCP-Key mehr
       erforderlich. :-)

  Revision 1.45.2.28  2001/10/26 18:34:08  my
  MY:- Zwei Debug-Ausgaben auskommentiert (der angestrebte Fix fr
       "/mailto:" funktioniert eh noch nicht).

  Revision 1.45.2.27  2001/10/26 17:40:02  my
  MY+JG+RB:- Automatische Zeitzonenumstellung (Optionen 'manuell',
             'Datum', 'TZ-Var.', 'TZ/Datum). Details siehe Hilfe.

  Revision 1.45.2.26  2001/10/21 14:40:41  mk
  - /nb bei /mailto

  Revision 1.45.2.25  2001/10/16 18:36:01  my
  MY:- /Netcall/Spezial fertiggestellt:
       - NETCALL.DAT kann jetzt bis zu 20 Eintrge enthalten, die bei
         einem /Netcall/Spezial mit <F2> ausgewhlt werden knnen. Je
         Eintrag stehen 255 Zeichen fr Boxnamen zur Verfgung. Die
         Eintrge werden in der Anzeige durchnumeriert.
       - Editor fr NETCALL.DAT unter /Netcall/Spezial-Liste mit
         Existenz-, Dupe- und Stringlngencheck (Danke an mk fr Hilfe)
       - Neuer Kommandozeilenparameter "/nsp:1..20", der einen /Netcall/
         Spezial fr den als Parameter bergebenen Eintrag aus NETCALL.DAT
         durchfhrt.

  Revision 1.45.2.24  2001/09/16 20:21:45  my
  JG+MY:- Zusatzmen fat jetzt bis zu 20 Eintrge (bei 25 Bildschirm-
          zeilen stehen nur die ersten 19 zur Verfgung).

  JG+MY:- Neuer Menpunkt "?" (Hilfe) im Hauptmen mit Untermens fr
          ntzliche und/oder in der Hilfe ansonsten nur schwer auffindbare
          Informationen. Untermen "ber OpenXP" zeigt Versions- und
          Snapshotnummer sowie OpenXP-Kontakte an. Beta- und
          Registrierungsfenster optisch angepat.

  MY:- Copyright-/Lizenz-Header aktualisiert

  Revision 1.45.2.23  2001/09/06 18:42:40  mk
  - removed unused variable n from zusatz_menu

  Revision 1.45.2.22  2001/08/12 09:05:39  mk
  - removed xpeasy

  Revision 1.45.2.21  2001/08/11 10:58:35  mk
  - debug switch on
  - moved some procedures and functions, because code size of unit

  Revision 1.45.2.20  2001/08/05 11:45:33  my
  - added new unit XPOVL.PAS ('uses')

  Revision 1.45.2.19  2001/07/01 15:43:34  my
  SV:- moved RTA code to new unit xp4rta.pas

  Revision 1.45.2.18  2001/01/10 17:39:03  mk
  - PPP-Modus, unversandt, Ruecklaeufer ersetzen, VGA-Palette,
    UUZ und Bugfixes

  Revision 1.45.2.17  2001/01/09 14:36:56  sv
  - reply-detection improved

  Revision 1.45.2.16  2001/01/03 22:46:48  mk
  - Parameter /Pal hinzugefuegt

  Revision 1.45.2.15  2000/12/28 19:15:37  mk
  - falsche Pfade konnten nicht editiert werden

  Revision 1.45.2.14  2000/12/12 11:30:27  mk
  - FindClose hinzugefuegt

  Revision 1.45.2.13  2000/12/09 16:41:07  mk
  - Sprachumschaltung aktiviert

  Revision 1.45.2.12  2000/12/07 13:10:04  mk
  - Pfade nur beim ersten Start anlegen

  Revision 1.45.2.11  2000/12/06 11:19:00  mk
  - TestPfad2 entfernt

  Revision 1.45.2.10  2000/12/05 13:09:42  mk
  - einige Datei/Verzeichnisnamen gross geschrieben

  Revision 1.45.2.9  2000/10/18 08:49:40  mk
  - Switch -312 fuer XP Kompatibilitaetsmodus (F-TO -> X-XP-FTO)

  Revision 1.45.2.8  2000/10/10 22:49:45  mk
  - Unit xp2 gesplittet, um Codegroessengrenzen zu umgehen

  Revision 1.45.2.7  2000/10/08 11:11:18  mk
  - Verschiedene Dateinamen gross geschrieben

  Revision 1.45.2.6  2000/09/30 16:28:00  mk
  - VESA 80x60-Zeilenmodus

  Revision 1.45.2.5  2000/08/28 23:35:54  mk
  - LFN in uses hinzugefuegt

  Revision 1.45.2.4  2000/08/27 08:39:38  mk
  - LFN-Unterstuetzung aktiviert, Parameter /LFN schaltet explizit zu

  Revision 1.45.2.3  2000/08/25 19:22:52  jg
  - "< >" in Macros funktioniert jetzt wie dokumentiert als Leertastenersatz
    XP10.PAS
  - Parameter -K verarbeitet jetzt ganze Zeichenketten. Benoetigt
    Anfuehrungszeichenauswertung damit Tasten wie <Enter> funktionieren !
    XP10.PAS,XP2.PAS
  - Neuer Parameter -mailto: dem direkt ein Mailto-Link uebergeben wird
    Subjects mit Leerzeichen benoetigen Anfuehrungszeichenauswertung !
    XP2.PAS

  Revision 1.45.2.2  2000/08/03 14:25:10  mk
  - Filehandles auf 40 erhoeht

  Revision 1.45.2.1  2000/08/03 09:22:23  mk
  - Filehandles hochgesetzt

  Revision 1.45  2000/06/19 20:19:32  ma
  - von CRC16/XPCRC32 auf Unit CRC umgestellt

  Revision 1.44  2000/06/02 16:28:36  ml
  Linux: Die Ressourcen werden nun im Programmverzeichnis gesucht, nicht im ~/openxp-Verzeichnis

  Revision 1.43  2000/06/01 16:03:05  mk
  - Verschiedene Aufraeumarbeiten

  Revision 1.42  2000/05/29 20:21:41  oh
  -findclose: ifdef virtualpascal nach ifdef ver32 geaendert

  Revision 1.41  2000/05/20 02:07:39  mk
  - 32 Bit/VP: FindFirst/FindNext aus Dos-Unit statta us SysTools verwendet

  Revision 1.40  2000/05/19 13:48:00  ml
  Hilfedatei wird jetzt gefunden (xp.hlp)

  Revision 1.39  2000/05/14 09:54:58  hd
  - 3. Cfg-Datei

  Revision 1.38  2000/05/14 07:22:51  jg
  - User-Schnellsuche Cursorposition anhand Feldtauscheinstellung bestimmen
  - Feldtausch-Config: Defaultauswahl mit F2

  Revision 1.37  2000/05/13 14:29:13  hd
  Workaround wg. noch nicht vorhandener Unit

  Revision 1.36  2000/05/13 14:24:56  hd
  - Suchmaske angepasst (test_pfade)

  Revision 1.35  2000/05/10 12:55:52  sv
  - Veraenderte Boxeneinstellungen wurden ohne XP-Neustart nicht
    uebernommen

  Revision 1.34  2000/05/04 10:32:57  mk
  - unbenutzer TurboBox Code entfernt

  Revision 1.33  2000/05/03 17:15:39  hd
  - Kleinschreibung der Dateinamen (duerfte keine Probleme geben :-/) (loadresource)
  - ustr durch lstr bei ParLanguage ersetzt (readpar)

  Revision 1.32  2000/05/02 19:14:00  hd
  xpcurses statt crt in den Units

  Revision 1.31  2000/04/30 17:24:54  mk
  - Erkennung eigener Mails jetzt mit FQDN-Unterstuetzung

  Revision 1.30  2000/04/29 11:54:09  mw

  - MIME in News voreingestellt
  - Triggerlevel 2 voreingestellt
  - EASY-Mode Aufruf verndert

  Revision 1.29  2000/04/22 13:54:08  mw

  - TermInit Default angepasst
  - TermInit hat jetzt auswhlbare Vorgaben
  - Rechtschreibfehler in xp2.pas gefunden

  Revision 1.28  2000/04/18 11:23:49  mk
  - AnyFile in ffAnyFile ($3F->$20) ersetzt

  Revision 1.27  2000/04/16 19:50:38  mk
  - Fixes fuer FindFirst

  Revision 1.26  2000/04/15 21:44:46  mk
  - Datenbankfelder von Integer auf Integer16 gaendert

  Revision 1.25  2000/04/13 12:48:35  mk
  - Anpassungen an Virtual Pascal
  - Fehler bei FindFirst behoben
  - Bugfixes bei 32 Bit Assembler-Routinen
  - Einige unkritische Memory Leaks beseitigt
  - Einge Write-Routinen durch Wrt/Wrt2 ersetzt
  - fehlende CVS Keywords in einigen Units hinzugefuegt
  - ZPR auf VP portiert
  - Winxp.ConsoleWrite provisorisch auf DOS/Linux portiert
  - Automatische Anpassung der Zeilenzahl an Consolengroesse in Win32

  Revision 1.24  2000/04/08 13:33:14  mk
  MW: Defaultwerte angepasst und aktualisiert

  Revision 1.23  2000/04/04 21:01:23  mk
  - Bugfixes fr VP sowie Assembler-Routinen an VP angepasst

  Revision 1.22  2000/04/04 10:33:56  mk
  - Compilierbar mit Virtual Pascal 2.0

  Revision 1.21  2000/03/16 19:25:10  mk
  - fileio.lock/unlock nach Win32 portiert
  - Bug in unlockfile behoben

  Revision 1.20  2000/03/14 15:15:38  mk
  - Aufraeumen des Codes abgeschlossen (unbenoetigte Variablen usw.)
  - Alle 16 Bit ASM-Routinen in 32 Bit umgeschrieben
  - TPZCRC.PAS ist nicht mehr noetig, Routinen befinden sich in CRC16.PAS
  - XP_DES.ASM in XP_DES integriert
  - 32 Bit Windows Portierung (misc)
  - lauffaehig jetzt unter FPC sowohl als DOS/32 und Win/32

  Revision 1.19  2000/03/10 13:29:33  mk
  Fix: Registrierung wird sauber erkannt

  Revision 1.18  2000/03/09 23:39:33  mk
  - Portierung: 32 Bit Version laeuft fast vollstaendig

  Revision 1.17  2000/03/07 23:41:07  mk
  Komplett neue 32 Bit Windows Screenroutinen und Bugfixes

  Revision 1.16  2000/03/04 15:54:43  mk
  Funktion zur DOSEmu-Erkennung gefixt

  Revision 1.15  2000/03/03 21:12:49  jg
  - Config-Optionen-Sprache ausgeklammert
  - Sprachabfrage bei allererstem Start eingebaut

  Revision 1.14  2000/03/02 18:32:24  mk
  - Code ein wenig aufgeraeumt

  Revision 1.13  2000/03/02 00:17:23  rb
  Hilfe bei XP /? fr Rechenzeitfreigabe berarbeitet

  Revision 1.12  2000/03/01 23:49:02  rb
  Rechenzeitfreigabe komplett berarbeitet

  Revision 1.11  2000/02/29 17:55:42  mk
  - /nb wird jetzt in Release-Versionen ignoriert

  Revision 1.10  2000/02/28 08:57:05  mk
  - Version auf 3.20 RC1 geandert

  Revision 1.9  2000/02/27 22:30:10  mk
  - Kleinere Aenderung zum Sprachenwechseln-Bug (2)

  Revision 1.8  2000/02/19 14:59:36  jg
  Parameter /w0 hat keine wirkung mehr, wenn /osx definiert ist.

  Revision 1.6  2000/02/19 11:40:08  mk
  Code aufgeraeumt und z.T. portiert

  Revision 1.5  2000/02/18 17:28:08  mk
  AF: Kommandozeilenoption Dupekill hinzugefuegt

}
