{ --------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.               }
{ (c) 1991-1999 Peter Mandrella                                   }
{ (c) 2000-2001 OpenXP-Team                                       }
{ (c) 2002-2005 FreeXP, http://www.freexp.de                      }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.     }
{                                                                 }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der }
{ Datei SLIZENZ.TXT oder auf www.crosspoint.de/oldlicense.html.   }
{ --------------------------------------------------------------- }
{ $Id: xp1help.pas,v 1.12 2005/01/01 11:16:28 mw Exp $ }

{ CrossPoint - Hotkey-Anzeige und Online-Hilfe }

{$I XPDEFINE.INC }
{$IFDEF BP }
  {$O+,F+}
{$ENDIF }

unit xp1help;

interface


uses
  xpglobal,crt,typeform,inout,keys,resource,maus2,help,
  winxp,printerx,maske,xp0;


const inithlp : boolean = false;
      maxhelpst = 20;
      helpstp : shortint = 1;

var   helpst  : array[1..maxhelpst] of word;

procedure showkeys(nr:integer);
procedure showlastkeys;
procedure set_helppos;
procedure hilfe;
procedure hilfealt;
procedure dispfunctionkeys(editor:boolean);
procedure do_help(n:word);

implementation  { --------------------------------------------------- }

uses xp1;

var lastkeys : integer;


procedure showkeys(nr:integer);
const kss : byte = 2;

  procedure ks(s:string);
  var p : byte;
  begin
    p:=cpos('^',s);
    delete(s,p,1);
    inc(shortkeys);
    if shortkeys>maxskeys then
      interr('Shortkey Overflow');
    with shortkey[shortkeys] do begin
      keypos:=wherex;
      keylen:=length(s);
      keyspot:=p;
      key:=LoCase(s[p]);
      end;
    attrtxt(col.colkeys);
    Wrt2(left(s,p-1));
    attrtxt(col.colkeyshigh);
    Wrt2(s[p]);
    attrtxt(col.colkeys);
    if kss = 2 then
      Wrt2(copy(s,p+1,30) + '  ')
    else
      Wrt2(copy(s,p+1,30) + ' ')
  end;

  procedure AddSK(pos,len,spot:shortint; _key:taste);
  begin
    inc(shortkeys);
    if shortkeys>maxskeys then
      interr('Shortkey Overflow');
    with shortkey[shortkeys] do begin
      keypos:=pos;
      keylen:=len;
      keyspot:=spot;
      key:=_key;
      end;
  end;

  procedure ende(const s1,s2:string);
  begin
    Wrt2(sp(79-length(s1)-length(s2)-wherex));
    attrtxt(col.colkeyshigh);
    Wrt2(s1);
    attrtxt(col.colkeys);
    Wrt2(s2 + '  ');
  end;

  procedure ksesc;
  begin
    ende('Esc','');
    AddSK(76,3,-3,keyesc);
  end;

  procedure plusminus;
  begin
    AddSK(wherex,1,1,'+');
    attrtxt(col.colkeyshigh);
    Wrt2('+');
    attrtxt(col.colkeys);
    Wrt2('/');
    AddSK(wherex,1,1,'-');
    attrtxt(col.colkeyshigh);
    Wrt2('-');
    attrtxt(col.colkeys);
  end;

  procedure tabkey;
  begin
    attrtxt(col.colkeys);
    Wrt2(sp(69-WhereX));
    addsk(WhereX,3,-3,keytab);
    attrtxt(col.colkeyshigh);
    Wrt2('Tab');
    attrtxt(col.colkeys);
    Wrt2(' / ');
    addsk(WhereX,4,1,'q');
    ende('Q','uit');
  end;

  procedure hitxt(const s:string);
  begin
    attrtxt(col.colkeyshigh);
    Wrt2(s);
  end;

  procedure ksmark;
  begin
    AddSK(wherex,21,-11,' ');
    hitxt('Space/F7/F');
    ks('^8-'+getres2(20,0));    { 'markieren' }
    dec(shortkeys);
  end;

  procedure kscr(const txt:string);
  begin
    AddSK(wherex,length(txt)+4,-3,keycr);
    hitxt(#17'');
    ks('^-'+txt);
    dec(shortkeys);
  end;

  procedure kstr(nr:word);
  var s : string[80];
      p : byte;
  begin
    s:=getres2(20,nr)+' ';
    repeat
      p:=cpos(' ',s);
      if s[1]='~' then begin      { Ctrl-Zeichen }
        hitxt('^');
        s[1]:='^';
        ks(left(s,p-1));
        with shortkey[shortkeys] do begin
          key:=chr(ord(upcase(s[2]))-64);
          dec(keypos);
          inc(keylen);
          keyspot:=-keyspot-1;
          end;
        end
      else
        ks(left(s,p-1));
      delete(s,1,p);
    until s='';
  end;

begin
  if not keydisp then exit;
  shortkeys:=0;
  gotoxy(1,2);
  attrtxt(col.colkeys);
  FWrt(1,2,sp(screenwidth)); { Q&D fuer durchgehende Menuzeile }
  moff;
  Wrt2('  ');
  case abs(nr) of
    0 : Wrt2(sp(screenwidth-2));
    1 : begin       { Brettfenster }
          kstr(1);  { ^Alle ^Brief T^extfile B^inr ^Spezial ^Lesen: }
          lesemodepos:=wherex-1;
          gotoxy(wherex+10,wherey);     { gegen flackernden Lesemode }
          tabkey;
        end;
    2 : begin       { User-Fenster }
          kstr(2);  { ^Alle ^Brief T^extfile B^inr ^Spezial S^uche Ad^rebuch ^Pawort }
          tabkey;
        end;
    3 : begin       { Edit-Brettfenster }
          if length(getres2(20,3))>=58 then
            kss:=1;
          kstr(3);  { ^Hinzuf. ^Lschen ^Edit ^Verknpfen ^Pos. ~Trenn. ^Spezial }
          plusminus;
          kss:=2;
          tabkey;
        end;
    4 : begin       { Edit-Userfenster }
          kstr(4);  { ^Alle ^Hinzuf. ^Vert. ^Lschen ^Edit ^Spezial Ad^rebuch ^PW }
          plusminus;
          tabkey;
        end;
    5 : begin       { Msg-Fenster / User-Msg-Fenster }
          if nr>0 then kstr(5)   { ^Alle ^Halten ^Lschen ^Kill Bezu^g ^BrettBrief ^PM ^User ^Info ^Sonst. }
          else kstr(6);          { ^Alle ^Halten ^Lschen ^Kill Bezu^g ^PM ^Info D^ruck ^Sonstiges }
          ksesc;
        end;
    6 : begin             { markierte Nachrichten / Kommentarbaum }
          if nr>0 then kstr(7)   { ^Halten ^Lschen ^Kill ^BrettBrief ^PM ^Info ^Absender ^Sonstige }
          else kstr(8);          { ^Adresse ^Halten ^Lschen ^Kill ^BrettBrief ^PM ^Info ^Sonstige  }
          ksesc;
        end;
    7 : begin             { Brett-Weiterleitfenster }
          kscr(getres2(20,9));   { 'besttigen' }
          ksesc;
        end;
    8 : begin             { User-Weiterleitfenster }
          ks(getres2(20,10));    { '^Alle' }
          ks(getres2(20,22));
          kscr(getres2(20,9));   { 'besttigen' }
          ksesc;
        end;
    9 : begin             { Maps - Brettliste }
          ksmark;
          kscr(getres2(20,iif(nr<0,11,12)));  { 'abbestellen' / 'bestellen' }
          ksesc;
        end;
   10 : begin             { Fileserver - Dateiliste }
          ksmark;
          kscr(getres2(20,21));   { 'bestellen' }
          ksesc;
        end;
   11 : begin             { Archiv-Viewer }
          ksmark;
          kstr(13);       { 'E^xtrakt' }
          kscr(getres2(20,14));    { 'anzeigen' }
          ksesc;
        end;
   12 : begin             { Brettliste - hinzufgen }
          ksmark;
          kscr(getres2(20,15));   { 'Bretter anlegen' }
          ksesc;
        end;
   13 : begin             { Auto-Netcall }
          hitxt('Spac');
          ks('^e-'+getres2(20,16));   { 'Netcall direkt starten' }
          ksesc;
        end;
   14 : begin       { Autoversand-Liste }
          kstr(17); { ^Aktiv ^Hinzufgen ^Kopie ^Lschen ^Edit ^TextEdit ^Info ^Senden }
          AddSK(wherex,3,-3,keycr);
          hitxt(#17'');
          ksesc;
        end;
   15 : begin             { Netcall - Anwahl }
          plusminus;
          Wrt2(getres2(20,18));   { ' Zeit' }
          ksesc;
        end;
   16 : begin             { Netcall - Warten }
          hitxt('Spac');
          ks('^e-'+getres2(20,19));    { 'Netcall starten' }
          ksesc;
        end;
   17 : ksesc;            { Esc = Abbruch }
   18 : begin             { Online-Anruf - Warten }
          hitxt('Spac');
          ks('^e-'+getres2(20,20));    { 'Anruf starten' }
          ksesc;
        end;
  end;
  mon;
  freeres;
  lastkeys:=nr;
end;

procedure showlastkeys;
begin
  showkeys(lastkeys);
end;


procedure set_helppos;
begin
  sethelppos(15,6+(screenlines-24)div 4,16+(screenlines-25)div 2);
end;


procedure do_help(n:word);
var
      x,y  : byte;
      hlp  : string[10];
      mh   : boolean;
begin
  if not inithlp then
    if not inithelp(OwnPath+helpfile,1,1,HInvers,HKeinBlocksatz,HHeadNotHigh) then
    begin
      rfehler1(1,helpfile);   { Die Hilfsdatei XP.HLP fehlt }
      if ioresult<>0 then;
      end
    else begin
      inithlp:=true;
      set_helppos;
      end;
  if inithlp then begin
    hlp:='';
    setrahmen(2);
    openbox(58,18+(actscreenlines-25)div 2,hlp,x,y,col.colHelp,col.colHelp);
    setrahmen(1);
    mh:=hotkeys;
    hotkeys:=false;
    IHS(n);
    hotkeys:=mh;
    closebox;
    end;
end;


procedure hprint;
begin
  help_printable(^D,printstring(druckinit),printstring(druckexit));
end;

procedure hilfe;
begin
  savecursor;
  hprint;
  if readmask_active and (mask_helpnr>0) then
    do_help(mask_helpnr)
  else
    do_help(helpst[helpstp]);
  restcursor;
end;


procedure hilfealt;
begin
  hprint;
  do_help(0);
end;


{ F-Tastenkrzel in letzter Zeile anzeigen }

procedure dispfunctionkeys(editor:boolean);
const fs : array[1..3] of char = 'SCA';
var fks,fkn : integer;
    i,j,spc : integer;
    hilfe,
    makros  : string[10];

  procedure wf(const s:string);
  begin
    attrtxt(col.colkeyshigh);
    Wrt2(left(s,cpos('-',s)-1));
    attrtxt(col.colkeys);
    Wrt2(copy(s,cpos('-',s),60) + sp(spc));
  end;

begin
  fks:=0; fkn:=0;
  if not editor then
    for i:=1 to 3 do                     { bentigten Platz berechnen }
      for j:=1 to 10 do                  { ohne Spaces                }
        with fkeys[i]^[j] do
          if menue<>'' then begin
            inc(fks,length(menue)+3);
            inc(fkn);
            end;
  spc:=iif(fks+2*fkn<42,2,1);
  inc(fks,spc*fkn);

  hilfe:=getres(100);
  makros:=getres(101);
  moff;
  gotoxy(1,screenlines);
  if fks<70-length(hilfe) then wf('F1-'+hilfe);
  if fks<57-length(hilfe)-length(makros) then wf('F6-'+makros);
  if fks<62-length(hilfe) then wf('F9-DOS');
  inc(windmax,$100);
  if editor then
    wf('F10-'+getres(133))
  else
    for i:=1 to 3 do
      for j:=1 to 10 do
        with fkeys[i]^[j] do
          if menue<>'' then
            if (wherex+length(menue)+3<=screenwidth+1) and (wherey=screenlines) then
              wf(fs[i]+strs(j)+'-'+menue);
  attrtxt(col.colkeys);
  XPdisplayed:=(wherey=screenlines) and                  { 2 Blanks mssen vor   }
               (wherex<=screenwidth-length(xp_display)); { xp_display Platz sein }
  if XPdisplayed then
    Wrt2(sp(screenwidth+1-length(xp_display)-wherex) + xp_display)  { 'FreeXP' }
  else
    if wherey=screenlines then Wrt2(sp(screenwidth+1-wherex));
  mon;
  dec(windmax,$100);
  fnkeylines:=1;
end;


end.
{
  $Log: xp1help.pas,v $
  Revision 1.12  2005/01/01 11:16:28  mw
  MW: - Willkommen im Jahr 2005

  Revision 1.11  2004/01/09 16:18:57  mw
  MW: - Wir haben jetzt 2004!!

  Revision 1.10  2003/08/01 23:18:21  my
  MY:- About-, Beta-, und alle sonstigen Dialoge, Ausgaben und
       Versionsmeldungen auf "FreeXP" umgestellt.

  Revision 1.9  2003/07/30 23:09:49  my
  MY:- Source-Header auf "FreeXP" aktualisiert, einige Detailkorrekturen
       an CVS-Logs vorgenommen und hier und da CVS-Loginfos implementiert.

  Revision 1.8  2003/06/25 17:27:59  tw
  auto-de-branching

  Revision 1.7.2.8  2002/03/31 15:48:13  my
  MY:- Die farbliche Unterlegung der Funktionstasten in der oberen
       Funktionstastenleiste geriet hin und wieder durcheinander (nach
       N/S/S z.B.). Ursprngliche (nicht optimierte) Display-Routine
       'showkeys.ks' wieder eingebaut.

  Revision 1.7.2.7  2002/03/08 23:40:10  my
  MY:- Registrierungs-, Beta-, "ber OpenXP"- und sonstige Dialoge auf
       OpenXP/16 umgestellt und Copyright-Hinweise sowie Kontakte
       aktualisiert.

  Revision 1.7.2.6  2001/12/18 14:10:22  mk
  - weitere const parameter hinzugefgt

  Revision 1.7.2.5  2001/12/18 14:06:59  mk
  - const parameter fr wf()

  Revision 1.7.2.4  2001/12/18 13:06:55  mk
  - Beschleunigung der Bildschirmausgabe unter Windows-Dos-Boxen

  Revision 1.7.2.3  2001/09/16 20:20:06  my
  JG+MY:- Neuer Menpunkt "?" (Hilfe) im Hauptmen mit Untermens fr
          ntzliche und/oder in der Hilfe ansonsten nur schwer auffindbare
          Informationen. Untermen "ber OpenXP" zeigt Versions- und
          Snapshotnummer sowie OpenXP-Kontakte an. Beta- und
          Registrierungsfenster optisch angepat.

  MY:- Copyright-/Lizenz-Header aktualisiert

  Revision 1.7.2.2  2001/08/11 22:17:56  mk
  - changed Pos() to cPos() when possible, saves 1814 Bytes ;)

  Revision 1.7.2.1  2000/12/08 01:08:40  mk
  MH:- Usersuche bei Auswahl ueber F2 moeglich

  Revision 1.7  2000/05/08 13:05:45  hd
  Anpassung an variable Screen-Breite

  Revision 1.6  2000/05/02 19:13:59  hd
  xpcurses statt crt in den Units

  Revision 1.5  2000/04/13 12:48:35  mk
  - Anpassungen an Virtual Pascal
  - Fehler bei FindFirst behoben
  - Bugfixes bei 32 Bit Assembler-Routinen
  - Einige unkritische Memory Leaks beseitigt
  - Einge Write-Routinen durch Wrt/Wrt2 ersetzt
  - fehlende CVS Keywords in einigen Units hinzugefuegt
  - ZPR auf VP portiert
  - Winxp.ConsoleWrite provisorisch auf DOS/Linux portiert
  - Automatische Anpassung der Zeilenzahl an Consolengroesse in Win32

}
