{ --------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.               }
{ (c) 1991-1999 Peter Mandrella                                   }
{ (c) 2000-2001 OpenXP-Team                                       }
{ (c) 2002-2005 FreeXP, http://www.freexp.de                      }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.     }
{                                                                 }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der }
{ Datei SLIZENZ.TXT oder auf www.crosspoint.de/oldlicense.html.   }
{ --------------------------------------------------------------- }
{ $Id: xp10p.inc,v 1.10 2005/02/18 11:08:51 mw Exp $ }

procedure SavePhonezones;
var t     : text;
    i,j,k : integer;
    first : boolean;
begin
  assign(t,ParGebdat);               { GEBUEHR.DAT speichern }
  rewrite(t);
  writeln(t,'## ',getres(1002));     { 'Telefon-Tarifzonen' }
  writeln(t);
  writeln(t,'Dummy=');
  writeln(t);
  for i:=1 to anzahl do
    with phones^[i] do begin
      writeln(t,'Zone=',komment);
      for j:=1 to (anz+7) div 8 do begin
        for k:=1 to 8 do
          if (j-1)*8+k<=anz then
            write(t,ph^[(j-1)*8+k],' ');
        writeln(t);
        end;
      writeln(t);
      end;
  close(t);
  assign(t,ParGebdat2);              { TARIFE.DAT speichern }
  rewrite(t);
  writeln(t,'## ',getres(1021));     { 'Telefon-Tarife' }
  writeln(t);
  for i:=1 to tables do with tarif^[i] do begin
    write(t,'[');                    { [Mo,Di,Mi,...] schreiben }
    first:=true;
    for j:=1 to maxwotage do
      if wochentag[j] then begin
        if not first then write(t,',');
        first:=false;
        write(t,wofeiertag[j]);
        end;
    writeln(t,']');
    for j:=1 to zeitbereiche do with zeitbereich[j] do begin
      write(t,von,'-',bis);
      for k:=1 to xp10.anzahl do with tarif[k] do begin
        write(t,' ');
        if round(sekunden,2)=round(sekunden,0) then
          write(t,strsr(sekunden,0))
        else
          write(t,strsr(sekunden,2));
        if round(pfennig,2)=round(pfennig,0) then begin
           write(t,'/');
           write(t,strsr(pfennig,0))
          end
        else begin
          write(t,'/');
          write(t,strsr(pfennig,2));
        end;
        if anwahl>0 then begin
          if round(anwahl,2)=round(anwahl,0) then begin
            write(t,'/');
            write(t,strsr(anwahl,0));
          end
          else begin
             write(t,'/');
             write(t,strsr(anwahl,2));
            end;
          end;
        end;
      writeln(t);
      end;
    writeln(t);
    end;
  close(t);
end;


procedure LoadPhonezones;
var pa    : phoneap;
    t     : text;
    s     : string;
    ss    : string[20];
    i     : integer;
    ppos  : integer;
    p     : byte;
    loadt : boolean;    { TARIFE.DAT laden }

  procedure AddP(s:string; _anz:integer);
  begin
    inc(anzahl);
    with phones^[anzahl] do begin
      komment:=s;
      anz:=_anz;
      if anz>0 then
        getmem(ph,anz*sizeof(phone1));
      end;
    ppos:=0;
  end;

  procedure x(nr:integer);
  begin
    with phones^[anzahl] do begin
      inc(ppos);
      ph^[ppos]:=strs(nr)+'-';
      end;
  end;

  procedure xs(s:string);
  begin
    with phones^[anzahl] do begin
      inc(ppos);
      ph^[ppos]:=s;
      end;
  end;

  procedure x7(nr:word);
  begin
    xs('7-'+strs(nr));
  end;


  procedure bereich(tnr,bereichnr:integer; _von,_bis:string;
                    g1,p1,g2,p2,g3,p3,g4,p4,g5,p5,g6,p6,g7,p7,g8,p8,g9,p9,g10,p10,g11,p11,g12,p12,g13,p13,g14,p14:real);
  var i : integer;
  begin
    with tarif^[tnr].zeitbereich[bereichnr] do begin
      von:=_von;
      bis:=_bis;
      tarif[1].sekunden:=g1; tarif[1].pfennig:=p1;
      tarif[2].sekunden:=g2; tarif[2].pfennig:=p2;
      tarif[3].sekunden:=g3; tarif[3].pfennig:=p3;
      tarif[4].sekunden:=g4; tarif[4].pfennig:=p4;
      tarif[5].sekunden:=g5; tarif[5].pfennig:=p5;
      tarif[6].sekunden:=g6; tarif[6].pfennig:=p6;
      tarif[7].sekunden:=g7; tarif[7].pfennig:=p7;
      tarif[8].sekunden:=g8; tarif[8].pfennig:=p8;
      tarif[9].sekunden:=g9; tarif[9].pfennig:=p9;
      tarif[10].sekunden:=g10; tarif[10].pfennig:=p10;
      tarif[11].sekunden:=g11; tarif[11].pfennig:=p11;
      tarif[12].sekunden:=g12; tarif[12].pfennig:=p12;
      tarif[13].sekunden:=g13; tarif[13].pfennig:=p13;
      tarif[14].sekunden:=g14; tarif[14].pfennig:=p14;
      for i:=1 to 16 do tarif[i].anwahl:=0;
      end;
  end;

begin
  new(phones);
  assign(t,ParGebdat);
  anzahl:=0;
  if existf(t) then begin
    new(pa);
    reset(t);
    while not eof(t) do begin
      repeat                         { Kopf berlesen }
        readln(t,s);
        if left(s,1)<>'#' then p:=cpos('=',s)
        else p:=0;
      until eof(t) or (p>0);
      while p>0 do begin             { einmaligen Datenblock einlesen }
        if eof(t) then s:=''
        else readln(t,s);
        p:=cpos('=',s);
        end;
      while not eof(t) and (anzahl<maxzones) do begin
        repeat
          readln(t,s); p:=cpos('=',s)
        until eof(t) or (p>0);
        if not eof(t) then begin
          inc(anzahl);               { Zonendaten einlesen }
          fillchar(phones^[anzahl],sizeof(phones^[anzahl]),0);
          with phones^[anzahl] do begin
            repeat
              if lstr(left(s,p-1))='zone' then komment:=trim(mid(s,p+1));
              readln(t,s);
              p:=cpos('=',s);
            until p=0;
            if not eof(t) then
              while trim(s)<>'' do begin     { Nummern einlesen }
                s:=left(trim(s),254)+' ';
                while s<>'' do begin
                  p:=cpos(' ',s);
                  if anz<maxphone then begin
                    inc(anz);
                    pa^[anz]:=left(s,p-1);
                    end;
                  s:=ltrim(mid(s,p+1));
                  end;
                if eof(t) then s:=''
                else readln(t,s);
                end;
            if memavail<sizeof(pa^)+anz*sizeof(phone1) then
              anz:=0;
            if anz>0 then begin
              getmem(ph,anz*sizeof(phone1));
              FastMove(pa^,ph^,anz*sizeof(phone1));
              end;
            end;
          end;
        end;
      end;
    close(t);
    dispose(pa);
    loadt:=exist(ParGebdat2);
    end

  else begin   { not exist(GebuehrDat) }
    AddP('T-Com Fern',0);
    AddP('T-Com Welt 4',0);
    AddP('T-Com Ort',0);
    AddP('T-Com Nah',0);
    AddP('T-Com VoIP',1);
    xs('032');
    AddP('T-Com Freecall',2);
    xs('0800'); x(800);
    AddP('T-Com Service 0700',1);
    xs('032');
    AddP('T-Com Mobil E-Netze',9);
    xs('0155'); xs('0156'); xs('0157'); xs('0159'); xs('0163'); xs('0176'); xs('0177'); xs('0178');
    xs('0179');
    AddP('T-Com Mobil D-Netze',10);
    xs('0151'); xs('0152'); xs('0160'); xs('0162'); xs('0170'); xs('0171'); xs('0172'); xs('0173');
    xs('0174'); xs('0175');
    AddP('T-Com Euro 1',22);
    x(298); x(30); x(31); x(32); x(33); x(34); x(351); x(352);
    x(353); x(354); x(358); x(376); x(378); x(39); x(41); x(42);
    x(43); x(44); x(45); x(46); x(47); x(48);
    AddP('T-Com Euro 2',41);
    x(20); x(212); x(213); x(216); x(218); x(350); x(355); x(356);
    x(357); x(359); x(36); x(370); x(371); x(372); x(373); x(375);
    x(380); x(381); x(385); x(386); x(387); x(389); x(40);
    xs('7-01'); xs('7-07'); xs('7-08'); xs('7-095'); xs('7-096');
    x7(811); x7(812); x7(815); x7(816); x7(820); x7(861); x7(862); x7(863);
    x(90); x(961); x(962); x(963); x(972);
    AddP('T-Com Welt 1',1);
    x(1);
    AddP('T-Com Welt 2',7);
    x(61); x(64); x(65); xs('672-3-'); x(81); x(82); x(852);
    AddP('T-Com Welt 3',14);
    xs('1-809'); x(27); x(54); x(55); x(56); x(57); x(599); x(63);
    x7(31); x7(32); x(886); x(966); x(971); x(98);
    loadt:=false;
    end;
  new(tarif);
  fillchar(tarif^,sizeof(tarif^),0);
  tables:=0;
  if loadt then begin
    assign(t,ParGebdat2);
    reset(t);
    while not eof(t) do begin
      repeat
        readln(t,s)
      until (firstchar(s)='[') or eof(t);
      if firstchar(s)='[' then begin
        delfirst(s); dellast(s);
        inc(tables);
        with tarif^[tables] do begin
          while s<>'' do begin   { '[Mo,Di,Mi,...] parsen }
            ss:=GetToken(s,',');
            for i:=1 to maxwotage do
              if stricmp(ss,wofeiertag[i]) then wochentag[i]:=true;
            end;
          zeitbereiche:=0;
          repeat
            readln(t,s);
            s:=trim(s);
            if (s<>'') and (s[3]=':') and (s[6]='-') and (s[9]=':') then begin
              inc(zeitbereiche);
              with zeitbereich[zeitbereiche] do begin
                ss:=GetToken(s,' ');
                von:=left(ss,5);
                bis:=right(ss,5);
                i:=0;
                while (s<>'') and (i<xp10.anzahl) do begin
                  inc(i);
                  ss:=GetToken(s,' ');    { Tarifeinheit parsen }
                  tarif[i].sekunden:=minmaxr(rval(GetToken(ss,'/')),0,9999);
                  tarif[i].pfennig:=minmaxr(rval(GetToken(ss,'/')),0,9999);
                  tarif[i].anwahl:=minmaxr(rval(GetToken(ss,'/')),0,9999);
                  end;                 { -> lt Platz fr Erweiterungen }
                end;
              s:='*';
              end;
          until s='';
          end;   { with table }
        end;   { [... }
      end;   { while not eof() }
    close(t);
    end

  else begin   { not loadt }
    tables:=2;
    for i:=1 to maxwotage do
      tarif^[1].wochentag[i]:=(i<=5);
    tarif^[1].zeitbereiche:=3;
    if not newgeb then begin
       bereich(1,1,'00:00','06:59',60,2.90,60,149,60,1.50,60,1.50,60,2.90,0,0,60,6,60,25.70,60,23.20,60,12.30,
                                 60,246,60,12.30,60,30.70,60,59);
       bereich(1,2,'07:00','18:59',60,4.9,60,149,60,3.90,60,3.90,60,4.90,0,0,60,6,60,25.70,60,23.20,60,12.30,
                                 60,246,60,12.30,60,30.70,60,59);
       bereich(1,3,'19:00','23:59',60,2.90,60,149,60,1.50,60,1.50,60,2.90,0,0,60,6,60,25.70,60,23.20,60,12.30,
                                 60,246,60,12.30,60,30.70,60,59);
    end else begin
       bereich(1,1,'00:00','06:59',60,2.90,60,149,60,1.50,60,1.50,60,2.90,0,0,60,6,60,25.70,60,23.20,60,12.30,
                                 60,246,60,12.30,60,30.70,60,59);
       bereich(1,2,'07:00','18:59',60,4.9,60,149,60,3.90,60,3.90,60,4.90,0,0,60,6,60,25.70,60,23.20,60,12.30,
                                 60,246,60,12.30,60,30.70,60,59);
       bereich(1,3,'19:00','23:59',60,2.90,60,149,60,1.50,60,1.50,60,2.90,0,0,60,6,60,25.70,60,23.20,60,12.30,
                                 60,246,60,12.30,60,30.70,60,59);  
    end;
    for i:=1 to maxwotage do
      tarif^[2].wochentag[i]:=(i in [6,7,8,9,10]);
    tarif^[2].zeitbereiche:=1;
    if not newgeb then begin
       bereich(2,1,'00:00','23:59',60,2.90,60,149,60,1.50,60,1.50,60,2.90,0,0,60,6,60,25.70,60,23.20,60,12.30,
                                 60,246,60,12.30, 60,30.70,60,59);
    end else begin
       bereich(2,1,'00:00','23:59',60,2.90,60,149,60,1.50,60,1.50,60,2.90,0,0,60,6,60,25.70,60,23.20,60,12.30,
                                 60,246,60,12.30, 60,30.70,60,59);
    end;
    end;
  if not loadt then SavePhonezones;
end;


procedure FreePhoneZones;
var i : integer;
begin
  for i:=1 to anzahl do
    if phones^[i].anz>0 then
      freemem(phones^[i].ph,phones^[i].anz*sizeof(phone1));
  dispose(phones);
  anzahl:=0;
  dispose(tarif);
end;

{
  $Log: xp10p.inc,v $
  Revision 1.10  2005/02/18 11:08:51  mw
  MW: - Neue Tarife der T-Com ab 01.03.2005 (Call-Plus)

  Revision 1.9  2005/01/01 11:16:27  mw
  MW: - Willkommen im Jahr 2005

  Revision 1.8  2004/12/05 12:33:57  mw
  MW: - Tariftabellenanpassung an neue Tarife ab 15.12.2004

  Revision 1.7  2004/11/08 12:07:16  mw
  MW: - Anpassung an aktuelle Telefon-Tarife

  Revision 1.6  2004/01/09 16:19:00  mw
  MW: - Wir haben jetzt 2004!!

  Revision 1.5  2003/07/30 23:09:49  my
  MY:- Source-Header auf "FreeXP" aktualisiert, einige Detailkorrekturen
       an CVS-Logs vorgenommen und hier und da CVS-Loginfos implementiert.

  Revision 1.4  2003/06/25 17:27:55  tw
  auto-de-branching

  Revision 1.3.4.2  2003/01/10 21:55:37  my
  MY:- Log- und Kommentarkosmetik

  Revision 1.3.4.1  2003/01/10 14:04:22  mw
  MW:- Groes Gebhren-Update:
       1. Es knnen jetzt auch Bruchteile von 1/100 Whrungseinheiten
          sowie ein zustzliches festes Verbindungsentgelt eingegeben und bei
          der Berechnung bercksichtigt werden.
       2. Neues Gebhrenmodell: Bei aktivem Schalter unter Config/Optionen/
                                Gebhren/Sonstiges werden Geldbetrge als
                                rechnerische Minutenpreise gewertet und nicht
                                mehr als Preis einer Tarifeinheit. Bei
                                inaktivem Schalter gelten Geldbetrge
                                weiterhin als Preis einer Tarifeinheit.
       3. Neue Default-Whrung fuer die Gebhrenberechnung ist nun EUR.
       4. Neue Tarife: Die Default-Tariftabelle enthlt nun alle aktuellen
          nationalen Privatkunden-Tarife der DTAG fr Festnetz zu Festnetz
          sowie den Tarif "Normaltarif" von 3U.
       5. Wenn die Default-Tariftabelle geschrieben wird, wird dabei das
          verwendete Gebhrenmodell bercksichtigt.
       6. XPOINT.LOG enthlt jetzt alle Kostenangaben mit 4 Nachkommastellen.

  Revision 1.3  2000/02/19 11:40:08  mk
  Code aufgeraeumt und z.T. portiert

}
