{ --------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.               }
{ (c) 1998, 2000 by Robert Boeck                                  }
{ (c) 2000-2001 OpenXP-Team                                       }
{ (c) 2002-2005 FreeXP, http://www.freexp.de                      }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.     }
{                                                                 }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der }
{ Datei SLIZENZ.TXT oder auf www.crosspoint.de/oldlicense.html.   }
{ --------------------------------------------------------------- }
{ $Id: encoder.pas,v 1.8 2005/01/01 11:16:27 mw Exp $ }

{$I XPDEFINE.INC }
{$F+,O+}

unit encoder;

interface

type str90=string[90];
     tbytestream=array[0..63] of byte;

procedure encode_base64(var bytestream:tbytestream;len:word;
                        var encoded:str90);
procedure encode_UU(var bytestream:tbytestream;len:word;
                    var encoded:str90);

implementation

type tbase64alphabet=array[0..63] of char;

const cbase64alphabet:tbase64alphabet=
      'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';

procedure encode_base64(var bytestream:tbytestream;len:word;
                        var encoded:str90);
  var i,j,l:word;
      b:array[0..3] of byte;
  begin
    encoded:='';
    if len=0 then exit;
    for i:=len to sizeof(tbytestream)-1 do bytestream[i]:=0;
    l:=0;
    for i:=0 to (len-1) div 3 do begin
      inc(l,3);
      if l>len then l:=len;
      b[0]:=(bytestream[i*3] and $fc) shr 2;
      b[1]:=((bytestream[i*3] and $03) shl 4)
            or ((bytestream[i*3+1] and $f0) shr 4);
      b[2]:=((bytestream[i*3+1] and $0f) shl 2)
            or ((bytestream[i*3+2] and $c0) shr 6);
      b[3]:=bytestream[i*3+2] and $3f;
      for j:=0 to (l-1) mod 3+1 do
       encoded:=encoded+cbase64alphabet[b[j]];
      for j:=1 to 2-(l-1) mod 3 do
       encoded:=encoded+'=';
    end;
  end;

procedure encode_UU(var bytestream:tbytestream;len:word;
                    var encoded:str90);
  var i,j:word;
      b:array[0..3] of byte;
  begin
    encoded:='';
    if len=0 then exit;
    for i:=len to sizeof(tbytestream)-1 do bytestream[i]:=0;
    for i:=0 to (len-1) div 3 do begin
      b[0]:=(bytestream[i*3] and $fc) shr 2;
      b[1]:=((bytestream[i*3] and $03) shl 4)
            or ((bytestream[i*3+1] and $f0) shr 4);
      b[2]:=((bytestream[i*3+1] and $0f) shl 2)
            or ((bytestream[i*3+2] and $c0) shr 6);
      b[3]:=bytestream[i*3+2] and $3f;
      for j:=0 to 3 do begin
        if b[j]=0 then b[j]:=64;
        encoded:=encoded+char(b[j]+32);
      end;
    end;
    encoded:=char(len+32)+encoded;
  end;

end.
{
  $Log: encoder.pas,v $
  Revision 1.8  2005/01/01 11:16:27  mw
  MW: - Willkommen im Jahr 2005

  Revision 1.7  2004/01/09 16:18:56  mw
  MW: - Wir haben jetzt 2004!!

  Revision 1.6  2003/07/30 23:09:49  my
  MY:- Source-Header auf "FreeXP" aktualisiert, einige Detailkorrekturen
       an CVS-Logs vorgenommen und hier und da CVS-Loginfos implementiert.

  Revision 1.5  2003/06/25 17:26:01  tw
  auto-de-branching

  Revision 1.4.2.1  2001/08/12 08:46:35  mk
  - moved to overlay

  Revision 1.4  2000/04/04 21:01:20  mk
  - Bugfixes fr VP sowie Assembler-Routinen an VP angepasst

  Revision 1.3  2000/02/17 16:14:19  mk
  MK: * ein paar Loginfos hinzugefuegt

}
