/*    =========================================================
 *    FreeDOS SMTP/POP3 client program vers. 0.34  (15-12-2001)
 *
 *    =  Free DOS (E)SMTP and POP3 protocols implementation   =
 *    =              based on WATTCP library                  =
 *
 *               by Yury Semenov (yury@zipper.paco.net)
 *    modified by Paolo Patruno (p.patruno@iperbole.bologna.it) 20/08/01
 *    modified by John Zappe (johnza@yifan.net) May 6, 2002
 *    =========================================================
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  This version modified by J. Zappe 5/16/02
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dir.h>
#include <dos.h>
#include <time.h>
#include <ctype.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/stat.h>
#include "tcp.h"
#include "dns.h"

#ifdef PP
#define VERSION "FD-(E)SMTP/POP3 v.0.33p2 for DOS"
#else /*PP*/
#define VERSION "FD-(E)SMTP/POP3 v.0.34 for DOS"
#endif /*PP*/
#define LOGFILE "FDSMTPOPLOG"

#define SMTP_PORT       25
#define POP3_PORT       110

#define SMTP_INTRO      220
#define SMTP_GOODBY     221
#define SMTP_LOCAL      250
#define SMTP_REMOTE1    251
#define SMTP_REMOTE2    252
#define SMTP_DATA       354
#define AUTH_INIT       334
#define AUTH_OK         235
#define SMTP_INVALID    550
#define ESMTP_NOTSUPP   502
#define AUTH_BADTYPE    504

#define SMTP_OK         SMTP_LOCAL

#define POP_OK          1

#define emacs (qtype == 2)
#define pm    (qtype == 1)
#define uupc  (qtype == 0)

extern char *cram_md5(unsigned char*, unsigned char*, unsigned char*);

extern struct useek *getmxlist(char *name);
extern struct mxrr *getmxanswer(struct useek *u,int anum);
extern longword getmxip(struct useek *u, char *dom);
extern int unpackdom(char *dst,char *src,char buf[] /*char *buf*/);
extern longword procmxlist(char *domname, struct useek *u, word minpref, FILE *log);
extern word preference;

int  port  = SMTP_PORT;
int  pport = POP3_PORT;
int  leave = 0, new = 0, kill = 0, direct = 1, qtype = 0, pop3 = 0, smtp = 1,
     verbose = 4, REVERSE = 0, ESMTP = 0, tmpESMTP = 0, auth_data_present;

/*---------eauthtype is used to set SMTP authentication method-------*/
int  eauthtype = 0;

char *host = NULL,
     *pophost = NULL,
     *domain = NULL,
     *from0 = NULL,
     *username = NULL,
     *password = NULL,
     *esmtpname = NULL,
     *esmtpassw = NULL,
     *queue  = "*.out",
     *qsmtp, *mail,
     *iext   = "msg";

char

    *crlf       = "\r\n",

/* (E)SMTP commands */

     *helo      = "HELO %s\r\n",
     *ehlo      = "EHLO %s\r\n",
     *auth      = "AUTH %s\r\n",
     *from      = "MAIL FROM:<%s>\r\n",
     *to        = "RCPT TO:<%s>\r\n",
     *datastart = "DATA\r\n",
     *dataend   = "\r\n.\r\n",
     *vrfy      = "VRFY %s\r\n",

/* AUTH mechanism types */

     *crammd5   = "CRAM-MD5",
     *login     = "LOGIN",
     *plain     = "PLAIN",

/* Common (SMTP and POP3) commands */

     *quit      = "QUIT\r\n",
     *rset      = "RSET\r\n",

/* POP3 commands */

     *user      = "USER %s\r\n",
     *pass      = "PASS %s\r\n",
     *list      = "LIST\r\n",
     *last      = "LAST\r\n",
     *retr      = "RETR %ld\r\n",
     *dele      = "DELE %ld\r\n";

struct list {
               long msgnum,
                    msgsize;
            };

int exitcode = 0;

long POP_RESP_VALUE, LAST_MSG;

char hostbuf[32] = "";
struct list *msglist = NULL;
long        maxmsg   = 0;

char *startmsg  = "\nStarting %s at %s %s",
     *tcpmsg    = "TCP connection to %s:%d %s %s",
     *swmes     = "Switching to %s mode %s";

char *error[9] =  {
                     "Oops!",
                     "Hostname is not defined",
                     "Can't resolve SMTP/POP3 host address",
                     "TCP error",
                     "Outbound mail queue directory is not specified",
                     "Inbound mail directory is not specified",
                     "$$$",
                     "POP3 server address is not specified",
                     "-Undefined-"
                  };
time_t timer;
FILE *log = NULL;

popexit(n)
int n;
  {
     char *errfrmt = "Aborted: %s, %s";
     time(&timer);
     if(verbose >= 2) fprintf(stdout,errfrmt,error[n == -1 ? 0: n],ctime(&timer));
     if(log) fprintf(log,errfrmt,error[n == -1 ? 0 : n],ctime(&timer));
     if(log) fclose(log);
     exit(n);
  }

int status;

char authstr[128];

int get_auth_data(socket)
tcp_Socket *socket;
  {
     char ch;
     int i;
     sock_tick(socket,&status);
     for (i = 0;;)
        {
                sock_wait_input(socket, sock_delay, NULL, &status);
                if(sock_read(socket, &ch, 1) <= 0) break;
                if(verbose >= 8)
                  {
                    if(isprint(ch) || isspace(ch))putc(ch,stdout);
                    else putc('.',stdout);
                  }
                if(ch == '\n') break;
                if(i < 127 && isprint(ch)) authstr[i++] = ch;
        }
     auth_data_present = 1;
 sock_err:
     authstr[i] = 0;
     return i;
  }

int smtp_resp(socket)
tcp_Socket *socket;
  {
     char buffer[8], ch, c;
     int i, smtp_stat;
     sock_tick(socket,&status);
     buffer[0] = 0;
     do
      {
       for (i = 0, c = 0, smtp_stat = 555;;)
        {
                int scanflag = 0;
                sock_wait_input(socket, sock_delay, NULL, &status);
                if(sock_read(socket, &ch, 1) <= 0) break;
                if(verbose >= 8)
                  {
                    if(isprint(ch) || isspace(ch))putc(ch,stdout);
                    else putc('.',stdout);
                  }
                if(ch == '\n') break;
                if((ch == '-' || isspace(ch)) && i < 4)
                  {
                    buffer[i++] = ch;
                    scanflag = 1;
                  }
                else if(isdigit(ch) && i < 3) buffer[i++] = ch;
                buffer[i] = 0;
                if(scanflag)
                  {
                    scanflag = 0;
                    if(sscanf(buffer,"%d%c",&smtp_stat,&c) == 2 && smtp_stat == AUTH_INIT && eauthtype == 3)
                      {
                        if(get_auth_data(socket) != 0)
                             goto auth_data;
                      }
                  }
        }
       sscanf(buffer,"%d%c",&smtp_stat,&c);
      }
     while(c == '-');
 auth_data:
 sock_err:
     return smtp_stat;
  }

int pop_resp(socket)
tcp_Socket *socket;
  {
     char buffer[32], ch;
     int i, pop_stat = 0;
     POP_RESP_VALUE = 0;
     sock_tick(socket,&status);
     for (i = 0;;)
        {
                sock_wait_input(socket, sock_delay, NULL, &status);
                if(sock_read(socket, &ch, 1) <= 0) break;
                if(verbose >= 8)
                  {
                    if(isprint(ch) || isspace(ch))putc(ch,stdout);
                    else putc('.',stdout);
                  }
                if(ch == '\n') break;
                if(i < 31) buffer[i++] = ch;
        }
     buffer[i] = '\0';
/*   if(i > 2) pop_stat = !strncmp(buffer,"+OK ", i == 3 ? 3 : 4);*/
     if(i > 2) pop_stat = !strncmp(buffer,"+OK", 3 );
     sscanf(buffer,"+OK %ld",&POP_RESP_VALUE);
 sock_err:
     return pop_stat;
  }

struct list *pop_list(socket)
tcp_Socket *socket;
  {
     char buffer[32], ch;
     int i, EOL = 1;
     struct list *msglist1;
     if(msglist) free(msglist), maxmsg = 0;
     msglist1 = msglist = malloc(sizeof(struct list));
     sock_tick(socket,&status);
     for (i = 0;;)
        {
                sock_wait_input(socket, sock_delay, NULL, &status);
                if(sock_read(socket, &ch, 1) <= 0) break;
                if(i < 31) buffer[i++] = ch;
                if(ch == '\r') continue;
                if(verbose >= 10)
                  {
                    if(isprint(ch) || isspace(ch))putc(ch,stdout);
                    else putc('.',stdout);
                  }
                if(ch == '\n')
                  {
                    if(EOL == 2) break;
                    if(!EOL) EOL++;
                    if(msglist1)
                      {
                        buffer[i] = '\0';
                        sscanf(buffer,"%ld %ld", &msglist[maxmsg].msgnum,
                                      &msglist[maxmsg].msgsize);
                        i = 0;
                        msglist1 = realloc(msglist,(maxmsg + 2)* sizeof(struct list));
                        if(msglist1)
                          {
                            msglist = msglist1;
                            maxmsg++;
                            msglist[maxmsg].msgnum  = 0;
                            msglist[maxmsg].msgsize = 0;
                          }
                      }
                  }
                else if(EOL == 1 && ch == '.') EOL ++;
                else EOL = 0;
        }
 sock_err:
     return maxmsg? msglist : NULL;
  }

void pop_msg(socket,msg,mbox)
tcp_Socket *socket;
FILE *msg;
int mbox;
  {
     char ch, *magic = "From ";
     int i, j, EOL = 0;
     sock_tick(socket,&status);
     for (i = 0, j = 0;; i++)
        {
                sock_wait_input(socket, sock_delay, NULL, &status);
                if(sock_read(socket, &ch, 1) <= 0) break;
                if(ch == '\r') continue;
                if(EOL == 1 && ch == '.') {EOL++; continue;}
                if(verbose >= 10)
                  {
                    if(isprint(ch) || isspace(ch)) putc(ch,stdout);
                    else putc('.',stdout);
                  }
                if(!mbox || i != j) putc(ch,msg);
                else
                  {
                    if(ch == magic[i])
                      {
                        if(!magic[++j]) {fprintf(msg,">%s",magic); j = 0;}
                      }
                    else
                      {
                        int k;
                        for(k=0; k<j; k++) putc(magic[k],msg);
                        putc(ch,msg);
                        j = 0;
                      }
                  }
                if(ch == '\n')
                  {
                    i = -1; j = 0;
                    if(EOL == 2) break;
                    if(!EOL) EOL++;
                  }
                else EOL = 0;
        }
 sock_err:
         ;
  }

void tcpclose(socket,status)
tcp_Socket *socket;
int *status;
     {
        if(verbose >= 4) fprintf(stdout,"Close current link\n");
        sock_close(socket);
        if(log)
          {
            timer = time(&timer);
            fprintf(log,"Actual TCP conncection closed %s",ctime(&timer));
          }
        sock_wait_closed(socket, sock_delay, NULL, status);
  sock_err:
          ;
     }

longword tcpopen(host,port,socket,status)
char *host;
int port, *status;
tcp_Socket *socket;
      {
        longword hostaddr = 0;
        if(verbose >= 4) fprintf(stdout,"Trying to open %s:%d ",host,port);
        if((hostaddr = resolve(host)) == 0)
           {
             if(verbose >= 2) fprintf(stdout,"... can't resolve %s\n",host);
             return 0;
           }
        if(verbose >= 4) fprintf(stdout,"... resolved ");
        if(!tcp_open(socket, 0, hostaddr, port, NULL))
           {
             if(verbose >= 2) fprintf(stdout,"... can't open tcp connection\n");
             return 0;
           }
        if(verbose >= 4) fprintf(stdout,"... waiting ");
        sock_wait_established(socket, sock_delay, NULL, status);
        sock_tick(socket, status);
        if(verbose >= 4) fprintf(stdout,"... established!\n");
        if(log)
          {
            timer = time(&timer);
            fprintf(log,tcpmsg,host,port,"established",ctime(&timer));
          }
        return hostaddr;
   sock_err:
        if(verbose >= 2) fprintf(stdout,"... no answer\n");
        tcpclose(socket,status);
        return 0;
      }

procarg(arg)
char *arg;
   {
         static int swstat = 0;
         char *cp;
         if(swstat)
           {
            switch(swstat) {
                   case 1: /* host */
                           host = arg;
                           if((cp = strchr(arg,':')) != NULL)
                             {
                               *cp++ = '\0';
                               sscanf(cp,"%d",&port);
                               if((cp = strchr(cp,':')) != NULL)
                                   sscanf(++cp,"%d",&pport);
                             }
                           break;
                   case 7: /* pop3 host */
                           pophost = arg;
                           if((cp = strchr(arg,':')) != NULL)
                             {
                               *cp++ = '\0';
                               sscanf(cp,"%d",&pport);
                             }
                           break;
                   case 2: /* from */
                           from0 = arg;
                           break;
                   case 3: /* domain */
                           domain = arg;
                           break;
                   case 4: /* queue */
                           qsmtp = queue = arg;
                           break;
                   case 5: /* mail */
                           mail = arg;
                           break;
                   case 9: /* iext */
                           iext = arg;
                           break;
                   case 6: /* pop3 user */
                           username = arg;
                           password = strchr(arg,':');
                           if(password) *password++ = '\0';
                           break;
                   case 10: /* esmtp user */
                           esmtpname = arg;
                           esmtpassw = strchr(arg,':');
                           if(esmtpassw) *esmtpassw++ = '\0', ESMTP = 1;
                           break;
                   case 8: sscanf(arg,"%d",&verbose);
                           }
            swstat = 0;
           }
         else if(arg[0] == '-')
           switch(arg[1]) {
                                case 'i':  swstat = 9;
                                           return;
                                case 'l':  leave = 1;
                                           return;
                                case 'h':  swstat = 1;
                                           if(direct == 1) direct = 0;
                                           return;
                                case 'D':  direct = 3;
                                           return;
                                case 'f':  swstat = 2;
                                           return;
                                case 'd':  swstat = 3;
                                           return;
                                case 'q':  swstat = 4;
                                           if(arg[2] == 'e') /*emacs*/
                                                                  qtype = 2;
                                           if(arg[2] == 'p') /*pm*/
                                                                  qtype = 1;
                                           if(arg[2] == 'u') /*uupc*/
                                                                  qtype = 0;
                                           return;
                                case 'm':  swstat = 5;
                                           return;
                                case 'p':  swstat = 6;
                                           return;

        /*------SMTP authentication options specified with 'e' switch-----*/
                                case 'e':  swstat = 10;
                                           ESMTP = 1;
                                           if(arg[2] == 'p') /*AUTH PLAIN (default)*/
                                             {eauthtype = 1;
                                              return; }
                                           if(arg[2] == 'l') /*AUTH LOGIN*/
                                             {eauthtype = 2;
                                              return; }
                                           if(arg[2] == 'c') /*AUTH CRAM-MD5*/
                                             {eauthtype = 3;
                                              return; }
                                           fprintf(stdout,"\nNo authentication method specified...\n");
                                           eauthtype = 4;    /*Try all types*/
                                           return;
                                case 'E':  ESMTP = 1;
                                           return;
                                case 'H':  swstat = 7;
                                           return;
                                case 'v':  swstat = 8;
                                           return;
                                case 'n':  new = 1;
                                           return;
                                case 'k':  kill = 1;
                                           return;
                                default:   swstat = 0;
                                           return;
                              }
         /* protocol */
         if(!strcmp(arg,"smtp") || (tmpESMTP = !strcmp(arg,"esmtp")) != 0)
                                 { smtp++;
                                   if(tmpESMTP) ESMTP = 1;
                                   if(pop3) REVERSE = 1;
                                 }
                                        else
         if(!strcmp(arg,"pop3")) smtp--,pop3++;
   }


rmlastdot(buffer)
char *buffer;
    {
      int l = strlen(buffer);
      if(l && buffer[l - 1] == '.')
              buffer[l - 1] = '\0';
    }

#define CHK_SOCK  if(status) goto sock_err; else sock_tick(&sock,&status);

main(argc,argv)
int argc;
char **argv;
  {
    struct ffblk curdta;
    char host1[128] ="",
         *cnf_buff,
         *cnf_name = NULL,
         buffer[128],
         buffer1[128],
         hostname[128] = "",
         qpath[MAXPATH];
    char *cp;
    int smtp_stat, wmark, ff, ss = 0, MODE = -1, i;
    longword hostaddr = 0;
    tcp_Socket sock;
    timer = time(&timer);
    if((cp = getenv(LOGFILE))!=NULL)
      log = fopen(cp,"a");
    tcp_config(NULL);
    tcp_cbrk(0x11);
    if(gethostname(hostname,64) && hostname[0])
        {
          /*-----moved start msg to after command line parameters and cnf
                 file processed so that verbose variable can be changed-----*/
        }
    else popexit(1);
    for(i=1; i<argc; i++)
       {
         if(!strcmp(argv[i],"-?"))
           {
              printf("Usage: fdsmtpop [-q[e|p|u] queue path][-h smtp.host[:smtpport[:pop3port]]]\\\n");
              printf("                [-H pop3.host[:pop3port]][-l][-n][-k][-v level][-m maildir]\\\n");
              printf(" [-p user:passw][-e[p,l,c] user:passw][-f from user][-d domain][smtp][pop3]\n");
              printf("\n -qe  - use FreeEmacs   \\\n");
              printf(  " -qp  - use PegasusMail - - outbound mail queue path/mask format\n");
              printf(  " -qu  - use UUPC queue  /\n");
              printf(  "            ^^^^\n");
              printf(  " -m  - path to inbound mail folder\n");
              printf(  " -h  - use specified SMTP/POP3 host (and port(s))\n");
              printf(  " -H  - use specified POP3 separate host (and port)\n");
              printf(  " -f  - from user default (for MAIL FROM:)\n");
              printf(  " -d  - domain    (for HELO)\n");
              printf(  " -p  - POP3  user:password\n");
              printf(  " -e   - ESMTP  AUTH????   user:password\n");
              printf(  " -ep  - ESMTP  AUTHPLAIN  user:password\n");
              printf(  " -el  - ESMTP  AUTHLOGIN  user:password\n");
              printf(  " -ec  - ESMTP AUTHCRAMMD5 user:password\n");
              printf(  " -i  - filename ext. for incoming mail\n");
              printf(  " -D  - Force SMTP delivering via MX hosts (not via ISP sendmail)\n");
              printf(  " -E  - Force ESMTP mode\n");
              printf(  " -l  - leave messages at server\n");
              printf(  " -n  - retrieve only new messages\n");
              printf(  " -k  - kill old messages\n");
              printf(  " -v  - verbose level (0..10, default 4)\n");
                                           exit(-1);
           }
         qsmtp = queue;
         procarg(argv[i]);
         if(argv[i][0] == '+') cnf_name = argv[i] + 1;
       }
    if(cnf_name)
      {
        FILE *cnf = fopen(cnf_name,"r");
        int sz, delta;
        char *cp1;
        if(cnf)
          {
             cnf_buff = malloc(delta = 512);
             for(cp1 = cp = cnf_buff, sz = 0; delta == 512; cp1 = realloc(cp,sz+delta))
                {
                  if(!cp1) break; cp = cp1;
                  delta = fread(cp+sz,1,delta,cnf);
                  sz += delta;
                }
             fclose(cnf);
             if(cp1)
               {
                 char *delim;
                 cp = strtok(cp1, delim = " \t\r\n\f");
                 do {
                      if(cp) procarg(cp);
                    }
                 while((cp = strtok(NULL,delim)) != NULL);
               }
             else free(cp); /* No memory to process config file */
          }
      }

    /*-------------print starting message-----------*/
    if(verbose >= 2)
           fprintf(stdout,startmsg,VERSION,hostname,ctime(&timer));
    if(log)fprintf(log,startmsg,VERSION,hostname,ctime(&timer));


    sock_init();
    if(!domain) domain = hostname;
    if(smtp && !queue) popexit(4);
    if(pop3 && !mail)  popexit(5);
    if(!pophost) pophost = host;
    if(REVERSE) smtp = 0;
    if(direct)
      {
        if(smtp) /*popexit(6)*/;
        else if(pop3 && !pophost) popexit(7);
        else popexit(-1);
      }
 SwProto:
    status = 0;
    timer = time(&timer);
    if(smtp)
      {
         if(MODE) MODE = 0;
         queue = qsmtp;
      }
    else if(pop3) MODE = 1, queue = mail, direct = 0;
    if(log) fprintf(log,swmes,MODE ? "POP3" : "SMTP",ctime(&timer));
    if((cp  = max(strrchr(queue,'\\'), strrchr(queue,'/'))) != NULL)
          {
           cp++; wmark = cp - queue;
          }
    else wmark = 0 /*= strlen(queue)*/;
    strcpy(qpath,queue);
    /*strncpy(qpath,queue,wmark);*/
    if(MODE)
      {
        /* vvv POP3 HERE vvv */
        FILE *message, *mbox = NULL;
        long maxfile=0;
    /*-------------print account name-----------*/
    if (verbose == 1)
          fprintf(stdout,"\n----%s@%s----\n",username,host);
    if (verbose >= 4)
          fprintf(stdout,"\nReceiving mail for --%s@%s--\n",username,host);
        if(strlen(qpath) > wmark )
         {
           if((mbox = fopen(qpath,"a")) == NULL)
             {
               if(errno == EACCES)
                 {  /* Not mbox but directory */
                    strcat(qpath,"/");
                    wmark = strlen(qpath);
                 }
             }
           else if(log) fprintf(log,"Receiving mail from %s to mbox %s %s",\
                                     pophost, qpath, ctime(&timer));
         }
        if((hostaddr = tcpopen(pophost,pport,&sock,&status)) == 0)
                       popexit(2);
        if(pop_resp(&sock) != POP_OK)
          {
            char *fmt = "POP3 host %s refused our call %s";
            timer = time(&timer);
            if(log) fprintf(log, fmt, pophost, ctime(&timer));
            if(verbose >= 2) fprintf(log, fmt, pophost, ctime(&timer));
            exitcode |= 16;
            goto AbortSes;
          }
        if(username)
          {
            if(verbose >= 6) fprintf(stdout,user,username);
            CHK_SOCK;
            sock_printf(&sock,user,username);
            if(pop_resp(&sock) != POP_OK)
              {
                char *fmt = "Invalid user name %s %s";
                timer = time(&timer);
                if(log) fprintf(log,fmt, username, ctime(&timer));
                if(verbose >= 2) fprintf(stdout,fmt, username, ctime(&timer));
                exitcode |= 32;
                goto AbortSes;
              }
          }
        if(password)
          {
            strcpy(buffer1,password);
            cp = buffer1; while(*cp) *cp++ = '*';
            if(verbose >= 6) fprintf(stdout,pass,buffer1);
            CHK_SOCK;
            sock_printf(&sock,pass,password);
            if(pop_resp(&sock) != POP_OK)
              {
                char *fmt = "Invalid password %s";
                timer = time(&timer);
                if(log) fprintf(log,fmt, ctime(&timer));
                if(verbose >= 2) fprintf(stdout,fmt, ctime(&timer));
                exitcode |= 32;
                goto AbortSes;
              }
          }
        if(verbose >= 6) fprintf(stdout,last);
        CHK_SOCK;
        sock_printf(&sock,last);
        if(pop_resp(&sock) != POP_OK)
          {
            char *fmt = "Can't get status of last mail session %s";
            timer = time(&timer);
            if(log) fprintf(log,fmt, ctime(&timer));
            if(verbose >= 2) fprintf(stdout,fmt, ctime(&timer));
            LAST_MSG = 0;
          }
        else LAST_MSG = POP_RESP_VALUE;
        if(verbose >= 6) fprintf(stdout,list);
        CHK_SOCK;
        sock_printf(&sock,list);
        if(pop_resp(&sock) != POP_OK)
          {
            char *fmt = "Can't get list of waiting mail %s";
            timer = time(&timer);
            if(log) fprintf(log, fmt, ctime(&timer));
            if(verbose >= 2) fprintf(stdout, fmt, ctime(&timer));
            goto AbortSes;
          }
        if(pop_list(&sock))
          {
            long i;
            if(!mbox)
              {
                qpath[wmark] = '\0';
                strcat(qpath,"lastmsg.num");
                if((message = fopen(qpath,"r"))!=NULL)
                  {
                    fscanf(message,"%ld",&maxfile);
                    fclose(message);
                  }
              }
            for(i=0; i<maxmsg; i++)
               {
                 int fd;
                 if(msglist[i].msgnum <= LAST_MSG)
                   {
                     if(kill)
                       {
                         if(verbose >= 6) fprintf(stdout,dele,msglist[i].msgnum);
                         CHK_SOCK;
                         sock_printf(&sock,dele,msglist[i].msgnum);
                         if(pop_resp(&sock) != POP_OK)
                           {
                             char *fmt = "Can't remove old message #%ld message %s";
                             timer = time(&timer);
                             if(log) fprintf(log, fmt, msglist[i].msgnum, ctime(&timer));
                             if(verbose >= 2) fprintf(stdout, fmt, msglist[i].msgnum, ctime(&timer));
                           }
                         continue;
                       }
                     if(new) continue;
                   }
                 if(!mbox)
                   {
                     do {
                           qpath[wmark] = '\0';
                           sprintf(qpath+wmark,"%08ld.%s",maxfile++,iext);
                           fd = open(qpath, O_WRONLY | O_CREAT | O_EXCL, S_IREAD | S_IWRITE);
                        }
                     while(fd == -1 && errno == EEXIST);
                     if(fd == -1)
                       {
                         char *fmt = "Can't create file %s to store incoming message, skip it %s";
           SkipIt:
                         timer = time(&timer);
                         if(log) fprintf(log, fmt, qpath, ctime(&timer));
                         if(verbose >= 2) fprintf(stdout, fmt, qpath, ctime(&timer));
                         break;
                       }
                     if((message = fdopen(fd,"w"))==NULL) goto SkipIt;
                   }
                 else message = mbox;
                 if(verbose >= 6) fprintf(stdout,retr,msglist[i].msgnum);
                 CHK_SOCK;
                 sock_printf(&sock,retr,msglist[i].msgnum);
                 if(pop_resp(&sock) != POP_OK)
                   {
                     char *fmt = "Can't retrieve incoming message %s";
                     timer = time(&timer);
                     if(log) fprintf(log, fmt, ctime(&timer));
                     if(verbose >= 2) fprintf(stdout, fmt, ctime(&timer));
                     fclose(message); if(!mbox) unlink(qpath);
                     goto AbortSes;
                   }
                 timer = time(&timer);
                 { char *fmt = "Receiving message #%ld into %s %s %s";
                   if(log) fprintf(log, fmt,msglist[i].msgnum, mbox ? "mail box": "file", qpath, ctime(&timer));
                   if(verbose == 1) fprintf(stdout, fmt,msglist[i].msgnum, mbox ? "mail box": "file", qpath, "\n");
                   if(verbose >= 4) fprintf(stdout, fmt,msglist[i].msgnum, mbox ? "mail box": "file", qpath, ctime(&timer));
                 }
                 if(mbox) fprintf(message,"From send-mail@%s %s",pophost,ctime(&timer));
                 /*                 My fantasy  ^^^^^^^^^              */
                 pop_msg(&sock,message,(mbox != NULL));
                 if(!mbox) fclose(message);
                 if(!leave)
                   {
                     if(verbose >= 6) fprintf(stdout,dele,msglist[i].msgnum);
                     CHK_SOCK;
                     sock_printf(&sock,dele,msglist[i].msgnum);
                     if(pop_resp(&sock) != POP_OK)
                       {
                         char *fmt = "Can't remove on server received message %s";
                         timer = time(&timer);
                         if(log) fprintf(log, fmt, ctime(&timer));
                         if(verbose >= 2) fprintf(stdout, fmt, ctime(&timer));
                         goto AbortSes;
                       }
                   }
               }
          }
        else
          {
            char *fmt = "No waiting mail %s";
            timer = time(&timer);
            if(log) fprintf(log, fmt, ctime(&timer));
            if(verbose == 1) fprintf(stdout, fmt, "\n");
            if(verbose >= 3) fprintf(stdout, fmt, ctime(&timer));
            goto AbortSes;
          }

        qpath[wmark] = '\0';
        strcat(qpath,"lastmsg.num");
        if(!mbox && (message = fopen(qpath,"w")) != NULL)
              {
                fprintf(message,"%ld",maxfile);
                fclose(message);
              }

        if(mbox) fclose(mbox);
        if(verbose >= 6) fprintf(stdout,quit);
        CHK_SOCK;
        sock_printf(&sock,quit);
        if(pop_resp(&sock) != POP_OK)
          {
             timer = time(&timer);
             if(log)
                  fprintf(log,"Server %s don't accept QUIT command, exiting anyway %s", pophost , ctime(&timer));
             goto AbortSes;
          }
        timer = time(&timer);
        if(log)
           fprintf(log,"POP3 session with %s finished %s", pophost , ctime(&timer));
        goto AbortSes;
        /* ^^^ POP3 HERE ^^^ */
      }
 RetryScan:
    if((ff = findfirst(queue,&curdta,NULL))==NULL)
      {
       auth_data_present = 0;
       if(direct) hostaddr = 0;
       else
       {
        if((hostaddr = tcpopen(host,port,&sock,&status)) == 0) popexit(2);
        if(smtp_resp(&sock) != SMTP_INTRO)
          {
             char *fmt = "No answer from SMTP at %s:%d %s";
             timer = time(&timer);
             if(log) fprintf(log, fmt, host, port, ctime(&timer));
             if(verbose >= 2) fprintf(stdout, fmt, host, port, ctime(&timer));
                exitcode |= 64;
             goto AbortSes;
          }
        if((tmpESMTP = ESMTP) != 0)
          {
             if(verbose >= 6) fprintf(stdout,ehlo,domain);
             CHK_SOCK;
             sock_printf(&sock,ehlo,domain);
             if(smtp_resp(&sock) != SMTP_OK)
                {
                  if(verbose >= 6) fprintf(stdout,rset);
                  CHK_SOCK;
                  sock_printf(&sock,rset);
                  if(smtp_resp(&sock) != SMTP_OK)
                    {
                     if(log)
                      fprintf(log,"Can't reset connection. ");
                      exitcode |= 64;
                      goto AbortSes;
                    }
                  tmpESMTP = ESMTP = 0;
                  goto SimpleSMTP;
                }

/*-------------cram auth procedure--------------------------------*/

             if(esmtpassw && (eauthtype == 3 || eauthtype == 4))
               {
                   if(verbose >= 6) fprintf(stdout,auth,crammd5);
                   CHK_SOCK;
                   sock_printf(&sock,auth,crammd5);
                   if(smtp_resp(&sock) == AUTH_INIT)
                     {
                       if(auth_data_present || get_auth_data(&sock))
                         {
                           char *answer = cram_md5(esmtpname, esmtpassw, authstr);
                           if(verbose >= 6) fprintf(stdout,"%s\n", answer);
                           CHK_SOCK;
                           sock_printf(&sock,"%s\n",answer);
                           if(smtp_resp(&sock) == AUTH_OK)
                             {
                               if(eauthtype == 4) eauthtype++;
                               if(log)
                                 {
                                   timer = time(&timer);
                                   fprintf(log,"CRAM ESMTP authetication is Ok %s",ctime(&timer));
                                 }
                             }
                           else
                             {
                               if(log)
                                 {
                                   timer = time(&timer);
                                   fprintf(log,"CRAM ESMTP authetication failed %s",ctime(&timer));
                                 }
                             }
                         }
                     }
               }
/*-------------login auth procedure--------------------------------*/

             if(esmtpassw && (eauthtype == 2 || eauthtype == 4))
               {
                   char inputstr[128] = {0};
                   if(verbose >= 6) fprintf(stdout,auth,login);
                   CHK_SOCK;
                   sock_printf(&sock,auth,login);
                   if(smtp_resp(&sock) == AUTH_INIT)
                     {
                       strcpy(inputstr,esmtpname);
                       encode64(inputstr, authstr);
                       if(verbose >= 6) fprintf(stdout,"%s\n", authstr);
                       CHK_SOCK;
                       sock_printf(&sock,"%s\r\n",authstr);
                       if(smtp_resp(&sock) == AUTH_INIT)
                          {
                            strcpy(inputstr,esmtpassw);
                            encode64(inputstr, authstr);
                            if(verbose >= 6) fprintf(stdout,"%s\n", authstr);
                            CHK_SOCK;
                            sock_printf(&sock,"%s\r\n",authstr);
                            if(smtp_resp(&sock) == AUTH_OK)
                                {

                                  if(eauthtype == 4) eauthtype++;
                                  if(log)
                                    {
                                      timer = time(&timer);
                                      fprintf(log,"LOGIN ESMTP authetication is Ok %s",ctime(&timer));
                                    }
                                }
                              else
                                {
                                  if(log)
                                    {
                                      timer = time(&timer);
                                      fprintf(log,"LOGIN ESMTP authetication failed %s",ctime(&timer));
                                    }
                                }
                          }
                        else
                          {
                            if(log)
                              {
                                timer = time(&timer);
                                fprintf(log,"LOGIN ESMTP authetication failed %s",ctime(&timer));
                              }
                          }
                     }
                   else
                     {
                       if(log)
                         {
                           timer = time(&timer);
                           fprintf(log,"LOGIN ESMTP authetication failed %s",ctime(&timer));
                         }
                     }
               }
/*-------------plain auth procedure--------------------------------*/

             if(esmtpassw && (eauthtype == 1 || eauthtype == 4))
               {
                   int kk;
                   char inputstr[128] = {0};
                   char *ii = inputstr;
                   *ii++ = '\0';
                   while (*esmtpname)
                     {
                       *ii++ = *esmtpname++;
                     }
                   *ii++ = '\0';
                   while (*esmtpassw)
                     {
                       *ii++ = *esmtpassw++;
                     }
                   *(ii+1) = '\0';
                   kk = ii - inputstr; /*type change?--OK to initialize
                      an interger variable as the diff between two pointers */
                   nencode64(inputstr,authstr,kk);
                   if(verbose >= 6) fprintf(stdout,"AUTH PLAIN %s\n",authstr);
                   CHK_SOCK;
                   sock_printf(&sock,"AUTH PLAIN %s\r\n",authstr);
                   if(smtp_resp(&sock) == AUTH_OK)
                      {
                        if(eauthtype == 4) eauthtype++;
                        if(log)
                          {
                            timer = time(&timer);
                            fprintf(log,"PLAIN ESMTP authetication is Ok %s",ctime(&timer));
                          }
                      }
                   else
                      {
                        if(log)
                          {
                            timer = time(&timer);
                            fprintf(log,"PLAIN ESMTP authetication failed %s",ctime(&timer));
                          }
                      }
               }

/*----------------end authentication procedures--------------------*/
          }
        else
          {
SimpleSMTP:
             if(verbose >= 6) fprintf(stdout,helo,domain);
             CHK_SOCK;
             sock_printf(&sock,helo,domain);
             if(smtp_resp(&sock) != SMTP_OK)
                {
                      exitcode |= 64;
                     if(log)
          fprintf(log,"Server %s don't accept HELO command, exiting %s", pophost , ctime(&timer));
                      goto AbortSes;
                }
          }
       }
        do {
             FILE *qfile;
             char *cp, field_buf[32];
             int resp;
             int STOP, trig, recnum = 0, destnum = 0;
             int inheader, hidden_field;
#ifdef PP
             int bcc = 0;
             int fr = 0;
#endif /*PP*/

             qpath[wmark] = '\0'; strcat(qpath,curdta.ff_name);
             if(verbose >= 4) fprintf(stdout,"Processing queue file -->%s\n",qpath);
             if(log)
               {
                 timer = time(&timer);
                 fprintf(log,"Processing outbound queue file %s %s",qpath,ctime(&timer));
               }
             host1[0] = '\0';
             if((qfile = fopen(qpath,"r"))==NULL) continue;
             if(emacs) fscanf(qfile,"%127[^\n]\n",host1);  /* skip host ? */
             if(uupc)
               {
                 if(!fscanf(qfile,"%127[^\n]\n",cp = buffer))
                     cp = NULL;
               }
             else
               {
                 if(!fscanf(qfile,pm ? "$$ %127[^\n]\n" : "%127[^\n]\n",cp = buffer))
                     cp = NULL;
                 /* PM specific procession -- really must be more accurate :-( */
                if(pm && cp) /* strip () - comments */
                  {
                    char *c = strchr(cp,'(');
                    if(c)
                      {
                        *c = '\0';
                        while(cp < c && isspace(*--c)) *c = '\0';
                      }
                  }
               }
             if(from0) cp = from0;
             if(!cp || !*cp) goto AbortSend;
             strncpy(buffer1,cp,127);
             rmlastdot(buffer1);
             if(!direct)
             {
              if(verbose >= 6) fprintf(stdout,from,buffer1);
              CHK_SOCK;
              sock_printf(&sock,from,buffer1);
              if(smtp_resp(&sock) != SMTP_OK || feof(qfile))
                {
 AbortSend:
                  fclose(qfile);
                  if(verbose >= 6) fprintf(stdout,rset);
/*                  CHK_SOCK;*/
                  if(direct)
                    {
                      if(hostaddr) tcpclose(&sock,&status);
                      hostaddr = 0;
                    }
                  else
                    {
                      sock_printf(&sock,rset);
                      if(smtp_resp(&sock) != SMTP_OK);
                    }
#ifdef PP
                  exitcode |= 64;
#endif PP
                  if(verbose >= 4)fprintf(stdout,
                  "              WARNING !!!!\n");
                  if(verbose >= 4)fprintf(stdout,
                  "Message from %s is refused by %s %s",buffer1,host,ctime(&timer));
                  if(log)
                    {
                      timer = time(&timer);
                      fprintf(log,"Message from %s is refused by %s %s",buffer1,host,ctime(&timer));
                    }
                  continue;
                }
             }
             STOP = 0; trig = 0;
#ifdef PP
             fr = 1;
#endif /*PP*/
             do {
                  if(emacs) {if (feof(qfile)) STOP = 1;}
                  if (pm)
                    {
                      if     (fscanf(qfile, "T %127[^\n]\n", cp = buffer));
                      else if(fscanf(qfile, "C %127[^\n]\n", cp = buffer));
                      else if(fscanf(qfile, "B %127[^\n]\n", cp = buffer))
                      {
#ifdef PP
                      bcc=1;
                      if(verbose >= 12) fprintf(stdout,"setting BCC flag\n");
#endif /*PP*/
                      }
                      else {
                        buffer[0] = '\0';
                        STOP = 1;
                      }
                    }
                    else if(!fscanf(qfile,"%127[^\n]\n", cp = buffer))
                     buffer[0] = '\0';

                  if(uupc) {if (!strcmp(cp,"<<NULL>>")) STOP = 1;}
/*                  else if(pm) {if (!*cp) STOP = 1;}          */
/*                  else if(emacs) {if (feof(qfile)) STOP = 1;}*/
                  if(!STOP)
                    {
                      destnum++;
                      if(direct && !trig)
                        {
                          /* Resolve MX'es */
                          longword addr;
                          struct useek *u = getmxlist(cp);
                          preference = 0;
                          trig = 1;
                          if(u) {
                                  while((addr = procmxlist(cp, u,
                                                   preference,
                                                   verbose >= 6 ? stdout :
                                                       NULL)) != NULL)
                                       {
                                        sprintf(hostbuf,"%u.%u.%u.%u",
                                             ((unsigned char*) &addr)[3],
                                             ((unsigned char*) &addr)[2],
                                             ((unsigned char*) &addr)[1],
                                             ((unsigned char*) &addr)[0]);
                          /* Open TCP connection */
                                        if((hostaddr = tcpopen(host = hostbuf,
                                                  port,&sock,&status)) == 0)
                                               continue;
                                        else break;
                                       }
                                  free(u);
                                  if(!hostaddr) goto AbortSend;
                                }
                          if(smtp_resp(&sock) != SMTP_INTRO)
                            {
                             char *fmt = "No answer from SMTP at %s:%d %s";
                             timer = time(&timer);
                             if(log) fprintf(log, fmt, host, port, ctime(&timer));
                             if(verbose >= 2) fprintf(stdout, fmt, host, port, ctime(&timer));
                               exitcode |= 64;
                             goto AbortSend;
                            }
/*---------------------------------------------------------------------*/
                          /* Establish SMTP session */
                          if((tmpESMTP = ESMTP) != 0)
                            {
                               if(verbose >= 6) fprintf(stdout,ehlo,domain);
                               CHK_SOCK;
                               sock_printf(&sock,ehlo,domain);
                               if(smtp_resp(&sock) != SMTP_OK)
                                  {
                                    if(verbose >= 6) fprintf(stdout,rset);
                                    CHK_SOCK;
                                    sock_printf(&sock,rset);
                                    if(smtp_resp(&sock) != SMTP_OK)
                                      {
                                       if(log)
                                        fprintf(log,"Can't reset connection. ");
                                        exitcode |= 64;
                                        goto AbortSes;
                                      }
                                    tmpESMTP = 0;
                                    goto SimpleSMTP1;
                                  }
                            }
                          else
                            {
                  SimpleSMTP1:
                               if(verbose >= 6) fprintf(stdout,helo,domain);
                               CHK_SOCK;
                               sock_printf(&sock,helo,domain);
                               if(smtp_resp(&sock) != SMTP_OK)
                                  {
                                        exitcode |= 64;
                                        goto AbortSes;
                                  }
                            }
/*---------------------------------------------------------------------*/
#if 0
                          if(verbose >= 6) fprintf(stdout,helo,domain);
                          CHK_SOCK;
                          sock_printf(&sock,helo,domain);
                          if(smtp_resp(&sock) != SMTP_OK)
                            {
                              exitcode |= 64;
                              goto AbortSend;
                            }
#endif
/*---------------------------------------------------------------------*/
                          /* Send From data */
                          if(verbose >= 6) fprintf(stdout,from,buffer1);
                          CHK_SOCK;
                          sock_printf(&sock,from,buffer1);
                          if(smtp_resp(&sock) != SMTP_OK || feof(qfile))
                            goto AbortSend;
                        }
                      rmlastdot(cp);
                      if(verbose >= 6) fprintf(stdout,to,cp);
                      CHK_SOCK;
                      sock_printf(&sock,to,cp);
                      if((smtp_stat = smtp_resp(&sock)) != SMTP_LOCAL   &&
                                         smtp_stat != SMTP_REMOTE1 &&
                                         smtp_stat != SMTP_REMOTE2  )
                        {
                          if(log)
                            {
                              timer = time(&timer);
                              fprintf(log,"Message from %s to %s was not accepted by host %s %s",
                                       buffer1, cp, host, ctime(&timer));
                            }
                          continue;
                        }
                      recnum++;
                    }
                }
             while(!STOP);
             if(emacs)
               {
                 fclose(qfile);
                 qpath[strlen(qpath)-3] = '\0';
                 strcat(qpath,"txt");
                 qfile = fopen(qpath,"r");
               }
             if(!recnum)
               {
                if(log)
                 fprintf(log,"No valid recipients. ");
                goto AbortSend;
               }
             if(verbose >= 6) fprintf(stdout,datastart,cp);
             CHK_SOCK;
             sock_printf(&sock,datastart,cp);
             if((resp = smtp_resp(&sock)) != SMTP_DATA && resp != SMTP_OK)
             /*                                           ^^^^^^^^^^^^^^^ */
             /* Special hint for Qmail at Weinman's luna :-()    ???      */
                {
                  if(log)
                    {
                      timer = time(&timer);
                      fprintf(log,"Host %s can't accept message data from %s %s",
                                 host, buffer1, ctime(&timer));
                    }
                  fclose(qfile);
                  if(verbose >= 6) fprintf(stdout,rset);
                  CHK_SOCK;
                  sock_printf(&sock,rset);
                  if(smtp_resp(&sock) != SMTP_OK)
                    {
                     if(log)
                      fprintf(log,"Can't reset connection. ");
                     goto AbortSend;
                    }
                  if(direct) goto AbortSend;
                  continue;
                }
             /* Here we ready to send data! */
             inheader = 1;
             while(fgets(buffer,127,qfile))
               {
                 /*---- next 3 lines add \r back into msg body----*/
                 char *iii = NULL;
                 iii = strchr(buffer,'\n');
                 if (iii) strcpy(iii,"\r\n\0");
                 hidden_field = 0;
                 if(inheader && buffer[0] == '\n')
                   {
                     inheader = 0;
                     if(verbose >= 12) fprintf(stdout,"**end of header**\n");
#ifdef PP
                     bcc=0; fr=0;
#else /*PP*/
                     if(from0)
                       {
                         if(verbose >= 10)
                           fprintf(stdout,"Sender: %s\n",from0);
                         CHK_SOCK;
                         sock_printf(&sock,"Sender: %s%s",from0,crlf);
                       }
#endif /*PP*/
                   }
#ifdef PP
                 if (fr && from0)
                   {
                     if ( strncmp (buffer,"FROM:" , 5 ))
                       {
                         strcpy (buffer,"FROM: ") ;
                         strcat (buffer,from0) ;
                         strcat (buffer,"\n") ;
                         fr = 0 ;
                       }
                   }
#else  /*PP*/
                 if(inheader)
                   {
                     char *c = strchr(buffer,':');
                     if(c)
                       {
                         *c = 0;
                         strncpy(field_buf, buffer, 31);
                         strupr(field_buf);
                         if(!strcmp(field_buf, "BCC") || !strcmp(field_buf, "RESENT-BCC"))
                           hidden_field = 1;
                         *c = ':';
                       }
                   }
#endif /*PP*/
                 if(buffer[0] == '.')
                  {
                   if(verbose >= 10) fprintf(stdout,".%s",buffer);
                   CHK_SOCK;
                   sock_printf(&sock,".%s",buffer);
                  }
                 else
                  {
                   if(!hidden_field)
                     {
                       if(verbose >= 10) fprintf(stdout,"%s",buffer);
                       CHK_SOCK;
                       sock_printf(&sock,"%s",buffer);
                     }
                  }
                 while(buffer[strlen(buffer) - 1] != '\n')
                   {
                     if(fgets(buffer,127,qfile))
                       {
                        /*---- next 2 lines add \r back into msg body----*/
                        iii = strchr(buffer,'\n');
                        if (iii) strcpy(iii,"\r\n\0");
                        if(!hidden_field)
                          {
                           if(verbose >= 10) fprintf(stdout,"%s",buffer);
                           CHK_SOCK;
                           sock_printf(&sock,"%s",buffer);
                          }
                       }
                     else break;
                   }
#ifdef PP /* Hm, but it can't work! --YS */
                  if (bcc) fscanf (qfile,"BCC: %127[^\n]\n",buffer);
#endif /*PP*/
               }
             if(verbose >= 10) fprintf(stdout,"\n.\n");
             CHK_SOCK;
             sock_printf(&sock,dataend);
             if(smtp_resp(&sock) != SMTP_OK)
               {
                 if(log)
                   {
                     timer = time(&timer);
                     fprintf(log,"Message data from %s is not accepted by %s %s",
                                  buffer1, host, ctime(&timer));
                   }
                 continue;
               }
             fclose(qfile);
             if(direct && hostaddr)
               {
                 tcpclose(&sock,&status);
                 hostaddr = 0;
               }
             timer = time(&timer);
             if(recnum == destnum)
               {
                 char *dm = "Deleting %s\n";
                 if(verbose >= 4) fprintf(stdout,dm,qpath);
                 if(log)
                  fprintf(log,"Deleting sent message %s %s",qpath,ctime(&timer));
                 unlink(qpath);
                 if(emacs)
                   {
                     qpath[strlen(qpath)-3] = '\0';
                     strcat(qpath,"wrk");
                     if(verbose >= 4) fprintf(stdout,dm,qpath);
                     unlink(qpath);
                   }
               }
             else
               {
                 char *hm = "Set mode to hidden %s\n";
                 if(verbose >= 4) fprintf(stdout,hm,qpath);
                 if(log)
                  fprintf(log,"Warning: message %s was not delivered to all recepients, change queue file mode to hidden %s",
                               qpath,ctime(&timer));
                 _chmod(qpath,1,FA_RDONLY | FA_HIDDEN);
                 if(emacs)
                   {
                     qpath[strlen(qpath)-3] = '\0';
                     strcat(qpath,"wrk");
                     if(verbose >= 4) fprintf(stdout,hm,qpath);
                     _chmod(qpath,1,FA_RDONLY | FA_HIDDEN);
                   }
               }
           }
        while (findnext(&curdta)==NULL);
        if(verbose >= 6) fprintf(stdout,quit);
        CHK_SOCK;
        sock_printf(&sock,quit);
             if(smtp_resp(&sock) != SMTP_GOODBY);
 AbortSes:
        timer = time(&timer);
        if(log)
          {
            fprintf(log,"Mail session finished %s",ctime(&timer));
          }
        if(hostaddr) tcpclose(&sock,&status);
        if(REVERSE && !smtp) {smtp = 1; pop3 = 0; goto SwProto;}
        if(!MODE && pop3) {smtp = 0; goto SwProto;}
      }
    if(ff && !ss && !MODE)
      { char c = qpath[strlen(queue) - 1];
        ss = 1;
        if(strchr(queue,'*') || strchr(queue,'?')) goto ChkMode;
        strcpy(qpath,queue);
        if(c != '\\' && c != '/') strcat(qpath,"/");
        wmark = strlen(qpath);
        strcat(queue = qpath, emacs ? "*.wrk" : "*.*");
        goto RetryScan;
      }

 ChkMode:
    if(!MODE && pop3) {smtp = 0; goto SwProto;}
    if(log) fclose(log);
    exit(exitcode);

 sock_err:

    if(status == 1) popexit(3);

    else
     {
       char *fmt = "TCP timeout. Trying to close session %s";
       timer = time(&timer);
       if(verbose >= 2) fprintf(stdout,fmt,ctime(&timer));
       if(log) fprintf(log,fmt,ctime(&timer));
       exitcode |= 8;
       if(direct) goto AbortSend;
       goto AbortSes;
     }
  }
