/*    =========================================================
 *    FreeDOS SMTP/POP3 client program vers. 0.30  (09-02-2001)
 *
 *    =       ESMTP CRAM-MD5 handshaking implementation       =
 *    =   based on code samples from RFC 1321 and RFC 2104    =
 *    =                                                       =
 *    =       derived from the RSA Data Security, Inc.        =
 *    =           MD5 Message-Digest Algorithm                =
 *
 *              by Yury Semenov (yury@zipper.paco.net)
 *    =========================================================
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <string.h>

extern unsigned char *encode64(unsigned char *in, unsigned char *out);
extern unsigned char *decode64(unsigned char *in, unsigned char *out);

extern void hmac_md5(unsigned char *text, int text_len, 
                     unsigned char *key, int key_len, 
                     unsigned char *digest);

  char buf[128];

char *cram_md5(name, password, encoded_id)
unsigned char *name, *password, *encoded_id;
{
  unsigned char id[128], digest[16], digstr[128];
  memset(id,0,128);
  memset(digest,0,16);
  memset(digstr,0,128);
  if(name && password)
    {
      char *c;
      int i, idlen = strlen((char*)decode64(encoded_id, id));
      hmac_md5(id, idlen, password, strlen((char*)password), digest);
      sprintf((char*)digstr, "%s ", name);
      c = (char*)digstr + strlen((char*)digstr);
      for (i = 0; i < 16; i++) sprintf ((char*)c + (i<<1), "%02x", digest[i]);
      return (char*)encode64(digstr, (unsigned char*)buf);
    }
  return NULL;
}

#ifdef MAIN4TESTING
main()
{
  printf("Must be : %s\n","dGltIGI5MTNhNjAyYzdlZGE3YTQ5NWI0ZTZlNzMzNGQzODkw");
  printf("Returned: %s\n", cram_md5("tim", "tanstaaftanstaaf",
         "PDE4OTYuNjk3MTcwOTUyQHBvc3RvZmZpY2UucmVzdG9uLm1jaS5uZXQ+"));
  printf("Returned: %s\n", cram_md5("theo", "*******",
         "PDE2ODkyLjk4MjYzNTk4OUBkZnctbW1wNC5lbWFpbC52ZXJpby5uZXQ+"));
}
#endif
