#
# Makefile for DJGPP
#

SOURCE = rtos.c bqueue.c strlst.c kconio.c filename.c inifile.c \
         emath.c parse.c graph.c gifsave.c net.c sio.c

CC     = gcc.exe
CFLAGS = -O2 -g -I../inc -Wall -Winline -falign-loops=2 \
         -falign-jumps=2 -falign-functions=2 -fno-strength-reduce \
         -ffast-math #-fomit-frame-pointer

OBJDIR = djgpp
OBJS   = $(addprefix $(OBJDIR)/, $(SOURCE:.c=.o))
TARGET = ../lib/librt32.a

$(OBJDIR)/%.o: %.c
	$(CC) $(CFLAGS) -o $@ -c $<

all:   $(TARGET)

$(TARGET): $(OBJS)
	ar rs $@ $?

clean::
	rm -f $(OBJS)
	@echo Cleaning done
