/*
 * modem - more advanced terminal server
 *       - allows multiple TELNETs in
 */
#include <dos.h>
#include <stdio.h>
#include <rtos.h>
#include <string.h>
#include <mem.h>
#include <telnetd.h>
#include <ftpd.h>
#include <httpd.h>
#include <smtpcli.h>
#include <process.h>
#include <inifile.h>
#include <syslog.h>

#include "webpart.h"

#define MAXHTTPD 5
#define MAXTELNETD 4


static void (*old_init)(char *name, char *value);
char *emailuserid = NULL;
DWORD oursysloghost = 0;
char *syslogname = NULL;
DWORD snmptraphost = 0;
char *snmptrapname = NULL;
#define EMAILNOTIFY "email.notify"
#define SYSLOGHOST "syslog.host"
#define SNMPHOST "snmptrap.host"
char *loginuserid = NULL;
char *loginpassword = NULL;
int inuse[ MAXTELNETD ];

/********************************************************************/
void init_vars(void)
{
    char *p;
    int i;

    p = GetIniString( "TCP.CFG", "settings", EMAILNOTIFY, "");
    if ( *p ) {
        emailuserid = p;
        cprintf("Configured email userid to %s.\r\n", emailuserid );
    } else {
        emailuserid = NULL;
        kfree( p );
        cprintf("No email userid set.\r\n");
    }

    p = GetIniString( "TCP.CFG", "settings", SYSLOGHOST, "");
    if ( *p ) {
        syslogname = p;
        cprintf("Configured syslogging to %s.\r\n", syslogname);
        oursysloghost = resolve( syslogname );
    } else {
        oursysloghost = 0;
        syslogname = NULL;
        kfree( p );
        cprintf("No syslogging configured.\r\n");
    }
    p = GetIniString( "TCP.CFG", "settings", SNMPHOST, "");
    if ( *p ) {
        snmptrapname = p;
        cprintf("Configured syslogging to %s.\r\n", snmptrapname);
        snmptraphost = resolve( snmptrapname );
    } else {
        snmptrapname = NULL;
        snmptraphost = 0;
        kfree( p );
        cprintf("No SNMP trap host configured.\r\n");
    }

    p = GetIniString( "TCP.CFG","settings","userid","");
    if ( *p ) {
        loginuserid = p;
        cprintf("Login permitted with userid: %s\r\n", loginuserid );
    } else {
        kfree( p );
        cprintf("No Web login userid specified\r\n");
    }

    p = GetIniString("TCP.CFG","settings","password","");
    if ( *p ) {
        loginpassword = p;
        cprintf("Login permitted with password: %s\r\n", loginpassword );
    } else
        kfree( p );

}

/********************************************************************/

void teld_write_string( void *t, char *s )
{
    teld_write( t, s, strlen(s) );
}
/********************************************************************/
/* telnet_server - each thread executes this
 */

void telnet_server( DWORD virtualport )
{
#define CBUFSIZ 128
    BYTE ch;
    BYTE buffer[ CBUFSIZ ];
    teld_str *t;
    int i;

    do {
        inuse[ virtualport ] = 0;
        cprintf("Listenning... TELNET #%u\r\n", virtualport);
        t = teld_listen( 0 );
        cprintf("connection arrived... TELNETD session #%u\r\n", virtualport);

        /* if syslog enabled, notify log of change */
        if ( oursysloghost )
            syslog( oursysloghost, LOG_DAEMON, LOG_ERR, "connection arrived");

        inuse[ virtualport ] = 1;
        teld_write_string( t, "DEMO TERMSERV\r\nCopyright (c) 1990, 1999 Erick Engelke\r\n");
        rt_sleep( 1000 );
        teld_write_string( t, "press any key to exit\r\n");
        i = 0;
        do {
            /* way to break out */
            if ( kbhit() ) exit( 0 );

            /* look for TELNET arriving chars */
            ch = teld_getc( t );
            if ( ch == 255 ) break;             /* end of connection */

            if ( ch != 0 ) {
                teld_write_string( t, "\r\nuser pressed a key, session ending");
                break;
            }

            rt_sleep( 1000 );
            sprintf( buffer, "%u\r\n", i++ );
            teld_write_string( t, buffer);
        } while ( 1 );
        teld_close( t );
        cprintf("Connection closed... Telnet #%u\r\n", virtualport);
        /* if syslog enabled, notify log of change */
        if ( oursysloghost )
            syslog( oursysloghost, LOG_DAEMON, LOG_ERR, "connection closed");

    } while ( 1 );
}

/********************************************************************/
/* main - setup everything then wait for a keystroke
 */
#pragma argsused

void main(int argc, char **argv )
{
    int temp;
    DWORD dummy;

    rt_init( 100 );

    cputs("TERMSERV 1.1\r\n");
    cputs("Copyright (c) 1990, 1999 Erick Engelke\r\n");

    dbug_init();
    sock_init();

    init_vars();

    kdebug = 1;

    cputs("Press any key to exit\r\n");

    rt_newthread( ftpdthread, 1,2048, 0, "ftpd" );

    for ( temp = 1 ; temp < MAXTELNETD ; ++temp ) {
        rt_newthread( &telnet_server, temp, 4096, 0, "telnet thread");
    }

    rt_newthread( collector, 1,2048, 0, "collector" );

    for ( temp = 0 ; temp < MAXHTTPD; ++temp )
        rt_newthread( httpdthread, (DWORD)&user_proc, 2048, 0, "httpd worker" );

    if ( emailuserid != NULL ) {
        cprintf("Sending Email notification to %s\r\n", emailuserid );
        smtp_client( 0, "thisbox", emailuserid, "AUTOSEND: TermServer restarted",
            "The terminal server has restarted");
    }

    /* if syslog enabled, notify log of change */
    if ( oursysloghost )
        syslog( oursysloghost, LOG_DAEMON, LOG_ERR, "termserver started");

    while ( 1 ) {
        if ( kbhit() ) break;
        rt_sleep( 250 );
    }
}

