/*
 * readkeys - demonstrates a NON-interrupt based input program
 *
 * Copyright (c) 1999 Erick Engelke
 *
 * The PC keyboard contains an Intel 8048 (or functional equivalent) which
 * debouces and does other beneficial stuff.
 *
 * We are ignoring it and just periodically scanning the data pins to see
 * what character is currently changing.
 *
 * Make is when the key is pressed, Break is when it is released.
 *
 * Notice that auto key repeat is a BIOS function, so we don't see this
 * phenomenon, though we hear it because the BIOS buffer overflows if
 * you hold down a key for a while!
 */

#include <stdio.h>
#include <mem.h>
#include <ctype.h>
#include <conio.h>
#include <dos.h>
#include <rtos.h>


void key_thread( DWORD dummy )
{
    WORD port = 0x60;
    BYTE data, prevdata, ch;

    prevdata = 0;
    do {
        data = inportb( port );

        if ( data != prevdata ) {

            /* use BIOS to translate */
            while ( kbhit())
                ch = getch();

            /* only interesting if it changed */
            cprintf("data : %x : %c : %s\r\n", data & 0x7f, ch,
                (data & 128 ) ? "break" : "make" );
            prevdata = data;
        }
        rt_sleep( 10 );
    } while ( 1 );

}

int main( int argc, char **argv )
{
    int i;

    kpreemptive = 1;
    kdebug = 0;
    rt_init( 100 );

    rt_newthread( key_thread, 1, 4096, 0, "keyboard reader" );

    /* let this program run for 10 seconds */
    rt_sleep( 10000 );
    return( 0 );
}
