/* This example show a CGI script and Cookie in use
 *
 */
#include <rtos.h>
#include <net.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <graph.h>
#include <smtpcli.h>

#include <httpd.h>
#include <strlst.h>

char *webpassword = "rosebud";


void web_password( tcp_Socket *s )
{
    html_hdr( s, "PASSWORD" );

    sock_puts( s, "<p>The password you need to enter is ");
    sock_puts( s, webpassword );
    sock_puts( s, "</p>"
                  "<form method=\"post\" action=\"login\">"
                  "PASSWORD : "
                  "<input type=\"TEXT\" name=\"Password\">"
                  "<input type=\"submit\" value=\"login\">"
                  "</form>");

    html_tail(s);
}

void web_showform( tcp_Socket *s )
{
    char buf[ 128 ];
    sprintf( buf, "<p>Free memory : %lu bytes</p>", kcorefree());
    sock_puts( s, buf );
    sock_puts( s, "<form method=\"post\" action=\"square\">"
                  "Enter a number "
                  "<input type=\"TEXT\" name=\"NUMBER\" value=\"23\">"
                  "<input type=\"submit\" value=\"Square\">"
                  "<input type=\"reset\"  value=\"Reset\">"
                  "</form>");
    sock_puts( s, "<form method=\"post\" action=\"logout\">"
                  "<input type=\"submit\" value=\"Logout\">"
                  "</form>");
    html_tail( s );
}

void web_index( tcp_Socket *s )
{
    FILE *f;
    char buf[128];

    sock_puts(s, "Content-Type: text/html\r\n");
    html_hdr( s, "Welcome");
    web_showform( s );
}

void web_ticket( tcp_Socket *s )
{
    char buffer[ 128 ];

    sprintf( buffer, "Set-Cookie: Password=%s", webpassword );
    sock_puts( s, buffer );
}


void web_login( tcp_Socket *s )
{
    stringlist *sl;
    char *p, *q;

    sl = cgi_getstrings( s );

    if ( (p = strlst_findfirst( sl, "Password", NULL, &q )) != NULL ) {
        if ( !stricmp( q, webpassword ) ) {
            /* give them a cookie with the password embedded */
            web_ticket( s );

            /* and go to the main screen */
            html_hdr(s,"Login Succeeded");
            sock_puts(s,"<p>You successfully logged in.</p>");

            web_showform( s );
        } else
            /* password failed */
            web_password( s );
    } else
        /* no password given */
        web_password( s );

    cgi_freestrings( sl );
}
/*
 * web_logout - erase the password cookie and go back to login screen
 */
void web_logout( tcp_Socket *s )
{
    sock_puts( s, "Set-Cookie: Password=" );
    web_password( s );
}
void web_result( tcp_Socket *s )
{
    stringlist *sl;
    char *p, *q;
    DWORD x = 0;
    char buf[ 128 ];



    sock_puts(s, "Content-Type: text/html\r\n");

    sl = cgi_getstrings( s );

    if ( (p = strlst_findfirst( sl, "NUMBER", NULL, &q )) != NULL )
        x = atol( q );

    cgi_freestrings( sl );

    html_hdr(s,"Simple CGI");

    sprintf( buf, "<p>%lu squared is %lu</p>", x, x*x );

    sock_puts(s, buf );

    web_showform( s );

}
/*
 * - the web server calls this proc for each web request
 * - it is called in the context of *one* of the HTTPD threads,
 *   though which is not known or important
 * - multiple threads may be in the same proc at the same time
 */
void user_proc( tcp_Socket *s, char *cmd, char *file, char *ext,
    stringlist *cookies )
{
    char *p, *q;

    if ( !strcmp( file, "/logout"))
        web_logout( s );
    else if ( !strcmp( file, "/login" ))
        web_login( s );
    else {
        /* check to see if ANY password given */
        if (( p = strlst_findfirst( cookies, "Password", NULL, &q )) != NULL ) {
            if ( !strcmp( q, webpassword )) {
                if ( !stricmp( file, "/square" )) web_result( s );
                else web_index( s );
                return;
            }
        }
        /* either no password, or an incorrect one */
        web_password( s );
    }
}

main()
{
    int i;
    kdebug = 1;
    rt_init(100);
    sock_init();            /* initialize network */

    cputs("starting...\r\n");

#define MAXHTTPD 5
    for ( i = 0 ; i < MAXHTTPD; ++i )
        rt_newthread( httpdthread, (DWORD)&user_proc, 8192, 0, "httpd worker" );
    do {
        /* nothing */
        rt_yield();
    } while ( 1 );
}

