/**************************************************************************/
/* TEST2 - count maximum number of thread switches per second             */
/*       - NORMAL rate and DEBUG rate computed separately                 */
/*       - messaging used to signal main thread at the end of each test   */
/**************************************************************************/

#include <stdio.h>
#include <rtos.h>

DWORD count1 = 0, count2 = 0;

DWORD far *sysclock = 0x46cL;
DWORD endtime;

void syncro_start(void)
{
    DWORD now;

    now = *sysclock;
    while ( now == *sysclock) ;
    endtime = *sysclock + 91L;  // 5 sec
}

void switcher1(DWORD arg)
{
    count1 = 0;
    do {
        rt_yield();
        count1++;
        if ( endtime < *sysclock ) break;
    } while ( 1 );
    ksendmessage( kmainthread, 1, 0 );
}
void switcher2(DWORD arg)
{
    count2 = 0;
    do {
        rt_yield();
        count2 ++;
        if ( endtime < *sysclock ) break;
    } while ( 1 );
    ksendmessage( kmainthread, 1, 0 );
}

int main(int argc, char **argv)
{
    int value;
    DWORD data;

    kpreemptive = 0;    /* it's zero by default, just stressing the point */
    rt_init(100);

    puts("starting...will take 5 seconds to measure NORMAL thread switch rate");
    kdebug = 0;
    syncro_start();
    rt_newthread( switcher1, 1,2048, 0, "worker" );
    rt_newthread( switcher2, 2,2048, 0, "worker" );
    kreadmessage( &value, &data );
    kreadmessage( &value, &data );
    printf("%lu switches per second\n", (count1 + count2)/ 5 );


    puts("starting...will take 5 seconds to measure DEBUG thread switch rate");
    kdebug = 1;
    syncro_start();
    rt_newthread( switcher1, 1,2048, 0, "worker" );
    rt_newthread( switcher2, 2,2048, 0, "worker" );
    kreadmessage( &value, &data );
    kreadmessage( &value, &data );
    printf("%lu switches per second\n", (count1 + count2)/ 5 );

    return( 0 );
}

