/*
 * Test15 - creates an INI file with three sections
 *        - then reads an entry from the middle section
 *        - finally demonstrates changing a value 5 times
 */

#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <rtos.h>
#include <inifile.h>

main()
{
    char *filename = "test15.ini";
    char *t;
    DWORD i, j;

    rt_init(100);

    cprintf("first we making sample config file\r\n");

    /* make 3 sections, and we will later read from middle one */
    SetIniString( filename, "top","topic", "read failed, got top" );
    SetIniString( filename, "mid","topic", "read worked, got middle" );
    SetIniString( filename, "bottom","topic", "read failed, got botom" );

    /* throw in another string to confuse things */
    SetIniString( filename, "mid","topic2", "another key in mid" );

    t = GetIniString( filename, "mid", "topic", NULL  );
    cprintf("Searching for mid, topic gets '%s'\r\n", t ? t : "<empty>");

    SetIniString( filename, "mid","topic", "write worked" );

    t = GetIniString( filename, "mid", "topic", "default" );
    cprintf("Searching for mid, topic gets '%s'\r\n", t ? t : "<empty>");

    for ( i = 0 ; i < 5 ; ++i ) {
        SetIniDWORD(filename, "mid", "count", i );
        j = GetIniDWORD(filename,"mid", "count", 0xffffffff );
        cprintf("   wrote %lu and read = %lu\r\n", i, j );
    }
}

