/**************************************************************************/
/* test1                                                                  */
/* This is an interesting demonstration showing the effect of changing    */
/* the system clock, pre-emptive operation.                               */
/*                                                                        */
/* We create thread1 and use pre-emptive tasking, because thread1 never   */
/* yields.  So the fact that the main thread EVER executes shows the      */
/* pre-emptive operation.                                                 */
/*                                                                        */
/* Normally the system uses the default PC interrupt rate, 18.2 times     */
/* per second.                                                            */
/*                                                                        */
/* Pass this program an argument of 100 to change the PC rate to 100/s    */
/* or 1000 to change the tick to 1000/s or 1 ms.                          */
/*                                                                        */
/**************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <setjmp.h>
#include <dos.h>
#include <alloc.h>
#include <mem.h>
#include <conio.h>
#include <rtos.h>

/*********************************************************/
void test(DWORD arg)
{
    int i, j;
    kwindow( 1, 1, 80, 6 );

    do {
        cprintf("in thread #1.%lu %i\n\r", arg, i);
        i++;
        /* introduce a random delay */
        for ( j = 0 ; j < rand(); ++j );
    } while ( i < 20000 );

}

/*--------------------------------------------------------------------*/

main(int argc, char **argv)
{
    int i;

    kpreemptive = 1;
    kdebug = 1;
    rt_init( 100 );
    if ( argc > 1 ) {
        i = atoi( argv[1] );
        if ( ( i > 0 ) && ( i < 1001 ))
            rt_timerfreq( i );
    }

    kwindow( 1, 6, 80, 16 );
    cputs("starting...\r\n");

    rt_newthread( test,  1,2048, 0, "worker 1" );
    rt_sleep( 100 );
    for ( i = 0 ; i < 25000 ; ++i ) {
        rt_sleep( 10 );
        cprintf("in main %i\n\r", i);
    }
}

