/*
 * eRTOS SNMP Sample #3 - a very dynamic SNMP MIB application
 *
 * see snmp_d.c, snmp_d_2.c for background
 */

#include <stdio.h>
#include <string.h>
#include <snmp.h>
#include <rtos.h>
#include <net.h>
#include <time.h>

esnmp_oid far local_oids[] =
    { { 0,{1,3,6,1,2,1,1,1,0, -1}, NULL, SNMP_DISPLAYSTR, (DWORD)"eRTOS example" },
      { 0,{1,3,6,1,2,1,1,3,0, -1}, NULL, SNMP_TIMETICKS, 1 },
      { 0,{1,3,6,1,2,1,1,4,0, -1}, NULL, SNMP_DISPLAYSTR, (DWORD)"Contact: joe" },

      /* list terminator */
      { 0,{ -1 }, NULL, 0, 0 }
      };

/* User function called before each MIB walk,                   *
 * but after optional prewalk of sample #2                      */
/* this function is called within the SNMPD's thread context    */
extern int local_override( BYTE *com, int op, SNMP_OBJECT *reply )
{
                 /* just using LEN and OID part, all other fields unused */
    static esnmp_oid testcase = { 9, { 1,3,6,1,2,1,1,1,0,-1}, NULL, 0, 0 };


    /* we can look at the incoming SNMP operation and OID and   *
     * just react if it is a particular one                     */
    if ( _snmp_compare_oid( reply, &testcase ) == 0 ) {
        if ( stricmp( com, "PUBLIC" ))
            return( SNMP_GENERROR );

        switch ( op ) {
            case SNMP_PDU_SET : return( SNMP_READONLY );
            case SNMP_PDU_GET : cputs("Message: getting sysDesc\r\n");
                                reply->Type = SNMP_OCTETSTR;
                                strcpy( reply->Syntax.BufChr, "hi there");
                                reply->SyntaxLen = strlen( reply->Syntax.BufChr );
                                return( SNMP_NOERROR );
            case SNMP_PDU_NEXT : /* this is difficult, we have to know what
                                  * MIB is next.  Let's take easy way out and
                                  * just pass this on to the static MIB table */
                                 cprintf("GETNEXT of our oid, but we'll pass\r\n");
                                 return( SNMP_NOOVERRIDE );

        }
    } else
        return( SNMP_NOOVERRIDE );

}

void main(int argc, char **argv)
{
    kdebug = 1;
    rt_init( 100 );
    sock_init();

    snmp_compile_oids( local_oids );

    /* insert our Dynamic MIB function */
    _snmp_override = local_override;

    rt_newthread( snmpthread,  1,2048, 0, "snmpd" );

    while (1) {
        rt_sleep(1000);
    }
}


