/*
 * simple UDP server - just read data and write it out to the console
 *
 */

#define LISTEN_PORT 162

/*
 * Copyright (c) 2000 Erick Engelke
 */

#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <rtos.h>
#include <net.h>
#include <ctype.h>

#define BUF_SIZ 2048

void dump(void *ptr, int len )
{
	 unsigned char *p = ptr;
	 int x, y, xy;
	 char ch;


         cprintf("\n\r%u (0x%04x) bytes\n\r", len, len );
	 for ( y = 0 ; y < len ; y+= 16 ) {
                  cprintf("\n\r%04x : ", y  );
		  for ( x = 0 ; x < 16 ; ++x ) {
				xy = x + y;
                                cprintf( xy < len ? "%02x " : "   ", p[xy] );
		  }
                  cprintf(" : ");
		  for ( x = 0 ; x < 16 ; ++x ) {
				xy = x + y;
				ch = p[ xy ];
				if ( ! isprint( ch )) ch = '*';
                                cprintf( xy < len ? "%c" : "  ", ch );
		  }
	 }
         cprintf("\n\r");
}



main(int argc, char **argv)
{
    udp_Socket *udp;
    static char buffer[ BUF_SIZ ];
    int len;

    rt_init(100);
    sock_init();

    udp = kcalloc( sizeof( udp_Socket ), 1 );

    if ( udp == NULL )
        rt_halt("out of memory");

    if (!udp_open( udp, 161, 0, 0, NULL ))
            rt_halt("unable to open SNMP server socket");

    while ( 1 ){
        if ( kbhit() ) rt_halt("user halted program");

        rt_sleep( 10 );
        tcp_tick( NULL );

        /* look for input */
        if ( (len = sock_dataready( udp )) != 0 ) {
            sock_fastread( udp, buffer, len );
            dump( buffer, len );
        }
    }
}

