/*
 * http get client
 * Copyright (c) 1999 Erick Engelke
 */


#include <stdio.h>
#include <string.h>
#include <rtos.h>
#include <net.h>
#include <strlst.h>
#include <http.h>


void display_list( stringlist *sl )
{
    void *x;
    char *p;

    p = strlst_getfirst( sl, &x, NULL );
    while ( p != NULL ) {
        cprintf("%s\r\n", p );
        p = strlst_getnext( sl, &x, NULL );
    }
    cprintf("\r\n");
}

int main( int argc, char **argv )
{
    stringlist *sl;
    rt_init( 100 );

    kdebug = 1;

    sock_init();

    if ( argc < 2 ) {
        cputs("ERROR: http_c //hostname/url\r\n");
        exit( 3 );
    }

    if ( http_get( argv[1], 0, &sl, NULL ))
        if ( sl ) display_list( sl );

    if ( sl ) strlst_freeall( sl );
    return( 0 );
}


