// ========================================================================
// Arachne WWW browser NNTP functions
// 2005 Werner Scholz
// ========================================================================
//
// Structure of commando is like cgistring         &=separator
// Get article           -  article=Message-ID
// Get grouplist         -  list=yes
// Post articles         -  post=yes
// Cgistr from Grouppage -  group=name&subject1=number1&subject2=number2
//                          &article=articlenumber1&article=articlenumber2..

# include "arachne.h"
# include "internet.h"
# include "html.h"
# include "nntp.h"

int xnntp(struct Url *url,char *commando)
{
  char newspath [90];
  char download [90];
  char sendfile [90];
  char listfile [90];
  char  article [90];

  char user[80];
  char pass[80];
  longword host;
  int status;      /* TCP stuff  */
  int MODE=FAILED;
  int SubFlag=0;  // no nntp to html
  char Group[120];
  long subject_min,subject_max,subject_got=1, x,y,z;   /* subjectprocessing */

  FILE *fopen(),*in,*out,*fout,*lst;
  char buffer[1001];  // was 513
  char *buffer_pointer,letter,*p; // *c;
  int ComString=1;     /*  0 = commando ende  */
  int Count;
  char *pcgi;
  char filename[15];
  char str[120];
  long filenumber;
  int fileflag;
  struct ffblk ffblk;          /*   findfile    */

     filenumber=time(NULL);    /*   articlefile  */
     strcpy(Group,"");

     strcpy(newspath,exepath);  strcat(newspath,"news\\");

     strcpy(download,newspath); strcat(download,"nntp.log");
     strcpy(sendfile,newspath); strcat(sendfile,"*.snd");
     strcpy(listfile,newspath); strcat(listfile,"groups.txt");

     sprintf(user,"authinfo user %s",url->user);
     sprintf(pass,"authinfo pass %s",url->password);

   if(!tcpip) return FAILED;

     out=fopen(download,"w+t");
       if(out==NULL) {outs("Cannot open downloadfile");return FAILED;}

   pcgi=commando;
   if (strlen(pcgi)<5)   // no valid nntp-command !
       {fprintf(out,"Invalid nntp-command\n");fclose(out);return FAILED;}

   free_socket();

   sprintf(str,msg_askdns,url->host);
   outs(str);

   if ((host = resolve(url->host)) == 0uL)
	 {DNSerr(url->host);fclose(out);return FAILED;}

   if (!tcp_open(socket,0,host,url->port,NULL))
	 { sprintf(str,msg_errcon,url->host);
	   outs(str);fclose(out);
	   return FAILED;
	 }

   sprintf(str,msg_con,url->host,url->port);
   outs(str);

   sock_mode(socket,TCP_MODE_ASCII);
   sock_wait_established(socket,sock_delay,NULL,&status);
   sock_wait_input(socket,sock_delay,NULL,&status);
   sock_gets(socket,(unsigned char *)buffer,sizeof(buffer));
   fprintf(out,"%s\n",buffer);
   outs(buffer);

   if(strncmp(buffer,"200",3)==0) goto NNTPserver;
   if(strncmp(buffer,"201",3)==0) goto NNTPserver;
   goto FAILURE;

NNTPserver:
 if (user[0]!=0)
  {fprintf(out,"%s\n",user);
    sprintf( str, "%s",user);
    sock_puts(socket,(unsigned char *)str);
    sock_wait_input(socket,sock_delay,NULL,&status);
    sock_gets(socket,(unsigned char *)buffer,sizeof(buffer));
    fprintf(out,"%s\n",buffer);
    outs(buffer);
   if(strncmp(buffer,"381",3)!=0) goto FAILURE;
  }

 if (pass[0]!=0)
  {fprintf(out,"%s\n",pass);
    sprintf( str, "%s",pass);
    sock_puts(socket,(unsigned char *)str);
    sock_wait_input(socket,sock_delay,NULL,&status);
    sock_gets(socket,(unsigned char *)buffer,sizeof(buffer));
    fprintf(out,"%s\n",buffer);
    outs(buffer);
   if(strncmp(buffer,"281",3)!=0) goto FAILURE;
  }

    sprintf( str, "mode reader");
    sock_puts(socket,(unsigned char *)str);
    sock_wait_input(socket,sock_delay,NULL,&status);
    sock_gets(socket,(unsigned char *)buffer,sizeof(buffer));
    fprintf(out,"%s\n",buffer);
    outs(buffer);


 // ---- TCP OK ! ------  Start cgiinput  ---------

START:
     Count=0;             // protect buffer!
     if(ComString==0) goto LOGOUT;
     buffer_pointer=buffer;
   CGI_INPUT:
     letter=*pcgi; pcgi++;Count++;
     if(Count>500) goto TEST;  // protect buffer
     if(letter == 0)   {ComString=0;goto TEST;}
     if(letter == 38)  goto TEST;    /*   &   */
     if(letter == 61)                /*   =   */
	      { *buffer_pointer=32;buffer_pointer+=1;goto CGI_INPUT;}
   /*  if(letter == 37)                -  %20 -
	      { pcgi++;pcgi++;goto CGI_INPUT;} */

     *buffer_pointer=letter;buffer_pointer+=1;
     goto CGI_INPUT;

TEST:
     *buffer_pointer=0;

     if (strncmp(buffer,"file ",5)==0)
	{fprintf(out,"File=%s\n",buffer+5);goto START; }

     if (strncmp(buffer,"group ",6)==0)
	{  MODE=GROUP;
	   fprintf(out,"%s\n",buffer);      /* important !!! don't delete */
	   if (strlen(buffer)>120) goto FAILURE;
	   if (strlen(buffer)>7) strcpy(Group,buffer+6);
	   sprintf( str, "%s", buffer);
	   sock_puts(socket,(unsigned char *)str);
	   outs(str);
	   sock_wait_input(socket,sock_delay,NULL,&status);
	   sock_gets(socket,(unsigned char *)buffer,sizeof(buffer));
	   fprintf(out,"%s\n",buffer);
	   outs(buffer);
	   if(strncmp(buffer,"411",3)==0) {goto LOGOUT;} /* no such group  */
	   if(strncmp(buffer,"211",3)!=0) goto FAILURE;
	   p=buffer;
	   if ((p=strchr(p,' '))== NULL ) goto FAILURE;
	   while (*p==' ') p++;
	   subject_min=atol(p);
	   if ((p=strchr(p,' '))== NULL ) goto FAILURE;
	   while (*p==' ') p++;
	   subject_min=atol(p);
	   if ((p=strchr(p,' '))== NULL ) goto FAILURE;
	   while (*p==' ') p++;
	   subject_max=atol(p);
	   goto START;
	 }

     if (strncmp(buffer,"subject1 ",9)==0)
	  { p=buffer;p=p+8;
	    while(*p==' ') p++;
	    subject_got=atol(p);
	    goto START;
	  }

      if (strncmp(buffer,"subject2 ",9)==0)
	 { SubFlag=1;      // process nntp to html
	   p=buffer;p=p+8;
	   while(*p==' ') p++;
	   z=atol(p);

	      if (z<=0) z=1;                     /* to avoid problems !*/
	      if (z>100) z=100;                  /* max 100 subjects  */
	      if (subject_got<=0) subject_got=1; /* to avoid problems !*/
	      if (subject_got<=subject_min) x=subject_min;
		  else  x=subject_got+1;
	      if ((subject_max-x) >= z) y=x+z ;
		  else  y=subject_max;

	      sprintf( str, "xhdr subject %ld-%ld", x,y);
	      outs(str);
	      sock_puts(socket,(unsigned char *)str);
	      sock_wait_input(socket,sock_delay,NULL,&status);
	      sock_gets(socket,(unsigned char *)buffer,sizeof(buffer));
	      fprintf(out,"%s\n",buffer);
	      outs(buffer);
	      fprintf(out,"subject %ld\n",y);
	      if(strncmp(buffer,"221",3)!=0) goto FAILURE;
	      do {sock_wait_input(socket,sock_delay,NULL,&status);
		  sock_gets(socket,(unsigned char *)buffer,sizeof(buffer));
		  fprintf(out,"%s\n",buffer);
		 }while(buffer[0]!='.'|| buffer[1] !=0);
	      goto START;
	 }


   if ((strncmp(buffer,"article ",8)==0) && (MODE!=GROUP))
		MODE=MESSAGE;  // article selected by message_ID

   if (strncmp(buffer,"article ",8)==0)
	 { if(MODE==MESSAGE)   // build <article>
	     {if(strlen(buffer)>100) goto FAILURE;
	      p=strchr(buffer,' ');
	      if(p){sprintf(str,"article <%s>",p+1);strcpy(buffer,str);}
	     }

	   filenumber++;sprintf(filename,"%ld.rec",filenumber);
	   p=filename;
	   if(strlen(filename)>12) p=p+strlen(filename)-12;
	   strcpy(article,newspath); strcat(article,p);

	   sprintf( str, "%s", buffer);
	   outs(buffer);
	   sock_puts(socket,(unsigned char *)str);
	   sock_wait_input(socket,sock_delay,NULL,&status);
	   sock_gets(socket,(unsigned char *)buffer,sizeof(buffer));
	   fprintf(out,"%s\n",buffer);
	   outs(buffer);
	   if(strncmp(buffer,"220",3)!=0)
		{if((MODE==GROUP)&&(SubFlag==1)) goto START;
		 goto FAILURE;
		}
	   fileflag=1;
	   if ((fout=fopen(article,"wt"))==NULL) fileflag=0;
	   fprintf(out,"FILE: %s\n",p);
	   if(MODE==GROUP)fprintf(fout,"Group: %s\n",Group);
	    do {sock_wait_input(socket,sock_delay,NULL,&status);
		sock_gets(socket,(unsigned char *)buffer,sizeof(buffer));
		if(fileflag==1) fprintf(fout,"%s\n",buffer);
	       }while (buffer[0]!='.'|| buffer[1] !=0);
	   fclose(fout);
	   if(MODE==MESSAGE) goto LOGOUT;
	   if((MODE==GROUP)&&(SubFlag==0)) {MODE=MESSAGE;goto LOGOUT;}
	   goto START;
	 }

   if (strncmp(buffer,"post yes",8)==0)
       { int done;
	 if (MODE!=GROUP) MODE=POST;  /* no group selected, only posting */
	 done=findfirst(sendfile,&ffblk,0);
	     if (done) goto LOGOUT;

	 while(!done)
	     {strcpy(sendfile,newspath);strcat(sendfile,ffblk.ff_name);
	       if ((in=fopen(sendfile,"r"))==NULL) goto NEXT_FILE;
		 sprintf( str, "post");
		 outs(str);
		 sock_puts(socket,(unsigned char *)str);
		 sock_wait_input(socket,sock_delay,NULL,&status);
		 sock_gets(socket,(unsigned char *)buffer,sizeof(buffer));
		 fprintf(out,"%s\n",buffer);
		 outs(buffer);
		 if(strncmp(buffer,"340",3)!=0) goto FAILURE;

		    while ((fgets(buffer,1000,in))!= NULL)
			     {if (strlen(buffer)==2)    /*  . problem  */
			      if (buffer[0]=='.') strcpy(buffer,"..\n");
			      p=buffer;p=strchr(p,'\0');p--;
			      if (*p=='\n') *p=0;
			      sock_puts(socket,(unsigned char *) buffer);
			     }
			   sock_puts(socket,(unsigned char *) "");
			   sock_puts(socket,(unsigned char *) ".");

			   sock_wait_input(socket,sock_delay,NULL,&status);
			   sock_gets(socket,(unsigned char *)buffer,sizeof(buffer));
			   fprintf(out,"%s\n",buffer);
			   outs(buffer);
			   fclose(in);
			   if(strncmp(buffer,"240",3)!=0) goto FAILURE;
			   unlink(sendfile);
		NEXT_FILE: done=findnext(&ffblk);

	       }
	   goto LOGOUT;
	 }


   if (strncmp(buffer,"list yes",8)==0)
	 {  MODE=LIST;
	    if ((lst=fopen(listfile,"w+t"))==NULL) goto FAILURE;
	      sprintf(str,"list");
	      sock_puts(socket,(unsigned char *)str);
	      sock_wait_input(socket,sock_delay,NULL,&status);
	      sock_gets(socket,(unsigned char *)buffer,sizeof(buffer));
	      fprintf(out,"%s",buffer);
	      outs(buffer);
	      if(strncmp(buffer,"215",3)!=0) goto FAILURE;
	      sprintf( str, "Download grouplist, please wait..");
	      outs(str);
	      do  { sock_wait_input(socket,sock_delay,NULL,&status);
		    sock_gets(socket,(unsigned char *)buffer,sizeof(buffer));
		    p=buffer;
			if((p=strchr(p,' '))!=NULL) *p=0;   /* no numbers */
		    fprintf(lst,"%s\n",buffer);
		  } while ( buffer[0]!='.' || buffer[1]!=0 );
	       fclose(lst);
	       goto LOGOUT;
	 }


   goto LOGOUT;  /*  no further command   */

FAILURE:  MODE=FAILED;

LOGOUT:
    sprintf( str, "QUIT");
    outs(str);
    sock_puts(socket,(unsigned char *)str);
    sock_wait_input(socket,sock_delay,NULL,&status);
    sock_gets(socket,(unsigned char *)buffer,sizeof(buffer));
    fprintf(out,"%s\n",buffer);
    outs(buffer);
    // if(strncmp(buffer,"205",3)!=0) goto error;
    sock_close(socket);    /* END TCP_CONNECTION  */
    fclose(out);fclose(lst);

   if (MODE==FAILED)  goto error;
   if (MODE==LIST)    return LIST;
   if (MODE==POST)    return POST;
   if (MODE==MESSAGE) {strcpy(GLOBAL.location,article);return MESSAGE;}
   if (MODE==GROUP)   return GROUP;

sock_err:
   sprintf(str,"sockerror = %s",sockerr(socket));
   fprintf(out,"%s\n",str);
   outs(str);
error:
   fclose(out);fclose(lst);
   return FAILED;
}


