// ========================================================================
// ArachneChat  IRC-client for arachne
// 2006 Werner Scholz
// There is (still) no DCC support.
// ========================================================================

#include "arachne.h"
#include "html.h"
#include "gui.h"
#include "customer.h"
#include "internet.h"
#include "stdio.h"

//  TCPMODE installs TCP.
//  Without TCPMODE you can run IRC offline for testing(needs hotkey) !
#define TCPMODE

//JdS Comment : Can't we use the NOTCPIP define for offline testing ... ???

// What about dx,dy in Bigmode ?  See also MessageBox !
// Using fontx() and fonty() in  -xirc()-   from SVGASTAT.C
int dx=8,dy=14;           // pixel per character

int xmin,xmax,ymin,ymax;  // Screencoordinates

// Scrollwindow
#define lenmax 60    // Characters per line

int Pointer=1;
int Scrollmin=0;    // to protect Messagewindow from scrolling !


void Lineprocess(char *p)  // Remove leading Spaces and toupper
{ int flag=0;
  char *p1,*p2;
  p1=p,p2=p;
  while(*p2==' ')p2++;
  if(*p2!='/')flag=1;
  while(*p2!=0)
   {if(flag==0)*p1=toupper(*p2);
      else *p1=*p2;
    if(*p2==' ')flag=1;
    p1++;p2++;
   }*p1=0;
}


int PrintTitle(char *Title,char *str)
{if(!xg_video_XMS) x_charmod(1);
 sprintf(Title,"ArachneChat  %s",str);
 MakeTitle(Title);
 DrawTitle(arachne.title,0);
 htmlfont(SYSFONT,0);
 x_setfill(0,user_interface.paper);
 x_setcolor(user_interface.ink);
 if(!xg_video_XMS) x_charmod(0);
 return;
}

void MessageLine(char *text)
{x_charmod(1);
 outs(text);
 htmlfont(SYSFONT,0);
 x_setfill(0,user_interface.paper);
 x_setcolor(user_interface.ink);
 x_charmod(0);
 return;
}

/*     ringing if privatchat wanted  system crashed !
void Bell()
{sound(4200);delay(100);
 sound(3000);delay(100);
 sound(4200);delay(100);
 sound(3000);delay(100);
 sound(4200);delay(100);
 }
*/

void MessageBox(int a,int b,char *text)
{int hlen,mitte;
 if(!xg_video_XMS) x_charmod(1);
  mitte=a+lenmax*4;     // to avoid division by 2 only valid for dx=14 !!
  hlen=4*strlen(text);  // to avoid division by 2 only valid for dx=14 !!
 Box3D(mitte-hlen-10,b+20,mitte+hlen+10,b+50);
 x_text_ib(mitte-hlen,b+30,(unsigned char *)text);
 htmlfont(SYSFONT,0);
 x_setfill(0,user_interface.paper);
 x_setcolor(user_interface.ink);
 if(!xg_video_XMS) x_charmod(0);
}

void ScrollWindow(int x,int y,int mode,char *ScrP,unsigned char *colP,int xlength,char *newline,int colour)
{ int len,i,j,k;
  // BlankLine of 61 Spaces
  char *Blank="                                                              ";
  int length; // 21.09.06 changed char to int, solving wordwrap problem ?
  char *xp,*p,*p1;
  unsigned char l;     // 21.09.06+ changed char to unsigned char
   if (mode==0)   // INIT WINDOW
    {for(i=1;i<=21;i++)        // sprintf(xp,"");
    {*(colP+i-1)=15;xp=ScrP+70*i-70;xp[0]=0;strncat(xp,Blank,xlength);}}
  do
   {length=xlength;
       // begin wordwrap
    if(strlen(newline)>length)
     {p=newline;p1=p+length;
      l=*p1,*p1=0;p=strrchr(p,' ');
      *p1=l;if(p)length=p-newline+1;
     } // endwordwrap
    xp=ScrP+70*Pointer-70;
    if(*newline==' ')newline++;  // Skip leading Space
    strncpy(xp,newline,length); xp[length]='\0';len=strlen(xp);
    *(colP+Pointer-1)=colour;
    if (len<xlength) strncat(xp,Blank,xlength-len);   // length -> xlength
    Pointer++; if(Pointer>21) Pointer=1;
    i=1;j=Pointer;
    while(i<=21)       // Scroll Screen
     {xp=ScrP+j*70-70; // x_setcolor(Colour[j]);
       x_setcolor(*(colP+j-1));
      if(i>=Scrollmin) x_text_ib(x,y+i*dy-dy,(unsigned char *)xp);
      i++;j++;if(j>21)j=1;
     }
    k=strlen(newline)-length;
    if(k>0) newline=newline+length;
   }while (k>0);
  return;
}

void NickNameBox(int x,int y,int mode,char *pstart,int index,int pnick,char *Nick)
{  int i,j;
   char *p1;
   if(mode==0){for(i=0;i<=49;i++) sprintf(pstart+i*15,"");*pstart=0;}
   p1=pstart+15*index-15;j=pnick-index+1;x_setcolor(15);
     for(i=1;i<=24;i++)                    //   123456789012345
       {x_text_ib(x,y+i*dy-dy,(unsigned char *)"               ");
        if(j==i)x_setcolor(11);
        if(mode==1) x_text_ib(x,y+i*dy-dy,(unsigned char *)p1);
        if(j==i)x_setcolor(15);
        p1=p1+15;
       } //  sprintf(Nick,"");
       if(mode==0) {Nick[0]=0;return;}
       p1=pstart+15*pnick-15;
       if((*p1=='@')||(*p1=='+')) p1++; //eliminate @ and +
       sprintf(Nick,"%s",p1);
   return;
}


char* GetItem(char *P,int k,char *item,int maxlen) // pointer to item k
{ char *p1,*p2;         // put item number k from string P to result
  p1=P;p2=P; item[0]=0;
  weiter:
    p2=strchr(p2,' ');k--;
    if(!p2) goto weiter2;
    if(k>0) {while(*p2==' ')p2++;p1=p2;goto weiter;}
  weiter2:
    if (k!=0) return NULL;  // Item k doesn't exist
    if(p2) *p2=0;
    if(strlen(p1)<=maxlen)sprintf(item,"%s",p1);
    if(p2) *p2=' ';
    if(strlen(p1)==0)return NULL;  // Oct 1.2006  to solve /part problem
    return p1; // p1 is pointer to Item number k
}

void parse(int *IrcCommand,char *p,char *MyNick,char *FromNick,int *ToMe,int *MessTyp)
{ char *pt,*p1,*p2,*p3;
  *IrcCommand=0;pt=p;p1=p;*ToMe=0;FromNick[0]=0;*MessTyp=0;
  if (*pt==':')
     {pt=strchr(pt,' ');
      if(!pt)return;
      *pt=0;p2=pt+1;pt=p;
      if((pt=strchr(pt,'!'))!=NULL)
        { *pt=0;if(strlen(p+1)<30)sprintf(FromNick,"%s",p+1);
          *pt=' ';p1=pt+1;}
      if(strncmp(p2,"PRIVMSG ",8)==0){*MessTyp=1;p2++;}
      if(strncmp(p2,"NOTICE ",7)==0)*MessTyp=2;
      if(*MessTyp>0)
        {p2=p2+7;p3=p2-1;        // Jump PRIVMSG and NOTICE
         if(strncmp(p2,MyNick,strlen(MyNick))==0) *ToMe=1; // message to Me ?
         p2=strchr(p2,' ');if(!p2)p2=p3;
         p2++;if(*p2==':')p2++;  // jump :
        }
      if(p!=p1) {*p='<';*pt='>';pt++;*pt=' ';p1++;}
      while(*p2!=0) {*p1=*p2;p1++,p2++;}
      *p1=*p2;
     }
  *IrcCommand=atoi(p);
  if (*IrcCommand>0)
       {pt=p;pt=strchr(pt,' ');
        if(!pt)return;
        pt++;p1=pt;
        if(*IrcCommand==20){*ToMe=1;goto nonamecheck;} // irc.uni-erlangen.de
        p3=pt;p3=strchr(p3,' ');
        if(!p3)return;
        *p3=0;
        if(strncmp(pt,MyNick,strlen(MyNick))==0) *ToMe=1; // message to Me ?
         else strcpy(MyNick,pt);
        *p3=' ';
      nonamecheck:          // Solves irc.uni-erlangen.de problem !
        pt=strchr(pt,' ');
        if(!pt) return;
        p2=pt+1;
        while(*p2!=0){*p1=*p2;p1++;p2++;}
        *p1=*p2;
       }
 return;
}

char* SkipNumber(char *p)
{ char *p1;
  int i;
  p1=p;
  for(i=1;i<4;i++)   // max 3 ciphers !
  {if((*p1<48)||(*p1>58))return p1; // jump cipher
   p1++;
  }return p1;
}

void DelControlCode(char *p)
{ char *ps,*pd,*px;    // copy  *ps to *pd
  pd=p;ps=p;px=p;
 weiter:
    if(*ps=='\0'){*pd='\0';return;}
    //  face      triangle    star
    if((*ps==2)||(*ps==31)||(*ps==15)) {ps++;goto weiter;}
    if(*ps==3)    // heart  - jump colorcode -
     {ps++;px=SkipNumber(ps);
      if(px==ps) goto weiter; // no argument
      if(*px==',')px++;
      ps=SkipNumber(px);
      goto weiter;
     }
    *pd=*ps;pd++,ps++;goto weiter;
}

int LineEditor(char *p,char laenge,char xmin,char xmax,int y,char e)
{  static char COURSOR_SPALTE;
   static char *COURSOR_LINETEXT,*SCREEN_LINETEXT;
   static char *LINETEXT_START, *LINETEXT_ENDE;
   static char LINE_XMIN , LINE_XMAX;
   char c,*POINTER;
   char txt[3];
   unsigned char key;
   int k,i;

   if(e==0)  // Init LineEditor
   {LINETEXT_START=p;SCREEN_LINETEXT=p;
    LINETEXT_ENDE=p+laenge;
    LINE_XMIN=xmin;LINE_XMAX=xmax;
    COURSOR_SPALTE=xmin;
    COURSOR_LINETEXT=p;
    goto EINGABE;
   }

        key=getch();
        if(key)
              {if (key==13) return 13;  // Send Message
               if (key==9)  return 9;   // End IRC
               if (key==8) goto ENTFERNEN;
               if (key<32) goto EINGABE;
                   //  if (key>126) goto EINGABE;
               if(COURSOR_LINETEXT>LINETEXT_ENDE) goto EINGABE;
               POINTER=LINETEXT_ENDE-1;     /*  LINETEXT_ENDE-1  */
                 while( POINTER>=COURSOR_LINETEXT )
                     { *(POINTER+1)=*POINTER;POINTER-=1;}
               *COURSOR_LINETEXT=key;
               if(COURSOR_LINETEXT==LINETEXT_ENDE) goto EINGABE;
               COURSOR_LINETEXT+=1;
               if(COURSOR_SPALTE==LINE_XMAX) SCREEN_LINETEXT+=1;
               if(COURSOR_SPALTE<LINE_XMAX) COURSOR_SPALTE+=1;
               goto EINGABE;
              }

        key=getch();
        if(key==72) return 72; // Scroll up   NickNameBox
        if(key==80) return 80; // Scroll down NickNameBox
        if(key==59) return 59; // initiate privatchat
        if(key==60) return 60; // accept privatchat
        if(key==61) return 61; // end privatchat
        if(key==77)                                      /* RECHTS */
             {if(*COURSOR_LINETEXT==0) goto EINGABE;
              if(COURSOR_SPALTE<LINE_XMAX)
              {COURSOR_SPALTE+=1;COURSOR_LINETEXT+=1;goto EINGABE;}
              if (COURSOR_LINETEXT==LINETEXT_ENDE) goto EINGABE;
              COURSOR_LINETEXT+=1;SCREEN_LINETEXT+=1;goto EINGABE;
             }
        if(key==75)                                       /* LINKS */
             {if (COURSOR_SPALTE>LINE_XMIN)
                   { COURSOR_SPALTE-=1;COURSOR_LINETEXT-=1;goto EINGABE;}
              if(COURSOR_LINETEXT==LINETEXT_START) goto EINGABE;
              COURSOR_LINETEXT-=1;SCREEN_LINETEXT-=1;goto EINGABE;
             }
        if(key==83)                                       /* ENTFERNEN */
             {POINTER=COURSOR_LINETEXT;
              if(*POINTER==0) goto EINGABE;
              while(POINTER<LINETEXT_ENDE)
                    { *POINTER=*(POINTER+1);POINTER+=1; }
              *POINTER=0;goto EINGABE;
             } goto EINGABE;

         ENTFERNEN:  /*    delete */
                if(COURSOR_LINETEXT==LINETEXT_START) goto EINGABE;
                COURSOR_LINETEXT-=1;POINTER=COURSOR_LINETEXT;
                while(POINTER<LINETEXT_ENDE)
                          { *POINTER=*(POINTER+1);POINTER+=1; }
                *POINTER=0;
                if (COURSOR_SPALTE>LINE_XMIN)
                          { COURSOR_SPALTE-=1;goto EINGABE;}
                SCREEN_LINETEXT-=1;

  EINGABE:  // --- Output LineEdit  -----
      i=LINE_XMIN;POINTER=SCREEN_LINETEXT;k=0;x_setcolor(15);
        while(i<=LINE_XMAX)
           {c=*POINTER;POINTER+=1;
            if (c==0) break;
            sprintf(txt,"%c",c);
            x_text_ib(xmin*dx+k*dx,y,(unsigned char *)txt);
            k=k+1;i=i+1;
           } sprintf(txt," ");
        while(i<=LINE_XMAX)
          { x_text_ib(xmin*dx+k*dx,y,(unsigned char *)txt);k=k+1;i=i+1;}

      // Set coursor now
       if(*COURSOR_LINETEXT==0) sprintf(txt," ");
          else sprintf(txt,"%c",*COURSOR_LINETEXT);
       x_setfill(0,BLOCK_PAPER);
       x_setcolor(BLOCK_INK);
       x_text_ib(COURSOR_SPALTE *dx,y,(unsigned char *)txt);
       x_setfill(0,user_interface.paper);
       // x_setcolor(user_interface.ink);
       x_setcolor(15);
  return 0;
 }

// ======================== IRC-MAIN =============================

#if defined TCPMODE
 int xirc(struct Url *url,char *startchannel,int logfile)
#else
 int xirc()   // Testmode without TCP using hotkey J
#endif

{ FILE *fopen(),*channels, *log;
  int i;
  char *ptr;
  int key=0;          //  Returnvalue of LineEditor
//!!JdS 2006/9/17 {
//Restructured LineText[] index underflow/overflow protection scheme ...
//  char     text1[2];  //  Never delete !!! crashprotection for LineText
//  char LineText[80];  //
//  char     text2[2];  //  Never delete !!! crashprotection for Linetext
  char ExtendedLineText[2+80+2];  //include 2 extra characters on either side
  char *LineText = &(ExtendedLineText[2]);
//!!JdS 2006/9/17 }

  int xemin,xemax,ye; // Editorparameter

  // ScrollWindow
  int xscroll,yscroll;
  typedef char ircstr[70];
  ircstr IrcLine[22];
  unsigned char Colour[22];
  char Title[80];
  char  Channel[52];  // current Channel
  char sChannel[52];  // startchannel

  int iname=1;       // Startvalue nicknamelist
  int IrcCommand;    // Number from Server

  // NickNameBox
  int xnscroll,ynscroll;
  typedef char nickname[15];  // do not change 15 !!
  nickname NickName[51];      // do not change 51 !!
  char  NICK[16];
  int   werner=1;
  int    pnick=1;
  int pnickmax=1;

  int PrivatChat=0;   // 1 indicates: privatchat is on

  int      farbe;     // colourflag
  int  MessTyp=0;     // 1=Privmsg  2=Notice
  int     ToMe=0;     // 1 indicates message to me
  char   MyNick[32];  // My nickname
  char ChatNick[32];  // Privatchatpartner
  char FromNick[32];  // Message from
  char   ReNick[32];  // Respond with privatchat to

// TCP
  char    nick[80];
  char    user[80];
  char buffer[520];

  int  startflag=1; // for startchannel
  int   ListFlag=0; // flag for channellistdownload
  int logoutflag=1; // wait untill key pressed at logout (to read scrollwndow)
  char    str[120];

  int ComList[38]={1,2,3,4,5,251,252,253,254,255,265,266,290,292,301,305,306,311,312,313,314,317,-318,319,-321,324,-328,331,332,-333,351,-366,372,-375,-376,391,-369,0};
  int dx1,dy1;

#if defined TCPMODE
  longword host;
  int status;      /* TCP stuff  */
#endif
  dx1=fontx(SYSFONT,0,' ');  // I got this 2 lines from GUIDRAW.C ,
  dy1=fonty(SYSFONT,0);      // only to check dx=8 and dy=14 !

#if defined TCPMODE
  if((dx1!=dx)||(dy1!=dy)) // Arachnechat only runs with dx=8 and dy=14 !
       return 0;           // Doesn't run in Bigfontmode
#endif

  // Screencoordinates
  xmin=0;
  xmax=x_maxx();
  ymin=p->htscrn_ytop;
  ymax=ymin+10+25*14; // x_maxy();

  // ScrollWindowcoordinates  left top
  xscroll=10;
  yscroll=ymin+10;

  // NickNameBox   left top
  xnscroll=xscroll+60*dx+10;  // werner: 13.05.2007 xnscroll=xmax-15*dx-10;
  ynscroll=ymin+10;

  // LineEditorparameter
  xemin=10;    // 10th  characterpos begin
  xemax=60;    // 60th  characterpos end
  ye=yscroll+23*dy; // ye measured in Pixels !

  Scrollmin=0;      // Full Scrollwindow

  NICK[0]=0;ReNick[0]=0;Channel[0]=0;sChannel[0]=0;
#if defined TCPMODE
  if(strlen(url->password)>15) return 0;
  if(strncmp(startchannel,"Channel=",8)==0)   // join startchannel
     sprintf(sChannel,"%s",startchannel+8);   // given by irc.htm
  if(!url->password[0])sprintf(url->password,"Chatkid");
  sprintf(nick,"NICK %s",url->password);
  if(!url->user[0])sprintf(url->user,"arachnefan");
  sprintf(user,"USER %s 0 * : %s",url->user,url->user);
  sprintf(str,"%s",url->file);ptr=str;
    // outs(str); delay(5000);
  if(strlen(str)>1)      // join startchannel given by url
    {if(str[0]=='/')ptr++;
     if((ptr[0]=='#')||(ptr[0]=='&')||(ptr[0]=='+')||(ptr[0]=='!'))
      sprintf(sChannel,"%s",ptr);
       else sprintf(sChannel,"#%s",ptr);
    }

  if(!tcpip) return 0;
  free_socket();

  sprintf(str,msg_askdns,url->host);
  outs(str);
   if ((host = resolve(url->host)) == 0uL)
        {DNSerr(url->host);return 0;}

   if (!tcp_open(socket,0,host,url->port,NULL))
        {sprintf(str,msg_errcon,url->host);outs(str);return 0;}

  sprintf(str,msg_con,url->host,url->port);
  outs(str);
   sock_mode(socket,TCP_MODE_ASCII);
   sock_wait_established(socket,sock_delay,NULL,&status);
   sock_puts(socket,(unsigned char *)nick);
   sock_puts(socket,(unsigned char *)user);
  sprintf(MyNick,"%s",url->password);
#else
  sprintf(MyNick,"Friscokid");sprintf(ReNick,"You");
  sprintf(str,"SYSFONT : dx= %d und dy=%d",dx1,dy1);
  outs(str);
#endif
  // Background for IRC
  mousex=20;mousey=20;
  Box3D(1,ymin+1,xnscroll+15*dx+10,ymax);  // Werner 13.05.2005 : Box3D(1,ymin+1,xmax-1,ymax);
  x_text_ib(xemin*dx,ye-20,(unsigned char *)"Exit IRC: Tabkey"); // werner 13.05.2007
  x_text_ib((xemin-6)*dx,ye,(unsigned char *)"MSG :");  // LINE
  PrintTitle(Title,"");   // and set video !
    // MSG-EDITOR
  Cell3D(xemin*dx-3,ye-3,xemax*dx+dx+3,ye+dy+3,user_interface.paper);
  LineText[0]=0;
  LineEditor(LineText,80,xemin,xemax,ye,0);   // Init Editor
  // ScrollWindow
  Cell3D(xscroll-3,yscroll-3,xscroll+60*dx+3,yscroll+21*dy+3,user_interface.paper);
  // NickNameBox
  Cell3D(xnscroll-3,ynscroll-3,xnscroll+15*dx+3,ynscroll+24*dy+3,user_interface.paper);
  // Init ScrollWindow
  ScrollWindow(xscroll,yscroll,0,IrcLine[1],&Colour[1],lenmax,"Hi,",12);
  // Init NickNameBox
  NickNameBox(xnscroll,ynscroll,0,NickName[1],1,1,NICK);
#if defined TCPMODE
#else
  sprintf(NickName[1],"Friscokid");
  NickNameBox(xnscroll,ynscroll,1,NickName[1],1,1,NICK);
#endif
  // PrintTitle(Title,Channel);
#if defined TCPMODE
#else
   for(i=1;i<=15;i++) // Colourtest
     ScrollWindow(xscroll,yscroll,1,IrcLine[1],&Colour[1],lenmax,"Hallo Werner,",i);
#endif
  log=NULL;
  printf(str,"Your nickname : %s",MyNick);
  MessageLine(str);
#if defined TCPMODE
  sprintf(str,"%sirc\\irc.log",exepath);
   if(logfile) log=fopen(str, "w+t");
while (tcp_tick(socket))
#else
while(key!=27)
#endif
{if (kbhit())
  {key=LineEditor(LineText,80,xemin,xemax,ye,1);
    if(key==72) // Scroll up
               {if(pnick>1){pnick--;if((pnick-werner)<0)werner--;}}
    if(key==80) // Scroll down
               {if(pnick<pnickmax){pnick++;if((pnick-werner)>23)werner++;}}
    if((key==72)||(key==80))  // scroll NickNameBox and select Nickname
          NickNameBox(xnscroll,ynscroll,1,NickName[1],werner,pnick,NICK);

    if(key==59)
      {if(PrivatChat==1) goto endkey;
       sprintf(ChatNick,"%s",NICK);
      }
    if(key==60)
      {if(PrivatChat==1) goto endkey;
       if(ReNick[0]==0) goto endkey;
       sprintf(ChatNick,"%s",ReNick);ReNick[0]=0;
      }
     if(key==61)
      {if(PrivatChat==0) goto endkey;
       PrivatChat=0;PrintTitle(Title,Channel);ReNick[0]=0;
       sprintf(str,"Privatchat end");
       MessageLine("");
       ScrollWindow(xscroll,yscroll,1,IrcLine[1],&Colour[1],lenmax,str,12);
       goto endkey;
      }

    if(key==13)   // Send message
      {Lineprocess(LineText);

        if(PrivatChat==1)
           {ScrollWindow(xscroll,yscroll,1,IrcLine[1],&Colour[1],lenmax,LineText,10);
            sprintf(str,"PRIVMSG %s :%s",ChatNick,LineText);goto send2;}

        if(strncmp(LineText,"/JOIN ",6)==0)
           {if(Channel[0]!=0)  // only 1 Channel
               {MessageBox(xscroll,yscroll,"You are already on channel !");
                goto endkey;}
            if(!GetItem(LineText,2,buffer,52))goto endkey;
            strcpy(sChannel,buffer);
            sprintf(str,"JOIN %s",buffer);goto send;
           }

        if(strncmp(LineText,"/PART",5)==0)  // Oct 1.2006 was  ,"/PART ",6)
           { ptr=GetItem(LineText,2,buffer,52);
             if(!ptr)strcpy(buffer,Channel);
             sprintf(str,"PART %s",buffer);goto send;}

        if(strncmp(LineText,"/NICK ",6)==0)
           {GetItem(LineText,2,buffer,15);  // no nicknamelength >15
            if(buffer[0]==0)goto endkey;
            sprintf(str,"NICK %s",buffer);goto send;}

        if(strncmp(LineText,"/RAW ",5)==0) // Send
           {sprintf(str,"%s",LineText+5);goto send;}

        if(strncmp(LineText,"/QUERY",6)==0) // switch to privatchat
           {ptr=GetItem(LineText,2,buffer,30);if(!ptr)goto endkey;
            sprintf(ChatNick,"%s",buffer);key=59;goto clearLineText;}

        if(strncmp(LineText,"/MSG ",5)==0) // Send to channel or nickname
           {ptr=GetItem(LineText,2,buffer,52);if(!ptr)goto endkey;
            ptr=GetItem(LineText,3,str,20);if(!ptr)goto endkey;
            sprintf(str,"PRIVMSG %s :%s",buffer,ptr);goto send;}

        if(strncmp(LineText,"/NOTICE ",8)==0) // Send to channel or nickname
           {ptr=GetItem(LineText,2,buffer,52);if(!ptr)goto endkey;
            ptr=GetItem(LineText,3,str,20);if(!ptr)goto endkey;
            sprintf(str,"NOTICE %s :%s",buffer,ptr);goto send;}

        if(strncmp(LineText,"/",1)==0) // Send command
           {sprintf(str,"%s",LineText+1);goto send;}

        if(strncmp(LineText,".",1)==0)
           {if (NICK[0]==0)
            {MessageBox(xscroll,yscroll,"No Nickname selected !");
             goto endkey;}
             sprintf(str,"PRIVMSG %s :%s",NICK,LineText+1);goto send;
           }

        if(Channel[0]==0)        // Send to current channel
           {MessageBox(xscroll,yscroll,"You have to join channel first !");
            goto endkey;}

           sprintf(str,"PRIVMSG %s :%s",Channel,LineText);
           ScrollWindow(xscroll,yscroll,1,IrcLine[1],&Colour[1],lenmax,LineText,10);
           goto send2;

       send:
            ScrollWindow(xscroll,yscroll,1,IrcLine[1],&Colour[1],lenmax,str,10);
       send2:

#if defined TCPMODE
        sock_puts(socket,(unsigned char *)str);
#endif
       Scrollmin=0; // full Scrollwindow
       if(log) fprintf(log,"ArachneChat: %s\n",str);
       startflag=0;   // in case there was no motd !
       if(strncmp(str,"QUIT",4)==0)logoutflag=0;  // don't wait at logout
      clearLineText:
       LineText[0]=0; // Clear Msg-Editor
       LineEditor(LineText,80,xemin,xemax,ye,0);
      }

    if((key==59)||(key==60))
      {PrivatChat=1;
       sprintf(str," %s",ChatNick);
       PrintTitle(Title,str);Scrollmin=0;
       sprintf(str,"Privatchat begin");
       ScrollWindow(xscroll,yscroll,1,IrcLine[1],&Colour[1],lenmax,str,12);
       MessageLine("Press F3 to end privatchat");
      }

    if (key==9)  {logoutflag=0;goto ende;} // End of IRC
  }
  endkey:

#if defined TCPMODE
  while(sock_dataready(socket))
   {sock_gets(socket,(unsigned char *)buffer,sizeof(buffer));
      // if(atoi(buffer)!=322)  do not log channellist !
       // if(log)fprintf(log,"%s\n",buffer);
    parse(&IrcCommand,buffer,MyNick,FromNick,&ToMe,&MessTyp);
    if(atoi(buffer)!=322)    // do not log channellist !
     if(log) fprintf(log,"%s\n",buffer);
       DelControlCode(buffer);  //  Delete ControlCode on Screen
  // -------------- Analyze Messages received -----------------------------
     if(strchr(buffer,''))goto endcommand; // throw away !

     if(IrcCommand==401)goto print2screen; // to avoid suppressing this
                                           // message in privatchat !
     if(strncmp(buffer,"PING ",5)==0)
        {sprintf(str,"PONG %s",buffer+5);
         sock_puts(socket,(unsigned char *)str);
         // ScrollWindow(xscroll,yscroll,1,IrcLine[1],&Colour[1],lenmax,str,10);
         goto endcommand;
        }

     if(IrcCommand==322)    // download of channellist to file
        {if(ListFlag==0)
          {ListFlag=1;Scrollmin=6;
           MessageBox(xscroll,yscroll,"Download Channellist");
           sprintf(str,"%sirc\\channels.txt",exepath);
           channels = fopen(str, "w+t");
          }
          if(channels)fprintf(channels,"%s\n",buffer+4);goto endcommand;
        }

     if (IrcCommand==323)
         {if(channels)fclose(channels);ListFlag=0;Scrollmin=0;
          ScrollWindow(xscroll,yscroll,1,IrcLine[1],&Colour[1],lenmax,"Channellist ready !",14);
          goto endcommand;
         }

     if(strcmp(FromNick,MyNick)==0)  // message from server to me
         {GetItem(buffer,2,str,15);
          if(strcmp(str,"NICK")==0)  // I have got new nickname
          {GetItem(buffer,3,str,15);sprintf(MyNick,"%s",str+1);
           sprintf(str,"New nickname: %s",MyNick);
           MessageLine(str);goto weix;}
          if(strcmp(str,"PART")==0)  // part channel
          {Channel[0]=0;if(PrivatChat==0)PrintTitle(Title,"");goto weix;}
          if(strcmp(str,"JOIN")==0)  // joined channel
          {GetItem(buffer,3,str,49);
           ptr=str;if(*ptr==':')ptr++;
           if(strncmp(ptr,sChannel,strlen(sChannel))!=0)
             {sprintf(str,"PART %s",ptr);  // unwanted channel rejected !
              if(log) fprintf(log,"ArachneChat: %s\n",str);
              sock_puts(socket,(unsigned char *)str);goto weix;
             }
           sprintf(Channel,"%s",ptr);
           if(PrivatChat==0)PrintTitle(Title,Channel);goto weix;}
         } weix:

     if(PrivatChat==1)  // we are in privatchat
         {if(ToMe==0)goto endcommand;
          if(MessTyp!=1)goto endcommand;
          if(strcmp(FromNick,ChatNick)!=0) // != send notice to FromNick
           {sprintf(str,"NOTICE %s :Please try %s later",FromNick,MyNick);
            ScrollWindow(xscroll,yscroll,1,IrcLine[1],&Colour[1],lenmax,str,11);
            sock_puts(socket,(unsigned char *)str);
            // goto endcommand;
           }
          ptr=GetItem(buffer,2,str,20);
          if(!ptr)ptr=buffer;
          ScrollWindow(xscroll,yscroll,1,IrcLine[1],&Colour[1],lenmax,ptr,11);
          goto endcommand;
         }

     if((ToMe==1)&&(MessTyp==1)) // Someone sends me message
         {sprintf(ReNick,"%s",FromNick);
          ScrollWindow(xscroll,yscroll,1,IrcLine[1],&Colour[1],lenmax,buffer,11);
          sprintf(str,"Message from %s  Press F2 to privatchat",ReNick);
          MessageLine(str);MessageBox(xscroll,yscroll,str);
          // Bell();  crashed
          goto endcommand;
         }
     /*
     if(IrcCommand==332)
        {GetItem(buffer,2,str,49);if(strcmp(str,Channel)==0)openbox=1; }
     */
     if(IrcCommand==353)  // Load NickNameBox
         {if(iname==1)    // Clear NickNameBox
            NickNameBox(xnscroll,ynscroll,0,NickName[1],1,1,NICK);
          i=4;   // start with 4th item
          while(iname<51)  // Maximal nicknames = 50 !!!
            {GetItem(buffer,i,str,30);i++;
             if(str[0]==0) break;    // end of list
             ptr=str;
             if(i==5){ptr++;if(*ptr==0) break;}  // skip :
             if(strlen(ptr)<15)      // accept only nicknames < 15
                   {sprintf(NickName[iname],"%s",ptr);iname++;}
            }werner=1;pnick=1;pnickmax=iname-1;
             if(iname>=1)
                NickNameBox(xnscroll,ynscroll,1,NickName[1],1,1,NICK);
           goto endcommand;
         }

     if(IrcCommand==366)
        {iname=1;MessageLine("begin privatchat with F1");goto endcommand;}

     if(IrcCommand==433)
        MessageBox(xscroll,yscroll,"You must change your Nickname !");

     if(IrcCommand==0)
        {GetItem(buffer,2,str,10);
         if(strcmp(str,"KICK")==0)
           {GetItem(buffer,3,str,50);
            if(strcmp(str,Channel)!=0)goto endcommand;
            GetItem(buffer,4,str,15);
            if(strcmp(str,MyNick)==0)
             {Channel[0]=0; Scrollmin=6;
              if(PrivatChat==0)PrintTitle(Title,"");
              MessageLine("You are kicked off from Channel !");
             }
           }
        }

     if((IrcCommand==376)&&(startflag==1))  // end motd command
      {if(sChannel[0]!=0)                   // startchannel set
         {sprintf(str,"JOIN %s",sChannel);
          sock_puts(socket,(unsigned char *)str);
          ScrollWindow(xscroll,yscroll,1,IrcLine[1],&Colour[1],lenmax,str,10);
          if(log) fprintf(log,"AracheChat: %s\n",str);
         }startflag=0;
      }
     if((IrcCommand>50)&&(ToMe==0))  // to jump Number 020 !
      {Scrollmin=6;
       MessageBox(xscroll,yscroll,"Your nickname has been changed !");
       sprintf(str,"New nickname : %s",MyNick);
       MessageLine(str);
      }

     print2screen:    // to enable 401 message in privatchat !

     if(IrcCommand>0)farbe=15;
        else farbe=13;

     ptr=buffer;
     if(IrcCommand>0)
       {for(i=1;i<=38;i++)
         {if(ComList[i]==IrcCommand)ptr=ptr+4; // jump IrcCommandnumber
          if(ComList[i]==-IrcCommand)goto endcommand; // throw  line away
         }
       }

      ScrollWindow(xscroll,yscroll,1,IrcLine[1],&Colour[1],lenmax,ptr,farbe);

     endcommand:  // -------------- COMMANDS  END --------------------
    }
#endif

#ifdef TCPMODE
#else
   delay(100); // to slowdown testmode
#endif
}

ende:

#if defined TCPMODE
  sock_close(socket);    /* END TCP_CONNECTION  */
#endif
  if(channels)fclose(channels);
  if(log)fclose(log);
  if(logoutflag==1)
     {sprintf(str,"Server closed connection !  Press TabKey");
      MessageLine(str);while(!kbhit());
     }
  if(!xg_video_XMS) x_charmod(1);
  return 1;
#if defined TCPMODE
 sock_err:
  sprintf(str,"sockerror = %s",sockerr(socket));
  outs(str);
error:
  sock_close(socket);
  if(!xg_video_XMS) x_charmod(1);
  // while(kbhit()); ??
  if(channels)fclose(channels);
  if(log) fclose(log);
  return 0;
#endif
}


