
// ===============================================================================
// HTML/2.0 entities (defined in <fontpath>/fontinfo.bin)
// ===============================================================================

#include "arachne.h"

unsigned char HTMLentity(char *name)
{
 if (*name=='#')
//!!JdS: 2007/02/06 & 2007/05/28 {
//Added support for both hex & decimal character entity values
 {
  int value;
  if (toupper(name[1])=='X')
   value = (int)strtol(name + 2, NULL, 16);
  else
   value = (int)strtol(name + 1, NULL, 10);
//!!glennmcc: begin Dec 29, 2004 -- 'fix' for punctuation in numeric code format
//!!glennmcc: Mar 27, 2005 -- added 8222 == "
//!!glennmcc: May 26, 2007 -- added 145 == `
//!!glennmcc: May 27, 2007 -- added 8212 == -
  if (value==146 || value==8217)
   return 39; // 39 == '
  else if (value==8216 || value==145)
   return 96; //96 == `
  else if (value==8220 || value==8221 || value==8222)
   return 34; // 34 == "
  else if (value==8211 || value==8212)
   return 45; // 45 == -
  else if(value>255)
   return 127; // 127 == 
  else
   return value;
 }
//!!glennmcc: end
//!!JdS: 2007/02/06 & 2007/05/28 }

//!!JdS: 2007/05/28 {
//Optimization & tidy-up ...
 if(!strcmpi(name,"lt"))
  return '<';
 else if(!strcmpi(name,"gt"))
  return '>';
 else if(!strcmpi(name,"amp"))
  return '&';
 else if(!strcmpi(name,"quot"))
  return '\"';
//!!glennmcc: Jan 04, 2005 -- 'bullet'
//!!glennmcc: May 26, 2007 -- lsquo & rsquo
//!!glennmcc: May 27, 2007 -- mdash and ndash
 else if(!strcmpi(name,"bul") || !strcmpi(name,"bull") || !strcmpi(name,"bullet"))
  return 127; // 127 == 
 else if(!strcmpi(name,"lsquo"))// lsquo == left single quote
  return 96; // 96 == `
 else if(!strcmpi(name,"rsquo"))// rsquo == right single quote
  return 39; // 39 == '
 else if(!strcmpi(name,"ldquo") || !strcmpi(name,"rdquo"))
  //ldquo == left double quote, rdquo == right double quote
  return 34; // 34 == "
 else if(!strcmpi(name,"mdash") || !strcmpi(name,"ndash"))
  return 45; // 45 == -
//!!glennmcc: end
//!!JdS: 2007/05/28 }
 else //------------------------- ISO Latin entities
 {
  int i=0,l=strlen(name);

  while(i<128)
  {
   if(!strncmp(finf->entity[i],name,l))
    return (unsigned char)128+i;
   i++;
  }
 }

 if (!strcmpi(name,"copy"))
  return 'c';
 else if (!strcmpi(name,"reg"))
  return 'r';
 else if (!strcmpi(name,"middot"))
//!!glennmcc: Jun 12, 2005
  return 183;
//return 127;
//!!glennmcc: end
 else if (!strcmpi(name,"sp"))
  return ' ';
 else if (!strcmpi(name,"nbsp"))
  return 160;
 else
  return name[0]; // "Aacute" -> 'A'

}

void entity2str(char *str)
{
 int i=0,j=0,l=strlen(str);
 char *ptr;

 while(i<l)
 {
//!!glennmcc: Mar 06, 2005 -- fix '&' and '&amp;' in URL bug
//http://www.cisnet.com/glennmcc/testing_&_symbol/&-amp-bug.htm
  if (str[i]=='&' && !(i<l && str[i+1]==' ') &&
      (str[i+2]==';' || str[i+3]==';' || str[i+4]==';' ||
       str[i+5]==';' || str[i+6]==';'))
//  if (str[i]=='&' && !(i<l && str[i+1]==' ')) //original line
//!!glennmcc: end
  {
   ptr=&str[++i];
   while(i<l && str[i]!=';') i++;
   str[i++]='\0';
   str[j]=HTMLentity(ptr);
   if((unsigned char)str[j]==160) //&nbsp;
    str[j]=' ';
  }
  else
   str[j]=str[i++];

  j++;
 }//loop
 str[j]='\0';
}


  /*
  if(!strcmpi(name,"reg"))
   return 174; //(R)
  else
  if(!strcmp(name,"aacute"))
   return '';
  else
  if(!strcmp(name,"Aacute"))
   return '';
  else
  if(!strcmp(name,"auml"))
   return 228;
  else
  if(!strcmp(name,"Auml"))
   return 196;
  else
  if(!strcmp(name,"Eacute"))
   return '';
  else
  if(!strcmp(name,"eacute"))
   return '';
  else
  if(!strcmp(name,"iacute"))
   return '';
  else
  if(!strcmp(name,"Iacute"))
   return '';
  else
  if(!strcmp(name,"ntilde"))
   return '';
  else
  if(!strcmp(name,"Ntilde"))
   return '';
  else
  if(!strcmp(name,"oacute"))
   return '';
  else
  if(!strcmp(name,"Oacute"))
   return '';
  else
  if(!strcmp(name,"ouml"))
   return 246;
  else
  if(!strcmp(name,"Ouml"))
   return 214;
  else
  if(!strcmp(name,"szlig"))
   return 223;
  else
  if(!strcmp(name,"uuml"))
   return 252;
  else
  if(!strcmp(name,"Uuml"))
   return 220;
  else
  if(!strcmp(name,"uacute"))
   return '';
  else
  if(!strcmp(name,"Uacute"))
   return '';
  else
  if(!strcmp(name,"uacute"))
   return '';
  else
  if(!strcmp(name,"Uacute"))
   return '';
  else
  if(!strcmp(name,"yacute"))
   return '';
  else
  if(!strcmp(name,"Yacute"))
   return '';
  */
