/*
   Arachne compiler-dependent and portability definitions

   Copyright (c) 2003-2004,2007 The Contributors to Arachne GPL Project.

   This program is free software.
   The terms of GNU General Public License v2 (or any later version,
   at your option) apply; see COPYING.TXT for details.

   History log:
   ---------------
   040725 mht      Created
   040728 mht      Null pointer optimizations
   040729 mht      CPU and FPU defines; integer types included
   070530 jds      Adapted to suit TC 3.0 (as well as BC 3.1)
   ---------------
   End history.
*/

// Handy, strict and portable integer type definitions

typedef unsigned char  byte;
typedef unsigned short word;
typedef unsigned long  dword;
typedef signed   char  int8;
typedef signed   short int16;
typedef signed   long  int32;


// Make null far pointer set/check more efficient (segmented memory models).
// The segment/selector part shouldn't be 0 in Real mode, and it cannot
// be 0 in Protected mode.

#ifdef __TURBOC__
#   define IS_NULL(p) (FP_SEG(p) == 0)
#   define NULL_P FP_SEG
#else
#   define IS_NULL(p) (p == NULL)
#   define NULL_P
#endif

// Some Borland C specific keywords should be ignored by other compilers
#ifndef __TURBOC__
#   define _fastcall
#   define _pascal
#   define _cdecl
#endif

// Let Borland C generate better code if a variable-length argument list
// is located on the stack (normal case)
#ifdef __TURBOC__
#   define VA_LIST_SS(ap) ((va_list) ((void _ss *) ap))
#else
#   define VA_LIST_SS(ap) (ap)
#endif

// Inserting the following macro disturbs BC++ 3.1 code optimizer
// and -- surprisingly, because it emits absolutely no CPU instruction --
// in some situations allows it to generate better code. This includes:
// (1) copy propagation -- the compiler sometimes tries
// to propagate the source location of a value instead of the value itself;
// (2) jump optimization -- the compiler is overzealous in removing jumps
// to jumps and produces too many inverse conditional jumps, particularly
// in compound conditions followed by a goto. [2004-07-22 mht]
#ifdef __TURBOC__
#   define __NOOP__ _AX = _AX
#else
#   define __NOOP__
#endif

