// ========================================================================
// ArachneChat  IRC-client for arachne
// 2006 Werner Scholz
// There is (still) no DCC support.
// ========================================================================

#include "arachne.h"
#include "html.h"
#include "gui.h"
#include "customer.h"
#include "internet.h"
#include "stdio.h"

//  TCPMODE installs TCP.
//  Without TCPMODE you can run IRC offline for testing(needs hotkey) !
#define TCPMODE
#define TCPLOG

// What about dx,dy in other Graphicmodes ?
int dx=8,dy=14;           // pixel per character

int xmin,xmax,ymin,ymax;  // Screencoordinates

// Scrollwindow
int lenmax=60;      // Characters per line
char *Blank;        // not the best solution !
int Pointer=1;
int Scrollmin=0;    // to protect Messagewindow from scrolling !


void Lineprocess(char *p)  // Remove leading Spaces and toupper
{ int flag=0;
  char *p1,*p2;
  p1=p,p2=p;
  while(*p2==' ')p2++;
  if(*p2!='/')flag=1;
  while(*p2!=0)
   {if(flag==0)*p1=toupper(*p2);
      else *p1=*p2;
    if(*p2==' ')flag=1;
    p1++;p2++;
   }*p1=0;
}


int PrintTitle(char *Title,char *str)
{  if(!xg_video_XMS) x_charmod(1);
   sprintf(Title,"ArachneChat  %s",str);
   MakeTitle(Title);
   DrawTitle(0);      // Draw Title manipulates Pointer startchannel  !!!
  htmlfont(SYSFONT,0);
  x_setfill(0,user_interface.paper);
  x_setcolor(user_interface.ink);
  if(!xg_video_XMS) x_charmod(0);
  return;
}


void MessageBox(int a,int b,char *text)
{int hlen,mitte;
 if(!xg_video_XMS) x_charmod(1);
  mitte=a+lenmax*4;         // to avoid division by 2 only valid for dx=14 !!
  hlen=4*strlen(text);  // to avoid division by 2 only valid for dx=14 !!
 Box3D(mitte-hlen-10,b+20,mitte+hlen+10,b+50);
 x_text_ib(mitte-hlen,b+30,(unsigned char *)text);
 htmlfont(SYSFONT,0);
 x_setfill(0,user_interface.paper);
 x_setcolor(user_interface.ink);
 if(!xg_video_XMS) x_charmod(0);
}

void ScrollWindow(int x,int y,int mode,char *ScrP,unsigned char *colP,int length,char *newline,int colour)
{ int len,i,j,k;
  char *xp;
   if (mode==0)   // INIT WINDOW
    {for(i=1;i<=21;i++)
    {*(colP+i-1)=15;xp=ScrP+70*i-70;sprintf(xp,"");strncat(xp,Blank,length);}}
  do
   {xp=ScrP+70*Pointer-70;
    strncpy(xp,newline,length); len=strlen(xp);
    *(colP+Pointer-1)=colour;
    if (len<length) strncat(xp,Blank,length-len);
    Pointer++; if(Pointer>21) Pointer=1;
    i=1;j=Pointer;
    while(i<=21)       // Scroll Screen
     {xp=ScrP+j*70-70; // x_setcolor(Colour[j]);
       x_setcolor(*(colP+j-1));
      if(i>=Scrollmin) x_text_ib(x,y+i*dy-dy,(unsigned char *)xp);
      i++;j++;if(j>21)j=1;
     }
    k=strlen(newline)-length;
    if(k>0) newline=newline+length;
   }while (k>0);
  return;
}

void NickNameBox(int x,int y,int mode,char *pstart,int index,int pnick,char *Nick)
{  int i,j;
   char *p1;
   if(mode==0){for(i=0;i<=49;i++) sprintf(pstart+i*15,"");*pstart=0;}
   p1=pstart+15*index-15;j=pnick-index+1;x_setcolor(15);
     for(i=1;i<=24;i++)                    //   123456789012345
       {x_text_ib(x,y+i*dy-dy,(unsigned char *)"               ");
	if(j==i)x_setcolor(11);
	if(mode==1) x_text_ib(x,y+i*dy-dy,(unsigned char *)p1);
	if(j==i)x_setcolor(15);
	p1=p1+15;
       }
       if(mode==0) {sprintf(Nick,"");return;}
       p1=pstart+15*pnick-15;
       if((*p1=='@')||(*p1=='+')) p1++; //eliminate @ and +
       sprintf(Nick,"%s",p1);
   return;
}


void GetItem(char *P,int k,char *result,int maxlen)
{ char *p1,*p2;             // put item number k from string P to result
  p1=P;p2=P;sprintf(result,"");  // no changes in string P !!
  weiter:
    p2=strchr(p2,' ');k--;
    if(!p2) goto weiter2;
    if(k>0) {p2++,p1=p2;goto weiter;}
  weiter2:
    if (k!=0) return;
    if(p2) *p2=0;
    if(strlen(p1)<=maxlen)sprintf(result,"%s",p1);
    if(p2) *p2=' ';
    return;
}

void parse(int *IrcCommand,char *p,char *MyNick,char *FromNick,int *ToMe)
{ char *pt,*p1,*p2;
  *IrcCommand=0;pt=p;p1=p;*ToMe=0;sprintf(FromNick,"");
  if (*pt==':')
     {pt=strchr(pt,' ');
      if(!pt)return;
      *pt=0;p2=pt+1;pt=p;
      if((pt=strchr(pt,'!'))!=NULL)
	{ *pt=0;sprintf(FromNick,"%s",p+1);
	  *pt=' ';p1=pt+1;}
      if(strncmp(p2,"PRIVMSG ",8)==0)
	{p2=p2+8;                     // Jump PRIVMSG
	 if(strncmp(p2,MyNick,strlen(MyNick))==0) *ToMe=1; // message to Me ?
	 p2=strchr(p2,' ');
	 if(p2) {p2++;if(*p2==':')p2++;}  // jump :
	}
      if((p!=p1)&&((p2-pt)>1))
	   {*p='<';*pt='>';pt++;*pt=' ';p1++;}
      while(*p2!=0) {*p1=*p2;p1++,p2++;}
      *p1=*p2;
     }
  *IrcCommand=atoi(p);
  if (*IrcCommand>0)
       {pt=p;pt=strchr(pt,' ');
	if(!pt)return;
	pt++;p1=pt;
	pt=strchr(pt,' ');
	if(!pt) return;
	p2=pt+1;
	while(*p2!=0){*p1=*p2;p1++;p2++;}
	*p1=*p2;
       }
 return;
}


int LineEditor(char *p,char laenge,char xmin,char xmax,int y,char e)
{  static char COURSOR_SPALTE;
   static char *COURSOR_LINETEXT,*SCREEN_LINETEXT;
   static char *LINETEXT_START, *LINETEXT_ENDE;
   static char LINE_XMIN , LINE_XMAX;
   char c,*POINTER;
   char txt[3];
   unsigned char key;
   int k,i;

   if(e==0)  // Init LineEditor
   {LINETEXT_START=p;SCREEN_LINETEXT=p;
    LINETEXT_ENDE=p+laenge;
    LINE_XMIN=xmin;LINE_XMAX=xmax;
    COURSOR_SPALTE=xmin;
    COURSOR_LINETEXT=p;
    goto EINGABE;
   }

	key=getch();
	if(key)
	      {  if (key==13) return 13;  // Send Message
		 if (key==9)  return 9;   // End IRC
		 if (key==8) goto ENTFERNEN;
		 if (key<32) goto EINGABE;
		   //  if (key>126) goto EINGABE;
		 if(COURSOR_LINETEXT>LINETEXT_ENDE) goto EINGABE;
		 POINTER=LINETEXT_ENDE-1;     /*  LINETEXT_ENDE-1  */
		   while( POINTER>=COURSOR_LINETEXT )
			     { *(POINTER+1)=*POINTER;POINTER-=1;}
		 *COURSOR_LINETEXT=key;
		 if(COURSOR_LINETEXT==LINETEXT_ENDE) goto EINGABE;
		 COURSOR_LINETEXT+=1;
		 if(COURSOR_SPALTE==LINE_XMAX) SCREEN_LINETEXT+=1;
		 if(COURSOR_SPALTE<LINE_XMAX) COURSOR_SPALTE+=1;
		 goto EINGABE;
	      }

	key=getch();
	if(key==72) return 72; // Scroll up   NickNameBox
	if(key==80) return 80; // Scroll down NickNameBox
	if(key==59) return 59; // initiate privatchat
	if(key==60) return 60; // accept privatchat
	if(key==61) return 61;  // end privatchat
	if(key==77)                                      /* RECHTS */
	     {  if(*COURSOR_LINETEXT==0) goto EINGABE;
		if(COURSOR_SPALTE<LINE_XMAX)
		{COURSOR_SPALTE+=1;COURSOR_LINETEXT+=1;goto EINGABE;}
		if (COURSOR_LINETEXT==LINETEXT_ENDE) goto EINGABE;
		COURSOR_LINETEXT+=1;SCREEN_LINETEXT+=1;goto EINGABE;
	     }
	if(key==75)                                       /* LINKS */
	     { if (COURSOR_SPALTE>LINE_XMIN)
		   { COURSOR_SPALTE-=1;COURSOR_LINETEXT-=1;goto EINGABE;}
	       if(COURSOR_LINETEXT==LINETEXT_START) goto EINGABE;
	       COURSOR_LINETEXT-=1;SCREEN_LINETEXT-=1;goto EINGABE;
	     }
	if(key==83)                                       /* ENTFERNEN */
	     {  POINTER=COURSOR_LINETEXT;
		if(*POINTER==0) goto EINGABE;
		while(POINTER<LINETEXT_ENDE)
		    { *POINTER=*(POINTER+1);POINTER+=1; }
		*POINTER=0;goto EINGABE;
	     } goto EINGABE;

	 ENTFERNEN:  /*    delete */
		if(COURSOR_LINETEXT==LINETEXT_START) goto EINGABE;
		COURSOR_LINETEXT-=1;POINTER=COURSOR_LINETEXT;
		while(POINTER<LINETEXT_ENDE)
			  { *POINTER=*(POINTER+1);POINTER+=1; }
		*POINTER=0;
		if (COURSOR_SPALTE>LINE_XMIN)
			  { COURSOR_SPALTE-=1;goto EINGABE;}
		SCREEN_LINETEXT-=1;

  EINGABE:  // --- Output LineEdit  -----
      i=LINE_XMIN;POINTER=SCREEN_LINETEXT;k=0;x_setcolor(15);
	while(i<=LINE_XMAX)
	  { c=*POINTER;POINTER+=1;
	    if (c==0) break;
	    sprintf(txt,"%c",c);
	    x_text_ib(xmin*dx+k*dx,y,(unsigned char *)txt);
	    k=k+1;i=i+1;
	   } sprintf(txt," ");
	while(i<=LINE_XMAX)
	  { x_text_ib(xmin*dx+k*dx,y,(unsigned char *)txt);k=k+1;i=i+1;}

      // Set coursor now
       if(*COURSOR_LINETEXT==0) sprintf(txt," ");
	  else sprintf(txt,"%c",*COURSOR_LINETEXT);
       x_setfill(0,BLOCK_PAPER);
       x_setcolor(BLOCK_INK);
       x_text_ib(COURSOR_SPALTE *dx,y,(unsigned char *)txt);
       x_setfill(0,user_interface.paper);
       // x_setcolor(user_interface.ink);
       x_setcolor(15);
  return 0;
 }

// ======================== IRC-MAIN =============================

#if defined TCPMODE
 int xirc(struct Url *url,char *startchannel)
#else
 int xirc()   // Activated without TCP using hotkey J
#endif

{ FILE *fopen(),*channels, *log ;
  int i;
  char *ptr;

  int key=0;          //  Returnvalue of LineEditor

  char text[2];       //  Never delete !!! crashprotection for LineText
  char LineText[80];  //
  char text1[2];      //  Never delete !!! crashprotection for Linetext

  int xemin,xemax,ye; // Editorparameter

  // BlankLine of 61 Spaces
  char *BlankLine="                                                              ";

  // ScrollWindow
  int xscroll,yscroll;
  typedef char ircstr[70];
  ircstr IrcLine[22];
  unsigned char Colour[22];
  char Title[80];
  char  Channel[52];  // current Channel
  char sChannel[52];  // startchannel

  int iname=1;       // Startvalue nicknamelist
  int IrcCommand;    // Number from Server

  // NickNameBoox
  int xnscroll,ynscroll;
  typedef char nickname[15];  // do not change 15 !!
  nickname NickName[51];      // do not change 15 !!
  char NICK[16];
  int werner=1;
  int pnick=1;
  int pnickmax=50;

  int PrivatChat=0;   // 1 indicates: privatchat is on

  int farbe;
  int ToMe=0;         // 1 indicates message to me
  char   MyNick[30];  // My nickname
  char ChatNick[30];  // Privatchatpartner
  char FromNick[30];  // Message from
  char   ReNick[30];  // Respond with privatchat to

// TCP
  char nick[80];
  char user[80];
  char buffer[520];

  int MboxFlag=0;
  int startflag=1; // for startchannel
  int ListFlag=0;  // flag for channellistdownload
  char str[120];   // Different use

#if defined TCPMODE
   longword host;
   int status;      /* TCP stuff  */
#endif

  // Screencoordinates
  xmin=0;
  xmax=x_maxx();
  ymin=p->htscrn_ytop;
  ymax=ymin+10+25*14; // x_maxy();

  // ScrollWindowcoordinates  left top
  xscroll=10;
  yscroll=ymin+10;

  // NickNameBox   left top
  xnscroll=xmax-15*dx-10;
  ynscroll=ymin+10;

  // LineEditorparameter
  xemin=10;    // 10th  characterpos begin
  xemax=60;    // 60th  characterpos end
  ye=yscroll+23*dy; // ye measured in Pixels !

  Blank=BlankLine;  // For ScrollWindow  bad solution !

  strcpy(NICK,"");strcpy(ReNick,"");strcpy(Channel,"");
  if(strncmp(startchannel,"Channel=",8)==0)   // join startchannel
     sprintf(sChannel,"%s",startchannel+8);   // given at irc.htm

#if defined TCPMODE
  // sprintf(str,msg_askdns,url->host);
  // outs(str);
  sprintf(nick,"NICK %s",url->password);
  sprintf(user,"USER %s 0 * : %s",url->user,url->user);
  sprintf(str,"%s",url->file);ptr=str;
  if(strlen(str)>3)                   // join startchannel
    {if(str[0]=='/')ptr++;            // given by url
     if((ptr[0]=='#')||(ptr[0]=='&')||(ptr[0]=='+')||(ptr[0]=='!'))
      sprintf(sChannel,"%s",ptr);
       else sprintf(sChannel,"#%s",ptr);
    }
  // outs("Achtung");delay(1000);
  // outs(Channel);delay(4000);

  if(!tcpip) return 0;
  free_socket();

  sprintf(str,msg_askdns,url->host);
  outs(str);
   if ((host = resolve(url->host)) == 0uL) goto error;
   if (!tcp_open(socket,0,host,url->port,NULL))
      {sprintf(str,msg_errcon,url->host);outs(str);goto error;}

  sprintf(str,msg_con,url->host,url->port);
  outs(str);
   sock_mode(socket,TCP_MODE_ASCII);
   sock_wait_established(socket,sock_delay,NULL,&status);
   sock_puts(socket,(unsigned char *)nick);
   sock_puts(socket,(unsigned char *)user);
  sprintf(MyNick,"%s",url->password);
#else
  sprintf(MyNick,"Friscokid");sprintf(ReNick,"You");
#endif
  // Background for IRC

  Box3D(1,ymin+1,xmax-1,ymax);    // ymax-25;
  x_text_ib((xemin-6)*dx,ye,(unsigned char *)"LINE:");  // LINE
  PrintTitle(Title,"");   // and set video !
    // MSG-EDITOR
  Cell3D(xemin*dx-3,ye-3,xemax*dx+dx+3,ye+dy+3,user_interface.paper);
  LineText[0]=0; // sprintf(LineText,"");
  LineEditor(LineText,80,xemin,xemax,ye,0);   // Init Editor
  // ScrollWindow
  Cell3D(xscroll-3,yscroll-3,xscroll+60*dx+3,yscroll+21*dy+3,user_interface.paper);
  // NickNameBox
  Cell3D(xnscroll-3,ynscroll-3,xnscroll+15*dx+3,ynscroll+24*dy+3,user_interface.paper);
  // Init ScrollWindow
  ScrollWindow(xscroll,yscroll,0,IrcLine[1],&Colour[1],lenmax,"Hi,",12);
  // Init NickNameBox
  NickNameBox(xnscroll,ynscroll,0,NickName[1],werner,pnick,NICK);
   // sprintf(NickName[1],"spiderman");sprintf(NickName[40],"d");  test
   // sprintf(NICK,"%s",NickName[1]);                              test
  NickNameBox(xnscroll,ynscroll,1,NickName[1],werner,pnick,NICK);
  PrintTitle(Title,Channel);

  log=NULL;
#if defined TCPLOG
  sprintf(str,"%sirc\\log.txt",exepath);
   log = fopen(str, "w+t");
    if(!log) goto ende;
#endif

#if defined TCPMODE
#else
   for(i=1;i<=15;i++) // Colourtest
     ScrollWindow(xscroll,yscroll,1,IrcLine[1],&Colour[1],lenmax,"Hallo Werner,",i);
#endif

#if defined TCPMODE
while (tcp_tick(socket))
#else
while(key!=27)
#endif
{if (kbhit())
  {key=LineEditor(LineText,80,xemin,xemax,ye,1);
    if(key==72) // Scroll up
	       {if(pnick>1){pnick--;if((pnick-werner)<0)werner--;}}
    if(key==80) // Scroll down
	       {if(pnick<pnickmax){pnick++;if((pnick-werner)>23)werner++;}}
    if((key==72)||(key==80))  // NickNameBox and select Nickname
	  NickNameBox(xnscroll,ynscroll,1,NickName[1],werner,pnick,NICK);

    if(key==59)
      {if(PrivatChat==1) goto endkey;
       sprintf(ChatNick,"%s",NICK);
      }
    if(key==60)
      {if(PrivatChat==1) goto endkey;
       if(ReNick[0]==0) goto endkey;
       sprintf(ChatNick,"%s",ReNick);sprintf(ReNick,"");
      }
    if((key==59)||(key==60))
      {PrivatChat=1;
       sprintf(str,": %s",ChatNick);
       PrintTitle(Title,str);Scrollmin=0;
	 //	 123456789012345678901234567890123456789012345678901234567890
    sprintf(str,"---- start privatchat ------ press F3 to end privatchat ----");
       ScrollWindow(xscroll,yscroll,1,IrcLine[1],&Colour[1],lenmax,str,13);
       goto endkey;
      }
    if(key==61)
      {PrivatChat=0;PrintTitle(Title,Channel);sprintf(ReNick,"");
	  //     123456789012345678901234567890123456789012345678901234567890
    sprintf(str,"---------------------- end privatchat ----------------------");
       ScrollWindow(xscroll,yscroll,1,IrcLine[1],&Colour[1],lenmax,str,13);
       goto endkey;
      }

    if(key==13)   // Send message
      { Lineprocess(LineText);
       if(PrivatChat==1)
	   {ScrollWindow(xscroll,yscroll,1,IrcLine[1],&Colour[1],lenmax,LineText,12);
	    sprintf(str,"PRIVMSG %s :%s",ChatNick,LineText);goto send;
	   }

	if(strncmp(LineText,"/MSG ",5)==0) // Send to channel or nickname
	   {sprintf(str,"PRIVMSG %s",LineText+5);goto send;}

	if(strncmp(LineText,"/",1)==0) // Send command
	   {sprintf(str,"%s",LineText+1);goto send;}

	if(strncmp(LineText,",",1)==0)
	   {if (NICK[0]==0)
	    {MessageBox(xscroll,yscroll,"No Nickname selected !");
	     goto endkey;
	    }
	     sprintf(str,"PRIVMSG %s :%s",NICK,LineText+1);goto send;
	   }

	if(Channel[0]==0)        // Send to current channel
	   {MessageBox(xscroll,yscroll,"You have to join channel first !");
	    goto endkey;
	   }
	   sprintf(str,"PRIVMSG %s :%s",Channel,LineText);

       send:
       if((strncmp(str,"JOIN ",5)==0)&&(Channel[0]!=0)) // only 1 Channel
	  {MessageBox(xscroll,yscroll,"You are already on channel !");
	   goto endkey;
	  }
       ScrollWindow(xscroll,yscroll,1,IrcLine[1],&Colour[1],lenmax,str,14);
       send2:
#if defined TCPMODE
       sock_puts(socket,(unsigned char *)str);
#endif
       if(log) fprintf(log,"ARACHNE: %s\n",str);
       startflag=0;   // in case not motd
       LineText[0]=0; // sprintf(LineText,"");  Clear Msg-Editor
       LineEditor(LineText,80,xemin,xemax,ye,0);
      }
    if (key==9)  goto ende; // End of IRC
  }
  endkey:
#if defined TCPMODE
  while(sock_dataready(socket))
   {sock_gets(socket,(unsigned char *)buffer,sizeof(buffer));
     if(log) fprintf(log,"%s\n",buffer);
    parse(&IrcCommand,buffer,MyNick,FromNick,&ToMe);
     if(log) fprintf(log,"%s\n",buffer);
     // ------------------- COMMANDS -------------------------------
     if(IrcCommand==376)       // Test for startchannelproblem
      ScrollWindow(xscroll,yscroll,1,IrcLine[1],&Colour[1],lenmax,sChannel,14);

     if((IrcCommand==376)&&(startflag==1))        //   end motd command
      {if(sChannel[0]!=0)  //   and join startchannel
	 {sprintf(str,"JOIN %s",sChannel);
	  sock_puts(socket,(unsigned char *)str);
	  ScrollWindow(xscroll,yscroll,1,IrcLine[1],&Colour[1],lenmax,str,14);
	 }startflag=0;
      }

     if(IrcCommand==322)    // download of channellist to file
	{if(ListFlag==0)
	  {ListFlag=1;Scrollmin=6;
	   MessageBox(xscroll,yscroll,"Download Channellist");
	   sprintf(str,"%sirc\\channels.txt",exepath);
	   channels = fopen(str, "w+t");
	  }
	  if(channels)fprintf(channels,"%s\n",buffer+4);goto endcommand;
	}

     if (IrcCommand==323)
	 {if(channels)fclose(channels);ListFlag=0;Scrollmin=0;
	  ScrollWindow(xscroll,yscroll,1,IrcLine[1],&Colour[1],lenmax,"Channellist ready !",14);
	  goto endcommand;
	 }

     if(strcmp(FromNick,MyNick)==0)
	 {GetItem(buffer,2,str,15);
	  if(strcmp(str,"NICK")==0)
	  {GetItem(buffer,3,str,15);sprintf(MyNick,"%s",str+1);goto weix;}
	  if(strcmp(str,"PART")==0)
	  {sprintf(Channel,"");if(PrivatChat==0)PrintTitle(Title,"");goto weix;}
	  if(strcmp(str,"JOIN")==0)
	  {GetItem(buffer,3,Channel,46);
	   if(PrivatChat==0)PrintTitle(Title,Channel);goto weix;}
	 } weix:

     if(PrivatChat==1)  // we are in privatchat
	 {if(ToMe==0)goto endcommand;
	  if(strcmp(FromNick,ChatNick)!=0) // send notice to FromNick
	   {sprintf(str,"NOTICE %s :Please try later %s",FromNick,MyNick);
	    ScrollWindow(xscroll,yscroll,1,IrcLine[1],&Colour[1],lenmax,str,11);
	    // sock_puts(socket,(unsigned char *)str);
	    goto endcommand;
	   }
	  ptr=buffer;ptr=strchr(ptr,' ');  // jump nickname
	   if(ptr)ptr++;
	     else ptr=buffer;
	  ScrollWindow(xscroll,yscroll,1,IrcLine[1],&Colour[1],lenmax,ptr,11);
	  goto endcommand;
	 }

     if(ToMe==1) // Someone sends me message
	 {sprintf(ReNick,"%s",FromNick);
	  sprintf(str,"You have got message from %s  accept with F1",ReNick);
	  ScrollWindow(xscroll,yscroll,1,IrcLine[1],&Colour[1],lenmax,buffer,11);
	  Scrollmin=6;MessageBox(xscroll,yscroll,str);goto endcommand;
	 }

     if(IrcCommand==332)
	{GetItem(buffer,2,Channel,45);PrintTitle(Title,Channel);}

     if(IrcCommand==353)  // Load NickNameBox
	 {if(iname==1)    // Clear NickNameBox
	    NickNameBox(xnscroll,ynscroll,0,NickName[1],1,1,NICK);
	  i=4;   // start with 4th item
	  while(iname<51)
	    {GetItem(buffer,i,str,20);i++;
	     if(str[0]==0) break;    // end of list
	     ptr=str;
	     if(i==5){ptr++;if(*ptr==0) break;}  // skip :
	     if(strlen(ptr)<15)
		   {sprintf(NickName[iname],"%s",ptr);iname++;}
	    }werner=1;pnick=1;pnickmax=iname-1;
	     if(iname>=1)
		NickNameBox(xnscroll,ynscroll,1,NickName[1],1,1,NICK);
	   goto endcommand;
	 }

     if(IrcCommand==366) {iname=1;goto endcommand;}  // reset

     if(IrcCommand==433)
	MessageBox(xscroll,yscroll,"You must change your NickName !");

     if(IrcCommand==0)
	{GetItem(buffer,2,str,10);
	 if(strcmp(str,"KICK")==0)
	   {GetItem(buffer,3,str,50);
	    if(strcmp(str,Channel)!=0)goto endcommand;
	    GetItem(buffer,4,str,15);
	    if(strcmp(str,MyNick)==0)
	     {sprintf(Channel,""); // Scrollmin=6;
	      if(PrivatChat==0)PrintTitle(Title,"");
	      MessageBox(xscroll,yscroll,"You are kicked off from Channel");
	     }
	   }
	}

     if(strncmp(buffer,"PING ",5)==0)
	{sprintf(str,"PONG %s",buffer+5);
	 sock_puts(socket,(unsigned char *)str);
	 ScrollWindow(xscroll,yscroll,1,IrcLine[1],&Colour[1],lenmax,str,12);
	 goto endcommand;
	}

      if(IrcCommand>0)farbe=15;
	else farbe=14;
      ScrollWindow(xscroll,yscroll,1,IrcLine[1],&Colour[1],lenmax,buffer,farbe);


     endcommand:  // -------------- COMMANDS  END --------------------

    }
#else
   delay(100); // to slowdown testmode
#endif
}


 ende:
  if(!xg_video_XMS) x_charmod(1);
#if defined TCPMODE
  // sprintf( str, "QUIT");outs(str);
  // sock_puts(socket,(unsigned char *)str);
  // sock_wait_input(socket,sock_delay,NULL,&status);
  // sock_gets(socket,(unsigned char *)buffer,sizeof(buffer));
  // outs(buffer);
  sock_close(socket);    /* END TCP_CONNECTION  */
#endif
  fclose(channels);
  if(log) fclose(log);
  while(kbhit());
   return 1;
#if defined TCPMODE
 sock_err:
  sprintf(str,"sockerror = %s",sockerr(socket));
  outs(str);
error:
  sock_close(socket);
  if(!xg_video_XMS) x_charmod(1);
  while(kbhit());
  return 0;
#endif
}


