#include <stdio.h>
#include <string.h>

char *base64tab =
"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

struct {
   char chars[4];
   unsigned char bytes[3];
} tribyte;

int cptr;

void initdecoder(void)
{
  cptr = 0;
}

void decode(char c, FILE *f)
{
   if (cptr < 3)
   {
      tribyte.chars[cptr] = c;
      cptr++;
      return;
   }
   tribyte.chars[cptr] = c;
   tribyte.bytes[0] = (tribyte.chars[0] << 2) | (tribyte.chars[1] >> 4);
   tribyte.bytes[1] = (tribyte.chars[1] << 4) | (tribyte.chars[2] >> 2);
   tribyte.bytes[2] = (tribyte.chars[2] << 6) | tribyte.chars[3];
   fwrite(&tribyte.bytes, 1, 3, f);
   cptr = 0;
}

void flushdecoder(FILE *f)
{
   switch (cptr)
   {
      case 0:
  break;
      case 1:
  tribyte.bytes[0] = tribyte.chars[0] << 2;
  fwrite(&tribyte.bytes, 1, 1, f);
  break;
      case 2:
  tribyte.bytes[0] = (tribyte.chars[0] << 2) | (tribyte.chars[1] >> 4);
  tribyte.bytes[1] = tribyte.chars[1] << 4;
  fwrite(&tribyte.bytes, 1, 2, f);
  break;
      case 3:
  tribyte.bytes[0] = (tribyte.chars[0] << 2) | (tribyte.chars[1] >> 4);
  tribyte.bytes[1] = (tribyte.chars[1] << 4) | (tribyte.chars[2] >> 2);
  tribyte.bytes[2] = tribyte.chars[2] << 6;
  fwrite(&tribyte.bytes, 1, 3, f);
   }
}

//int main(int argc, char **argv)
int decodebase64(char *infile,char *outfile)
{
   FILE *fi, *fo;
   char buf[64], *c;
   int n, i;

   fi = fopen(infile, "rb");
   if (fi == NULL){printf("  Can't open input file %s.\n",infile);return 1;}
   fo = fopen(outfile, "wb");
   if (fo == NULL){printf("  Can't open output file %s.\n",outfile);fclose(fi);return 1;}

   initdecoder();

   //mp!!!
   while(!feof(fi))
   {n = fread(buf, 1, 64, fi);
    i = 0;
    while (n--)
     {c = strchr(base64tab, buf[i]);
      if (c!=NULL)decode((char)(c-base64tab), fo);
      i++;}}
   flushdecoder(fo);

   fclose(fi);

//!!glennmcc: begin June 26, 2004
//credit to L.D. Best and Michal H. Tyc
//added to fix the problem of only 12
//base64 encoded attachments being decoded
   fclose(fo);
//!!glennmcc: end

   //mp!!!
   printf("  File \"%s\" written.\n",outfile);
   return 0;
}
