
// ======================================================================
// insert mime attachment to e-mail,
// Gnupyright(G)1997-2000 Michael Polak, Arache Labs
// ======================================================================

#include <io.h>
#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <dir.h>
#include "string1.h"

extern char versionstr[];
extern char *base64tab;

char*ext2mime(char*mime,char*sext);
int copyfile(char *s1,char *s);

void attach(char *filename)
{
  FILE *f,*out;
  char s[2000],cmd[128];
  char multipart=0,uu=0;
  char separator[60];
  int errorlevel=0,attachcount=0,thisa=0;
  char attachment[8][80];
  char content[80]="text/plain; charset=US-ASCII";
  char cte[40]="7bit";
  char cid=0,cdescr=0;

  sprintf(separator,"MIME-multipart-message-boundary-%ld",time(NULL));
  f=fopen(filename,"rt");if(!f) exit(128);
  out=fopen("$$$.tmp","wt");if(!out) exit(128);
  while(!feof(f))
  {
   s[0]='\0';
   fgets(s,512,f);s[511]=0;strrtrim(s);

   if(!multipart) //process header:
   {
    if(!strncmpi(s,"X-Attachment: ",14) && attachcount<8)
     strcpy(attachment[attachcount++],&s[14]);
    else
    if(!strncmpi(s,"X-Encoding: ",12) && toupper(s[12])=='U')
      uu=1;
    else
    if(!strncmpi(s,"X-Cdescr: 1",11))
      cdescr=1;
    else
    if(!strncmpi(s,"X-CID: 1",8))
      cid=1;
    else
    if(!multipart && !strncmpi(s,"Content-type: ",14))
    {
     strncpy(content,&s[14],79);
     content[79]='\0';
    }
    else
    if(!multipart && !strncmpi(s,"Content-transfer-encoding: ",27))
    {
     strncpy(cte,&s[27],39);
     cte[39]='\0';
    }
    else
    if(!multipart && !s[0] && !uu && attachcount)
    {
     sprintf(s,"X-Attachment-Processor: Insight %s\nContent-Type: multipart/mixed; boundary=%s\n\n",versionstr,separator);
     fputs(s,out);
     fputs("* This message is in MIME format.\n\n--",out);
     fputs(separator,out);
     fputs("\nContent-type: ",out);
     fputs(content,out);
     fputs("\nContent-transfer-encoding: ",out);
     fputs(cte,out);
     fputs("\n\n",out);
     multipart=1;
    }
    else
     goto writeline;
   }
   else
   {
    writeline:
    fputs(s,out);
    fputs("\n",out);
   }

  }//loop
  fclose(f);

  if(attachcount)
  {
   while(thisa<attachcount)
   {
    if(uu)
    {
     char *shortname;
     char copy;

     fputs("\n",out);

     shortname=strrchr(attachment[thisa],'\\');
     if(!shortname)
      shortname=strrchr(attachment[thisa],':');
     if(!shortname)
     {
      shortname=attachment[thisa];
      copy=0;
      sprintf(cmd,"UUENCODE %s>>$$$.tmp",shortname);
     }
     else
     {
      copy=1;
      shortname++;
      mkdir("$tmpdir$");
//!!glennmcc: Nov 5, 2000 "COPY /b" will assure "exact copy" 
      sprintf(cmd,"COPY /b %s $tmpdir$\\%s>NUL",attachment[thisa],shortname);
      system(cmd);
      chdir("$tmpdir$");
      sprintf(cmd,"..\\UUENCODE %s>>..\\$$$.tmp",shortname);
     }

     fclose(out); //out = $$$.tmp
     system(cmd);

     if(copy)
     {
      unlink(shortname);
      chdir("..");
      rmdir("$tmpdir$");
     }


     out=fopen("$$$.tmp","at");
     if(!out)
     {
      return;
     }
     fputs("\n",out);
    }
    else
    {
     FILE *a;
     char ctype[80]="application/octet-stream",*name;
     int i,j,k;

     fputs("\n--",out);
     fputs(separator,out);
     fputs("\n",out);

     a=fopen(attachment[thisa],"rb");
     if(!a)
     {
      sprintf(s,"Content-Type: text/plain; charset=US-ASCII\n\nCannot read input file '%s'!\n",attachment[thisa]);
      fputs(s,out);
      errorlevel=128;
      //tady by se melo delat neco, aby hlasku videl i odesilatel !
     }
     else
     {
      //! dodelat tabulku - MIME.CFG !!!
      name=strrchr(attachment[thisa],'\\');
      if(!name)
       name=strrchr(attachment[thisa],':');
      if(name)
       name++;
      else
       name=attachment[thisa];

      ext2mime(ctype,name);

      sprintf(s,"Content-Type: %s ;name=%s\n",ctype,name);
      fputs(s,out);

      if(cid)
      {
       sprintf(s,"Content-ID: arachne-namespace/%s\n",attachment[thisa]);
       fputs(s,out);
      }

      if(cdescr)
      {
       sprintf(s,"Content-Description: File \"%s\" (type %s, size %ld KB)\n",name,ctype,filelength((int)a->fd)>>10);
       fputs(s,out);
      }

      if(!strncmpi(ctype,"text/",5))
      {
       unsigned char buf[512];

       fputs("Content-Transfer-Encoding: quoted-printable\n\n",out);
       while(!feof(a))
       {
        i=fread(buf,1,512,a);

        j=k=0;
        while(j<i)
        {
         if(buf[j]>127||buf[j]==(unsigned char)'=')
         {
          sprintf(&s[k],"=%02X",buf[j]);
          k+=3;
         }
         else if(buf[j]!='\r')
          s[k++]=(char)buf[j];
         j++;
        }//loop
        fwrite(s,k,1,out);
       }//loop

      }
      else
      {
       char q[5];
       unsigned char buf[4];

       fputs("Content-Transfer-Encoding: base64\n\n",out);

       j=0;
       while(!feof(a))
       {
        k=fread(buf,1,3,a);
        if(k<1)
         break;

        if(k<3)
        {
         buf[2]=0;
         if(k==1)
          buf[1]=0;
        }

        q[0]=base64tab[(buf[0]>>2) & 0x3F];
        q[1]=base64tab[((buf[0]<<4) & 0x3F)|((buf[1]>>4) & 0x3F)];
        q[2]=base64tab[((buf[1]<<2) & 0x3F)|((buf[2]>>6) & 0x3F)];
        q[3]=base64tab[buf[2] & 0x3F];

        if(k<3)
        {
         q[3]='=';
         if(k==1)
          q[2]='=';
        }

        fwrite(q,4,1,out);
        j+=4;
        if(j%72==0)
         fputs("\n",out);

       }//loop

      }
      fclose(a);
     }//endif file ok.
    }

    thisa++;

   }//loop

   if(!uu)
   {
    fputs("\n--",out);
    fputs(separator,out);
    fputs("--\n",out);
   }
  }//endif attachment

  fclose(out);
  unlink(filename);
  {
   copyfile(filename,"$$$.tmp");
   unlink("$$$.tmp");
  }
  if(errorlevel)
   exit(errorlevel);
}