/***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/
/* $XConsortium: oscolor.c,v 1.17 89/12/18 15:41:43 rws Exp $ */

#include "windef.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys\stat.h>
#include "misc.h"
#include "rgb.h"
#include "os.h"

extern char Xinit[];

/* Looks up the color in the database.  Note that we are assuming there
 * is only one database for all the screens.  If you have multiple databases,
 * remove the dbminit() in OsInit(), and open the appropriate database each
 * time. Or implement a database package that allows you to have more than
 * one database open at a time.
 */

extern void CopyISOLatin1Lowered(unsigned char *, unsigned char *, int);

static FILE	*rgb_fp;
static int	rgb_fsize;

void
OsInitColors()
{
    int i;
    struct stat statb;
    char buff[80];

    i = GetPrivateProfileString("MicroX", "RGBfile", "\\RGB.BIN", buff,
				sizeof(buff), Xinit);
    if (i == sizeof(buff))
	FatalError("RGBfile: name too long");

    rgb_fp = fopen(buff, "rb");
    if (!rgb_fp) {
	DebugStr("Couldn't open RGB_DB '%s'", buff);
	return;
    }
    if (stat(buff, &statb) < 0) {
	DebugStr("Couldn't stat RGB_DB '%s'", buff);
	fclose(rgb_fp);
	rgb_fp = (FILE *)NULL;
    } else
	rgb_fsize = statb.st_size;
}

void
OsCloseColors()
{

    fclose(rgb_fp);
    rgb_fp = (FILE *)NULL;
}

/*ARGSUSED*/
Bool
OsLookupColor(screen, name, len, pred, pgreen, pblue)
int	screen;
char	*name;
unsigned len;
unsigned short	*pred, *pgreen, *pblue;
{
    struct RGB_ent ent;
    char	*lowername;
    unsigned long offset;
    unsigned char hash;
    int		i;

    if (!rgb_fp)
	return FALSE;

    /* convert name to lower case */
    lowername = (char *)alloca(len + 1);
    if (!lowername)
	return FALSE;

    CopyISOLatin1Lowered((unsigned char *)lowername, (unsigned char *)name,
			  (int)len);

    /* generate the hash */
    hash = 0;
    for (i = 0; i < len; i++)
	hash = DO_HASH(hash, lowername[i]);

    /* get the bucket pointer */
    if (fseek(rgb_fp, (fpos_t)hash * sizeof(unsigned long), SEEK_SET))
	return FALSE;
    if (fread(&offset, sizeof(unsigned long), 1, rgb_fp) != 1)
	return FALSE;

    /* Do search through the database searching for name. */
    if (!offset)
	return FALSE;

    if (fseek(rgb_fp, (fpos_t)offset, SEEK_SET))
	return FALSE;

    while (1) {
	if (fread(&ent.length, sizeof(unsigned short), 1, rgb_fp) != 1) {
		break;
	}
	if (!ent.length) {
	    break;
	}
	if (ent.length == len) {
	    ent.length = (ent.length + 1) & ~1;
	    if (fread(&ent.rgb, sizeof(RGB) + ent.length, 1, rgb_fp) != 1) {
		break;
	    }
	    if (!memcmp(ent.name, lowername, len)) {
		*pred = ent.rgb.red;
		*pgreen = ent.rgb.green;
		*pblue = ent.rgb.blue;
/*
DebugStr("looking for %s %x %x %x", lowername, (int)ent.rgb.red, (int)ent.rgb.green, (int)ent.rgb.blue);
*/
		return TRUE;
	    }
	} else {
	    ent.length = (ent.length + 1) & ~1;
	    if (fseek(rgb_fp, (fpos_t)(ent.length + sizeof(RGB)), SEEK_CUR))
		break;
	}
    }
    return FALSE;
}
