/* $XConsortium: gcstruct.h,v 5.2 89/07/18 17:56:45 rws Exp $ */
/***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

#ifndef GCSTRUCT_H
#define GCSTRUCT_H

#include "gc.h"

#include "miscstruct.h"
#include "region.h"
#include "pixmap.h"
#include "screenint.h"
#include "dixfont.h"

/*
 * functions which modify the state of the GC
 */

typedef struct _GCFuncs {
    void	(* ValidateGC)(GCPtr, unsigned long, DrawablePtr);
    void	(* ChangeGC)(GCPtr, unsigned long);
    void	(* CopyGC)(GCPtr, unsigned long, GCPtr);
    void	(* DestroyGC)(GCPtr);
    void	(* ChangeClip)(GCPtr, int, pointer, int);
    void	(* DestroyClip)(GCPtr);
    void	(* CopyClip)(GCPtr, GCPtr);
    DevUnion	devPrivate;
} GCFuncs;

/*
 * graphics operations invoked through a GC
 */

typedef struct _GCOps {
    void	(* FillSpans)(DrawablePtr, GCPtr, int, DDXPointPtr,
				int *, Bool, BoxPtr);
    void	(* SetSpans)(DrawablePtr, GCPtr, unsigned char *, DDXPointPtr,
				int *, int, Bool, BoxPtr);
    void	(* PutImage)(DrawablePtr, GCPtr, int, int,
			    int, int, int, int, int, unsigned char *);
    RegionPtr	(* CopyArea)(DrawablePtr, DrawablePtr, GCPtr, int, int,
				int, int, int, int);
    RegionPtr	(* CopyPlane)(DrawablePtr, DrawablePtr, GCPtr, int, int,
				int, int, int, int, unsigned long);
    void	(* PolyPoint)(DrawablePtr, GCPtr, int, int, DDXPointPtr);
    void	(* Polylines)(DrawablePtr, GCPtr, int, int, DDXPointPtr);
    void	(* PolySegment)(DrawablePtr, GCPtr, int, struct _xSegment *);
    void	(* PolyRectangle)(DrawablePtr, GCPtr, int, struct _xRectangle *);
    void	(* PolyArc)(DrawablePtr, GCPtr, int, struct _xArc *);
    void	(* FillPolygon)(DrawablePtr, GCPtr, int, int, int, DDXPointPtr);
    void	(* PolyFillRect)(DrawablePtr, GCPtr, int, struct _xRectangle *);
    void	(* PolyFillArc)(DrawablePtr, GCPtr, int, struct _xArc *);
    int		(* PolyText8)(DrawablePtr, GCPtr, int, int, int, pointer);
    int		(* PolyText16)(DrawablePtr, GCPtr, int, int, int, pointer);
    void	(* ImageText8)(DrawablePtr, GCPtr, int, int, int, pointer);
    void	(* ImageText16)(DrawablePtr, GCPtr, int, int, int, pointer);
    void	(* ImageGlyphBlt)(DrawablePtr, GCPtr, int, int, unsigned int,
				struct _CharInfo **, pointer);
    void	(* PolyGlyphBlt)(DrawablePtr, GCPtr, int, int, unsigned int,
				struct _CharInfo **, pointer);
    void	(* PushPixels)(GCPtr, PixmapPtr, DrawablePtr, int, int, int, int);
    void	(* LineHelper)(DrawablePtr, GCPtr, Bool, int,
			    struct _SppPoint *, int, int);
    DevUnion	devPrivate;
} GCOps;

#define SPANS_SORTED	1		/* scan lines are sorted */
#define SPANS_RECT	2		/* scan lines compose a rectangle */
#define SPANS_TRECT	4		/* "tiled" (duplicated) rects */

/* there is padding in the bit fields because the Sun compiler doesn't
 * force alignment to 32-bit boundaries.  losers.
 * However, the PC/AT doesn't need alignment on 32-bit boundaries.
 */
typedef struct _GC {
    ScreenPtr		pScreen;		
    unsigned char	depth;    
    unsigned char	alu;
    unsigned short	lineWidth;          
    unsigned short	dashOffset;
    unsigned short	numInDashList;
    unsigned char	*dash;
    unsigned int	lineStyle : 2;
    unsigned int	capStyle : 2;
    unsigned int	joinStyle : 2;
    unsigned int	fillStyle : 2;
    unsigned int	fillRule : 1;
    unsigned int 	arcMode : 1;
    unsigned int	subWindowMode : 1;
    unsigned int	graphicsExposures : 1;
    unsigned int	clientClipType : 2; /* CT_<kind> */
    unsigned int	miTranslate:1; /* should mi things translate? */
    unsigned int	tileIsPixel:1; /* tile is solid pixel */
#ifdef sun
    unsigned int	unused:16; /* see comment above */
#endif
    unsigned long	planemask;
    unsigned long	fgPixel;
    unsigned long	bgPixel;
    /*
     * alas -- both tile and stipple must be here as they
     * are independently specifiable
     */
    PixUnion		tile;
    PixmapPtr		stipple;
    DDXPointRec		patOrg;		/* origin for (tile, stipple) */
    FontPtr		font;
    DDXPointRec		clipOrg;
    DDXPointRec		lastWinOrg;	/* position of window last validated */
    pointer		clientClip;
    unsigned long	stateChanges;	/* masked with GC_<kind> */
    unsigned long       serialNumber;
    GCFuncs		*funcs;
    GCOps		*ops;
    DevUnion		*devPrivates;
} GC;

void	mxFillSpans(DrawablePtr, GCPtr, int, DDXPointPtr, int *, Bool, BoxPtr);
void	mxSetSpans(DrawablePtr, GCPtr, unsigned char *, DDXPointPtr,
			int *, int, Bool, BoxPtr);
void	mxPutImage(DrawablePtr, GCPtr, int, int,
		    int, int, int, int, int, unsigned char *);
RegionPtr	mxCopyArea(DrawablePtr, DrawablePtr, GCPtr, int, int,
			int, int, int, int);
RegionPtr	mxCopyPlane(DrawablePtr, DrawablePtr, GCPtr, int, int,
			int, int, int, int, unsigned long);
void	miPolyPoint(DrawablePtr, GCPtr, int, int, DDXPointPtr);
void	miPolylines(DrawablePtr, GCPtr, int, int, DDXPointPtr);
void	miPolySegment(DrawablePtr, GCPtr, int, struct _xSegment *);
void	miPolyRectangle(DrawablePtr, GCPtr, int, struct _xRectangle *);
void	miPolyArc(DrawablePtr, GCPtr, int, struct _xArc *);
void	miFillPolygon(DrawablePtr, GCPtr, int, int, int, DDXPointPtr);
void	miPolyFillRect(DrawablePtr, GCPtr, int, struct _xRectangle *);
void	miPolyFillArc(DrawablePtr, GCPtr, int, struct _xArc *);
int	miPolyText8(DrawablePtr, GCPtr, int, int, int, pointer);
int	miPolyText16(DrawablePtr, GCPtr, int, int, int, pointer);
void	miImageText8(DrawablePtr, GCPtr, int, int, int, pointer);
void	miImageText16(DrawablePtr, GCPtr, int, int, int, pointer);
void	mxImageGlyphBlt(DrawablePtr, GCPtr, int, int, unsigned int,
			struct _CharInfo **, pointer);
void	mxPolyGlyphBlt(DrawablePtr, GCPtr, int, int, unsigned int,
			struct _CharInfo **, pointer);
void	mxPushPixels(GCPtr, PixmapPtr, DrawablePtr, int, int, int, int);

#endif /* GCSTRUCT_H */
