#include "shared.h"
#include "funcdef.h"

int
kbd_init()
{
    short buf[1];

    buf[0] = FUNC_KBD_INIT;
    rpc_call(rpc_handle, 0, sizeof buf, buf);
    return 0;
}

void
kbd_exit()
{
    short buf[1];

    buf[0] = FUNC_KBD_SHUT;
    rpc_call(rpc_handle, 0, sizeof buf, buf);
}

void
kbd_command(com)
unsigned char com;
{
    short buf[2];

    buf[0] = FUNC_KBD_COM;
    buf[1] = com;
    rpc_call(rpc_handle, 0, sizeof buf, buf);
}

int
kbd_country()
{
    short buf[1];

    buf[0] = FUNC_KBD_COUNTRY;
    rpc_call(rpc_handle, sizeof buf, sizeof buf, buf);
    return buf[0];
}
