/************************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

********************************************************/

/* $XConsortium: swapreq.c,v 1.29 89/07/03 19:50:28 rws Exp $ */

#include "X.h"
#define NEED_EVENTS
#include "Xproto.h"
#include "Xprotostr.h"
#include "misc.h"
#include "dixstruct.h"
#include "funcs.h"

extern int (* ProcVector[256]) (ClientPtr);
extern void (* EventSwapVector[128]) ();  /* for SendEvent */
static void SwapLongs (long *list, unsigned int count);

/* Thanks to Jack Palevich for testing and subsequently rewriting all this */

/* Byte swap a list of longs */

static void
SwapLongs (list, count)
	long *list;
	unsigned int count;
{

	while (count >= 8) {
	    list[0] = lswapl(list[0]);
	    list[1] = lswapl(list[1]);
	    list[2] = lswapl(list[2]);
	    list[3] = lswapl(list[3]);
	    list[4] = lswapl(list[4]);
	    list[5] = lswapl(list[5]);
	    list[6] = lswapl(list[6]);
	    list[7] = lswapl(list[7]);
	    list += 8;
	    count -= 8;
	}
	if (count != 0) {
	    do {
		*list = lswapl(*list);
		list++;
	    } while (--count != 0);
	}
}

/* Byte swap a list of shorts */

#ifndef SwapShorts
void
SwapShorts (list, count)
	short *list;
	unsigned long count;
{

	while (count >= 16) {
	    swaps(list+0, n);
	    swaps(list+1, n);
	    swaps(list+2, n);
	    swaps(list+3, n);
	    swaps(list+4, n);
	    swaps(list+5, n);
	    swaps(list+6, n);
	    swaps(list+7, n);
	    swaps(list+8, n);
	    swaps(list+9, n);
	    swaps(list+10, n);
	    swaps(list+11, n);
	    swaps(list+12, n);
	    swaps(list+13, n);
	    swaps(list+14, n);
	    swaps(list+15, n);
	    list += 16;
	    count -= 16;
	}
	if (count != 0) {
	    do {
		swaps(list, n);
		list++;
	    } while (--count != 0);
	}
}
#endif

/* The following is used for all requests that have
   no fields to be swapped (except "length") */
int
SProcSimpleReq(client)
	ClientPtr client;
{

    REQUEST(xReq);
    stuff->length = lswaps(stuff->length);
    return(*ProcVector[stuff->reqType])(client);
}

/* The following is used for all requests that have
   only a single 32-bit field to be swapped, coming
   right after the "length" field */
int
SProcResourceReq(client)
	ClientPtr client;
{

    REQUEST(xResourceReq);
    stuff->length = lswaps(stuff->length);
    stuff->id = lswapl(stuff->id);
    return(*ProcVector[stuff->reqType])(client);
}

int
SProcCreateWindow(client)
    ClientPtr client;
{

    REQUEST(xCreateWindowReq);
    stuff->length = lswaps(stuff->length);
    stuff->wid = lswapl(stuff->wid);
    stuff->parent = lswapl(stuff->parent);
    stuff->x = lswaps(stuff->x);
    stuff->y = lswaps(stuff->y);
    stuff->width = lswaps(stuff->width);
    stuff->height = lswaps(stuff->height);
    stuff->borderWidth = lswaps(stuff->borderWidth);
    stuff->class = lswaps(stuff->class);
    stuff->visual = lswapl(stuff->visual);
    stuff->mask = lswapl(stuff->mask);
    SwapRestL(stuff);
    return((* ProcVector[X_CreateWindow])(client));
}

int
SProcChangeWindowAttributes(client)
    ClientPtr client;
{

    REQUEST(xChangeWindowAttributesReq);
    stuff->length = lswaps(stuff->length);
    stuff->window = lswapl(stuff->window);
    stuff->valueMask = lswapl(stuff->valueMask);
    SwapRestL(stuff);
    return((* ProcVector[X_ChangeWindowAttributes])(client));
}

int
SProcReparentWindow(client)
    ClientPtr client;
{
    REQUEST(xReparentWindowReq);
    stuff->length = lswaps(stuff->length);
    stuff->window = lswapl(stuff->window);
    stuff->parent = lswapl(stuff->parent);
    stuff->x = lswaps(stuff->x);
    stuff->y = lswaps(stuff->y);
    return((* ProcVector[X_ReparentWindow])(client));
}

int
SProcConfigureWindow(client)
    ClientPtr client;
{
    REQUEST(xConfigureWindowReq);
    stuff->length = lswaps(stuff->length);
    stuff->window = lswapl(stuff->window);
    stuff->mask = lswaps(stuff->mask);
    SwapRestL(stuff);
    return((* ProcVector[X_ConfigureWindow])(client));

}


int
SProcInternAtom(client)
    ClientPtr client;
{
    REQUEST(xInternAtomReq);
    stuff->length = lswaps(stuff->length);
    stuff->nbytes = lswaps(stuff->nbytes);
    return((* ProcVector[X_InternAtom])(client));
}

int
SProcChangeProperty(client)
    ClientPtr client;
{
    REQUEST(xChangePropertyReq);
    stuff->length = lswaps(stuff->length);
    stuff->window = lswapl(stuff->window);
    stuff->property = lswapl(stuff->property);
    stuff->type = lswapl(stuff->type);
    stuff->nUnits = lswapl(stuff->nUnits);
    switch ( stuff->format ) {
        case 8 : break;
        case 16:
            SwapShorts((short *)(stuff + 1), (int)stuff->nUnits);
	    break;
	case 32:
	    SwapLongs((long *)(stuff + 1), (int)stuff->nUnits);
	    break;
	}
    return((* ProcVector[X_ChangeProperty])(client));
}

int 
SProcDeleteProperty(client)
    ClientPtr client;
{
    REQUEST(xDeletePropertyReq);
    stuff->length = lswaps(stuff->length);
    stuff->window = lswapl(stuff->window);
    stuff->property = lswapl(stuff->property);
    return((* ProcVector[X_DeleteProperty])(client));
              
}

int 
SProcGetProperty(client)
    ClientPtr client;
{
    REQUEST(xGetPropertyReq);
    stuff->length = lswaps(stuff->length);
    stuff->window = lswapl(stuff->window);
    stuff->property = lswapl(stuff->property);
    stuff->type = lswapl(stuff->type);
    stuff->longOffset = lswapl(stuff->longOffset);
    stuff->longLength = lswapl(stuff->longLength);
    return((* ProcVector[X_GetProperty])(client));
}

int
SProcSetSelectionOwner(client)
    ClientPtr client;
{
    REQUEST(xSetSelectionOwnerReq);
    stuff->length = lswaps(stuff->length);
    stuff->window = lswapl(stuff->window);
    stuff->selection = lswapl(stuff->selection);
    stuff->time = lswapl(stuff->time);
    return((* ProcVector[X_SetSelectionOwner])(client));
}

int
SProcConvertSelection(client)
    ClientPtr client;
{
    REQUEST(xConvertSelectionReq);
    stuff->length = lswaps(stuff->length);
    stuff->requestor = lswapl(stuff->requestor);
    stuff->selection = lswapl(stuff->selection);
    stuff->target = lswapl(stuff->target);
    stuff->property = lswapl(stuff->property);
    stuff->time = lswapl(stuff->time);
    return((* ProcVector[X_ConvertSelection])(client));
}

int
SProcSendEvent(client)
    ClientPtr client;
{
    xEvent eventT;
    void (*proc)();
    REQUEST(xSendEventReq);
    stuff->length = lswaps(stuff->length);
    stuff->destination = lswapl(stuff->destination);
    stuff->eventMask = lswapl(stuff->eventMask);

    /* Swap event */
    proc = EventSwapVector[stuff->event.u.u.type & 0177];
    if (!proc)   /* no swapping proc; invalid event type? */
       return (BadValue);
    (*proc)(&stuff->event, &eventT);
    stuff->event = eventT;

    return((* ProcVector[X_SendEvent])(client));
}

int
SProcGrabPointer(client)
    ClientPtr client;
{
    REQUEST(xGrabPointerReq);
    stuff->length = lswaps(stuff->length);
    stuff->grabWindow = lswapl(stuff->grabWindow);
    stuff->eventMask = lswaps(stuff->eventMask);
    stuff->confineTo = lswapl(stuff->confineTo);
    stuff->cursor = lswapl(stuff->cursor);
    stuff->time = lswapl(stuff->time);
    return((* ProcVector[X_GrabPointer])(client));
}

int
SProcGrabButton(client)
    ClientPtr client;
{
    REQUEST(xGrabButtonReq);
    stuff->length = lswaps(stuff->length);
    stuff->grabWindow = lswapl(stuff->grabWindow);
    stuff->eventMask = lswaps(stuff->eventMask);
    stuff->confineTo = lswapl(stuff->confineTo);
    stuff->cursor = lswapl(stuff->cursor);
    stuff->modifiers = lswaps(stuff->modifiers);
    return((* ProcVector[X_GrabButton])(client));
}

int
SProcUngrabButton(client)
    ClientPtr client;
{
    REQUEST(xUngrabButtonReq);
    stuff->length = lswaps(stuff->length);
    stuff->grabWindow = lswapl(stuff->grabWindow);
    stuff->modifiers = lswaps(stuff->modifiers);
    return((* ProcVector[X_UngrabButton])(client));
}

int
SProcChangeActivePointerGrab(client)
    ClientPtr client;
{
    REQUEST(xChangeActivePointerGrabReq);
    stuff->length = lswaps(stuff->length);
    stuff->cursor = lswapl(stuff->cursor);
    stuff->time = lswapl(stuff->time);
    stuff->eventMask = lswaps(stuff->eventMask);
    return((* ProcVector[X_ChangeActivePointerGrab])(client));
}

int
SProcGrabKeyboard(client)
    ClientPtr client;
{
    REQUEST(xGrabKeyboardReq);
    stuff->length = lswaps(stuff->length);
    stuff->grabWindow = lswapl(stuff->grabWindow);
    stuff->time = lswapl(stuff->time);
    return((* ProcVector[X_GrabKeyboard])(client));
}

int
SProcGrabKey(client)
    ClientPtr client;
{
    REQUEST(xGrabKeyReq);
    stuff->length = lswaps(stuff->length);
    stuff->grabWindow = lswapl(stuff->grabWindow);
    stuff->modifiers = lswaps(stuff->modifiers);
    return((* ProcVector[X_GrabKey])(client));
}

int
SProcUngrabKey(client)
    ClientPtr client;
{
    REQUEST(xUngrabKeyReq);
    stuff->length = lswaps(stuff->length);
    stuff->grabWindow = lswapl(stuff->grabWindow);
    stuff->modifiers = lswaps(stuff->modifiers);
    return((* ProcVector[X_UngrabKey])(client));
}

int
SProcGetMotionEvents(client)
    ClientPtr client;
{
    REQUEST(xGetMotionEventsReq);
    stuff->length = lswaps(stuff->length);
    stuff->window = lswapl(stuff->window);
    stuff->start = lswapl(stuff->start);
    stuff->stop = lswapl(stuff->stop);
    return((* ProcVector[X_GetMotionEvents])(client));
}

int
SProcTranslateCoords(client)
    ClientPtr client;
{
    REQUEST(xTranslateCoordsReq);
    stuff->length = lswaps(stuff->length);
    stuff->srcWid = lswapl(stuff->srcWid);
    stuff->dstWid = lswapl(stuff->dstWid);
    stuff->srcX = lswaps(stuff->srcX);
    stuff->srcY = lswaps(stuff->srcY);
    return((* ProcVector[X_TranslateCoords])(client));
}

int
SProcWarpPointer(client)
    ClientPtr client;
{
    REQUEST(xWarpPointerReq);
    stuff->length = lswaps(stuff->length);
    stuff->srcWid = lswapl(stuff->srcWid);
    stuff->dstWid = lswapl(stuff->dstWid);
    stuff->srcX = lswaps(stuff->srcX);
    stuff->srcY = lswaps(stuff->srcY);
    stuff->srcWidth = lswaps(stuff->srcWidth);
    stuff->srcHeight = lswaps(stuff->srcHeight);
    stuff->dstX = lswaps(stuff->dstX);
    stuff->dstY = lswaps(stuff->dstY);
    return((* ProcVector[X_WarpPointer])(client));
}

int
SProcSetInputFocus(client)
    ClientPtr client;
{
    REQUEST(xSetInputFocusReq);
    stuff->length = lswaps(stuff->length);
    stuff->focus = lswapl(stuff->focus);
    stuff->time = lswapl(stuff->time);
    return((* ProcVector[X_SetInputFocus])(client));
}


SProcOpenFont(client)
    ClientPtr client;
{
    REQUEST(xOpenFontReq);
    stuff->length = lswaps(stuff->length);
    stuff->fid = lswapl(stuff->fid);
    stuff->nbytes = lswaps(stuff->nbytes);
    return((* ProcVector[X_OpenFont])(client));
}

int
SProcListFonts(client)
    ClientPtr client;
{
    REQUEST(xListFontsReq);
    stuff->length = lswaps(stuff->length);
    stuff->maxNames = lswaps(stuff->maxNames);
    stuff->nbytes = lswaps(stuff->nbytes);
    return((* ProcVector[X_ListFonts])(client));
}

int
SProcListFontsWithInfo(client)
    ClientPtr client;
{
    REQUEST(xListFontsWithInfoReq);
    stuff->length = lswaps(stuff->length);
    stuff->maxNames = lswaps(stuff->maxNames);
    stuff->nbytes = lswaps(stuff->nbytes);
    return((* ProcVector[X_ListFontsWithInfo])(client));
}

int
SProcSetFontPath(client)
    ClientPtr client;
{
    REQUEST(xSetFontPathReq);
    stuff->length = lswaps(stuff->length);
    stuff->nFonts = lswaps(stuff->nFonts);
    return((* ProcVector[X_SetFontPath])(client));
}

int
SProcCreatePixmap(client)
    ClientPtr client;
{
    REQUEST(xCreatePixmapReq);

    stuff->length = lswaps(stuff->length);
    stuff->pid = lswapl(stuff->pid);
    stuff->drawable = lswapl(stuff->drawable);
    stuff->width = lswaps(stuff->width);
    stuff->height = lswaps(stuff->height);
    return((* ProcVector[X_CreatePixmap])(client));
}

int
SProcCreateGC(client)
    ClientPtr client;
{
    REQUEST(xCreateGCReq);
    stuff->length = lswaps(stuff->length);
    stuff->gc = lswapl(stuff->gc);
    stuff->drawable = lswapl(stuff->drawable);
    stuff->mask = lswapl(stuff->mask);
    SwapRestL(stuff);
    return((* ProcVector[X_CreateGC])(client));
}

int
SProcChangeGC(client)
    ClientPtr client;
{
    REQUEST(xChangeGCReq);
    stuff->length = lswaps(stuff->length);
    stuff->gc = lswapl(stuff->gc);
    stuff->mask = lswapl(stuff->mask);
    SwapRestL(stuff);
    return((* ProcVector[X_ChangeGC])(client));
}

int
SProcCopyGC(client)
    ClientPtr client;
{
    REQUEST(xCopyGCReq);
    stuff->length = lswaps(stuff->length);
    stuff->srcGC = lswapl(stuff->srcGC);
    stuff->dstGC = lswapl(stuff->dstGC);
    stuff->mask = lswapl(stuff->mask);
    return((* ProcVector[X_CopyGC])(client));
}

int
SProcSetDashes(client)
    ClientPtr client;
{
    REQUEST(xSetDashesReq);
    stuff->length = lswaps(stuff->length);
    stuff->gc = lswapl(stuff->gc);
    stuff->dashOffset = lswaps(stuff->dashOffset);
    stuff->nDashes = lswaps(stuff->nDashes);
    return((* ProcVector[X_SetDashes])(client));

}

int
SProcSetClipRectangles(client)
    ClientPtr client;
{
    REQUEST(xSetClipRectanglesReq);
    stuff->length = lswaps(stuff->length);
    stuff->gc = lswapl(stuff->gc);
    stuff->xOrigin = lswaps(stuff->xOrigin);
    stuff->yOrigin = lswaps(stuff->yOrigin);
    SwapRestS(stuff);
    return((* ProcVector[X_SetClipRectangles])(client));
}

int
SProcClearToBackground(client)
    ClientPtr client;
{
    REQUEST(xClearAreaReq);
    stuff->length = lswaps(stuff->length);
    stuff->window = lswapl(stuff->window);
    stuff->x = lswaps(stuff->x);
    stuff->y = lswaps(stuff->y);
    stuff->width = lswaps(stuff->width);
    stuff->height = lswaps(stuff->height);
    return((* ProcVector[X_ClearArea])(client));
}

int
SProcCopyArea(client)
    ClientPtr client;
{
    REQUEST(xCopyAreaReq);
    stuff->length = lswaps(stuff->length);
    stuff->srcDrawable = lswapl(stuff->srcDrawable);
    stuff->dstDrawable = lswapl(stuff->dstDrawable);
    stuff->gc = lswapl(stuff->gc);
    stuff->srcX = lswaps(stuff->srcX);
    stuff->srcY = lswaps(stuff->srcY);
    stuff->dstX = lswaps(stuff->dstX);
    stuff->dstY = lswaps(stuff->dstY);
    stuff->width = lswaps(stuff->width);
    stuff->height = lswaps(stuff->height);
    return((* ProcVector[X_CopyArea])(client));
}

int
SProcCopyPlane(client)
    ClientPtr client;
{
    REQUEST(xCopyPlaneReq);
    stuff->length = lswaps(stuff->length);
    stuff->srcDrawable = lswapl(stuff->srcDrawable);
    stuff->dstDrawable = lswapl(stuff->dstDrawable);
    stuff->gc = lswapl(stuff->gc);
    stuff->srcX = lswaps(stuff->srcX);
    stuff->srcY = lswaps(stuff->srcY);
    stuff->dstX = lswaps(stuff->dstX);
    stuff->dstY = lswaps(stuff->dstY);
    stuff->width = lswaps(stuff->width);
    stuff->height = lswaps(stuff->height);
    stuff->bitPlane = lswapl(stuff->bitPlane);
    return((* ProcVector[X_CopyPlane])(client));
}

/* The following routine is used for all Poly drawing requests
   (except FillPoly, which uses a different request format) */
int
SProcPoly(client)
    ClientPtr client;
{

    REQUEST(xPolyPointReq);
    stuff->length = lswaps(stuff->length);
    stuff->drawable = lswapl(stuff->drawable);
    stuff->gc = lswapl(stuff->gc);
    SwapRestS(stuff);
    return((* ProcVector[stuff->reqType])(client));
}

/* cannot use SProcPoly for this one, because xFillPolyReq
   is longer than xPolyPointReq, and we don't want to swap
   the difference as shorts! */
int
SProcFillPoly(client)
    ClientPtr client;
{

    REQUEST(xFillPolyReq);
    stuff->length = lswaps(stuff->length);
    stuff->drawable = lswapl(stuff->drawable);
    stuff->gc = lswapl(stuff->gc);
    SwapRestS(stuff);
    return((* ProcVector[X_FillPoly])(client));
}

int
SProcPutImage(client)
    ClientPtr client;
{
    REQUEST(xPutImageReq);
    stuff->length = lswaps(stuff->length);
    stuff->drawable = lswapl(stuff->drawable);
    stuff->gc = lswapl(stuff->gc);
    stuff->width = lswaps(stuff->width);
    stuff->height = lswaps(stuff->height);
    stuff->dstX = lswaps(stuff->dstX);
    stuff->dstY = lswaps(stuff->dstY);
    /* Image should already be swapped */
    return((* ProcVector[X_PutImage])(client));

}

int
SProcGetImage(client)
    ClientPtr	client;
{
    REQUEST(xGetImageReq);
    stuff->length = lswaps(stuff->length);
    stuff->drawable = lswapl(stuff->drawable);
    stuff->x = lswaps(stuff->x);
    stuff->y = lswaps(stuff->y);
    stuff->width = lswaps(stuff->width);
    stuff->height = lswaps(stuff->height);
    stuff->planeMask = lswapl(stuff->planeMask);
    return((* ProcVector[X_GetImage])(client));
}

/* ProcPolyText used for both PolyText8 and PolyText16 */

int
SProcPolyText(client)
    ClientPtr client;
{
    REQUEST(xPolyTextReq);
    stuff->length = lswaps(stuff->length);
    stuff->drawable = lswapl(stuff->drawable);
    stuff->gc = lswapl(stuff->gc);
    stuff->x = lswaps(stuff->x);
    stuff->y = lswaps(stuff->y);
    return((* ProcVector[stuff->reqType])(client));
}

/* ProcImageText used for both ImageText8 and ImageText16 */

int
SProcImageText(client)
    ClientPtr client;
{
    REQUEST(xImageTextReq);
    stuff->length = lswaps(stuff->length);
    stuff->drawable = lswapl(stuff->drawable);
    stuff->gc = lswapl(stuff->gc);
    stuff->x = lswaps(stuff->x);
    stuff->y = lswaps(stuff->y);
    return((* ProcVector[stuff->reqType])(client));
}

int
SProcCreateColormap(client)
    ClientPtr client;
{
    REQUEST(xCreateColormapReq);
    stuff->length = lswaps(stuff->length);
    stuff->mid = lswapl(stuff->mid);
    stuff->window = lswapl(stuff->window);
    stuff->visual = lswapl(stuff->visual);
    return((* ProcVector[X_CreateColormap])(client));
}


int
SProcCopyColormapAndFree(client)
    ClientPtr client;
{
    REQUEST(xCopyColormapAndFreeReq);
    stuff->length = lswaps(stuff->length);
    stuff->mid = lswapl(stuff->mid);
    stuff->srcCmap = lswapl(stuff->srcCmap);
    return((* ProcVector[X_CopyColormapAndFree])(client));

}

int
SProcAllocColor                (client)
    ClientPtr client;
{
    REQUEST(xAllocColorReq);
    stuff->length = lswaps(stuff->length);
    stuff->cmap = lswapl(stuff->cmap);
    stuff->red = lswaps(stuff->red);
    stuff->green = lswaps(stuff->green);
    stuff->blue = lswaps(stuff->blue);
    return((* ProcVector[X_AllocColor])(client));
}

int
SProcAllocNamedColor           (client)
    ClientPtr client;
{

    REQUEST(xAllocNamedColorReq);
    stuff->length = lswaps(stuff->length);
    stuff->cmap = lswapl(stuff->cmap);
    stuff->nbytes = lswaps(stuff->nbytes);
    return((* ProcVector[X_AllocNamedColor])(client));
}

int
SProcAllocColorCells           (client)
    ClientPtr client;
{
    REQUEST(xAllocColorCellsReq);
    stuff->length = lswaps(stuff->length);
    stuff->cmap = lswapl(stuff->cmap);
    stuff->colors = lswaps(stuff->colors);
    stuff->planes = lswaps(stuff->planes);
    return((* ProcVector[X_AllocColorCells])(client));
}

int
SProcAllocColorPlanes(client)
    ClientPtr client;
{
    REQUEST(xAllocColorPlanesReq);
    stuff->length = lswaps(stuff->length);
    stuff->cmap = lswapl(stuff->cmap);
    stuff->colors = lswaps(stuff->colors);
    stuff->red = lswaps(stuff->red);
    stuff->green = lswaps(stuff->green);
    stuff->blue = lswaps(stuff->blue);
    return((* ProcVector[X_AllocColorPlanes])(client));
}

int
SProcFreeColors          (client)
    ClientPtr client;
{
    REQUEST(xFreeColorsReq);
    stuff->length = lswaps(stuff->length);
    stuff->cmap = lswapl(stuff->cmap);
    stuff->planeMask = lswapl(stuff->planeMask);
    SwapRestL(stuff);
    return((* ProcVector[X_FreeColors])(client));

}

int
SProcStoreColors               (client)
    ClientPtr client;
{
    unsigned long count;
    xColorItem 	*pItem;

    REQUEST(xStoreColorsReq);
    stuff->length = lswaps(stuff->length);
    stuff->cmap = lswapl(stuff->cmap);
    pItem = (xColorItem *) &stuff[1];
    for(count = LengthRestB(stuff)/sizeof(xColorItem); count != 0; count--)
	SwapColorItem(pItem++);
    return((* ProcVector[X_StoreColors])(client));
}

int
SProcStoreNamedColor           (client)
    ClientPtr client;
{
    REQUEST(xStoreNamedColorReq);
    stuff->length = lswaps(stuff->length);
    stuff->cmap = lswapl(stuff->cmap);
    stuff->pixel = lswapl(stuff->pixel);
    stuff->nbytes = lswaps(stuff->nbytes);
    return((* ProcVector[X_StoreNamedColor])(client));
}

int
SProcQueryColors(client)
    ClientPtr client;
{
    REQUEST(xQueryColorsReq);
    stuff->length = lswaps(stuff->length);
    stuff->cmap = lswapl(stuff->cmap);
    SwapRestL(stuff);
    return((* ProcVector[X_QueryColors])(client));
} 

int
SProcLookupColor(client)
    ClientPtr client;
{
    REQUEST(xLookupColorReq);
    stuff->length = lswaps(stuff->length);
    stuff->cmap = lswapl(stuff->cmap);
    stuff->nbytes = lswaps(stuff->nbytes);
    return((* ProcVector[X_LookupColor])(client));
}

int
SProcCreateCursor( client)
    ClientPtr client;
{
    REQUEST(xCreateCursorReq);
    stuff->length = lswaps(stuff->length);
    stuff->cid = lswapl(stuff->cid);
    stuff->source = lswapl(stuff->source);
    stuff->mask = lswapl(stuff->mask);
    stuff->foreRed = lswaps(stuff->foreRed);
    stuff->foreGreen = lswaps(stuff->foreGreen);
    stuff->foreBlue = lswaps(stuff->foreBlue);
    stuff->backRed = lswaps(stuff->backRed);
    stuff->backGreen = lswaps(stuff->backGreen);
    stuff->backBlue = lswaps(stuff->backBlue);
    stuff->x = lswaps(stuff->x);
    stuff->y = lswaps(stuff->y);
    return((* ProcVector[X_CreateCursor])(client));
}

int
SProcCreateGlyphCursor( client)
    ClientPtr client;
{
    REQUEST(xCreateGlyphCursorReq);
    stuff->length = lswaps(stuff->length);
    stuff->cid = lswapl(stuff->cid);
    stuff->source = lswapl(stuff->source);
    stuff->mask = lswapl(stuff->mask);
    stuff->sourceChar = lswaps(stuff->sourceChar);
    stuff->maskChar = lswaps(stuff->maskChar);
    stuff->foreRed = lswaps(stuff->foreRed);
    stuff->foreGreen = lswaps(stuff->foreGreen);
    stuff->foreBlue = lswaps(stuff->foreBlue);
    stuff->backRed = lswaps(stuff->backRed);
    stuff->backGreen = lswaps(stuff->backGreen);
    stuff->backBlue = lswaps(stuff->backBlue);
    return((* ProcVector[X_CreateGlyphCursor])(client));
}


int
SProcRecolorCursor(client)
    ClientPtr client;
{
    REQUEST(xRecolorCursorReq);
    stuff->length = lswaps(stuff->length);
    stuff->cursor = lswapl(stuff->cursor);
    stuff->foreRed = lswaps(stuff->foreRed);
    stuff->foreGreen = lswaps(stuff->foreGreen);
    stuff->foreBlue = lswaps(stuff->foreBlue);
    stuff->backRed = lswaps(stuff->backRed);
    stuff->backGreen = lswaps(stuff->backGreen);
    stuff->backBlue = lswaps(stuff->backBlue);
    return((* ProcVector[X_RecolorCursor])(client));
}

int
SProcQueryBestSize   (client)
    ClientPtr client;
{
    REQUEST(xQueryBestSizeReq);
    stuff->length = lswaps(stuff->length);
    stuff->drawable = lswapl(stuff->drawable);
    stuff->width = lswaps(stuff->width);
    stuff->height = lswaps(stuff->height);
    return((* ProcVector[X_QueryBestSize])(client));

}

int
SProcQueryExtension   (client)
    ClientPtr client;
{
    REQUEST(xQueryExtensionReq);
    stuff->length = lswaps(stuff->length);
    stuff->nbytes = lswaps(stuff->nbytes);
    return((* ProcVector[X_QueryExtension])(client));
}

int
SProcChangeKeyboardMapping   (client)
    ClientPtr client;
{
    long *p;
    int i, count;

    REQUEST(xChangeKeyboardMappingReq);
    stuff->length = lswaps(stuff->length);
    p = (long *)&stuff[1];
    count = stuff->keyCodes * stuff->keySymsPerKeyCode;
    for(i = 0; i < count; i++)
    {
	*p = lswapl(*p);
	p++;
    }
    return((* ProcVector[X_ChangeKeyboardMapping])(client));
}


int
SProcChangeKeyboardControl   (client)
    ClientPtr client;
{
    REQUEST(xChangeKeyboardControlReq);
    stuff->length = lswaps(stuff->length);
    stuff->mask = lswapl(stuff->mask);
    SwapRestL(stuff);
    return((* ProcVector[X_ChangeKeyboardControl])(client));
}

int
SProcChangePointerControl   (client)
    ClientPtr client;
{
    REQUEST(xChangePointerControlReq);
    stuff->length = lswaps(stuff->length);
    stuff->accelNum = lswaps(stuff->accelNum);
    stuff->accelDenum = lswaps(stuff->accelDenum);
    stuff->threshold = lswaps(stuff->threshold);
    return((* ProcVector[X_ChangePointerControl])(client));
}


int
SProcSetScreenSaver            (client)
    ClientPtr client;
{
    REQUEST(xSetScreenSaverReq);
    stuff->length = lswaps(stuff->length);
    stuff->timeout = lswaps(stuff->timeout);
    stuff->interval = lswaps(stuff->interval);
    return((* ProcVector[X_SetScreenSaver])(client));
}

int
SProcChangeHosts(client)
    ClientPtr client;
{

    REQUEST(xChangeHostsReq);
    stuff->length = lswaps(stuff->length);
    stuff->hostLength = lswaps(stuff->hostLength);
    return((* ProcVector[X_ChangeHosts])(client));

}

int
SProcRotateProperties(client)
    ClientPtr client;
{
    REQUEST(xRotatePropertiesReq);
    stuff->length = lswaps(stuff->length);
    stuff->window = lswapl(stuff->window);
    stuff->nAtoms = lswaps(stuff->nAtoms);
    stuff->nPositions = lswaps(stuff->nPositions);
    SwapRestL(stuff);
    return ((* ProcVector[X_RotateProperties])(client));
}

/*ARGSUSED*/
int
SProcNoOperation(client)
    ClientPtr client;
{
    client = client;
    /* noop -- don't do anything */
    return(Success);
}

void
SwapTimecoord(pCoord)
    xTimecoord *pCoord;
{

    pCoord->time = lswapl(pCoord->time);
    pCoord->x = lswaps(pCoord->x);
    pCoord->y = lswaps(pCoord->y);
}


void
SwapRGB(prgb)
    xrgb	*prgb;
{

    prgb->red = lswaps(prgb->red);
    prgb->green = lswaps(prgb->green);
    prgb->blue = lswaps(prgb->blue);
}

void
SwapColorItem(pItem)
    xColorItem	*pItem;
{

    pItem->pixel = lswapl(pItem->pixel);
    pItem->red = lswaps(pItem->red);
    pItem->green = lswaps(pItem->green);
    pItem->blue = lswaps(pItem->blue);
}

void
SwapConnClientPrefix(pCCP)
    xConnClientPrefix	*pCCP;
{

    pCCP->majorVersion = lswaps(pCCP->majorVersion);
    pCCP->minorVersion = lswaps(pCCP->minorVersion);
    pCCP->nbytesAuthProto = lswaps(pCCP->nbytesAuthProto);
    pCCP->nbytesAuthString = lswaps(pCCP->nbytesAuthString);
}

