/************************************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

************************************************************************/

/* $XConsortium: glyphcurs.c,v 5.1 89/07/03 13:27:00 rws Exp $ */

#include <stdio.h>
#include "X.h"
#include "Xmd.h"
#include "Xproto.h"
#include "misc.h"
#include "cursorstr.h"
#include "dixfontstr.h"
#include "fontstruct.h"
#include "scrnintstr.h"
#include "gcstruct.h"
#include "resource.h"
#include "dix.h"
#include "opaque.h"
#include "servermd.h"
#include "funcs.h"


/*
    get the bits out of the font in a portable way.  to avoid
dealing with padding and such-like, we draw the glyph into
a bitmap, then read the bits out with GetImage, which
uses server-natural format.
    since all screens return the same bitmap format, we'll just use
the first one we find.
    the character origin lines up with the hotspot in the
cursor metrics.
*/

#include "pixmapstr.h"

int
ServerBitsFromGlyph(pfont, ch, cm, ppbits)
    FontPtr	pfont;
    unsigned short ch;
    CursorMetricPtr cm;
    unsigned char **ppbits;
{
#if MAXSCREENS != 1
    ScreenPtr pScreen;
#endif
    GCPtr pGC;
    xRectangle rect;
    PixmapPtr ppix;
    int nby;
    unsigned char *pbits;
    XID gcval[3];
    unsigned char char2b[2];

    /* turn glyph index into a protocol-format char2b */
    char2b[0] = (unsigned char)(ch >> 8);
    char2b[1] = (unsigned char)(ch);

#if MAXSCREENS != 1
    pScreen = screenInfo.screens[0];
#endif
    nby = PixmapBytePad(cm->width, 1) * (long)cm->height;
    pbits = (unsigned char *)xalloc(nby);
    if (!pbits)
	return BadAlloc;
    /* zeroing the (pad) bits seems to help some ddx cursor handling */
    bzero((char *)pbits, nby);

#if MAXSCREENS == 1
    ppix = (*screenInfo.screen.CreatePixmap)(&screenInfo.screen,
						cm->width, cm->height, 1);
    if (!ppix) {
	xfree(pbits);
	return BadAlloc;
    }
    pGC = GetScratchGC(1, &screenInfo.screen);
    if (!pGC) {
	(*screenInfo.screen.DestroyPixmap)(ppix);
	xfree(pbits);
	return BadAlloc;
    }
#else
    ppix = (*pScreen->CreatePixmap)(pScreen, cm->width, cm->height, 1);
    if (!ppix) {
	xfree(pbits);
	return BadAlloc;
    }
    pGC = GetScratchGC(1, pScreen);
    if (!pGC) {
	(*pScreen->DestroyPixmap)(ppix);
	xfree(pbits);
	return BadAlloc;
    }
#endif

    rect.x = 0;
    rect.y = 0;
    rect.width = cm->width;
    rect.height = cm->height;

    /* fill the pixmap with 0 */
    gcval[0] = GXcopy;
    gcval[1] = 0;
    gcval[2] = (XID)pfont;
    DoChangeGC(pGC, GCFunction | GCForeground | GCFont, gcval, 1);
    ValidateGC((DrawablePtr)ppix, pGC);
    (*pGC->ops->PolyFillRect)((DrawablePtr)ppix, pGC, 1, &rect);

    /* draw the glyph */
    gcval[0] = 1;
    DoChangeGC(pGC, GCForeground, gcval, 0);
    ValidateGC((DrawablePtr)ppix, pGC);
    (*pGC->ops->PolyText16)((DrawablePtr)ppix, pGC, cm->xhot, cm->yhot, 1, char2b);
#if MAXSCREENS == 1
    (*screenInfo.screen.GetImage)((DrawablePtr)ppix, 0, 0,
			cm->width, cm->height, ZPixmap, 1, pbits);
#else
    (*pScreen->GetImage)((DrawablePtr)ppix, 0, 0, cm->width, cm->height,
			 ZPixmap, 1, pbits);
#endif
    *ppbits = pbits;
    FreeScratchGC(pGC);
#if MAXSCREENS == 1
    (*screenInfo.screen.DestroyPixmap)(ppix);
#else
    (*pScreen->DestroyPixmap)(ppix);
#endif
    return Success;
}


Bool
CursorMetricsFromGlyph( pfont, ch, cm)
    FontPtr 	pfont;
    unsigned		ch;
    CursorMetricPtr cm;
{
    CharInfoPtr 	pci;

    if (   ch < pfont->pFI->chFirst
	|| ch >= pfont->pFI->chFirst + n1dChars(pfont->pFI))
	return FALSE;
    pci = ADDRXTHISCHARINFO(pfont, ch);
    cm->width = pci->metrics.rightSideBearing - pci->metrics.leftSideBearing;
    cm->height = pci->metrics.descent + pci->metrics.ascent;
    if (pci->metrics.leftSideBearing > 0)
    {
	cm->width += pci->metrics.leftSideBearing;
	cm->xhot = 0;
    }
    else
    {
	cm->xhot = -pci->metrics.leftSideBearing;
	if (pci->metrics.rightSideBearing < 0)
	    cm->width -= pci->metrics.rightSideBearing;
    }
    if (pci->metrics.ascent < 0)
    {
	cm->height -= pci->metrics.ascent;
	cm->yhot = 0;
    }
    else
    {
	cm->yhot = pci->metrics.ascent;
	if (pci->metrics.descent < 0)
	    cm->height -= pci->metrics.descent;
    }
    return TRUE;
}



