/*******************************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

************************************************************************/
/* $XConsortium: mipolytext.c,v 5.0 89/06/09 15:08:40 keith Exp $ */
/*
 * mipolytext.c - text routines
 *
 * Author:	haynes
 * 		Digital Equipment Corporation
 * 		Western Software Laboratory
 * Date:	Thu Feb  5 1987
 */

#include <stdio.h>
#include	"X.h"
#include	"Xmd.h"
#include	"Xproto.h"
#include	"fontstruct.h"
#include	"dixfontstr.h"
#include	"gcstruct.h"
#include	"funcs.h"

#ifdef notdef
static int miPolyText(DrawablePtr, GCPtr, int, int, int, pointer,
		FontEncoding);
static int miImageText(DrawablePtr, GCPtr, int, int, int, pointer,
		FontEncoding);

static int
miPolyText(pDraw, pGC, x, y, count, chars, fontEncoding)
    DrawablePtr pDraw;
    GCPtr	pGC;
    int		x, y;
    int		count;
    pointer	chars;
    FontEncoding fontEncoding;
{
    CharInfoPtr *charinfo;
    unsigned int n, i;
    unsigned int w;

    charinfo = (CharInfoPtr *)ALLOCATE_LOCAL(count*sizeof(CharInfoPtr ));
    if (!charinfo)
	return 0;
    GetGlyphs(pGC->font, count, (unsigned char *)chars,
	      fontEncoding, &n, charinfo);
    w = 0;
    for (i=0; i < n; i++) w += charinfo[i]->metrics.characterWidth;
    if (n != 0)
        (*pGC->ops->PolyGlyphBlt)(
	    pDraw, pGC, x, y, n, charinfo, pGC->font->pGlyphs);

    DEALLOCATE_LOCAL(charinfo);
    return x+w;
}
#endif


int
miPolyText8(pDraw, pGC, x, y, count, chars)
    DrawablePtr pDraw;
    GCPtr	pGC;
    int		x, y;
    int 	count;
    pointer	chars;
{
    register CharInfoPtr *charinfo;
    unsigned int n, i;
    unsigned int w;

    charinfo = (CharInfoPtr *)ALLOCATE_LOCAL(count*sizeof(CharInfoPtr ));
    if (!charinfo)
	return 0;
    GetGlyphs(pGC->font, count, (unsigned char *)chars,
	      Linear8Bit, &n, charinfo);
    w = 0;
    for (i=0; i < n; i++) w += charinfo[i]->metrics.characterWidth;
    if (n != 0)
        (*pGC->ops->PolyGlyphBlt)(
	    pDraw, pGC, x, y, n, charinfo, (pointer)pGC->font->pGlyphs);

    DEALLOCATE_LOCAL(charinfo);
    return x+w;
}


int
miPolyText16(pDraw, pGC, x, y, count, chars)
    DrawablePtr pDraw;
    GCPtr	pGC;
    int		x, y;
    int		count;
    pointer	chars;
{
    register CharInfoPtr *charinfo;
    unsigned int n, i;
    unsigned int w;

    charinfo = (CharInfoPtr *)ALLOCATE_LOCAL(count*sizeof(CharInfoPtr ));
    if (!charinfo)
	return 0;
    GetGlyphs(pGC->font, count, chars,
	      (pGC->font->pFI->lastRow == 0) ? Linear16Bit : TwoD16Bit,
	      &n, charinfo);
    w = 0;
    for (i=0; i < n; i++) w += charinfo[i]->metrics.characterWidth;
    if (n != 0)
        (*pGC->ops->PolyGlyphBlt)(
	    pDraw, pGC, x, y, n, charinfo, (pointer)pGC->font->pGlyphs);

    DEALLOCATE_LOCAL(charinfo);
    return x+w;
}


#ifdef notdef
static int
miImageText(pDraw, pGC, x, y, count, chars, fontEncoding)
    DrawablePtr pDraw;
    GCPtr	pGC;
    int 	x, y;
    int 	count;
    pointer 	chars;
    FontEncoding fontEncoding;
{
    register CharInfoPtr *charinfo;
    unsigned int n, i;
    FontPtr font = pGC->font;
    unsigned int w;

    charinfo = (CharInfoPtr *)ALLOCATE_LOCAL(count*sizeof(CharInfoPtr));
    if (!charinfo)
	return 0;
    GetGlyphs(font, count, (unsigned char *)chars,
	      fontEncoding, &n, charinfo);
    w = 0;
    for (i=0; i < n; i++) w += charinfo[i]->metrics.characterWidth;
    if (n !=0 )
        (*pGC->ops->ImageGlyphBlt)(pDraw, pGC, x, y, n, charinfo, font->pGlyphs);
    DEALLOCATE_LOCAL(charinfo);
    return x+w;
}
#endif

void
miImageText8(pDraw, pGC, x, y, count, chars)
    DrawablePtr pDraw;
    GCPtr	pGC;
    int		x, y;
    int		count;
    pointer	chars;
{
    CharInfoPtr *charinfo;
    unsigned int n;
    FontPtr font = pGC->font;

    charinfo = (CharInfoPtr *)ALLOCATE_LOCAL(count*sizeof(CharInfoPtr));
    if (!charinfo)
	return;
    GetGlyphs(font, count, (unsigned char *)chars,
	      Linear8Bit, &n, charinfo);
    if (n !=0 )
        (*pGC->ops->ImageGlyphBlt)(pDraw, pGC, x, y, n, charinfo, (pointer)font->pGlyphs);
    DEALLOCATE_LOCAL(charinfo);
}


void
miImageText16(pDraw, pGC, x, y, count, chars)
    DrawablePtr pDraw;
    GCPtr	pGC;
    int		x, y;
    int		count;
    pointer	chars;
{
    CharInfoPtr *charinfo;
    unsigned int n;
    FontPtr font = pGC->font;

    charinfo = (CharInfoPtr *)ALLOCATE_LOCAL(count*sizeof(CharInfoPtr));
    if (!charinfo)
	return;
    GetGlyphs(font, count, chars,
	      (pGC->font->pFI->lastRow == 0) ? Linear16Bit : TwoD16Bit,
	      &n, charinfo);
    if (n !=0 )
        (*pGC->ops->ImageGlyphBlt)(pDraw, pGC, x, y, n, charinfo, (pointer)font->pGlyphs);
    DEALLOCATE_LOCAL(charinfo);
}
