	name	headland

	.386p

INCLUDE	..\common\vgadrvr.inc

_CODE	SEGMENT DWORD PUBLIC 'CODE'

ASSUME	cs:_CODE

	org	0

smo	EQU	offset set_mode
mspo	EQU	offset mono_set_page
cspo	EQU	offset color_set_page
cco	EQU	offset CCOPY

head	vga_header	<,11h,62h,65h,,67h,69h,0,,smo,sml,mspo,mspl,cspo,cspl,cco,ccl>

NUMPAGES	equ	1
HEADLAND	equ	1

setpage	MACRO	page
	IFDIFI	<page>,<al>	; dst != ah
	mov	al,page
	ENDIF
	mov	al,5
	int	10h
	ENDM

set_mode	PROC NEAR
	push	edx
	push	ebx
	mov	bl,al
	sub	bh,bh		; zero high byte
	push	ebx
	mov	eax,6f05h	; extended BIOS call
	int	10h
	; read the mode back from BIOS to make sure we actually changed
	; it
	mov	eax,6f04h	; get current mode
	int	10h
	pop	ebx
	cmp	bl,al		; check current mode with what we want
	jne	local_bad
	mov	edx,3c4h		; enable extended register bank access
	mov	eax,0e06h
	out	dx,ax
	mov	al,0ffh		; enable access to 2nd bank of 256k
	out	dx,al
	inc	edx
	in	al,dx
	or	al,10h		; force bit 4
	out	dx,al
	cmp	bl,65h		; check for 1024x768 BW
	jne	local_cont
	mov	dx,3c4h
	mov	al,0f6h
	out	dx,al
	inc	dx
	in	al,dx
	and	al,0f0h
	out	dx,al
local_cont:
	xor	eax,eax		; return OK
	pop	ebx
	pop	edx
	ret
local_bad:
	mov	eax,1	; non-supported mode
	pop	ebx
	pop	edx
	ret
sml	EQU	$ - offset set_mode
set_mode	ENDP

	ASSUME	ds: nothing

include ccopy1.asm


;	VGABW	sets the VGA page for 1024x768 mono mode only
;
mono_set_page	PROC	NEAR
	push	edx
	mov	ah,al
	and	ah,3
	mov	al,ah
	shl	al,2
	or	ah,al
	mov	dx,3c4h
	mov	al,0f6h
	out	dx,al
	inc	dx
	in	al,dx
	and	al,0f0h
	or	al,ah
	out	dx,al
	pop	edx
	ret
mspl	EQU	$ - offset mono_set_page
mono_set_page	ENDP

color_set_page	PROC NEAR
	setpage	al
	ret
cspl	EQU	$ - offset color_set_page
color_set_page	ENDP

copyright db	10, 13, 'Headland Video 7 driver '
include version.asm
include date.asm
	db	10, 13
	db	'Copyright (c) 1992 Starnet Communications '
	db	'Corporation. All rights reserved.',10,13,'$'

_CODE	ENDS
	END
