#include <dos.h>
#include "X.h"
#include "scrnintstr.h"
#include "windowstr.h"
#include "svga.h"
#include "../../mi/mistruct.h"
#include "regionstr.h"
#include "gcstruct.h"
#include "../../../os/msdos/msdos.h"
#include "svgafuncs.h"
#include "mxfuncs.h"

static void reset_back(WindowPtr pWin);

Bool
mxCreateWindow(pWin)
WindowPtr pWin;
{
	pWin->mxBackground = 0;
	return TRUE;
}

Bool
mxDestroyWindow(pWin)
WindowPtr pWin;
{

	if (pWin->mxBackground)
	    mxDestroyPixmap(pWin->mxBackground);
	pWin->mxBackground = 0;
	return TRUE;
}

Bool
mxPositionWindow(pWin, x, y)
WindowPtr pWin;
int x, y;
{
	PixmapPtr pCopy;

	x = x;
	y = y;
	pCopy = pWin->mxBackground;
	if (pCopy && pWin->drawable.width != pCopy->drawable.width)
	    reset_back(pWin);
	return TRUE;
}

Bool
mxMapWindow(pWin)
WindowPtr pWin;
{
	pWin = pWin;
	return TRUE;
}

Bool
mxUnmapWindow(pWin)
WindowPtr pWin;
{
	pWin = pWin;
	return TRUE;
}

void 
mxCopyWindow(pWin, ptOldOrg, prgnSrc)
    WindowPtr pWin;
    DDXPointRec ptOldOrg;
    RegionPtr prgnSrc;
{
    RegionPtr prgnDst;
    int dx, dy, width;
    int i;
    RegBoxPtr pbox;
    int y, xMax, yMax;
    int xMin;
    Bool revy = 0;
    unsigned int	*ordering;
    int		num_rects;

    y = pWin->drawable.y;
    prgnDst = (* pWin->drawable.pScreen->RegionCreate)(NullBox, 
					       REGION_NUM_RECTS(&pWin->borderClip));

    /* turn cursor off while we do the copy */
    HideCursor();
    dx = pWin->drawable.x - ptOldOrg.x;
    dy = y - ptOldOrg.y;
    (* pWin->drawable.pScreen->TranslateRegion)(prgnSrc, dx, dy);
    (* pWin->drawable.pScreen->Intersect)(prgnDst, &pWin->borderClip, prgnSrc);

    num_rects = REGION_NUM_RECTS(prgnDst);
    ordering = (unsigned int *)
        ALLOCATE_LOCAL(num_rects * sizeof(unsigned int));
    if (!ordering)
	return;

    width = pWin->borderWidth;
    ptOldOrg.x -= width;
    ptOldOrg.y -= width;
    width *= 2;
    /* find out which direction to scroll */
    /* if no overlap, it doesn't matter which direction, so stop now */
    if ((unsigned)abs(dy) >= pWin->drawable.height + width ||
      (unsigned)abs(dx) >= pWin->drawable.width + width)
	for (i=0; i < num_rects; i++)
	    ordering[i] = i;
    else {
      if (dy <= 0) { /* Scroll up or stationary vertical.
                                  Vertical order OK */
        if (dx <= 0) { /* Scroll left or stationary horizontal.
                                  Horizontal order OK as well */
          for (i=0; i < num_rects; i++)
            ordering[i] = i;
        } else { /* scroll right. must reverse horizontal banding of rects. */
          for (i=0, xMin=1, xMax=0;
               i < num_rects;
               xMin=i+1, xMax=i) {
            /* find extent of current horizontal band */
            y=REGION_RECTS(prgnDst)[i].y1; /* band has this y coordinate */
            while ((xMin < num_rects) &&
                   (REGION_RECTS(prgnDst)[xMin].y1 == y))
              xMin++;
            /* reverse the horizontal band in the output ordering */
            for (xMin-- ; xMin >= xMax; xMin--, i++)
              ordering[i] = xMin;
          }
        }
      }
      else { /* Scroll down. Must reverse vertical banding. */
        if (dx < 0) { /* Scroll left. Horizontal order OK. */
          for (i=num_rects-1, xMin=i-1, xMax=i, yMax=0;
              i >= 0;
              xMin=i-1, xMax=i) {
            /* find extent of current horizontal band */
            y=REGION_RECTS(prgnDst)[i].y1; /* band has this y coordinate */
            while ((xMin >= 0) &&
                   (REGION_RECTS(prgnDst)[xMin].y1 == y))
              xMin--;
            /* reverse the horizontal band in the output ordering */
            for (xMin++ ; xMin <= xMax; xMin++, i--, yMax++)
              ordering[yMax] = xMin;
          }
        }
        else /* Scroll right or horizontal stationary.
                Reverse horizontal order as well (if stationary, horizontal
                order can be swapped without penalty and this is faster
                to compute). */
          for (i=0, xMin=num_rects-1;
               i < num_rects;
               i++, xMin--)
              ordering[i] = xMin;
	revy = 1;
      }
    }

    for (i = 0; i < num_rects; i++) {
	pbox = &REGION_RECTS(prgnDst)[ordering[i]];
	xMin = pbox->x1;
	xMax = pbox->x2;
	y = pbox->y1;
	yMax = pbox->y2;
	if (xMax <= xMin || yMax <= y)
	    continue;

	xMax -= xMin;
	yMax -= y;

	VGACopy(xMin - dx, y - dy, xMin, y, xMax, yMax,
	    svga_width, svga_page_shift);
    }
    SetPage();
    DEALLOCATE_LOCAL(ordering);
    (* pWin->drawable.pScreen->RegionDestroy)(prgnDst);
}

Bool
mxChangeWindowAttributes(pWin, mask)
WindowPtr pWin;
unsigned long mask;
{

    if (mask & (CWBackPixmap|CWBackPixel))
	reset_back(pWin);

    return(TRUE);
}

static void
reset_back(pWin)
WindowPtr pWin;
{
    PixmapPtr pPixmap, pCopy;
    u_char *psrcBase, *pdstBase, *pdst;
    int width, height, len, n;

    /* First, destroy old pixmap */
    if (pWin->mxBackground) {
	mxDestroyPixmap(pWin->mxBackground);
	pWin->mxBackground = 0;
    }
    if (pWin->backgroundState != BackgroundPixmap)
	    return;
    pPixmap = pWin->background.pixmap;
    /* Notice: width is from WINDOW, height is from PIXMAP. */
    height = pPixmap->drawable.height;
    width = pWin->drawable.width;
    pCopy = mxCreatePixmap(pWin->drawable.pScreen, width, height,
	pPixmap->drawable.depth);
    if (!pCopy)
	return;
    psrcBase = pPixmap->devPrivate.ptr;
    pdstBase = pCopy->devPrivate.ptr;
    while (height--) {
	len = width;
	pdst = pdstBase;
	while (len) {
	    n = min(len, pPixmap->drawable.width);
	    memcpy(pdst, psrcBase, n);
	    pdst += n;
	    len -= n;
	}
	psrcBase += pPixmap->devKind;
	pdstBase += pCopy->devKind;
    }
    pWin->mxBackground = pCopy;
}
