/* Combined Purdue/PurduePlus patches, level 2.0, 1/17/89 */
/***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

#include <stdio.h>
#include <conio.h>
#include "pixmap.h"
#include "region.h"
#include "gc.h"
#include "colormap.h"
#include "miscstruct.h"
#include "../../mi/mibstore.h"
#include "../common/ibmfuncs.h"

#ifndef WINDOW_DEFINED
#define WINDOW_DEFINED
typedef struct _Window *WindowPtr;
#endif

#ifdef ERGO
extern const __segment	svga_base;
#define vga_memcpy	_fmemcpy
#define vga_mem(x)	((u_char __based(svga_base) *)((u_short)(x)))
#define SVGA_BASED __based(svga_base)
#else
#define vga_memcpy	memcpy
#define vga_mem(x)	((u_char *)(0xa0000 + (u_short)(x)))
#define SVGA_BASED
#endif

extern int	svga_width;	/* width of screen in bytes */
extern u_char	svga_curpage;
extern u_char	svga_page_shift;	/* for VESA support */
extern ColormapPtr	svga_colormap;	/* current colormap */
extern int	scr_width, scr_height;

#define SetPage()	VGASetPage(svga_curpage << svga_page_shift)

extern int InverseAlu[];
extern u_char masktab[];

extern void clearbits(u_char *, u_char *, int, int, int);
extern void andbits(u_char *, u_char *, int, int, int);
extern void andReversebits(u_char *, u_char *, int, int, int);
extern void copybits(u_char *, u_char *, int, int, int);
extern void andInvertedbits(u_char *, u_char *, int, int, int);
extern void noopbits(u_char *, u_char *, int, int, int);
extern void xorbits(u_char *, u_char *, int, int, int);
extern void orbits(u_char *, u_char *, int, int, int);
extern void norbits(u_char *, u_char *, int, int, int);
extern void equivbits(u_char *, u_char *, int, int, int);
extern void invertbits(u_char *, u_char *, int, int, int);
extern void orReversebits(u_char *, u_char *, int, int, int);
extern void copyInvertedbits(u_char *, u_char *, int, int, int);
extern void orInvertedbits(u_char *, u_char *, int, int, int);
extern void nandbits(u_char *, u_char *, int, int, int);
extern void setbits(u_char *, u_char *, int, int, int);

extern int svgaGeneration;
extern int svgaGCPrivateIndex;
extern int svgaScrPrivateIndex;

typedef struct {
    unsigned char	rop;		/* reduction of rasterop to 1 of 3 */
    short	fExpose;		/* callexposure handling ? */
    short	freeCompClip;
    PixmapPtr	pRotatedTile;		/* tile/stipple  rotated to align */
    PixmapPtr	pRotatedStipple;	/* with window and using offsets */
    RegionPtr	pAbsClientRegion;	/* client region in screen coords */
    RegionPtr	pCompositeClip;		/* free this based on freeCompClip
					   flag rather than NULLness */
#ifdef notdef
    void	(*movebits)(u_char *, u_char *, int, int, int);
#else
    void	(*movebits)(u_char *, u_char *, int, int, int);
#endif
    void	(* movebytes)(u_char *pdst, u_char *psrc, int n);
    void	(*movebyte)(u_char *pdst, u_char src, int n, u_char pmask);
    PixmapPtr	*ppPixmap;		/* pointer to tile/stipple ptr */
    short	flags;
    } svgaPrivGC;
typedef svgaPrivGC	*vgaPrivGCPtr;

/* freeCompositeClip values */
#define REPLACE_CC	0		/* compsite clip is a copy of a
					   pointer, so it doesn't need to 
					   be freed; just overwrite it.
					   this happens if there is no
					   client clip and the gc has
					   ClipByChildren in it.
					*/
#define FREE_CC		1		/* composite clip is a real
					   region that we need to free
					*/

#define RROP_BLACK	GXclear
#define RROP_WHITE	GXset
#define RROP_NOP	GXnoop
#define RROP_INVERT	GXinvert

/* out of clip region codes */
#define OUT_LEFT 0x08
#define OUT_RIGHT 0x04
#define OUT_ABOVE 0x02
#define OUT_BELOW 0x01

struct svgaCursor {
	struct _Screen *pScreen;
	struct _CursorBits *pBits;
	int pos_x, pos_y;
	u_char isUp;
	u_char validSaved;
	u_char reDraw;
	u_char shouldBeUp;
	BoxRec saved;		/* region under cursor saved */
	u_char *pSaved;		/* pointer to saved data */
	int save_size;		/* size in bytes of pSaved */
	int screen_width, screen_height;
	int depth;		/* useful bits in fore_color and back_color */
	u_char fore_color, back_color;
};

extern int mouse_X, mouse_Y;

extern struct svgaCursor svgaCursor;

#define CUR_OVERLAP(X1,Y1,X2,Y2) ((svgaCursor.isUp || svgaCursor.validSaved) && \
				(X1) < svgaCursor.saved.x2 && \
				(X2) > svgaCursor.saved.x1 && \
				(Y1) < svgaCursor.saved.y2 && \
				(Y2) > svgaCursor.saved.y1)
