/* Combined Purdue/PurduePlus patches, level 2.0, 1/17/89 */
/***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/
/* $XConsortium: mfbhrzvert.c,v 1.9 88/09/06 14:53:43 jim Exp $ */
#include <dos.h>
#include "X.h"

#include "gc.h"
#include "window.h"
#include "pixmap.h"
#include "region.h"

#include "ega.h"
#include "egafuncs.h"

/* horizontal solid line
   abs(len) > 1
*/
void
mfbHorzS(rop, addr, nlwidth, x1, y1, len)
int rop;		/* a reduced rasterop */
u_char VGA_BASED *addr;
int nlwidth;	/* width in longwords of bitmap */
int x1;			/* initial point */ 
int y1;
int len;		/* length of line */
{
    unsigned char startmask;
    unsigned char endmask;
    unsigned char nlmiddle;
#ifdef EGA_HIRES
    unsigned char iswin = (u_long)addr >> 16 == 0xa;
#endif

    /* force the line to go left to right
       but don't draw the last point
    */
    if (len < 0)
    {
	x1 += len;
	x1 += 1;
	len = -len;
    }

    addr += (y1 * nlwidth) + (x1 >> 3);
#ifdef EGA_HIRES
    if (iswin && vga_hires) {
	if (addr > vga_mem(0xffff)) {
	    addr -= 0x10000;
	    if (!vga_curpage) {
		vga_curpage = 1;
		SetPage();
	    }
	} else if (vga_curpage) {
		vga_curpage = 0;
		SetPage();
	}
    }
#endif

    /* all bits inside same byte */
    if ( ((x1 & 7) + len) < 8)
    {
	startmask = 0xff >> (x1 & 7);
	startmask &= ~(0xff >> ((x1 + len) & 7));
        if (rop == RROP_BLACK)
        {
	    *addr &= ~startmask;
        }
        else if (rop == RROP_WHITE)
        {
	    *addr |= startmask;
        }
        else if (rop == RROP_INVERT)
        {
	    *addr ^= startmask;
        }
    }
    else
    {
	startmask = 0xff >> (x1 & 7);
	if (startmask)
		nlmiddle = (len - (8 - (x1 & 7))) >> 3;
	else
		nlmiddle = len >> 3;
	endmask = ~(0xff >> ((x1 + len) & 7));
        if (rop == RROP_BLACK)
        {
	    if (startmask)
		*addr++ &= ~startmask;
	    while (nlmiddle--)
		*addr++ = 0x0;
	    if (endmask)
		*addr &= ~endmask;
        }
        else if (rop == RROP_WHITE)
        {
	    if (startmask)
		*addr++ |= startmask;
	    while (nlmiddle--)
		*addr++ = 0xff;
	    if (endmask)
		*addr |= endmask;
        }
        else if (rop == RROP_INVERT)
        {
	    if (startmask)
		*addr++ ^= startmask;
	    while (nlmiddle--)
		*addr++ ^= 0xff;
	    if (endmask)
		*addr ^= endmask;
        }
    }
}

/* vertical solid line
   this uses do loops because pcc (Ultrix 1.2, bsd 4.2) generates
   better code.  sigh.  we know that len will never be 0 or 1, so
   it's OK to use it.
*/

void
mfbVertS(rop, addr, nlwidth, x1, y1, len)
int rop;		/* a reduced rasterop */
u_char VGA_BASED *addr;
int nlwidth;	/* width in bytes of bitmap */
int x1, y1;		/* initial point */
int len;	/* length of line */
{
    unsigned char bitmask;
#ifdef EGA_HIRES
    int extra = 0;
    unsigned char iswin = (u_long)addr >> 16 == 0xa;
#endif

    addr += (y1 * nlwidth) + (x1 >> 3);
#ifdef EGA_HIRES
    if (iswin && vga_hires) {
	if (addr > vga_mem(0xffff)) {
	    addr -= 0x10000;
	    if (!vga_curpage) {
		vga_curpage = 1;
		SetPage();
	    }
	} else {
	    if (vga_curpage) {
		vga_curpage = 0;
		SetPage();
	    }
	    if ((addr - vga_mem(0)) / nlwidth + len > HIRES_LPP) {
		extra = len + (addr - vga_mem(0)) / nlwidth - HIRES_LPP;
		len -= extra;
	    }
	}
    }
#endif

#ifdef notdef
    /* This function is never called with len < 0 */
    if (len < 0)
    {
printf("mfbVert: len=%d\n", len);
	nlwidth = -nlwidth;
	len = -len;
    }
#endif
 
more:
    if (rop == RROP_BLACK)
   {
	bitmask = ~(0x80>>(x1 & 7));
	do
	{
	    *addr &= bitmask;
	    addr += nlwidth;
	}
	while (--len);
    }
    else if (rop == RROP_WHITE)
    {
	bitmask = 0x80 >> (x1 & 7);
	do
	{
	    *addr |= bitmask;
	    addr += nlwidth;
	}
	while (--len);
    }
    else if (rop == RROP_INVERT)
    {
	bitmask = 0x80 >> (x1 & 7);
	do
	{
	    *addr ^= bitmask;
	    addr += nlwidth;
	}
	while (--len);
    }
#ifdef EGA_HIRES
    if (extra) {
	addr -= 0x10000;
	len = extra;
	extra = 0;
	vga_curpage = 1;
	SetPage();
	goto more;
    }
#endif
}
